/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import com.toedter.calendar.JDateChooserCellEditor;
import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.db.Speaker;
import ipsk.apps.speechrecorder.session.SessionDeleteDialog;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.db.speech.Person;
import ipsk.db.speech.Session;
import ipsk.db.speech.utils.EnumSexCellEditor;
import ipsk.net.Utils;
import ipsk.util.SystemHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class SpeakerDatabaseViewer
extends JDialog
implements TableModelListener {
    private static final long serialVersionUID = 390341902688247788L;
    private Logger logger;
    private SpeakerManager spkManager = null;
    private JPanel buttonPanel = null;
    private JTable dbTable = null;
    private JButton addButton;
    private JButton deleteButton;
    private JToggleButton editButton;
    private JButton selectButton;
    private UIResources uiString = null;

    SpeakerDatabaseViewer(JFrame owner, SpeakerManager sm) {
        super((Frame)owner, true);
        this.spkManager = sm;
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.uiString = UIResources.getInstance();
        Vector<String> description = ipsk.apps.speechrecorder.Speaker.getDescription();
        Vector<String> tableHeader = new Vector<String>();
        int i = 0;
        while (i < description.size()) {
            tableHeader.addElement(description.elementAt(i));
            ++i;
        }
        this.dbTable = new JTable(this.spkManager);
        this.dbTable.setSelectionMode(0);
        ListSelectionModel rowSM = this.dbTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    SpeakerDatabaseViewer.this.setIndex(lsm.getMinSelectionIndex());
                    int r = SpeakerDatabaseViewer.this.dbTable.getSelectedRow();
                    Rectangle rowFirstColRect = SpeakerDatabaseViewer.this.dbTable.getCellRect(r, 0, true);
                    SpeakerDatabaseViewer.this.dbTable.scrollRectToVisible(rowFirstColRect);
                }
            }
        });
        this.dbTable.setDefaultEditor(Person.Sex.class, (TableCellEditor)new EnumSexCellEditor());
        this.dbTable.setDefaultEditor(Date.class, (TableCellEditor)new JDateChooserCellEditor());
        this.dbTable.setShowGrid(true);
        this.dbTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        int rowIndex = this.spkManager.getIndex();
        JScrollPane scrollPane = new JScrollPane(this.dbTable);
        this.makeButtonPanel();
        this.setTitle(this.uiString.getString("SpeakerManagerFrameTitle"));
        this.setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        if (rowIndex >= 0) {
            this.dbTable.setRowSelectionInterval(rowIndex, rowIndex);
        }
        this.updateUIDependencies();
    }

    public void displayViewer() {
        Runnable doShow = new Runnable(){

            @Override
            public void run() {
                SpeakerDatabaseViewer.this.setSpeakerDataEditable(false);
                SpeakerDatabaseViewer.this.updateSelection();
                SpeakerDatabaseViewer.this.updateUIDependencies();
                SpeakerDatabaseViewer.this.pack();
                SpeakerDatabaseViewer.this.setVisible(true);
                SpeakerDatabaseViewer.this.toFront();
            }
        };
        if (EventQueue.isDispatchThread()) {
            doShow.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(doShow);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateSelection() {
        int currIndex = this.getIndex();
        if (currIndex >= 0) {
            this.setSelectedIndex(currIndex);
        }
    }

    private void setSelectedIndex(int index) {
        ListSelectionModel lsm = this.dbTable.getSelectionModel();
        if (lsm != null) {
            lsm.setSelectionInterval(index, index);
        }
    }

    public void setIndex(int index) {
        this.spkManager.setIndex(index);
        int newIndex = this.getIndex();
        this.setSelectedIndex(newIndex);
    }

    public int getIndex() {
        return this.spkManager.getIndex();
    }

    private void makeButtonPanel() {
        this.addButton = new JButton(this.uiString.getString("AddButtonText"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeakerDatabaseViewer.this.addSpeaker();
            }
        });
        this.addButton.setEnabled(true);
        this.deleteButton = new JButton(this.uiString.getString("DeleteButtonText"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeakerDatabaseViewer.this.deleteSpeaker();
            }
        });
        this.deleteButton.setEnabled(true);
        this.editButton = new JToggleButton(this.uiString.getString("EditButtonText"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeakerDatabaseViewer.this.toggleEditSpeaker();
            }
        });
        this.editButton.setEnabled(true);
        this.selectButton = new JButton(this.uiString.getString("SelectButtonText"));
        final SpeakerDatabaseViewer dialog = this;
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor cellEditor = SpeakerDatabaseViewer.this.dbTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                SystemHelper.disposeWindowForReuse((Window)dialog);
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 4, 10, 5));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.selectButton);
        this.buttonPanel.setBackground(Color.white);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.dbTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    public void addSpeaker() {
        this.spkManager.addNewSpeaker();
        this.setSpeakerDataEditable(true);
        this.dbTable.setRowSelectionInterval(this.spkManager.getIndex(), this.spkManager.getIndex());
        this.updateUIDependencies();
    }

    public void deleteSpeaker() {
        String msgTitle;
        String msg = this.uiString.getString("delete.row.selected.confirm.request");
        int ans = JOptionPane.showConfirmDialog(this, msg, msgTitle = this.uiString.getString("delete.speaker.data"), 1, 3);
        if (ans == 0) {
            Speaker spk = this.spkManager.getSpeaker();
            Set spkSesss = spk.getSessions();
            for (Session spkSess : spkSesss) {
                Set sessSpks = spkSess.getSpeakers();
                sessSpks.remove((Object)spk);
                if (!sessSpks.isEmpty()) continue;
                int spkSessId = spkSess.getSessionId();
                try {
                    SessionStorageManager sm = this.spkManager.getStorageManager();
                    URL sessUrl = sm.getSessionURL(spkSessId);
                    File sessDir = Utils.fileFromDecodedURL((URL)sessUrl);
                    if (sessDir == null) continue;
                    NumberFormat sessFmt = sm.getSessionIDFormat();
                    String spkSessIdStr = sessFmt.format(spkSessId);
                    SessionDeleteDialog sdd = new SessionDeleteDialog(spkSessIdStr, sessDir);
                    sdd.showDialog(this);
                }
                catch (StorageManagerException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Cannot get session URL: " + e.getMessage(), "Storage manager error", 0);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Cannot get session directory (unsupported encoding): " + e.getMessage(), "URL encoding error", 0);
                }
            }
            this.spkManager.deleteSpeaker(this.getIndex());
            if (this.spkManager.getSpeakerCount() > 0) {
                int ind = this.getIndex();
                if (ind >= 0) {
                    this.dbTable.setRowSelectionInterval(ind, ind);
                } else {
                    this.dbTable.getSelectionModel().clearSelection();
                }
            }
        }
        this.updateUIDependencies();
    }

    private void setSpeakerDataEditable(boolean editable) {
        if (!editable) {
            this.stopCellEditing();
        }
        this.spkManager.editSpeaker(editable);
        this.editButton.setSelected(editable);
    }

    public void toggleEditSpeaker() {
        this.setSpeakerDataEditable(!this.spkManager.isEditable());
    }

    @Override
    public void tableChanged(TableModelEvent te) {
        this.logger.info("tableChanged: " + te.toString());
    }

    private void updateUIDependencies() {
        boolean hasData = this.spkManager.getSpeakerCount() > 0;
        boolean spkSelected = false;
        if (hasData) {
            ListSelectionModel lsm = this.dbTable.getSelectionModel();
            spkSelected = lsm != null && !lsm.isSelectionEmpty();
        }
        boolean editable = this.spkManager.isEditable() && hasData;
        this.editButton.setSelected(editable);
        this.editButton.setEnabled(hasData);
        this.deleteButton.setEnabled(spkSelected);
        this.selectButton.setEnabled(spkSelected);
    }
}

