/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.Speaker;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeakerReader {
    private Vector<Speaker> speakerData = new Vector();
    private int maxID = 0;
    private String spkName;
    private String spkFirstName;
    private String spkCode;
    private String spkKey;
    private String spkAccent;
    private String spkDateOfBirth;
    private String spkGender;

    public SpeakerReader(Node speakerDoc) {
        this.extractSpeakerListData(speakerDoc);
    }

    public void initializeSpeakerReader() {
        this.spkName = null;
        this.spkFirstName = null;
        this.spkCode = null;
        this.spkKey = null;
        this.spkAccent = null;
        this.spkDateOfBirth = null;
        this.spkGender = null;
    }

    private void setMaxID(int id) {
        if (id > this.maxID) {
            this.maxID = id;
        }
    }

    public int getMaxID() {
        return this.maxID;
    }

    public String toString() {
        StringBuffer tmpBuffer = new StringBuffer();
        int i = 0;
        while (i < this.speakerData.size()) {
            Speaker pi = this.speakerData.elementAt(i);
            tmpBuffer.append(String.valueOf(((Object)pi).toString()) + "\n");
            ++i;
        }
        return tmpBuffer.toString();
    }

    public Vector<Speaker> getVector() {
        return this.speakerData;
    }

    private void extractSpeakerListData(Node node) {
        String childNodeName = "";
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && (childNodeName = childNode.getNodeName()).equals("speaker")) {
                this.initializeSpeakerReader();
                Speaker speaker = this.extractSpeakerData(childNode);
                this.setMaxID(speaker.getID());
                this.speakerData.add(speaker);
            }
            ++i;
        }
    }

    private Speaker extractSpeakerData(Node node) {
        NodeList nodeList = node.getChildNodes();
        int spkID = 0;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node tmpNode = nodeList.item(i);
            if (tmpNode.getNodeType() == 1) {
                if (tmpNode.getNodeName().equals("ID")) {
                    this.spkKey = tmpNode.getFirstChild().getNodeValue().trim();
                    spkID = Integer.parseInt(this.spkKey);
                } else if (tmpNode.getNodeName().equals("code")) {
                    this.spkCode = tmpNode.getFirstChild().getNodeValue().trim();
                } else if (tmpNode.getNodeName().equals("familyname")) {
                    this.spkName = tmpNode.getFirstChild().getNodeValue().trim();
                } else if (tmpNode.getNodeName().equals("givenname")) {
                    this.spkFirstName = tmpNode.getFirstChild().getNodeValue().trim();
                } else if (tmpNode.getNodeName().equals("accent")) {
                    this.spkAccent = tmpNode.getFirstChild().getNodeValue().trim();
                } else if (tmpNode.getNodeName().equals("sex")) {
                    this.spkGender = tmpNode.getFirstChild().getNodeValue().trim();
                } else if (tmpNode.getNodeName().equals("dateofbirth")) {
                    this.spkDateOfBirth = tmpNode.getFirstChild().getNodeValue().trim();
                }
            }
            ++i;
        }
        Speaker speaker = new Speaker(spkID);
        speaker.setCode(this.spkCode);
        speaker.setName(this.spkName);
        speaker.setFirstName(this.spkFirstName);
        speaker.setAccent(this.spkAccent);
        speaker.setGender(this.spkGender);
        speaker.setDateOfBirth(this.spkDateOfBirth);
        return speaker;
    }
}

