/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.db.Speaker;
import ipsk.text.table.ColumnDescriptor;
import ipsk.text.table.TableExportProvider;
import ipsk.text.table.TableExportSchemaProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Speakers
implements TableExportProvider {
    private static SpeakersTableSchemaProvider tableSchemaProvider = new SpeakersTableSchemaProvider();
    private List<Speaker> speakers = new ArrayList<Speaker>();

    public List<Speaker> getSpeakers() {
        return this.speakers;
    }

    public void setSpeakers(List<Speaker> speakers) {
        this.speakers = speakers;
    }

    public int maxID() {
        int maxID = -1;
        for (Speaker s : this.speakers) {
            int sId = s.getPersonId();
            if (sId <= maxID) continue;
            maxID = sId;
        }
        return maxID;
    }

    public List<List<List<String>>> tableData(List<ColumnDescriptor> columns) {
        ArrayList<List<List<String>>> d = new ArrayList<List<List<String>>>(1);
        ArrayList dg = new ArrayList(1);
        for (Speaker spk : this.speakers) {
            ArrayList<String> row = new ArrayList<String>();
            for (ColumnDescriptor cd : columns) {
                String key = cd.getKeyName();
                if ("id".equals(key)) {
                    row.add(Integer.toString(spk.getPersonId()));
                    continue;
                }
                if ("code".equals(key)) {
                    row.add(spk.getCode());
                    continue;
                }
                if ("name".equals(key)) {
                    row.add(spk.getName());
                    continue;
                }
                if ("forename".equals(key)) {
                    row.add(spk.getForename());
                    continue;
                }
                if ("gender".equals(key)) {
                    row.add(spk.getGender());
                    continue;
                }
                if ("accent".equals(key)) {
                    row.add(spk.getAccent());
                    continue;
                }
                if (!"dateOfBirth".equals(key)) continue;
                row.add(spk.getDateOfBirthString());
            }
            dg.add(row);
        }
        d.add(dg);
        return d;
    }

    public List<List<List<String>>> tableData() {
        return this.tableData(tableSchemaProvider.getColumnDescriptors());
    }

    public static SpeakersTableSchemaProvider getTableSchemaProvider() {
        return tableSchemaProvider;
    }

    public static class SpeakersTableSchemaProvider
    implements TableExportSchemaProvider {
        static ColumnDescriptor[] colDescriptors = new ColumnDescriptor[]{new ColumnDescriptor("id", true), new ColumnDescriptor("code", true), new ColumnDescriptor("name", true), new ColumnDescriptor("forename", true), new ColumnDescriptor("gender", true), new ColumnDescriptor("accent", true), new ColumnDescriptor("dateOfBirth", true)};

        public List<ColumnDescriptor> getColumnDescriptors() {
            List<ColumnDescriptor> cdList = Arrays.asList(colDescriptors);
            return cdList;
        }

        public boolean isCompleteTableLossless() {
            return false;
        }
    }
}

