/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.audio;

import ipsk.apps.speechrecorder.audio.AudioManagerException;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProvider;
import ipsk.audio.DeviceProviderInfo;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.text.ParserException;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.sound.sampled.Mixer;

public class AudioManager {
    private AudioController2 audioController;
    private Logger logger = Logger.getLogger("ipsk.apps.speechrecorder");
    private List<? extends DeviceProviderInfo> deviceProviderInfosList;

    public AudioManager(AudioController2 audioController) {
        this.audioController = audioController;
    }

    private DeviceProviderInfo findDeviceProvider(MixerName.ProviderId providerIdObj, AJSAudioSystem.DeviceType devType) {
        for (DeviceProviderInfo deviceProviderInfo : this.deviceProviderInfosList) {
            String audioInterfaceName;
            String providerIdInterfaceName;
            String providerClassname;
            String pClassname = deviceProviderInfo.getImplementationClassname();
            if ((!AJSAudioSystem.DeviceType.CAPTURE.equals((Object)devType) || !deviceProviderInfo.isProvidesCaptureDevices()) && (!AJSAudioSystem.DeviceType.PLAYBACK.equals((Object)devType) || !deviceProviderInfo.isProvidesPlaybackDevices()) || !(MixerName.ProviderId.ProviderIdType.JAVA_CLASS.equals((Object)providerIdObj.getIdType()) ? (providerClassname = providerIdObj.getId()) != null && pClassname.equals(providerClassname) : (MixerName.ProviderId.ProviderIdType.SELECT_BY_NAME.equals((Object)providerIdObj.getIdType()) ? (providerIdInterfaceName = providerIdObj.getId()).equals(audioInterfaceName = deviceProviderInfo.getAudioInterfaceName()) : MixerName.ProviderId.ProviderIdType.SELECT_DEFAULT.equals((Object)providerIdObj.getIdType())))) continue;
            return deviceProviderInfo;
        }
        return null;
    }

    private DeviceProviderInfo findDeviceProvider(MixerName mixerName, AJSAudioSystem.DeviceType devType) throws ParserException {
        MixerName.ProviderId providerIdObj = mixerName.providerIdObj();
        DeviceProviderInfo dpi = this.findDeviceProvider(providerIdObj, devType);
        return dpi;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceInfo findMatchingDeviceInfo(MixerName[] mixerNames, AJSAudioSystem.DeviceType devType) throws AudioManagerException {
        void var3_6;
        if (this.deviceProviderInfosList == null) {
            try {
                this.deviceProviderInfosList = this.audioController.getDeviceProviderInfos();
            }
            catch (AudioControllerException audioControllerException) {
                throw new AudioManagerException(audioControllerException);
            }
            for (DeviceProviderInfo deviceProviderInfo : this.deviceProviderInfosList) {
                this.logger.info("Available audio device provider : " + deviceProviderInfo.getImplementationClassname() + " for audio interface " + deviceProviderInfo.getAudioInterfaceName());
            }
        }
        Object var3_5 = null;
        MixerName[] mixerNameArray = mixerNames;
        int n = mixerNames.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceProviderInfo dpi;
            MixerName mixerName = mixerNameArray[n2];
            String mName = mixerName.getName();
            try {
                dpi = this.findDeviceProvider(mixerName, devType);
            }
            catch (ParserException e1) {
                e1.printStackTrace();
                throw new AudioManagerException(e1);
            }
            if (dpi != null) {
                DeviceProvider dp = null;
                try {
                    dp = this.audioController.getInstance(dpi);
                }
                catch (AudioControllerException e) {
                    throw new AudioManagerException(e);
                }
                if (dp != null) {
                    List diList = null;
                    if (AJSAudioSystem.DeviceType.CAPTURE.equals((Object)devType)) {
                        diList = dp.getCaptureDeviceInfos();
                    } else if (AJSAudioSystem.DeviceType.PLAYBACK.equals((Object)devType)) {
                        diList = dp.getPlaybackDeviceInfos();
                    }
                    for (DeviceInfo di : diList) {
                        String diDevName;
                        Mixer.Info diMi = di.getMixerInfo();
                        if (diMi == null || (diDevName = diMi.getName()) == null) continue;
                        if (!mixerName.isRegex()) {
                            this.logger.finest("Comparing: " + diDevName + " " + mName);
                            if (!diDevName.equals(mName)) continue;
                            DeviceInfo deviceInfo = di;
                            break;
                        }
                        this.logger.fine("Pattern matching: " + diDevName + " " + mName + "...");
                        boolean match = false;
                        try {
                            match = diDevName.matches(mName);
                        }
                        catch (PatternSyntaxException pse) {
                            String msg = "Syntax error in regular expression: " + mName + "\n" + pse.getMessage();
                            this.logger.severe(msg);
                            throw new AudioManagerException("Syntax error in regex of audio device name pattern:\n" + msg, pse);
                        }
                        if (!match) continue;
                        DeviceInfo deviceInfo = di;
                        break;
                    }
                    if (var3_6 != null) break;
                }
                if (var3_6 != null) break;
            }
            ++n2;
        }
        return var3_6;
    }
}

