/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config;

import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.config.SpeakersConfiguration;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProviderInfo;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.sound.sampled.Mixer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigHelper {
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DOMCodec domCodec;
    private DOMConverter domConverter;

    public ConfigHelper() throws ClassNotFoundException, DOMCodecException {
        Package configBasePack = Class.forName("ipsk.apps.speechrecorder.config.ProjectConfiguration").getPackage();
        this.domCodec = new DOMCodec(configBasePack);
        this.domConverter = new DOMConverter();
    }

    public ProjectConfiguration cloneConfiguration(ProjectConfiguration projectConfig) throws DOMCodecException {
        return (ProjectConfiguration)this.domCodec.copy((Object)projectConfig);
    }

    public void writeConfig(ProjectConfiguration pc, File file) throws DOMCodecException, DOMConverterException, IOException {
        DOMCodec domCodec = new DOMCodec();
        Document d = domCodec.createDocument((Object)pc);
        DOMConverter domConverter = new DOMConverter();
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
        domConverter.writeXML(d, (Writer)ow);
        ow.close();
        fos.close();
    }

    public Version getProjectConfigurationVersion(InputStream projectConfigurationInputStream) {
        String versionString = this.getProjectConfigurationVersionString(projectConfigurationInputStream);
        try {
            return Version.parseString((String)versionString);
        }
        catch (ParserException e) {
            return null;
        }
    }

    public static void applyLegacyToStrictConversions(ProjectConfiguration legacyCfg) {
        String projectVersionStr = legacyCfg.getVersion();
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 6;
        Version strictVersion = new Version(nArray);
        try {
            Version projectVersion = Version.parseString((String)projectVersionStr);
            if (projectVersion.compareTo(strictVersion) < 0) {
                PromptConfiguration promptCfg;
                String promptUrlStr;
                SpeakersConfiguration spksCfg;
                String spksUrlStr;
                RecordingConfiguration recCfg = legacyCfg.getRecordingConfiguration();
                String recUrlStr = recCfg.getUrl();
                if (recUrlStr != null) {
                    String strictRecUrlstr = ConfigHelper.convertLegacyURLString(recUrlStr);
                    recCfg.setUrl(strictRecUrlstr);
                }
                if ((spksUrlStr = (spksCfg = legacyCfg.getSpeakers()).getSpeakersUrl()) != null) {
                    String strictSpksUrlstr = ConfigHelper.convertLegacyURLString(spksUrlStr);
                    spksCfg.setSpeakersUrl(strictSpksUrlstr);
                }
                if ((promptUrlStr = (promptCfg = legacyCfg.getPromptConfiguration()).getPromptsUrl()) != null) {
                    String strictPromptUrlstr = ConfigHelper.convertLegacyURLString(promptUrlStr);
                    promptCfg.setPromptsUrl(strictPromptUrlstr);
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public static String convertLegacyURLString(String legacyURL) {
        String strictURLString = legacyURL;
        if (File.separatorChar == '\\') {
            strictURLString = legacyURL.replace(File.separatorChar, '/');
        }
        return strictURLString;
    }

    public String getProjectConfigurationVersionString(InputStream projectConfigurationInputStream) {
        String versionStr = "1.9.2";
        try {
            Element pe;
            String attrVersionStr;
            Node peN;
            DocumentBuilder db = this.documentBuilderFactory.newDocumentBuilder();
            Document d = db.parse(projectConfigurationInputStream);
            NodeList peNl = d.getElementsByTagName("ProjectConfiguration");
            if (peNl != null && peNl.getLength() == 1 && (peN = peNl.item(0)) instanceof Element && "".equals(attrVersionStr = (pe = (Element)peN).getAttribute("version"))) {
                versionStr = attrVersionStr;
            }
        }
        catch (ParserConfigurationException e1) {
            return null;
        }
        catch (SAXException e1) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return versionStr;
    }

    public static MixerName[] getAJSConvertedMixerNames(AudioController2 audioController, MixerName[] orgMns) {
        if (orgMns == null) {
            return null;
        }
        int mnCount = orgMns.length;
        MixerName[] ajsConvertedMixerNames = new MixerName[mnCount];
        int i = 0;
        while (i < mnCount) {
            block10: {
                MixerName orgMn;
                ajsConvertedMixerNames[i] = orgMn = orgMns[i];
                MixerName.ProviderId providerIdObj = null;
                try {
                    providerIdObj = orgMn.providerIdObj();
                }
                catch (ParserException e1) {
                    e1.printStackTrace();
                }
                if (providerIdObj == null) {
                    MixerName cMn;
                    String orgName;
                    String newName = orgName = orgMn.getName();
                    String providerId = null;
                    String interfaceName = null;
                    if (audioController.supportsDeviceProviders()) {
                        Mixer.Info mInfo;
                        DeviceInfo ndi = null;
                        try {
                            ndi = audioController.convertLegacyDeviceName(orgName);
                        }
                        catch (AudioControllerException e) {
                            break block10;
                        }
                        DeviceProviderInfo dpi = ndi.getDeviceProviderInfo();
                        if (dpi != null) {
                            String dpiCn = dpi.getImplementationClassname();
                            MixerName.ProviderId pId = new MixerName.ProviderId(MixerName.ProviderId.ProviderIdType.JAVA_CLASS, dpiCn);
                            providerId = pId.toString();
                            interfaceName = dpi.getAudioInterfaceName();
                        }
                        if ((mInfo = ndi.getMixerInfo()) != null) {
                            newName = mInfo.getName();
                        }
                    }
                    ajsConvertedMixerNames[i] = cMn = new MixerName(providerId, interfaceName, newName, orgMn.isRegex());
                }
            }
            ++i;
        }
        return ajsConvertedMixerNames;
    }
}

