/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationPluginManager;
import ipsk.apps.speechrecorder.config.AutoAnnotation;
import ipsk.apps.speechrecorder.config.AutoAnnotator;
import ipsk.apps.speechrecorder.config.ui.AutoAnnotatorPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class AutoAnnotationPanel
extends JPanel
implements ActionListener {
    private List<AutoAnnotatorPanel> annotatorPanels = new ArrayList<AutoAnnotatorPanel>();
    private AutoAnnotationPluginManager autoAnnotationPluginManager;

    public AutoAnnotationPanel(AutoAnnotationPluginManager autoAnnotationPluginManager) {
        super(new GridBagLayout());
        this.autoAnnotationPluginManager = autoAnnotationPluginManager;
        List<AutoAnnotationServiceDescriptor> aasds = autoAnnotationPluginManager.getAutoAnnotatorServiceDescriptors();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        for (AutoAnnotationServiceDescriptor sd : aasds) {
            AutoAnnotatorPanel aap = new AutoAnnotatorPanel(sd);
            aap.setEnabled(false);
            aap.setActionListener(this);
            this.annotatorPanels.add(aap);
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)aap, c);
        }
        this.updateUIdependencies();
    }

    private void updateUIdependencies() {
        boolean changed = false;
        do {
            AutoAnnotationServiceDescriptor aasd;
            ArrayList<AutoAnnotationServiceDescriptor> activatedAas = new ArrayList<AutoAnnotationServiceDescriptor>();
            for (AutoAnnotatorPanel aap : this.annotatorPanels) {
                if (!aap.isSelected()) continue;
                aasd = aap.getServiceDescriptor();
                activatedAas.add(aasd);
            }
            changed = false;
            for (AutoAnnotatorPanel aap : this.annotatorPanels) {
                aasd = aap.getServiceDescriptor();
                boolean enabledBefore = aap.isEnabled();
                boolean depsOK = this.autoAnnotationPluginManager.checkDependencies(activatedAas, aasd);
                changed = changed || enabledBefore != depsOK;
                aap.setEnabled(depsOK);
            }
        } while (changed);
    }

    public void setAutoAnnotationConfig(AutoAnnotation aanno) {
        AutoAnnotator[] aas;
        for (AutoAnnotatorPanel aap : this.annotatorPanels) {
            aap.setConfig(null);
        }
        AutoAnnotator[] autoAnnotatorArray = aas = aanno.getAutoAnnotators();
        int n = aas.length;
        int n2 = 0;
        while (n2 < n) {
            AutoAnnotator aa = autoAnnotatorArray[n2];
            String scNm = aa.getClassname();
            for (AutoAnnotatorPanel aap : this.annotatorPanels) {
                String aapScNm = aap.getServiceDescriptor().getServiceImplementationClassname();
                if (!scNm.equals(aapScNm)) continue;
                aap.setConfig(aa);
                break;
            }
            ++n2;
        }
        this.updateUIdependencies();
    }

    public void applyValues(AutoAnnotation aanno) {
        ArrayList<AutoAnnotator> aastmp = new ArrayList<AutoAnnotator>();
        for (AutoAnnotatorPanel aap : this.annotatorPanels) {
            AutoAnnotator aaTemplate = new AutoAnnotator();
            aap.applyValues(aaTemplate);
            if (!aaTemplate.isEnabled()) continue;
            aastmp.add(aaTemplate);
        }
        AutoAnnotator[] aas = aastmp.toArray(new AutoAnnotator[0]);
        aanno.setAutoAnnotators(aas);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateUIdependencies();
    }
}

