/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ipsk.apps.speechrecorder.config.AutoAnnotator;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class AutoAnnotatorPanel
extends JPanel
implements ActionListener {
    private AutoAnnotationServiceDescriptor serviceDescriptor;
    private JCheckBox enabledCheckBox;
    private JLabel enableLabel;
    private ActionListener actionListener = null;

    public AutoAnnotationServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public boolean isSelected() {
        return this.enabledCheckBox.isSelected();
    }

    public AutoAnnotatorPanel(AutoAnnotationServiceDescriptor sd) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.serviceDescriptor = sd;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.enableLabel = new JLabel("Enable:");
        this.add((Component)this.enableLabel, c);
        ++c.gridx;
        this.enabledCheckBox = new JCheckBox();
        this.enabledCheckBox.addActionListener(this);
        this.add((Component)this.enabledCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Name:"), c);
        ++c.gridx;
        String title = this.serviceDescriptor.getTitle().localize();
        this.add((Component)new JLabel(title), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Description:"), c);
        ++c.gridx;
        String descr = this.serviceDescriptor.getDescription().localize();
        c.weightx = 2.0;
        this.add((Component)new JLabel(descr), c);
        c.weightx = 0.0;
        String[] links = null;
        Method getLinksM = null;
        try {
            getLinksM = this.serviceDescriptor.getClass().getMethod("getLinks", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (getLinksM != null) {
            try {
                Object res = getLinksM.invoke((Object)this.serviceDescriptor, new Object[0]);
                if (res instanceof String[]) {
                    links = (String[])res;
                }
            }
            catch (Exception res) {
                // empty catch block
            }
        }
        if (links != null && links.length > 0) {
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("Links:"), c);
            final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            String[] stringArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                String link = stringArray[n2];
                JTextField linkF = new JTextField(link);
                URI linkUri = null;
                try {
                    linkUri = new URI(link);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                final URI browseUri = linkUri;
                final AutoAnnotatorPanel msgCnt = this;
                linkF.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (desktop != null && browseUri != null) {
                            try {
                                desktop.browse(browseUri);
                            }
                            catch (IOException e1) {
                                JOptionPane.showMessageDialog(msgCnt, "Could not open browser!", "Desktop bowse error", 0);
                            }
                        }
                    }
                });
                EditorKitMenu nameEkm = new EditorKitMenu((JTextComponent)linkF, false);
                nameEkm.setPopupMenuActiv(true);
                c.gridx = 1;
                c.weightx = 2.0;
                this.add((Component)linkF, c);
                ++c.gridy;
                c.weightx = 0.0;
                ++n2;
            }
        }
    }

    public void applyValues(AutoAnnotator aa) {
        aa.setClassname(this.serviceDescriptor.getServiceImplementationClassname());
        aa.setEnabled(this.enabledCheckBox.isSelected());
    }

    public void setConfig(AutoAnnotator aa) {
        if (aa == null) {
            this.enabledCheckBox.setSelected(false);
        } else {
            this.enabledCheckBox.setSelected(aa.isEnabled());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableLabel.setEnabled(enabled);
        this.enabledCheckBox.setEnabled(enabled);
        boolean selected = this.enabledCheckBox.isSelected();
        this.enabledCheckBox.setSelected(selected && enabled);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }
}

