/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.ui.KeyInputMapView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptAudioView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptBeepConfigurationView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptCommonConfigurationView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptFontsConfigurationView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptScriptConfigurationView;
import ipsk.apps.speechrecorder.config.ui.prompt.PromptSpeakerPrompterConfigurationView;
import ipsk.apps.speechrecorder.config.ui.prompt.StartStopSignalConfigurationView;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.audio.AudioController2;
import java.awt.Component;
import java.net.URL;
import javax.swing.JTabbedPane;

public class PromptConfigurationView
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private StartStopSignalConfigurationView ssscv = new StartStopSignalConfigurationView();
    private PromptFontsConfigurationView pfcv = new PromptFontsConfigurationView();
    private PromptCommonConfigurationView pccv;
    private PromptSpeakerPrompterConfigurationView pspcv;
    private PromptScriptConfigurationView pscv;
    private PromptAudioView pacv;
    private PromptBeepConfigurationView pbcv;

    public PromptConfigurationView(AudioController2 audioController, KeyInputMapView keyInputMapView, ActiveProjectManager activeProjectManager) {
        this.pccv = new PromptCommonConfigurationView(activeProjectManager);
        this.pspcv = new PromptSpeakerPrompterConfigurationView(keyInputMapView);
        this.pscv = new PromptScriptConfigurationView();
        this.pacv = new PromptAudioView(audioController);
        this.pbcv = new PromptBeepConfigurationView();
        this.addTab("Start stop signal", (Component)((Object)this.ssscv));
        this.addTab("Fonts", this.pfcv);
        this.addTab("Common", (Component)((Object)this.pccv));
        this.addTab("Speaker window", this.pspcv);
        this.addTab("Script", this.pscv);
        this.addTab("Audio", this.pacv);
        this.addTab("Beep", (Component)((Object)this.pbcv));
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        PromptConfiguration promptConfiguration = projectConfiguration.getPromptConfiguration();
        this.ssscv.setPromptConfiguration(promptConfiguration);
        this.pfcv.setPromptConfiguration(promptConfiguration);
        this.pccv.setPromptConfiguration(promptConfiguration);
        this.pspcv.setPromptConfiguration(promptConfiguration);
        this.pscv.setPromptConfiguration(promptConfiguration);
        this.pacv.setProjectConfiguration(projectConfiguration);
        this.pbcv.setPromptBeep(promptConfiguration.getPromptBeep());
    }

    public void setProjectContext(URL projectContext) {
        this.pbcv.setProjectContext(projectContext);
    }

    public void applyValues(ProjectConfiguration p) {
        PromptConfiguration pc = p.getPromptConfiguration();
        this.ssscv.applyValues(pc);
        this.pfcv.applyValues(pc);
        this.pccv.applyValues(pc);
        this.pspcv.applyValues(pc);
        this.pscv.applyValues(pc);
        this.pacv.applyValues(p);
        this.pbcv.applyValues(pc.getPromptBeep());
    }
}

