/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.SpeakersConfiguration;
import ipsk.swing.text.EditorKitMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SpeakersView
extends JPanel
implements DocumentListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField urlField;
    private Document urlDoc;
    private JPanel content = new JPanel(new GridBagLayout());
    private JButton speakersUrlBrowseButton;

    public SpeakersView() {
        super(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        this.content.add((Component)new JLabel("Speakers URL:"), c);
        this.urlField = new JTextField();
        EditorKitMenu urlFieldEkm = new EditorKitMenu((JTextComponent)this.urlField);
        urlFieldEkm.setPopupMenuActiv(true);
        this.urlDoc = this.urlField.getDocument();
        this.urlDoc.addDocumentListener(this);
        c.weightx = 1.0;
        c.fill = 2;
        ++c.gridx;
        this.content.add((Component)this.urlField, c);
        this.speakersUrlBrowseButton = new JButton("Browse...");
        this.speakersUrlBrowseButton.addActionListener(this);
        c.fill = 0;
        ++c.gridx;
        c.weightx = 0.0;
        this.content.add((Component)this.speakersUrlBrowseButton, c);
        this.add((Component)this.content, "North");
    }

    public void setSpeakersConfiguration(SpeakersConfiguration speakersConfig) {
        String spksUriStr = speakersConfig.getSpeakersUrl();
        this.urlField.setText(spksUriStr);
    }

    public void applyValues(SpeakersConfiguration s) {
        s.setSpeakersUrl(this.urlField.getText());
    }

    public void documentChanged(DocumentEvent de) {
        Document src = de.getDocument();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.speakersUrlBrowseButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Select speaker database file");
            chooser.setFileSelectionMode(0);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File selFile = chooser.getSelectedFile();
                URI selFileUri = selFile.toURI();
                String selFileuriStr = selFileUri.toString();
                this.urlField.setText(selFileuriStr);
            }
        }
    }
}

