/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.audio;

import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ui.AudioDevicesTableModel;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProvider;
import ipsk.audio.DeviceProviderInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class DeviceListChooser
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = -389739661431600386L;
    private static final String PROTOTYPE_MIXERNAME = "Audio dummy prototype mixer name foo bla (dummy)";
    private JButton addButt;
    private JButton removeButt;
    private JComboBox interfaceTypeSelector;
    private JComboBox availDevicesSelector;
    private Vector<ActionListener> listeners;
    private AudioController2 controller;
    private AudioDevicesTableModel selectedDevicesTableModel;
    private JTable selectedDevicesTable;
    private AudioController2.DeviceType deviceType;
    private JScrollPane listScrollPane;
    private boolean adjusting = false;

    public DeviceListChooser(AudioController2 controller, AudioController2.DeviceType deviceType) {
        this(controller, deviceType, new MixerName[0]);
    }

    public DeviceListChooser(AudioController2 controller, AudioController2.DeviceType deviceType, MixerName[] selMixerNames) {
        this.controller = controller;
        this.deviceType = deviceType;
        List providerInfos = null;
        try {
            providerInfos = controller.getDeviceProviderInfos();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
            return;
        }
        int mpsdCount = providerInfos.size();
        if (mpsdCount < 1) {
            return;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.selectedDevicesTableModel = new AudioDevicesTableModel();
        if (selMixerNames != null) {
            MixerName[] mixerNameArray = selMixerNames;
            int n = selMixerNames.length;
            int n2 = 0;
            while (n2 < n) {
                MixerName mn = mixerNameArray[n2];
                this.selectedDevicesTableModel.add(mn);
                ++n2;
            }
        }
        this.selectedDevicesTableModel.addTableModelListener(this);
        this.selectedDevicesTable = new JTable(this.selectedDevicesTableModel);
        this.selectedDevicesTable.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.listeners = new Vector();
        Vector<InterfaceElement> interfaces = new Vector<InterfaceElement>();
        int i = 0;
        while (i < mpsdCount) {
            DeviceProviderInfo mpsd = (DeviceProviderInfo)providerInfos.get(i);
            if (AudioController2.DeviceType.CAPTURE.equals((Object)deviceType) && mpsd.isProvidesCaptureDevices() || AudioController2.DeviceType.PLAYBACK.equals((Object)deviceType) && mpsd.isProvidesPlaybackDevices()) {
                InterfaceElement ie = new InterfaceElement(mpsd);
                interfaces.add(ie);
            }
            ++i;
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 2.0;
        JLabel listedMixersLabel = new JLabel("Allowed devices:");
        this.add((Component)listedMixersLabel, c);
        ++c.gridy;
        c.weighty = 2.0;
        this.selectedDevicesTable.getSelectionModel().setSelectionMode(0);
        this.selectedDevicesTable.getSelectionModel().addListSelectionListener(this);
        this.selectedDevicesTable.setDragEnabled(true);
        this.listScrollPane = new JScrollPane(this.selectedDevicesTable);
        this.add((Component)this.listScrollPane, c);
        c.weighty = 0.0;
        ++c.gridy;
        JPanel buttPanel = new JPanel(){
            private static final long serialVersionUID = 8969034884681272616L;

            @Override
            public void setEnabled(boolean enabled) {
                Component[] componentArray = this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    child.setEnabled(enabled);
                    ++n2;
                }
            }
        };
        this.addButt = new JButton("Add");
        this.addButt.addActionListener(this);
        buttPanel.add(this.addButt);
        this.removeButt = new JButton("Remove");
        this.removeButt.addActionListener(this);
        buttPanel.add(this.removeButt);
        this.add((Component)buttPanel, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        JLabel interfaceTypeLabel = new JLabel("Interface:");
        this.add((Component)interfaceTypeLabel, c);
        ++c.gridx;
        c.weightx = 2.0;
        c.anchor = 17;
        c.fill = 2;
        this.interfaceTypeSelector = new JComboBox(interfaces);
        this.interfaceTypeSelector.addActionListener(this);
        this.add((Component)this.interfaceTypeSelector, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        JLabel deviceLabel = new JLabel("Device:");
        this.add((Component)deviceLabel, c);
        this.availDevicesSelector = new JComboBox();
        this.availDevicesSelector.addActionListener(this);
        this.availDevicesSelector.setPrototypeDisplayValue(PROTOTYPE_MIXERNAME);
        ++c.gridx;
        c.weightx = 2.0;
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)this.availDevicesSelector, c);
        if (mpsdCount > 0) {
            InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
            this.loadDeviceList(ie);
        }
        this.setSelectedMixerNames(selMixerNames);
        this.updateEnabledActions();
    }

    public void stopEditing() {
        TableCellEditor ce = this.selectedDevicesTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    private boolean loadDeviceList(InterfaceElement ie) {
        boolean hasMatchingDevices = false;
        this.availDevicesSelector.removeAllItems();
        this.availDevicesSelector.setEnabled(false);
        DeviceProviderInfo dpi = ie.getMpsd();
        DeviceProvider dp = null;
        try {
            dp = this.controller.getInstance(dpi);
            List dis = null;
            if (AudioController2.DeviceType.CAPTURE.equals((Object)this.deviceType)) {
                dis = dp.getCaptureDeviceInfos();
            } else if (AudioController2.DeviceType.PLAYBACK.equals((Object)this.deviceType)) {
                dis = dp.getPlaybackDeviceInfos();
            }
            if (dis != null && dis.size() > 0) {
                hasMatchingDevices = true;
                this.availDevicesSelector.setEnabled(true);
                for (DeviceInfo di : dis) {
                    Mixer.Info mInfo = di.getMixerInfo();
                    DeviceView dv = new DeviceView(mInfo);
                    this.availDevicesSelector.addItem(dv);
                }
            }
        }
        catch (AudioControllerException e) {
            hasMatchingDevices = false;
        }
        return hasMatchingDevices;
    }

    public void setSelectedMixerNames(MixerName[] selectedMixerNames) {
        this.adjusting = true;
        this.selectedDevicesTableModel.clear();
        if (selectedMixerNames != null) {
            MixerName[] mixerNameArray = selectedMixerNames;
            int n = selectedMixerNames.length;
            int n2 = 0;
            while (n2 < n) {
                MixerName sm = mixerNameArray[n2];
                this.selectedDevicesTableModel.add(sm);
                ++n2;
            }
        }
        this.adjusting = false;
        this.updateEnabledActions();
    }

    public MixerName[] getSelectedMixerNames() {
        List<MixerName> selMnList = this.selectedDevicesTableModel.getDeviceNames();
        return selMnList.toArray(new MixerName[0]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] children;
        super.setEnabled(enabled);
        Component[] componentArray = children = this.getComponents();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Component ch = componentArray[n2];
            ch.setEnabled(enabled);
            ++n2;
        }
        this.selectedDevicesTable.setEnabled(enabled);
        if (enabled) {
            this.updateEnabledActions();
        }
    }

    private MixerName getSelected() {
        InterfaceElement selInterfaceE = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
        DeviceProviderInfo dpi = selInterfaceE.getMpsd();
        String pClname = dpi.getImplementationClassname();
        MixerName.ProviderId pIdObj = new MixerName.ProviderId(MixerName.ProviderId.ProviderIdType.JAVA_CLASS, pClname);
        String providerId = pIdObj.toString();
        String interfaceName = dpi.getAudioInterfaceName();
        DeviceView dv = (DeviceView)this.availDevicesSelector.getSelectedItem();
        if (dv == null) {
            return null;
        }
        String deviceName = dv.getMixerInfo().getName();
        MixerName mn = new MixerName(providerId, interfaceName, deviceName);
        return mn;
    }

    private void updateEnabledActions() {
        boolean enabled = this.isEnabled();
        boolean addAble = false;
        MixerName mn = this.getSelected();
        if (mn != null) {
            addAble = !this.selectedDevicesTableModel.contains(mn);
        }
        this.addButt.setEnabled(addAble && enabled);
        if (this.selectedDevicesTable.getSelectionModel().isSelectionEmpty()) {
            this.removeButt.setEnabled(false);
        } else {
            this.removeButt.setEnabled(enabled);
        }
        this.selectedDevicesTable.setEnabled(enabled);
        this.interfaceTypeSelector.setEnabled(enabled);
        this.availDevicesSelector.setEnabled(enabled);
        this.listScrollPane.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.interfaceTypeSelector) {
            InterfaceElement ie = (InterfaceElement)this.interfaceTypeSelector.getSelectedItem();
            this.loadDeviceList(ie);
        } else if (src == this.addButt) {
            MixerName mn = this.getSelected();
            this.selectedDevicesTableModel.add(mn);
            this.fireAction();
        } else if (src == this.removeButt) {
            int selRow = this.selectedDevicesTable.getSelectedRow();
            if (selRow >= 0) {
                this.selectedDevicesTableModel.remove(selRow);
            }
            this.fireAction();
        }
        this.updateEnabledActions();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.updateEnabledActions();
    }

    protected synchronized void fireAction() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 1001, "device_chooser_list_changed"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener != null && !this.listeners.contains(actionListener)) {
            this.listeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.removeElement(actionListener);
        }
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (!this.adjusting) {
            this.fireAction();
        }
    }

    public class DeviceView {
        private Mixer.Info mixerInfo;

        public DeviceView(Mixer.Info mInfo) {
            this.mixerInfo = mInfo;
        }

        public String toString() {
            if (this.mixerInfo == null) {
                return "(Default device)";
            }
            return this.mixerInfo.getName();
        }

        public Mixer.Info getMixerInfo() {
            return this.mixerInfo;
        }

        public boolean equals(Object o) {
            DeviceView oDv;
            Mixer.Info oMi;
            if (o == this) {
                return true;
            }
            return o instanceof DeviceView && ((oMi = (oDv = (DeviceView)o).getMixerInfo()) != null ? oMi.equals(this.mixerInfo) : this.mixerInfo == null);
        }
    }

    public class InterfaceElement {
        private DeviceProviderInfo mpsd;

        InterfaceElement(DeviceProviderInfo mpsd) {
            this.mpsd = mpsd;
        }

        public String toString() {
            return this.mpsd.getAudioInterfaceName();
        }

        public boolean equals(Object o) {
            InterfaceElement oIe;
            if (o == this) {
                return true;
            }
            return o instanceof InterfaceElement && this.mpsd.equals((oIe = (InterfaceElement)o).getMpsd());
        }

        public DeviceProviderInfo getMpsd() {
            return this.mpsd;
        }
    }
}

