/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.prompt;

import ipsk.apps.speechrecorder.config.PromptBeep;
import ipsk.audio.dsp.DSPUtils;
import ipsk.io.StreamCopy;
import ipsk.net.URLContext;
import ipsk.swing.panel.JConfigPanel;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

public class PromptBeepConfigurationView
extends JConfigPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH = "resources";
    private URL projectContext;
    private JCheckBox defaultBeepCb;
    private JTextField promptBeepUrlWidget;
    private JButton importButton;
    private JSpinner volumeSpinner;
    private PromptBeep currentConfig;
    private JLabel beepUrlLabel;

    public PromptBeepConfigurationView() {
        JPanel cp = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        cp.setLayout(layout);
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.0;
        gc.fill = 2;
        gc.insets = new Insets(2, 5, 2, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        JLabel defaultBeepLbl = new JLabel("Default beep");
        this.defaultBeepCb = new JCheckBox();
        this.defaultBeepCb.addActionListener(this);
        cp.add((Component)defaultBeepLbl, gc);
        ++gc.gridx;
        cp.add((Component)this.defaultBeepCb, gc);
        this.beepUrlLabel = new JLabel("Beep file URL");
        this.promptBeepUrlWidget = new JTextField(20);
        new EditorKitMenu((JTextComponent)this.promptBeepUrlWidget);
        this.promptBeepUrlWidget.addActionListener(this);
        this.promptBeepUrlWidget.setToolTipText("Enter a URL from which to retrieve the prompt beep audio file.");
        this.importButton = new JButton("Import");
        this.importButton.addActionListener(this);
        gc.gridx = 0;
        ++gc.gridy;
        cp.add((Component)this.beepUrlLabel, gc);
        ++gc.gridx;
        cp.add((Component)this.promptBeepUrlWidget, gc);
        ++gc.gridx;
        cp.add((Component)this.importButton, gc);
        JLabel volumeLabel = new JLabel("Volume dB");
        this.volumeSpinner = new JSpinner(new SpinnerNumberModel(0, -90, 6, 1));
        this.volumeSpinner.setToolTipText("Enter a value between -90 (nearly silent) and 0 (full volume) for the output volume of the prompt beep.");
        gc.gridx = 0;
        ++gc.gridy;
        cp.add((Component)volumeLabel, gc);
        ++gc.gridx;
        cp.add((Component)this.volumeSpinner, gc);
    }

    public void setPromptBeep(PromptBeep promptBeep) {
        this.currentConfig = promptBeep;
        String beepFileUrl = promptBeep.getBeepFileURL();
        boolean defBeep = beepFileUrl == null;
        String beepFileUrlStr = defBeep ? "" : beepFileUrl;
        this.defaultBeepCb.setSelected(defBeep);
        this.promptBeepUrlWidget.setText(beepFileUrlStr);
        Double beepvol = promptBeep.getBeepGainRatio();
        if (beepvol == null) {
            this.volumeSpinner.setValue(new Integer(0));
        } else {
            int beepLvlInt = (int)DSPUtils.getLevelInDB((double)beepvol);
            this.volumeSpinner.setValue(beepLvlInt);
        }
        this.setDependencies();
    }

    public void applyValues(PromptBeep p) {
        if (this.defaultBeepCb.isSelected()) {
            p.setBeepFileURL(null);
        } else {
            p.setBeepFileURL(this.promptBeepUrlWidget.getText());
        }
        Integer volDbInt = (Integer)this.volumeSpinner.getValue();
        double volDb = volDbInt.doubleValue();
        double volRatio = DSPUtils.toLinearLevel((double)volDb);
        p.setBeepGainRatio(volRatio);
    }

    private void setDependencies() {
        boolean defaultBeep = this.defaultBeepCb.isSelected();
        this.beepUrlLabel.setEnabled(!defaultBeep);
        this.promptBeepUrlWidget.setEnabled(!defaultBeep);
        this.importButton.setEnabled(!defaultBeep);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object as = ae.getSource();
        if (as == this.importButton) {
            JFileChooser chooser;
            block20: {
                chooser = new JFileChooser();
                chooser.setDialogTitle("Import prompt beep audio file");
                chooser.setApproveButtonText("Import");
                chooser.setApproveButtonToolTipText("Copies beep prompt audio file into the project workspace");
                chooser.setFileSelectionMode(0);
                try {
                    URL currentSrcUrl = new URL(this.promptBeepUrlWidget.getText());
                    if (currentSrcUrl == null || !"file".equalsIgnoreCase(currentSrcUrl.getProtocol())) break block20;
                    File preselectedFile = null;
                    try {
                        URI preselectedURI = currentSrcUrl.toURI();
                        String preselectedFilePath = preselectedURI.getPath();
                        if (preselectedFilePath != null) {
                            preselectedFile = new File(preselectedFilePath);
                        }
                    }
                    catch (URISyntaxException preselectedURI) {
                        // empty catch block
                    }
                    if (preselectedFile != null && preselectedFile.exists()) {
                        chooser.setSelectedFile(preselectedFile);
                    }
                }
                catch (MalformedURLException currentSrcUrl) {
                    // empty catch block
                }
            }
            File resProjFile = null;
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File selFile = chooser.getSelectedFile();
                String relProjPath = JOptionPane.showInputDialog((Component)((Object)this), "Please input relative path to store the resource", "resources/audio");
                String relprojResFilePath = String.valueOf(relProjPath) + "/" + selFile.getName();
                try {
                    URL projResUrl = URLContext.getContextURL((URL)this.projectContext, (String)relprojResFilePath);
                    URI projResUri = projResUrl.toURI();
                    String projResFilePath = projResUri.getPath();
                    resProjFile = new File(projResFilePath);
                    if (resProjFile.exists()) {
                        if (selFile.equals(resProjFile)) {
                            int selectSameFile = JOptionPane.showConfirmDialog((Component)((Object)this), resProjFile + " is same file.\nDo you want to select this file?");
                            if (selectSameFile != 0) {
                                return;
                            }
                        } else {
                            int overwriteRes = JOptionPane.showConfirmDialog((Component)((Object)this), resProjFile + " already exists.\nDo you want to overwrite?");
                            if (overwriteRes != 0) {
                                return;
                            }
                            StreamCopy.copy((File)selFile, (File)resProjFile, (boolean)true);
                        }
                    } else {
                        StreamCopy.copy((File)selFile, (File)resProjFile, (boolean)true);
                    }
                    this.promptBeepUrlWidget.setText(relprojResFilePath);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)this), "Could not convert to valid URL:\n" + e1.getMessage(), "Malformed URL error", 0);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    if (resProjFile != null) {
                        resProjFile.delete();
                    }
                    JOptionPane.showMessageDialog((Component)((Object)this), "Input/Output error:\n" + e2.getMessage(), "I/O error", 0);
                }
                catch (URISyntaxException e3) {
                    e3.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)this), "Could not convert to valid URI:\n" + e3.getMessage(), "URI syntax error", 0);
                }
            }
        } else {
            super.actionPerformed(ae);
        }
        this.setDependencies();
    }

    public void resetToDefaults() {
        PromptBeep defaultConfig = new PromptBeep();
        PromptBeep oldCurrentConfig = this.currentConfig;
        this.setPromptBeep(defaultConfig);
        this.currentConfig = oldCurrentConfig;
    }

    public void resetToInitial() {
        this.setPromptBeep(this.currentConfig);
    }

    public void setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
    }
}

