/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.recording;

import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.swing.panel.JConfigPanel;
import ipsk.swing.text.EditorKitMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class RecordingMainView
extends JConfigPanel
implements DocumentListener,
ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JLabel progressToNextUnrecordedLabel;
    private JCheckBox resetPeakOnRecordingCheckBox;
    private Document urlDoc;
    private JComboBox numLineBox;
    private JCheckBox progressToNextUnrecordedCheckbox;
    private JComboBox modeBox;
    private JTextField urlField;
    private JSpinner preRecDelSpinner;
    private JLabel preRecLabel;
    private JSpinner postRecDelSpinner;
    private JLabel postRecLabel;
    private JCheckBox forcePostRecPhaseCheckBox;
    private JCheckBox seamlessCheckBox;
    private JPanel recCfgPanel;
    private EnumVector<RecordingConfiguration.CaptureScope> captureScopes = new EnumVector(RecordingConfiguration.CaptureScope.class);
    private JComboBox captureScopeBox;
    private EnumVector<PrimaryRecordTarget> primaryRecordTargets = new EnumVector(PrimaryRecordTarget.class);
    private JComboBox primaryRecordTargetBox;
    private JCheckBox overwriteCheckBox;
    private JCheckBox overwriteWarningCheckBox;
    private String[] modes = new String[]{RecordingConfiguration.MANUAL, RecordingConfiguration.AUTOPROGRESS, RecordingConfiguration.AUTORECORDING};
    private JTextField recShortKey;
    private JButton recsUrlBrowseButton;
    private RecordingConfiguration currentConfig;

    public RecordingMainView() {
        JPanel contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.recCfgPanel = new JPanel();
        this.recCfgPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        c.anchor = 19;
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.gridwidth = 2;
        c2.insets = new Insets(2, 5, 2, 5);
        c2.anchor = 19;
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 2;
        c3.gridwidth = 1;
        c3.insets = new Insets(2, 5, 2, 5);
        c3.anchor = 19;
        c.gridy = 0;
        c2.gridy = c.gridy++;
        this.captureScopeBox = new JComboBox<RecordingConfiguration.CaptureScope>((Vector<RecordingConfiguration.CaptureScope>)this.captureScopes);
        this.captureScopeBox.addActionListener(this);
        JLabel captureScopeLabel = new JLabel("Audio capture scope:");
        this.recCfgPanel.add((Component)captureScopeLabel, c);
        this.recCfgPanel.add((Component)this.captureScopeBox, c2);
        ++c2.gridy;
        this.primaryRecordTargetBox = new JComboBox<PrimaryRecordTarget>((Vector<PrimaryRecordTarget>)this.primaryRecordTargets);
        this.primaryRecordTargetBox.addActionListener(this);
        JLabel useTempFileLabel = new JLabel("Recording target:");
        this.recCfgPanel.add((Component)useTempFileLabel, c);
        this.recCfgPanel.add((Component)this.primaryRecordTargetBox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteCheckBox.addActionListener(this);
        JLabel overwriteLabel = new JLabel("Overwrite:");
        this.recCfgPanel.add((Component)overwriteLabel, c);
        this.recCfgPanel.add((Component)this.overwriteCheckBox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.overwriteWarningCheckBox = new JCheckBox();
        this.overwriteWarningCheckBox.addActionListener(this);
        JLabel overwriteWarningLabel = new JLabel("Overwrite warning:");
        this.recCfgPanel.add((Component)overwriteWarningLabel, c);
        this.recCfgPanel.add((Component)this.overwriteWarningCheckBox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.modeBox = new JComboBox<String>(this.modes);
        this.modeBox.addActionListener(this);
        this.recCfgPanel.add((Component)new JLabel("Recording mode:"), c);
        this.recCfgPanel.add((Component)this.modeBox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.seamlessCheckBox = new JCheckBox();
        this.seamlessCheckBox.addActionListener(this);
        this.recCfgPanel.add((Component)new JLabel("Seamless (auto) recording:"), c);
        this.recCfgPanel.add((Component)this.seamlessCheckBox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.progressToNextUnrecordedCheckbox = new JCheckBox();
        this.progressToNextUnrecordedCheckbox.addActionListener(this);
        this.progressToNextUnrecordedLabel = new JLabel("Autoprogress to next unrecorded item:");
        this.recCfgPanel.add((Component)this.progressToNextUnrecordedLabel, c);
        this.recCfgPanel.add((Component)this.progressToNextUnrecordedCheckbox, c2);
        ++c.gridy;
        ++c2.gridy;
        this.resetPeakOnRecordingCheckBox = new JCheckBox();
        this.resetPeakOnRecordingCheckBox.addActionListener(this);
        this.recCfgPanel.add((Component)new JLabel("Reset peak at start of recording:"), c);
        this.recCfgPanel.add((Component)this.resetPeakOnRecordingCheckBox, c2);
        Integer min = new Integer(0);
        Integer max = new Integer(1000000);
        Integer step = new Integer(100);
        SpinnerNumberModel model = new SpinnerNumberModel(min, min, max, step);
        c2.gridwidth = 1;
        this.preRecDelSpinner = new JSpinner(model);
        this.preRecLabel = new JLabel("Default prerecording delay:");
        ++c.gridy;
        ++c2.gridy;
        this.recCfgPanel.add((Component)this.preRecLabel, c);
        this.recCfgPanel.add((Component)this.preRecDelSpinner, c2);
        this.preRecDelSpinner.addChangeListener(this);
        c3.gridy = c.gridy++;
        c3.anchor = 17;
        this.recCfgPanel.add((Component)new JLabel("ms"), c3);
        SpinnerNumberModel postmodel = new SpinnerNumberModel(min, min, max, step);
        this.postRecDelSpinner = new JSpinner(postmodel);
        this.postRecDelSpinner.addChangeListener(this);
        this.postRecLabel = new JLabel("Default postrecording delay:");
        ++c2.gridy;
        this.recCfgPanel.add((Component)this.postRecLabel, c);
        this.recCfgPanel.add((Component)this.postRecDelSpinner, c2);
        c3.gridy = c.gridy++;
        this.recCfgPanel.add((Component)new JLabel("ms"), c3);
        c2.gridwidth = 2;
        ++c2.gridy;
        this.forcePostRecPhaseCheckBox = new JCheckBox();
        this.forcePostRecPhaseCheckBox.addActionListener(this);
        this.recCfgPanel.add((Component)new JLabel("Force post recording phase:"), c);
        this.recCfgPanel.add((Component)this.forcePostRecPhaseCheckBox, c2);
        ++c.gridy;
        ++c2.gridy;
        c3.gridy = c.gridy;
        this.recCfgPanel.add((Component)new JLabel("Recording URL (directory):"), c);
        this.urlField = new JTextField();
        this.urlDoc = this.urlField.getDocument();
        this.urlDoc.addDocumentListener(this);
        EditorKitMenu urlFieldEkm = new EditorKitMenu((JTextComponent)this.urlField);
        urlFieldEkm.setPopupMenuActiv(true);
        c2.gridwidth = 1;
        this.recCfgPanel.add((Component)this.urlField, c2);
        this.recsUrlBrowseButton = new JButton("Browse...");
        this.recsUrlBrowseButton.addActionListener(this);
        this.recCfgPanel.add((Component)this.recsUrlBrowseButton, c3);
        c2.gridwidth = 2;
        contentPane.add((Component)this.recCfgPanel, "Center");
    }

    public void resetToInitial() {
        this.setRecordingConfiguration(this.currentConfig);
    }

    public void resetToDefaults() {
        RecordingConfiguration defaultConfig = new RecordingConfiguration();
        RecordingConfiguration oldCurrentConfig = this.currentConfig;
        defaultConfig.setCaptureScope(RecordingConfiguration.CaptureScope.SESSION);
        this.setRecordingConfiguration(defaultConfig);
        this.currentConfig = oldCurrentConfig;
    }

    public void setRecordingConfiguration(RecordingConfiguration recordingConfiguration) {
        this.preRecDelSpinner.setValue(new Integer(recordingConfiguration.getPreRecDelay()));
        this.postRecDelSpinner.setValue(new Integer(recordingConfiguration.getPostRecDelay()));
        this.forcePostRecPhaseCheckBox.setSelected(recordingConfiguration.isForcePostRecDelayPhase());
        RecordingConfiguration.CaptureScope los = recordingConfiguration.getCaptureScope();
        if (los == null) {
            los = RecordingConfiguration.CaptureScope.ITEM;
        }
        EnumSelectionItem losi = new EnumSelectionItem((Enum)los);
        this.captureScopeBox.setSelectedItem(losi);
        PrimaryRecordTarget prt = recordingConfiguration.getPrimaryRecordTarget();
        EnumSelectionItem prti = new EnumSelectionItem((Enum)prt);
        this.primaryRecordTargetBox.setSelectedItem(prti);
        this.overwriteCheckBox.setSelected(recordingConfiguration.getOverwrite());
        this.overwriteWarningCheckBox.setSelected(recordingConfiguration.isOverwriteWarning());
        this.urlField.setText(recordingConfiguration.getUrl());
        this.modeBox.setSelectedItem(recordingConfiguration.getMode());
        this.seamlessCheckBox.setSelected(recordingConfiguration.isSeamlessAutorecording());
        this.progressToNextUnrecordedCheckbox.setSelected(recordingConfiguration.getProgressToNextUnrecorded());
        this.resetPeakOnRecordingCheckBox.setSelected(recordingConfiguration.getResetPeakOnRecording());
        this.setDependencies();
        this.currentConfig = recordingConfiguration;
    }

    public void applyValues(RecordingConfiguration r) {
        r.setPreRecDelay((Integer)this.preRecDelSpinner.getValue());
        r.setPostRecDelay((Integer)this.postRecDelSpinner.getValue());
        r.setForcePostRecDelayPhase(this.forcePostRecPhaseCheckBox.isSelected());
        EnumSelectionItem selLos = (EnumSelectionItem)this.captureScopeBox.getSelectedItem();
        r.setCaptureScope((RecordingConfiguration.CaptureScope)selLos.getEnumVal());
        EnumSelectionItem selPRT = (EnumSelectionItem)this.primaryRecordTargetBox.getSelectedItem();
        r.setPrimaryRecordTarget((PrimaryRecordTarget)selPRT.getEnumVal());
        r.setOverwrite(this.overwriteCheckBox.isSelected());
        r.setOverwriteWarning(this.overwriteWarningCheckBox.isSelected());
        r.setMode((String)this.modeBox.getSelectedItem());
        r.setSeamlessAutorecording(this.seamlessCheckBox.isSelected());
        r.setProgressToNextUnrecorded(this.progressToNextUnrecordedCheckbox.isSelected());
        r.setResetPeakOnRecording(this.resetPeakOnRecordingCheckBox.isSelected());
        r.setUrl(this.urlField.getText());
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Object src = ce.getSource();
        if (src != this.preRecDelSpinner) {
            // empty if block
        }
    }

    private void setDependencies() {
        EnumSelectionItem selPRT = (EnumSelectionItem)this.primaryRecordTargetBox.getSelectedItem();
        PrimaryRecordTarget prt = (PrimaryRecordTarget)selPRT.getEnumVal();
        boolean seamlessEnabled = PrimaryRecordTarget.DIRECT.equals((Object)prt);
        this.seamlessCheckBox.setEnabled(seamlessEnabled);
        boolean primaryRecordTargetEnabled = !this.seamlessCheckBox.isSelected();
        this.primaryRecordTargetBox.setEnabled(primaryRecordTargetEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.recsUrlBrowseButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Select recordings directory");
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File selFile = chooser.getSelectedFile();
                URI selFileUri = selFile.toURI();
                String selFileuriStr = selFileUri.toString();
                this.urlField.setText(selFileuriStr);
            }
        }
        super.actionPerformed(ae);
        this.setDependencies();
    }

    public void documentChanged(DocumentEvent de) {
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }
}

