/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.project;

import ips.annot.BundleAnnotationPersistor;
import ips.annot.BundleAnnotationPersistorServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Schema;
import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.SpeechRecorderUI;
import ipsk.apps.speechrecorder.TimeLogFormatter;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.actions.EditScriptAction;
import ipsk.apps.speechrecorder.actions.ExportScriptAction;
import ipsk.apps.speechrecorder.actions.ImportScriptAction;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationPluginManager;
import ipsk.apps.speechrecorder.audio.AudioManager;
import ipsk.apps.speechrecorder.audio.AudioManagerException;
import ipsk.apps.speechrecorder.config.BundleAnnotationPersistorConfig;
import ipsk.apps.speechrecorder.config.ChannelRouting;
import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.Formatter;
import ipsk.apps.speechrecorder.config.Handler;
import ipsk.apps.speechrecorder.config.ItemcodeGeneratorConfiguration;
import ipsk.apps.speechrecorder.config.Logger;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import ipsk.apps.speechrecorder.monitor.plugins.SimpleTrafficLight;
import ipsk.apps.speechrecorder.project.NewProjectConfiguration;
import ipsk.apps.speechrecorder.project.ProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.project.ProjectManagerListener;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectClosedEvent;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectOpenedEvent;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectReadyForShutdownEvent;
import ipsk.apps.speechrecorder.prompting.PromptPresenterPluginManager;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.RecScriptSchemaVersionNewerException;
import ipsk.apps.speechrecorder.script.RecScriptStoreStatusChanged;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptManagerEvent;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.script.RecscriptManagerListener;
import ipsk.apps.speechrecorder.session.SessionManager;
import ipsk.apps.speechrecorder.session.SessionManagerListener;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioController4;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioSource;
import ipsk.audio.DeviceInfo;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.samples.SampleManager;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.io.FileUtils;
import ipsk.io.StreamCopy;
import ipsk.net.SimplePasswordAuthentication;
import ipsk.net.URLContext;
import ipsk.net.Upload;
import ipsk.net.UploadCache;
import ipsk.net.UploadException;
import ipsk.net.UploadFile;
import ipsk.persistence.AtomicIntegerSequenceGenerator;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.util.collections.ObservableArrayList;
import ipsk.util.collections.ObservableList;
import ipsk.util.logging.FileHandler;
import ipsk.util.services.ServicesInspector;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ActiveProjectManager
extends ProjectManager
implements RecscriptManagerListener,
SessionManagerListener {
    public static final boolean DEBUG = false;
    private final String LOG_FILE_SUFFIX = "_log.log";
    private final String TIME_LOG_FILE_SUFFIX = "_timelog.log";
    private final String TEMP_FILE_PREFIX = "IPSK_";
    private final String REC_SCRIPT_EXAMPLE = "ExampleRecScript_4.xml";
    public final String PREFERRED_START_STOP_SIGNAL_PLUGIN = "ips.apps.speechrecorder.startstopsignal.Ampelmaennchen";
    private long SHUTDOWN_RETRY_DELAY = 2000L;
    public String LOG_HANDLER_NAME = "default";
    public String TIMELOG_HANDLER_NAME = "timelog";
    public static Handler[] DEF_LOG_HANDLERS = new Handler[0];
    protected static final Formatter TIME_LOG_FORMATTER_CFG = new Formatter(TimeLogFormatter.class.getName(), "Time logger");
    public static final Formatter[] LOG_FORMATTERS = new Formatter[]{new Formatter(null, "(Default)"), new Formatter("java.util.logging.SimpleFormatter", "Plain Text"), new Formatter("java.util.logging.XMLFormatter", "XML"), TIME_LOG_FORMATTER_CFG};
    private static final float PREFERRED_LINE_BUFFER_SIZE_MILLIS = 4000.0f;
    public static Logger[] AVAIL_LOGGERS = new Logger[0];
    public static Action[] ACTIONS = new Action[0];
    private java.util.logging.Logger logger;
    private FileHandler logFileHandler;
    private FileHandler timeLogFileHandler;
    private java.util.logging.Logger timeLogger;
    private DOMConverter domConverter;
    private URL projectURL;
    private boolean projectConfigurationSaved;
    private GraphicsConfiguration speakerScreenConfig = null;
    private GraphicsConfiguration experimenterScreenConfig = null;
    protected ActiveSessionStorageManager storageManager;
    private SessionManager sessionManager;
    private AudioManager audioManager;
    private AudioController4 audioController;
    private boolean audioEnabled;
    private UIResources uiString;
    private SpeechRecorderUI speechRecorderUI;
    private File lastPromptSelectionDir = null;
    private AudioFileFormat audioFileFormat;
    private String audioControllerClassName;
    private UploadCache uploadCache;
    private boolean useUploadCache;
    private boolean waitForCompleteUpload;
    private boolean uploadDuringSessionRecording = true;
    private EditScriptAction editScriptAction;
    private ImportScriptAction importScriptAction;
    private Player beepPlayer;
    private Mixer promptMixer;
    private PrimaryRecordTarget primaryRecordTarget;
    private PromptPresenterPluginManager promptPresenterPluginManager;
    private AutoAnnotationPluginManager autoAnnotatorPluginManager;
    private ItemcodeGenerator itemcodeGenerator;
    private Schema schema;
    private List<BundleAnnotationPersistor> bundleAnnotationPersistorList = new ArrayList<BundleAnnotationPersistor>();
    private List<BundleAnnotationPersistorServiceDescriptor> availableBundleAnnotationServiceDescriptors;
    private ExportScriptAction exportScriptAction;
    private Integer lastSessionId = null;
    private Set<String> itemCodesInUse = null;
    private AtomicIntegerSequenceGenerator sequenceGenerator;
    private File workspaceDir;
    private ProjectManagerListener listener = null;
    protected List<AutoAnnotator> enabledAutoAnnotators;

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSpeechRecorderUI(SpeechRecorderUI speechRecorderUI) {
        this.speechRecorderUI = speechRecorderUI;
        this.sessionManager.setSpeechRecorderUI(speechRecorderUI);
        Action[] sessionActions = this.sessionManager.getActions();
        ACTIONS = new Action[sessionActions.length + 3];
        int i = 0;
        while (i < sessionActions.length) {
            ActiveProjectManager.ACTIONS[i] = sessionActions[i];
            ++i;
        }
        ActiveProjectManager.ACTIONS[i++] = this.editScriptAction;
        ActiveProjectManager.ACTIONS[i++] = this.importScriptAction;
        ActiveProjectManager.ACTIONS[i++] = this.exportScriptAction;
    }

    public EditScriptAction getEditScriptAction() {
        return this.editScriptAction;
    }

    public ImportScriptAction getImportScriptAction() {
        return this.importScriptAction;
    }

    public AutoAnnotationPluginManager getAutoAnnotatorPluginManager() {
        return this.autoAnnotatorPluginManager;
    }

    public ExportScriptAction getExportScriptAction() {
        return this.exportScriptAction;
    }

    public AtomicIntegerSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public List<AutoAnnotator> getEnabledAutoAnnotators() {
        return this.enabledAutoAnnotators;
    }

    public ProjectManagerListener getListener() {
        return this.listener;
    }

    public void setListener(ProjectManagerListener listener) {
        this.listener = listener;
    }

    public ActiveProjectManager(PromptPresenterPluginManager ppPm, AutoAnnotationPluginManager aaPm, String projectFileURL, String user, String password) throws ProjectManagerException {
        GraphicsDevice gd;
        this.storageManager = new ActiveSessionStorageManager();
        this.projectStorageManager = this.storageManager;
        this.promptPresenterPluginManager = ppPm;
        this.autoAnnotatorPluginManager = aaPm;
        Thread shutDownThread = new Thread(){

            @Override
            public void run() {
                if (ActiveProjectManager.this.storageManager != null) {
                    try {
                        ActiveProjectManager.this.storageManager.close(true);
                    }
                    catch (StorageManagerException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutDownThread);
        this.sessionManager = new SessionManager();
        this.sessionManager.setListener(this);
        AJSAudioSystem.init();
        Handler logHandler = new Handler(this.LOG_HANDLER_NAME);
        Handler timeLogHandler = new Handler(this.TIMELOG_HANDLER_NAME);
        timeLogHandler.setFormatter(TIME_LOG_FORMATTER_CFG);
        DEF_LOG_HANDLERS = new Handler[]{logHandler, timeLogHandler};
        Logger defLogger = new Logger();
        defLogger.setName("ipsk.apps.speechrecorder");
        defLogger.setHandlerName(logHandler.getName());
        Logger defTimeLogger = new Logger();
        defTimeLogger.setName("time");
        defTimeLogger.setHandlerName(timeLogHandler.getName());
        this.logger = java.util.logging.Logger.getLogger("ipsk.apps.speechrecorder");
        AVAIL_LOGGERS = new Logger[]{defLogger, defTimeLogger};
        this.timeLogger = java.util.logging.Logger.getLogger("time");
        this.uiString = UIResources.getInstance();
        this.itemcodeGenerator = new ItemcodeGenerator();
        this.sequenceGenerator = new AtomicIntegerSequenceGenerator();
        this.audioEnabled = false;
        new MixerManager();
        this.domConverter = new DOMConverter();
        this.speakerFileName = null;
        this.recScriptManager.setSequenceGenerator((IntegerSequenceGenerator)this.sequenceGenerator);
        this.recScriptManager.addRecscriptManagerListener(this);
        this.projectConfigurationSaved = true;
        this.editScriptAction = new EditScriptAction(this, "Edit script...");
        this.editScriptAction.setEnabled(false);
        this.importScriptAction = new ImportScriptAction(this, "Import text table...");
        this.importScriptAction.setEnabled(false);
        this.exportScriptAction = new ExportScriptAction(this, "Export script as text table file...");
        this.exportScriptAction.setEnabled(false);
        if (user != null) {
            Authenticator.setDefault((Authenticator)new SimplePasswordAuthentication(user, password));
            this.logger.info("Set authenticator for user " + user);
        }
        if (projectFileURL != null) {
            try {
                this.projectURL = new URL(projectFileURL);
            }
            catch (MalformedURLException e) {
                throw new ProjectManagerException(e);
            }
            try {
                InputStream projectFileStream = this.projectURL.openStream();
                projectFileStream.close();
            }
            catch (IOException e) {
                throw new ProjectManagerException(e);
            }
        }
        int experimenterScreenIdx = 0;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        GraphicsDevice defGd = ge.getDefaultScreenDevice();
        if (defGd == null && gds.length > 0) {
            defGd = gds[0];
        }
        if (gds == null || gds.length == 0) {
            this.logger.severe("No display connected!");
        }
        int i = 0;
        while (i < gds.length) {
            gd = gds[i];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle gb = gc.getBounds();
            this.logger.info("Display " + i + ": " + gb.getWidth() + " x " + gb.getHeight());
            ++i;
        }
        if (defGd != null) {
            i = 0;
            while (i < gds.length) {
                gd = gds[i];
                if (gd.equals(defGd)) {
                    this.experimenterScreenConfig = defGd.getDefaultConfiguration();
                    experimenterScreenIdx = i;
                    this.logger.info("Selected default display " + i + " as experimenter screen");
                }
                ++i;
            }
        }
        if (gds.length == 1) {
            this.speakerScreenConfig = this.experimenterScreenConfig;
            this.logger.info("Selected default display 0 as speaker screen");
        } else if (gds.length >= 2) {
            i = 0;
            while (i < gds.length) {
                gd = gds[i];
                if (this.speakerScreenConfig == null && !gd.equals(defGd)) {
                    this.speakerScreenConfig = gd.getDefaultConfiguration();
                    this.logger.info("Selected display " + i + " as speaker screen");
                }
                ++i;
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.sessionManager.init();
    }

    public Action getActionByActionCommand(String actionCmd) {
        int i = 0;
        while (i < ACTIONS.length) {
            if (ACTIONS[i].getValue("ActionCommandKey").equals(actionCmd)) {
                return ACTIONS[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean configure(ProjectConfiguration cfgProject) throws PluginLoadingException, AudioControllerException, DOMConverterException, IOException, WorkspaceException, RecscriptManagerException, ProjectManagerException {
        super.commonConfig(cfgProject);
        promptFileName = null;
        pc = this.project.getPromptConfiguration();
        recManualPlay = pc.getRecManualPlay();
        this.sessionManager.setRecManualPlay(recManualPlay);
        this.sessionManager.setDefaultShowSpeakerWindow(pc.getShowPromptWindow());
        recCfg = this.project.getRecordingConfiguration();
        this.primaryRecordTarget = recCfg.getPrimaryRecordTarget();
        overwrite = recCfg.getOverwrite();
        this.sessionManager.setOverwrite(overwrite);
        overwriteWarning = recCfg.isOverwriteWarning();
        this.sessionManager.setOverwriteWarning(overwriteWarning);
        aFormat = recCfg.getFormat();
        audioFormat = aFormat.toAudioFormat();
        this.audioFileFormat = new AudioFileFormat(AudioFileFormat.Type.WAVE, audioFormat, -1);
        forcePostRecPhase = recCfg.isForcePostRecDelayPhase();
        this.sessionManager.setForcePostRecPhase(forcePostRecPhase);
        this.sessionManager.setResetPeakOnRecording(recCfg.getResetPeakOnRecording());
        this.sessionManager.setProgressToNextUnrecorded(recCfg.getProgressToNextUnrecorded());
        defaultSectionMode = Section.Mode.getByValue((String)this.project.getRecordingConfiguration().getMode());
        this.sessionManager.setDefaultSectionMode(defaultSectionMode);
        this.project.getPromptConfiguration().getShowPromptWindow();
        promptFileName = pc.getPromptsUrl();
        if (promptFileName != null && !promptFileName.equals("")) {
            this.promptFile = URLContext.getContextURL((URL)this.projectContext, (String)promptFileName);
        } else {
            chooser = new JFileChooser();
            chooser.setDialogTitle(this.uiString.getString("SelectPromptFile"));
            chooser.setFileSelectionMode(0);
            if (this.lastPromptSelectionDir != null) {
                chooser.setCurrentDirectory(this.lastPromptSelectionDir);
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                selectedFile = chooser.getSelectedFile();
                this.lastPromptSelectionDir = selectedFile.getParentFile();
                this.promptFile = new URL("file:" + selectedFile.getAbsolutePath());
            } else {
                return true;
            }
        }
        startStopSignalClass /* !! */  = null;
        startStopSignalClassname = null;
        startStopSConfig = pc.getStartStopSignal();
        if (startStopSConfig != null && (startStopSClassNameAttr = startStopSConfig.getClassname()) != null) {
            startStopSignalClassname = startStopSClassNameAttr;
        }
        if (startStopSignalClassname == null) {
            pluginInterfaceClassName = StartStopSignal.class.getName();
            startStopSignalClassname = System.getProperty(pluginInterfaceClassName);
        }
        if (startStopSignalClassname == null) {
            try {
                Class.forName("ips.apps.speechrecorder.startstopsignal.Ampelmaennchen");
                startStopSignalClassname = "ips.apps.speechrecorder.startstopsignal.Ampelmaennchen";
            }
            catch (ClassNotFoundException pluginInterfaceClassName) {
                // empty catch block
            }
        }
        if (startStopSignalClassname == null && (startStopSignalClassnames = (startStopSignalPluginManager = new ServicesInspector(StartStopSignal.class)).getServiceImplementorClassnames()) != null && startStopSignalClassnames.size() > 0) {
            startStopSignalClassname = (String)startStopSignalClassnames.get(0);
        }
        if (startStopSignalClassname != null) {
            try {
                startStopSignalClass /* !! */  = Class.forName(startStopSignalClassname).asSubclass(StartStopSignal.class);
            }
            catch (ClassNotFoundException cnfe) {
                this.speechRecorderUI.displayError("Start-Stop-Signal plugin error", "Could not load start stop signal plugin: " + cnfe.getMessage() + "\nUsing default signal: simple traffic light.");
            }
        }
        if (startStopSignalClass /* !! */  == null) {
            startStopSignalClass /* !! */  = SimpleTrafficLight.class;
        }
        itemcodeGenCfg = pc.getItemcodeGeneratorConfiguration();
        itemcodeGenCfgSessionCopy = itemcodeGenCfg.cloneTyped();
        this.itemcodeGenerator.setConfig(itemcodeGenCfgSessionCopy);
        newSpeakerFilename = this.project.getSpeakers().getSpeakersUrl();
        if (this.speakerFileName == null || !this.speakerFileName.equals(newSpeakerFilename)) {
            this.speakerFileName = this.project.getSpeakers().getSpeakersUrl();
            if (this.speakerFileName != null && !this.speakerFileName.equals("")) {
                this.speakerURL = URLContext.getContextURL((URL)this.projectContext, (String)this.speakerFileName);
            } else {
                chooser = new JFileChooser();
                chooser.setDialogTitle(this.uiString.getString("SelectSpeakerFile"));
                chooser.setFileSelectionMode(0);
                returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    this.speakerURL = new URL("file:" + chooser.getSelectedFile().getAbsolutePath());
                } else {
                    return true;
                }
            }
        }
        this.speakerManager.loadURL(this.speakerURL);
        if (!this.recBaseURL.getProtocol().equalsIgnoreCase("file")) {
            this.useUploadCache = true;
        }
        this.sessionManager.setUseUploadCache(this.useUploadCache);
        this.speechRecorderUI.setFileSystemWorkspaceEnabled(this.useUploadCache == false);
        this.storageManager.setUseAsCache(this.useUploadCache);
        if (this.useUploadCache) {
            this.storageManager.setSessionIDFormat(new DecimalFormat("0"));
        }
        this.storageManager.setNumLines(this.numLines);
        this.speakerManager.setStorageManager(this.storageManager);
        logCfg = this.project.getLoggingConfiguration();
        loggers = logCfg.getLogger();
        rootLogger = java.util.logging.Logger.getLogger("");
        defHandlers = rootLogger.getHandlers();
        logFile = null;
        timeLogFile = null;
        i = 0;
        while (i < defHandlers.length) {
            rootLogger.removeHandler(defHandlers[i]);
            ++i;
        }
        handlers = logCfg.getHandler();
        i = 0;
        while (i < handlers.length) {
            formatterCfg = handlers[i].getFormatter();
            formatter = null;
            if (formatterCfg != null && (formatterClassName = formatterCfg.getClassName()) != null) {
                try {
                    fClass = Class.forName(formatterClassName);
                    constr = fClass.getConstructor(new Class[0]);
                    formatterObj = constr.newInstance(new Object[0]);
                    if (formatterObj instanceof java.util.logging.Formatter) {
                        formatter = (java.util.logging.Formatter)formatterObj;
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new PluginLoadingException(formatterClassName, e);
                }
            }
            if (handlers[i].getName().equals(this.LOG_HANDLER_NAME)) {
                if (logFile == null) {
                    try {
                        if (this.useUploadCache) {
                            logFile = File.createTempFile("IPSK_", "_log.log");
                            logFile.deleteOnExit();
                        } else {
                            logFile = new File(String.valueOf(this.projectContext.toURI().getPath()) + File.separator + this.project.getName() + "_log.log");
                        }
                        this.logFileHandler = new FileHandler(logFile, true);
                        if (formatter == null) ** GOTO lbl156
                        this.logFileHandler.setFormatter(formatter);
                    }
                    catch (IOException e) {
                        this.logger.severe("Could not associate a file with the current logger: " + e);
                    }
                    catch (SecurityException | URISyntaxException e) {
                        msg = "Could not write to a log file:" + e.getMessage();
                        this.logger.severe(msg);
                        throw new ProjectManagerException(msg, e);
                    }
                }
            } else if (handlers[i].getName().equals(this.TIMELOG_HANDLER_NAME)) {
                if (timeLogFile == null) {
                    try {
                        if (this.useUploadCache) {
                            timeLogFile = File.createTempFile("IPSK_", "_timelog.log");
                            timeLogFile.deleteOnExit();
                        } else {
                            timeLogFile = new File(String.valueOf(this.projectContext.toURI().getPath()) + File.separator + this.project.getName() + "_timelog.log");
                        }
                        this.timeLogFileHandler = new FileHandler(timeLogFile, true);
                        if (formatter == null) ** GOTO lbl156
                        this.timeLogFileHandler.setFormatter(formatter);
                    }
                    catch (IOException | SecurityException | URISyntaxException e) {
                        msg = "Could not associate a file with the current logger: " + e.getMessage();
                        this.logger.severe(msg);
                        throw new ProjectManagerException(msg, e);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Cannot associate log handler " + handlers[i].getName() + " !\n Ignoring.", "Configuration error", 0);
            }
lbl156:
            // 8 sources

            ++i;
        }
        logI = 0;
        while (logI < loggers.length) {
            l = loggers[logI];
            level = Level.parse(l.getLevel());
            logName = l.getName();
            handlerName = l.getHandlerName();
            logger = java.util.logging.Logger.getLogger(logName);
            logger.setLevel(level);
            if (handlerName.equals(this.LOG_HANDLER_NAME)) {
                logger.addHandler((java.util.logging.Handler)this.logFileHandler);
            } else if (handlerName.equals(this.TIMELOG_HANDLER_NAME)) {
                logger.addHandler((java.util.logging.Handler)this.timeLogFileHandler);
            }
            ++logI;
        }
        this.logger.info("Created logfiles.");
        this.logger.info("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        this.logger.info("JRE: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        this.logger.info("Speechrecorder version: " + SpeechRecorder.VERSION);
        this.logger.info("Loglevel: " + this.logger.getLevel());
        if (this.useUploadCache) {
            this.setWaitForCompleteUpload(this.project.getCacheConfiguration().getWaitForCompleteUpload());
            uploadCacheClassname = this.project.getCacheConfiguration().getUploadCacheClassname();
            try {
                uploadCacheClass = Class.forName(uploadCacheClassname);
                constr = uploadCacheClass.getConstructor(new Class[0]);
                uploadCacheObj = constr.newInstance(new Object[0]);
                if (uploadCacheObj instanceof UploadCache) {
                    this.uploadCache = (UploadCache)uploadCacheObj;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new PluginLoadingException(uploadCacheClassname, e);
            }
            this.uploadCache.setOverwrite(this.project.getRecordingConfiguration().getOverwrite());
            transferRateLimit = this.project.getCacheConfiguration().getTransferRateLimit();
            if (transferRateLimit != -1) {
                if (this.uploadCache.isTransferLimitSupported()) {
                    this.uploadCache.setTransferLimit(transferRateLimit);
                    this.logger.info("Upload cache set transfer rate limit: " + transferRateLimit);
                } else {
                    this.logger.warning("Upload cache does not support transfer rate limiting !");
                }
            }
            if (this.uploadDuringSessionRecording) {
                this.uploadCache.start();
                this.logger.info("Upload cache: " + this.uploadCache.getClass().getName() + "started.");
            }
        }
        this.storageManager.setUploadCache(this.uploadCache);
        this.storageManager.setUseAsCache(this.useUploadCache);
        this.storageManager.setOverwrite(overwrite);
        audioCompression = this.project.getCacheConfiguration().getAudioStorageType();
        if (audioCompression != null && !audioCompression.equals("")) {
            this.logger.fine("Requested audio upload type: " + audioCompression);
            types = AudioSystem.getAudioFileTypes();
            type = null;
            i = 0;
            while (i < types.length) {
                if (types[i].toString().equalsIgnoreCase(audioCompression)) {
                    type = types[i];
                }
                ++i;
            }
            if (type != null) {
                this.storageManager.setUploadType(type);
                this.logger.fine("Audio upload type " + audioCompression + " set.");
            } else {
                this.logger.warning("Requested audio type \"" + audioCompression + "\" not available.");
            }
        }
        this.storageManager.setCreateSessionDir(false);
        this.storageManager.setUseScriptID(false);
        try {
            this.storageManager.open(true);
        }
        catch (StorageManagerException e) {
            throw new ProjectManagerException(e.getMessage(), e);
        }
        if (this.projectContext != null) {
            this.recScriptManager.setContext(this.projectContext);
            this.recScriptManager.setSystemIdBase(this.projectContext.toExternalForm());
            this.speechRecorderUI.setProjectContext(this.projectContext);
        }
        this.recScriptManager.setDefaultSpeakerDisplay(pc.getShowPromptWindow());
        this.recScriptManager.setDefaultMode(Section.Mode.getByValue((String)recCfg.getMode()));
        this.recScriptManager.setDefaultPreDelay(recCfg.getPreRecDelay());
        this.recScriptManager.setDefaultPostDelay(recCfg.getPostRecDelay());
        this.recScriptManager.setDefaultAutomaticPromptPlay(pc.getAutomaticPromptPlay());
        this.sessionManager.setStorageManager(this.storageManager);
        aasdSet = new HashSet<AutoAnnotationServiceDescriptor>();
        annotationCfg = this.project.getAnnotation();
        aasds = this.autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
        this.enabledAutoAnnotators = new ArrayList<AutoAnnotator>();
        if (annotationCfg != null) {
            autoAnnoCfg = annotationCfg.getAutoAnnotation();
            aaCfgs = autoAnnoCfg.getAutoAnnotators();
            if (aaCfgs != null) {
                var34_51 = aaCfgs;
                var33_52 = aaCfgs.length;
                var32_54 = 0;
                while (var32_54 < var33_52) {
                    aaCfg = var34_51[var32_54];
                    en = aaCfg.isEnabled();
                    if (en) {
                        aaClasNm = aaCfg.getClassname();
                        for (AutoAnnotationServiceDescriptor aasd : aasds) {
                            aaSdClNm = aasd.getServiceImplementationClassname();
                            if (!aaClasNm.equals(aaSdClNm)) continue;
                            aasdSet.add(aasd);
                            break;
                        }
                    }
                    ++var32_54;
                }
            }
            aasdResolvedlist = this.autoAnnotatorPluginManager.resolve(aasdSet);
            for (AutoAnnotationServiceDescriptor aasd : aasdResolvedlist) {
                aaClsNm = aasd.getServiceImplementationClassname();
                try {
                    aaClass = Class.forName(aaClsNm);
                    aaCstr = aaClass.getConstructor(new Class[0]);
                    aa = (AutoAnnotator)aaCstr.newInstance(new Object[0]);
                    this.enabledAutoAnnotators.add(aa);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new PluginLoadingException(aaClsNm, e);
                }
            }
        }
        this.sessionManager.setEnabledAutoAnnotators(this.enabledAutoAnnotators);
        this.schema = new Schema();
        promptDef = new LevelDefinition(PredefinedLevelDefinition.PRT);
        templateDef = new LevelDefinition(PredefinedLevelDefinition.TPL);
        this.schema.addLevelDefinition(promptDef);
        this.schema.addLevelDefinition(templateDef);
        this.bundleAnnotationPersistorList.clear();
        annoPersCfg = annotationCfg.getPersistence();
        perCfgList = annoPersCfg.getBundleAnnotationPersistors();
        for (BundleAnnotationPersistorConfig perCfg : perCfgList) {
            if (!perCfg.isEnabled()) continue;
            bapClNm = perCfg.getClassname();
            try {
                bapCl = Class.forName(bapClNm);
                bapCstr = bapCl.getConstructor(new Class[0]);
                bapO = bapCstr.newInstance(new Object[0]);
                if (!(bapO instanceof BundleAnnotationPersistor)) continue;
                bap = (BundleAnnotationPersistor)bapO;
                this.bundleAnnotationPersistorList.add(bap);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new PluginLoadingException(bapClNm, e);
            }
        }
        this.sessionManager.setBundleAnnotationPersistorList(this.bundleAnnotationPersistorList);
        beepURL = null;
        promtBeepCfg = this.getConfiguration().getPromptConfiguration().getPromptBeep();
        promptBeepUrlStr = promtBeepCfg.getBeepFileURL();
        if (promptBeepUrlStr != null && !"".equals(promptBeepUrlStr)) {
            beepURL = URLContext.getContextURL((URL)this.getProjectContext(), (String)promptBeepUrlStr);
        } else {
            beepURL = SampleManager.class.getResource("beep/beep_PCM_16bit_44100Hz.wav");
        }
        this.sessionManager.setBeepURL(beepURL);
        beepVolume = this.getConfiguration().getPromptConfiguration().getPromptBeep().getBeepGainRatio();
        this.sessionManager.setBeepVolume(beepVolume);
        this.audioEnabled = false;
        this.sessionManager.setAudioEnabled(this.audioEnabled);
        this.sessionManager.setSeamlessAutoRecording(false);
        try {
            this.openAudioController();
            this.audioEnabled = true;
            this.audioController.setOverwrite(overwrite);
            this.sessionManager.setAudioEnabled(this.audioEnabled);
            captureScope = recCfg.getCaptureScope();
            if (captureScope == null) {
                captureScope = RecordingConfiguration.CaptureScope.ITEM;
            }
            this.sessionManager.setCaptureScope(captureScope);
            if (recCfg.isSeamlessAutorecording()) {
                if (this.audioController.isFileTransitionRecordingSupported()) {
                    if (!PrimaryRecordTarget.DIRECT.equals((Object)this.primaryRecordTarget)) {
                        this.speechRecorderUI.displayError("Audio configuration error", "Audio configuration error: Seamless recording is only posiible if primary recording target is direct file (DIRECT)");
                    } else {
                        this.sessionManager.setSeamlessAutoRecording(true);
                    }
                } else {
                    this.speechRecorderUI.displayError("Audio controller error", "Audio controller implementation class " + this.project.getAudioControllerClass() + " does not support recording file transition during capture.\nSeamless recording will be disabled !");
                }
            }
        }
        catch (PluginLoadingException pe) {
            this.speechRecorderUI.displayError("Plugin laoading error", "Could not load audio controller plugin: " + pe + "\naudio recording/playback will be disabled !");
        }
        catch (AudioControllerException ae) {
            this.speechRecorderUI.displayError("Audio controller error", "Could not open audio controller: " + (Object)ae + "\naudio recording/playback will be disabled !");
        }
        catch (AudioManagerException ame) {
            this.speechRecorderUI.displayError("Audio manager error", "Could not open audio controller: " + ame + "\naudio recording/playback will be disabled !");
        }
        try {
            this.recScriptManager.load(this.promptFile);
        }
        catch (RecscriptManagerException rme) {
            cause = rme.getCause();
            if (cause instanceof RecScriptSchemaVersionNewerException) {
                rne = (RecScriptSchemaVersionNewerException)cause;
                options = new Object[]{"Cancel", "Try to load script anyway"};
                res = JOptionPane.showOptionDialog(this.speechRecorderUI, "Recording script schema has newer version than the one used in this version of Speechrecorder.\nIt is recommended to update SpeechRecorder to the newest version and retry.\n\nIf you load the script nevertheless, new features of the script might be ignored. If you edit the script, it will be downgraded.\n\nDo you want to try to load the script anyway?", "Force loading script", 2, 2, null, options, options[0]);
                if (res == 1) {
                    this.recScriptManager.load(this.promptFile, true);
                }
                return true;
            }
            throw rme;
        }
        try {
            this.rebuildDb();
            this.updateItemCodesInUseSet();
        }
        catch (StorageManagerException e) {
            throw new ProjectManagerException(e.getMessage(), e);
        }
        this.speechRecorderUI.configure();
        this.speechRecorderUI.setStartStopSignalClass(startStopSignalClass /* !! */ );
        this.speechRecorderUI.setInstructionNumbering(this.project.getPromptConfiguration().getInstructionNumbering());
        if (this.listener != null) {
            this.listener.update(new ProjectManagerProjectOpenedEvent(this, this.project.getName()));
        }
        this.sessionManager.init();
        return false;
    }

    private void openAudioController() throws PluginLoadingException, AudioControllerException, AudioManagerException {
        try {
            this.audioControllerClassName = this.project.getAudioControllerClass();
            this.audioController = (AudioController4)Class.forName(this.audioControllerClassName).newInstance();
        }
        catch (Exception e) {
            throw new PluginLoadingException(this.audioControllerClassName, e);
        }
        AJSAudioSystem.setApplicationName((String)"SpeechRecorder");
        AJSAudioSystem.setFreeDesktopApplicationIconName((String)"speechrecorder");
        this.audioManager = new AudioManager((AudioController2)this.audioController);
        this.beepPlayer = new Player();
        this.audioController.setPreferredCaptureLineBufferSizeMilliSeconds(4000.0f);
        this.audioController.setPreferredPlaybackLineBufferSizeMilliSeconds(4000.0f);
        this.audioController.setProperty("ASIO_USE_MAX_BUFFER_SIZE", "true");
        MixerName[] orgTargetMixerNames = this.project.getRecordingMixerName();
        MixerName[] targetMixerNames = ConfigHelper.getAJSConvertedMixerNames((AudioController2)this.audioController, orgTargetMixerNames);
        if (targetMixerNames != null && targetMixerNames.length > 0) {
            DeviceInfo matchedDeviceInfo = this.audioManager.findMatchingDeviceInfo(targetMixerNames, AJSAudioSystem.DeviceType.CAPTURE);
            if (matchedDeviceInfo == null) {
                throw new AudioControllerException("No capture device matching configuration found!");
            }
            this.logger.info("Using capture mixer: " + matchedDeviceInfo);
            this.audioController.setCaptureDeviceByinfo(matchedDeviceInfo);
        } else {
            this.logger.info("Using default capture mixer.");
        }
        MixerName[] orgSourceMixerNames = this.project.getPlaybackMixerName();
        MixerName[] sourceMixerNames = ConfigHelper.getAJSConvertedMixerNames((AudioController2)this.audioController, orgSourceMixerNames);
        if (sourceMixerNames != null && sourceMixerNames.length > 0) {
            DeviceInfo matchedDeviceInfo = this.audioManager.findMatchingDeviceInfo(sourceMixerNames, AJSAudioSystem.DeviceType.PLAYBACK);
            if (matchedDeviceInfo == null) {
                throw new AudioControllerException("No playback device matching configuration found!");
            }
            this.audioController.setPlaybackDeviceByInfo(matchedDeviceInfo);
            this.logger.info("Using playback mixer: " + matchedDeviceInfo);
        } else {
            this.logger.info("Using default playback mixer.");
        }
        RecordingConfiguration recCfg = this.project.getRecordingConfiguration();
        ChannelRouting captureChannelRouting = recCfg.getChannelAssignment();
        if (captureChannelRouting != null) {
            ipsk.io.ChannelRouting chRouting;
            int chOffset = captureChannelRouting.getChannelOffset();
            if (chOffset != 0) {
                int recChs = recCfg.getFormat().getChannels();
                chRouting = new ipsk.io.ChannelRouting(true, chOffset, recChs);
            } else {
                int[] inChAssignment = captureChannelRouting.getAssign();
                Integer[] inChassignmentI = null;
                if (inChAssignment != null) {
                    inChassignmentI = new Integer[inChAssignment.length];
                    int i = 0;
                    while (i < inChAssignment.length) {
                        inChassignmentI[i] = inChAssignment[i];
                        ++i;
                    }
                }
                Integer inChs = captureChannelRouting.getSrcChannelCount();
                chRouting = new ipsk.io.ChannelRouting(inChs, inChassignmentI);
            }
            this.audioController.setInputChannelRouting(chRouting);
        }
        MixerName[] promptPlayMixerNames = this.project.getPromptPlaybackMixerName();
        PromptConfiguration promptCfg = this.project.getPromptConfiguration();
        if (promptPlayMixerNames != null && promptPlayMixerNames.length > 0) {
            DeviceInfo matchedDeviceInfo = this.audioManager.findMatchingDeviceInfo(promptPlayMixerNames, AJSAudioSystem.DeviceType.PLAYBACK);
            if (matchedDeviceInfo == null) {
                throw new AudioManagerException("No prompt playback device matching configuration found!");
            }
            List mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                String matcheddevProvClassname;
                String mpsdClassName = mpsd.getImplementationClassname();
                if (!mpsdClassName.equals(matcheddevProvClassname = matchedDeviceInfo.getDeviceProviderInfo().getImplementationClassname())) continue;
                AJSDeviceInfo ajsDevInfo = new AJSDeviceInfo(mpsd, matchedDeviceInfo.getMixerInfo());
                AJSDevice ajsDevice = AJSAudioSystem.getDevice((AJSDeviceInfo)ajsDevInfo);
                this.promptMixer = ajsDevice.getMixer();
                this.speechRecorderUI.setPromptMixer(this.promptMixer);
                try {
                    this.beepPlayer.setMixer(this.promptMixer);
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    throw new AudioManagerException("Could not set mixer for beep player!");
                }
                this.logger.info("Using prompt playback mixer: " + matchedDeviceInfo);
            }
        } else {
            this.logger.info("Using default playback mixer.");
        }
        int promptAudioChannelOffset = promptCfg.getAudioChannelOffset();
        this.speechRecorderUI.setPromptAudioChannelOffset(promptAudioChannelOffset);
        this.beepPlayer.setChannelOffset(promptAudioChannelOffset);
        this.audioController.setRecordingAudioFileFormat(this.audioFileFormat);
        this.audioController.setPrimaryRecordTarget(this.primaryRecordTarget);
        this.sessionManager.setAudioController(this.audioController);
        this.sessionManager.setBeepPlayer(this.beepPlayer);
    }

    public ProjectConfiguration getConfigurationCopy() throws DOMCodecException {
        return (ProjectConfiguration)this.domCodec.copy((Object)this.project);
    }

    public URL getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(URL url) {
        this.projectURL = url;
    }

    private void copyStream(InputStream i, OutputStream o) throws IOException {
        int b;
        while ((b = i.read()) != -1) {
            o.write(b);
        }
        o.close();
        i.close();
    }

    public File getProjectDir() throws MalformedURLException, URISyntaxException {
        ProjectConfiguration pc = this.getConfiguration();
        if (pc != null) {
            String dirStr = pc.getDirectory();
            URL projectDirURL = new URL(this.projectContext, dirStr);
            return new File(projectDirURL.toURI().getPath());
        }
        return null;
    }

    public String defaultScriptUrlString() {
        if (this.project != null) {
            return String.valueOf(this.project.getName()) + "_script.xml";
        }
        return null;
    }

    public void newProject(NewProjectConfiguration newProjectConfig) throws Exception {
        ProjectConfiguration newProject = newProjectConfig.getProjectConfiguration();
        newProject.setUuid(UUID.randomUUID());
        newProject.getRecordingConfiguration().setCaptureScope(RecordingConfiguration.CaptureScope.SESSION);
        newProject.getPromptConfiguration().setAutomaticPromptPlay(false);
        File projDir = new File(this.workspaceDir, newProject.getName());
        URI projDirURI = projDir.toURI();
        String projURLStr = projDirURI.toASCIIString();
        this.projectContext = new URL(projURLStr);
        URL projectDirURL = new URL(this.projectContext, newProject.getDirectory());
        File projectDir = new File(projectDirURL.toURI().getPath());
        String parent = projectDir.getParent();
        File workspaceRoot = new File(parent);
        if (!workspaceRoot.exists()) {
            int res = JOptionPane.showConfirmDialog(this.speechRecorderUI, "Workspace directory " + workspaceRoot.getPath() + " does not exist.\nCreate ?", "New Project", 2);
            if (res == 0) {
                if (!workspaceRoot.mkdirs()) {
                    throw new Exception("Could not create directory " + workspaceRoot.getPath());
                }
            } else {
                throw new Exception("Could not create project without workspace directory.");
            }
        }
        if (projectDir.exists()) {
            throw new Exception("Project (directory) already exists: " + projectDir.getPath());
        }
        if (!projectDir.mkdirs()) {
            throw new Exception("Could not create directory " + projectDir.getPath());
        }
        URI pdURI = projectDir.toURI();
        String projectDirURIstr = pdURI.toASCIIString();
        URL projectDirURLascii = new URL(projectDirURIstr);
        this.setProjectContext(projectDirURLascii);
        String projectFilename = String.valueOf(newProject.getName()) + "_project.prj";
        String recScriptFileName = String.valueOf(newProject.getName()) + "_script.xml";
        String speakersFilename = String.valueOf(newProject.getName()) + "_speakers.xml";
        File projectFile = new File(projectDir, projectFilename);
        File recScriptFile = new File(projectDir, recScriptFileName);
        File speakersFile = new File(projectDir, speakersFilename);
        InputStream is = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
        FileOutputStream fos = new FileOutputStream(new File(projectDir, "SpeechRecPrompts_4.dtd"));
        this.copyStream(is, fos);
        if (newProjectConfig.isUseExampleScript()) {
            is = RecscriptHandler.class.getResourceAsStream("ExampleRecScript_4.xml");
            fos = new FileOutputStream(recScriptFile);
            this.copyStream(is, fos);
            ItemcodeGeneratorConfiguration icCfg = newProject.getPromptConfiguration().getItemcodeGeneratorConfiguration();
            icCfg.setGeneratorName("Demo script itemcode generator");
            icCfg.setPrefix("demo_");
            icCfg.setFixedDecimalPlaces(3);
            icCfg.setCounterStart(70);
            icCfg.setActive(true);
        } else {
            Script newScript = new Script();
            newScript.setPropertyChangeSupportEnabled(true);
            this.recScriptManager.setScript(newScript);
        }
        this.createEmptySpeakerDatabase(speakersFile, true);
        URI recScriptURI = recScriptFile.toURI();
        URI projectDirURI = projectDir.toURI();
        URI recScriptRelURI = projectDirURI.relativize(recScriptURI);
        newProject.getPromptConfiguration().setPromptsUrl(recScriptRelURI.toString());
        URI speakersFileURI = speakersFile.toURI();
        URI speakersFileRelURI = projectDirURI.relativize(speakersFileURI);
        newProject.getSpeakers().setSpeakersUrl(speakersFileRelURI.toString());
        newProject.getRecordingConfiguration().setUrl("RECS/");
        this.setConfiguration(newProject);
        this.setProjectURL(projectFile.toURI().toURL());
        String systemIdBase = this.projectContext.toExternalForm();
        this.recScriptManager.setSystemIdBase(systemIdBase);
        this.saveProject();
        if (!newProjectConfig.isUseExampleScript()) {
            this.saveScript();
        }
        this.configure(newProject);
    }

    public File getWorkspaceDir() {
        return this.workspaceDir;
    }

    public void setWorkspaceDir(File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public void saveProject() throws DOMCodecException, DOMConverterException, IOException, URISyntaxException {
        String fPath = this.getProjectURL().toURI().getPath();
        File f = new File(fPath);
        ProjectConfiguration pc = this.getConfiguration();
        pc.setVersion("4.0.0");
        Document d = this.domCodec.createDocument((Object)this.getConfiguration());
        FileUtils.moveToBackup((File)f, (String)".bak");
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
        this.domConverter.writeXML(d, (Writer)ow);
        ow.close();
        this.setProjectConfigurationSaved(true);
    }

    public void saveProject(File file) throws DOMCodecException, DOMConverterException, IOException, URISyntaxException {
        try {
            this.setProjectURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.saveProject();
    }

    public void saveScript() throws DOMCodecException, DOMConverterException, IOException, ParserConfigurationException, URISyntaxException {
        RecscriptHandler recScriptHandler = new RecscriptHandler();
        recScriptHandler.setValidating(true);
        Script script = this.recScriptManager.getScript();
        File dtdFile = new File(this.getProjectDir(), "SpeechRecPrompts_4.dtd");
        if (!dtdFile.exists()) {
            InputStream is = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
            FileOutputStream fos = new FileOutputStream(dtdFile);
            this.copyStream(is, fos);
        }
        StringWriter stringWriter = new StringWriter();
        recScriptHandler.writeXML(script, (Writer)stringWriter);
        StringReader stringReader = new StringReader(stringWriter.toString());
        recScriptHandler.readScriptFromXML(stringReader, this.projectContext.toExternalForm());
        String promptFileName = this.project.getPromptConfiguration().getPromptsUrl();
        if (promptFileName != null && !promptFileName.equals("")) {
            URL promptFile = URLContext.getContextURL((URL)this.projectContext, (String)promptFileName);
            String protocol = promptFile.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                String fPath = promptFile.toURI().getPath();
                File f = new File(fPath);
                FileUtils.moveToBackup((File)f, (String)".bak");
                recScriptHandler = new RecscriptHandler();
                recScriptHandler.setValidating(true);
                recScriptHandler.writeXML(script, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charset.forName("UTF-8")));
                this.recScriptManager.setScriptSaved(true);
            } else {
                this.speechRecorderUI.displayError("Save script error", "Cannot save script to URL: " + promptFile + ", protocol " + protocol + "not supported.");
            }
        } else {
            this.speechRecorderUI.displayError("Save script error", "Cannot save script to empty URL!");
        }
    }

    public void saveSpeakerDatabase() throws IOException, URISyntaxException {
        File f = new File(this.speakerURL.toURI().getPath());
        FileUtils.moveToBackup((File)f, (String)".bak");
        this.speakerManager.getDatabaseLoader().writeDatabaseFile(f);
        this.speakerManager.setDatabaseSaved(true);
    }

    public void saveAll() throws DOMCodecException, DOMConverterException, IOException, ParserConfigurationException, URISyntaxException {
        this.saveProject();
        this.saveSpeakerDatabase();
        this.saveScript();
    }

    public boolean configureProject(URL projectUrl) throws ClassNotFoundException, DOMCodecException, DOMConverterException, StorageManagerException, PluginLoadingException, AudioControllerException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, WorkspaceException, URISyntaxException, RecscriptManagerException, SpeechRecorderException, ProjectManagerException {
        URLConnection prUrlConn = projectUrl.openConnection();
        prUrlConn.setUseCaches(false);
        InputStream prInStream = prUrlConn.getInputStream();
        Document d = this.domConverter.readXML(prInStream);
        ProjectConfiguration p = (ProjectConfiguration)this.domCodec.readDocument(d);
        this.setProjectURL(projectUrl);
        ConfigHelper.applyLegacyToStrictConversions(p);
        boolean canceled = this.configure(p);
        this.setProjectConfigurationSaved(true);
        return canceled;
    }

    public boolean isProjectEditable() {
        ProjectConfiguration pc = this.getConfiguration();
        if (pc == null) {
            return false;
        }
        return pc.getEditable();
    }

    @Override
    public void setEditingEnabled(boolean b) {
        boolean projectEditable = this.isProjectEditable();
        boolean editingEnabled = b;
        this.editScriptAction.setEnabled(projectEditable && editingEnabled);
        this.importScriptAction.setEnabled(projectEditable && editingEnabled);
        this.exportScriptAction.setEnabled(projectEditable && editingEnabled);
        this.speechRecorderUI.setEditingEnabled(b);
    }

    public boolean saveAllProjectDataInteractive() {
        int option;
        if (!this.isProjectConfigurationSaved()) {
            option = JOptionPane.showConfirmDialog(this.speechRecorderUI, "The project has been modified.\nDo you want to save ?", "Confirm message", 1, 1);
            if (option == 0) {
                try {
                    this.saveProject();
                }
                catch (Exception e) {
                    this.speechRecorderUI.displayError("Save error", e.getLocalizedMessage());
                    return false;
                }
            } else if (option == 2) {
                return false;
            }
        }
        if (!this.speakerManager.isDatabaseSaved()) {
            option = JOptionPane.showConfirmDialog(this.speechRecorderUI, "The speaker database has been modified.\nDo you want to save ?", "Confirm message", 1, 1);
            if (option == 0) {
                try {
                    this.saveSpeakerDatabase();
                }
                catch (Exception e) {
                    this.speechRecorderUI.displayError("Save error", e.getLocalizedMessage());
                    return false;
                }
            } else if (option == 2) {
                return false;
            }
        }
        if (!this.recScriptManager.isScriptSaved()) {
            option = JOptionPane.showConfirmDialog(this.speechRecorderUI, "The recording script has been modified.\nDo you want to save ?", "Confirm message", 1, 1);
            if (option == 0) {
                try {
                    this.saveScript();
                }
                catch (Exception e) {
                    this.speechRecorderUI.displayError("Save error", e.getLocalizedMessage());
                    return false;
                }
            } else if (option == 2) {
                return false;
            }
        }
        return true;
    }

    public void shutdown() {
        this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.OFF);
        this.speechRecorderUI.setEnableOpenOrNewProject(false);
        Runnable doShutdown = new Runnable(){

            @Override
            public void run() {
                if (ActiveProjectManager.this.uploadCache != null) {
                    if (!ActiveProjectManager.this.waitForCompleteUpload) {
                        ActiveProjectManager.this.uploadCache.stop();
                        try {
                            ActiveProjectManager.this.storageManager.close(false);
                        }
                        catch (StorageManagerException e1) {
                            e1.printStackTrace();
                        }
                        ActiveProjectManager.this.uploadCache.clear();
                    }
                    ActiveProjectManager.this.uploadCache.start();
                    if (ActiveProjectManager.this.logFileHandler != null) {
                        ActiveProjectManager.this.logger.removeHandler((java.util.logging.Handler)ActiveProjectManager.this.logFileHandler);
                        ActiveProjectManager.this.logFileHandler.close();
                        File logFile = ActiveProjectManager.this.logFileHandler.getFile();
                        try {
                            URL logFileURL = ActiveProjectManager.this.storageManager.getLogFile();
                            UploadFile logUpload = new UploadFile(logFile, logFileURL);
                            ActiveProjectManager.this.uploadCache.upload(new Upload[]{logUpload});
                        }
                        catch (UploadException e) {
                            e.printStackTrace();
                        }
                        catch (StorageManagerException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ActiveProjectManager.this.timeLogFileHandler != null) {
                        ActiveProjectManager.this.timeLogger.removeHandler((java.util.logging.Handler)ActiveProjectManager.this.timeLogFileHandler);
                        ActiveProjectManager.this.timeLogFileHandler.close();
                        File timeLogFile = ActiveProjectManager.this.timeLogFileHandler.getFile();
                        try {
                            UploadFile timelogUpload = new UploadFile(timeLogFile, ActiveProjectManager.this.storageManager.getTimeLogFile());
                            ActiveProjectManager.this.uploadCache.upload(new Upload[]{timelogUpload});
                        }
                        catch (UploadException e) {
                            e.printStackTrace();
                        }
                        catch (StorageManagerException e) {
                            e.printStackTrace();
                        }
                    }
                    while (!ActiveProjectManager.this.uploadCache.isIdle()) {
                        try {
                            Thread.sleep(ActiveProjectManager.this.SHUTDOWN_RETRY_DELAY);
                        }
                        catch (InterruptedException timeLogFile) {
                            // empty catch block
                        }
                    }
                    ActiveProjectManager.this.uploadCache.close();
                    try {
                        ActiveProjectManager.this.storageManager.close(true);
                    }
                    catch (StorageManagerException e) {
                        e.printStackTrace();
                    }
                }
                ActiveProjectManager.this.readyForShutdown();
            }
        };
        Thread shutdownThread = new Thread(doShutdown);
        shutdownThread.start();
    }

    private void readyForShutdown() {
        if (this.listener != null) {
            this.listener.update(new ProjectManagerProjectReadyForShutdownEvent(this));
        } else {
            System.exit(1);
        }
    }

    public void start() throws AudioControllerException, ProjectManagerException {
        ipsk.apps.speechrecorder.db.Speaker spk = this.speakerManager.getSpeaker();
        if (spk == null) {
            return;
        }
        int sessionId = this.speakerManager.getSpeaker().getPersonId();
        if (this.lastSessionId != null && this.lastSessionId != sessionId) {
            this.recScriptManager.shuffleItems();
        }
        this.lastSessionId = sessionId;
        this.sessionManager.setScript(this.recScriptManager.getScript());
        this.sessionManager.open();
        String speakerCode = this.speakerManager.getSpeaker().getCode();
        this.sessionManager.start(sessionId, speakerCode);
    }

    public RecScriptManager getRecScriptManager() {
        return this.recScriptManager;
    }

    public String getRecScriptName() {
        if (this.promptFile == null) {
            return null;
        }
        return this.promptFile.toExternalForm();
    }

    public String getRecDirName() {
        if (this.recBaseURL == null) {
            return null;
        }
        return this.recBaseURL.toExternalForm();
    }

    public ipsk.apps.speechrecorder.db.Speaker getSpeaker() {
        return this.speakerManager.getSpeaker();
    }

    public boolean isUsingUploadCache() {
        return this.useUploadCache;
    }

    public UploadCache getUploadCache() {
        return this.uploadCache;
    }

    public SpeechRecorderUI getSpeechRecorderUI() {
        return this.speechRecorderUI;
    }

    public AudioController4 getAudioController() {
        return this.audioController;
    }

    public boolean isProjectConfigurationSaved() {
        return this.projectConfigurationSaved;
    }

    public void setProjectConfigurationSaved(boolean saved) {
        this.projectConfigurationSaved = saved;
        this.speechRecorderUI.setProjectConfigurationSaved(saved);
        this.speechRecorderUI.updateSaveEnable();
    }

    public SpeakerManager getSpeakerManager() {
        return this.speakerManager;
    }

    public boolean isWaitForCompleteUpload() {
        return this.waitForCompleteUpload;
    }

    public void setWaitForCompleteUpload(boolean waitForCompleteUpload) {
        this.waitForCompleteUpload = waitForCompleteUpload;
    }

    @Override
    public void setProjectContext(URL context) {
        super.setProjectContext(context);
        if (this.speechRecorderUI != null) {
            this.speechRecorderUI.setProjectContext(this.projectContext);
        }
    }

    public AudioFileFormat getAudioFileFormat() {
        return this.audioFileFormat;
    }

    public void setAudioFileFormat(AudioFileFormat audioFileFormat) {
        this.audioFileFormat = audioFileFormat;
    }

    public void importResource(File f, String relpath) throws IOException, URISyntaxException {
        URL projResURL = null;
        projResURL = URLContext.getContextURL((URL)this.getProjectContext(), (String)relpath);
        String projResPath = projResURL.toURI().getPath();
        File proJResFile = new File(projResPath);
        StreamCopy.copy((File)f, (File)proJResFile);
    }

    public void resetItemcodeGenerator() {
        if (this.itemcodeGenerator != null) {
            ObservableArrayList genItemcodeList = this.itemcodeGenerator.getItemcodesList();
            if (genItemcodeList == null) {
                genItemcodeList = new ObservableArrayList();
                this.itemcodeGenerator.setItemcodesList((ObservableList<String>)genItemcodeList);
            } else {
                genItemcodeList.clear();
            }
            Script s = this.recScriptManager.getScript();
            if (s != null) {
                List itemcodesOfScript = s.itemCodesList();
                genItemcodeList.addAll((Collection)itemcodesOfScript);
            }
        }
    }

    public boolean isScriptSaved() {
        return this.recScriptManager.isScriptSaved();
    }

    public void setScriptSaved(boolean scriptSaved) {
        this.recScriptManager.setScriptSaved(scriptSaved);
    }

    @Override
    public void update(RecscriptManagerEvent e) {
        if (e instanceof RecScriptStoreStatusChanged) {
            this.speechRecorderUI.updateSaveEnable();
        }
    }

    public ItemcodeGenerator getItemcodeGenerator() {
        return this.itemcodeGenerator;
    }

    public List<AutoAnnotationServiceDescriptor> getAutoAnnotatorServiceDescriptors() throws IOException {
        return this.autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
    }

    public List<AudioClip> getSessionClipList() {
        Script scr = this.recScriptManager.getScript();
        if (scr == null) {
            return null;
        }
        ArrayList<AudioClip> audioClipList = new ArrayList<AudioClip>();
        List itemcodes = scr.itemCodesList();
        try {
            for (String itemCode : itemcodes) {
                File af = this.storageManager.recentRecordingFile(itemCode);
                if (af == null || !af.exists()) continue;
                FileAudioSource fas = new FileAudioSource(af);
                AudioClip ac = new AudioClip((AudioSource)fas);
                audioClipList.add(ac);
            }
        }
        catch (StorageManagerException e) {
            e.printStackTrace();
        }
        return audioClipList;
    }

    public List<BundleAnnotationPersistorServiceDescriptor> getBundleAnnotationPersistorServiceDescriptors() {
        return this.availableBundleAnnotationServiceDescriptors;
    }

    public void updateItemCodesInUseSet() throws StorageManagerException {
        HashSet<String> itemCodesInUse;
        if (this.storageManager != null && this.speakerManager != null && this.recScriptManager != null) {
            itemCodesInUse = new HashSet<String>();
            Set<String> scriptCodes = this.recScriptManager.getExistingCodes();
            HashSet<String> codesToCheck = new HashSet<String>(scriptCodes);
            for (Session s : this.projectDb.getSessions()) {
                for (Speaker spk : s.getSpeakers()) {
                    for (String itemCode : codesToCheck) {
                        boolean inUse = this.storageManager.isRecorded(s.getSessionId(), spk.getCode(), itemCode);
                        if (!inUse) continue;
                        itemCodesInUse.add(itemCode);
                    }
                    codesToCheck.removeAll(itemCodesInUse);
                }
                if (codesToCheck.size() != 0) continue;
            }
        } else {
            throw new StorageManagerException("Not all components initialized!");
        }
        this.itemCodesInUse = itemCodesInUse;
    }

    public Set<String> getItemCodesInUse() {
        return this.itemCodesInUse;
    }

    @Override
    public void requestProjectConfigDisableOverwriteWarning() {
        this.project.getRecordingConfiguration().setOverwriteWarning(false);
        this.projectConfigurationSaved = false;
    }

    public synchronized boolean close() throws AudioControllerException, StorageManagerException, WorkspaceException, SpeechRecorderException {
        block13: {
            this.sessionManager.close();
            boolean allSaved = this.saveAllProjectDataInteractive();
            if (!allSaved) {
                return false;
            }
            if (this.useUploadCache) {
                if (!this.uploadCache.isIdle()) {
                    final JDialog f = new JDialog(null, this.uiString.getString("UploadProgress"));
                    f.setDefaultCloseOperation(0);
                    JLabel pleaseWaitLabel = new JLabel();
                    pleaseWaitLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    Font defFont = this.speechRecorderUI.getFont();
                    pleaseWaitLabel.setFont(defFont.deriveFont(1));
                    if (this.waitForCompleteUpload) {
                        pleaseWaitLabel.setText(this.uiString.getString("PleaseWaitForCompleteUpload"));
                    } else {
                        pleaseWaitLabel.setText(this.uiString.getString("PleaseWaitForUploadCanceling"));
                    }
                    f.getContentPane().setLayout(new BorderLayout());
                    f.getContentPane().add((Component)pleaseWaitLabel, "Center");
                    f.getContentPane().add((Component)this.speechRecorderUI.getUploadCacheUI(), "South");
                    Runnable doShow = new Runnable(){

                        @Override
                        public void run() {
                            f.pack();
                            f.setLocationRelativeTo(ActiveProjectManager.this.speechRecorderUI);
                            f.setVisible(true);
                        }
                    };
                    try {
                        if (SwingUtilities.isEventDispatchThread()) {
                            doShow.run();
                            break block13;
                        }
                        SwingUtilities.invokeAndWait(doShow);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.storageManager != null) {
                this.storageManager.close();
            }
        }
        this.setProjectURL(null);
        this.recScriptManager.doClose();
        this.speakerManager.close();
        this.lastSessionId = null;
        this.bundleAnnotationPersistorList.clear();
        if (this.project != null) {
            String projectName = this.project.getName();
            this.setConfiguration(null);
            if (this.listener != null) {
                this.listener.update(new ProjectManagerProjectClosedEvent(this, projectName));
            }
        }
        return true;
    }

    public List<BundleAnnotationPersistor> getBundleAnnotationPersistorList() {
        return this.bundleAnnotationPersistorList;
    }
}

