/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.project;

import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.project.NewProjectConfiguration;
import ipsk.io.FilenameValidator;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class NewProjectDialog
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private String defWorkspaceDirPath;
    private String projectDir;
    private JCheckBox defCheckBox;
    private JTextField nameField;
    private JTextField dirField;
    private JRadioButton emptyScript;
    private JRadioButton exampleScript;
    private ButtonGroup scriptTemplateSelButtGroup;
    private static JButton okButton;
    private static JOptionPane selPane;
    private Document nameDoc;
    private Document dirDoc;
    private NewProjectConfiguration newProjectConfiguration;
    private ProjectConfiguration projectConfiguration;
    private JTextField statusLabel;

    public NewProjectDialog(NewProjectConfiguration newProjectConfiguration, File defWorkspaceDir) {
        super(new GridBagLayout());
        this.newProjectConfiguration = newProjectConfiguration;
        this.projectConfiguration = newProjectConfiguration.getProjectConfiguration();
        this.defWorkspaceDirPath = defWorkspaceDir.getPath();
        okButton = new JButton("OK");
        okButton.setEnabled(false);
        okButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Name"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new JTextField(20);
        this.nameDoc = this.nameField.getDocument();
        this.nameDoc.addDocumentListener(this);
        this.add((Component)this.nameField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Project directory"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.dirField = new JTextField(20);
        this.dirField.setText(this.projectConfiguration.getDirectory());
        this.dirField.setEnabled(false);
        this.dirDoc = this.dirField.getDocument();
        this.dirDoc.addDocumentListener(this);
        this.add((Component)this.dirField, c);
        this.scriptTemplateSelButtGroup = new ButtonGroup();
        c.gridx = 0;
        ++c.gridy;
        this.emptyScript = new JRadioButton("Load empty or");
        this.add((Component)this.emptyScript, c);
        this.scriptTemplateSelButtGroup.add(this.emptyScript);
        ++c.gridx;
        this.exampleScript = new JRadioButton("example project");
        this.add((Component)this.exampleScript, c);
        this.scriptTemplateSelButtGroup.add(this.exampleScript);
        this.exampleScript.addActionListener(this);
        this.emptyScript.setSelected(true);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 2.0;
        c.fill = 2;
        this.statusLabel = new JTextField(30);
        this.statusLabel.setEditable(false);
        this.add((Component)this.statusLabel, c);
    }

    public static Object showDialog(Component parent, NewProjectConfiguration newProjectConfiguration, File defWorkspaceDir) {
        NewProjectDialog pv = new NewProjectDialog(newProjectConfiguration, defWorkspaceDir);
        selPane = new JOptionPane(pv, -1, 2, null, new Object[]{okButton, "Cancel"});
        JDialog dialog = selPane.createDialog(parent, "New Project");
        dialog.setVisible(true);
        return selPane.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.defCheckBox) {
            this.projectDir = this.defWorkspaceDirPath.concat(String.valueOf(File.separator) + this.projectConfiguration.getName());
            this.dirField.setText(this.projectDir);
            this.dirField.setEnabled(!this.defCheckBox.isSelected());
        } else if (src != this.dirField) {
            if (src == this.exampleScript || src == this.emptyScript) {
                this.newProjectConfiguration.setUseExampleScript(this.exampleScript.isSelected());
            } else if (src == okButton) {
                selPane.setValue(new Integer(0));
            }
        }
    }

    public NewProjectConfiguration getNewProjectConfiguration() {
        NewProjectConfiguration npc = new NewProjectConfiguration();
        npc.setProjectConfiguration(this.projectConfiguration);
        npc.setUseExampleScript(this.exampleScript.isSelected());
        return npc;
    }

    private void documentChanged(Document d) {
        if (d == this.nameDoc) {
            String name = this.nameField.getText();
            if ("".equals(name)) {
                this.statusLabel.setText("Project name must not be empty.");
                okButton.setEnabled(false);
            } else {
                FilenameValidator.ValidationResult vr = FilenameValidator.validate((String)name);
                if (vr.isValid()) {
                    String projectDirPath = this.defWorkspaceDirPath.concat(String.valueOf(File.separator) + name);
                    File testProjectDir = new File(projectDirPath);
                    if (testProjectDir.exists()) {
                        this.statusLabel.setText("\"" + name + "\" already exists.");
                        okButton.setEnabled(false);
                    } else {
                        try {
                            String nameURLEncoded = URLEncoder.encode(name, "UTF-8");
                            this.projectConfiguration.setName(name);
                            this.projectDir = this.defWorkspaceDirPath.concat(String.valueOf(File.separator) + nameURLEncoded);
                            this.dirField.setText(this.projectDir);
                            this.statusLabel.setText("");
                            okButton.setEnabled(true);
                        }
                        catch (UnsupportedEncodingException e) {
                            this.statusLabel.setText(e.getMessage());
                            okButton.setEnabled(false);
                        }
                    }
                } else {
                    LocalizableMessage lm = vr.getMessage();
                    String locText = lm.localize();
                    this.statusLabel.setText(locText);
                    okButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }
}

