/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptDocEditorKit;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyleContext;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.Block;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.P;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

@Title(value="Formatted text prompter")
@Description(value="Presents Speechrecorder formatted text.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=0, minor=0, subminor=1)
public class FormattedPromptTextViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    public static final float VIRTUAL_HEIGHT = 600.0f;
    public static final String DEF_CHARSET = "UTF-8";
    private JEditorPane textPane;
    private Color backgroundColor = Color.WHITE;
    private static String DEFAULT_FONT_NAME;
    private static int DEFAULT_FONT_STYLE;
    private int DEFAULT_FONT_SIZE = 48;
    private int fontSize;
    private boolean updatingDoc = false;
    private Integer renderedHeight = null;

    static {
        int[] nArray = new int[3];
        nArray[2] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(FormattedPromptTextViewer.class.getName(), new LocalizableMessage("Formatted text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(nArray), new LocalizableMessage("Presents formatted prompt text."), FormattedPromptTextViewer.getSupportedMIMETypes());
        DEFAULT_FONT_NAME = "sans-serif";
        DEFAULT_FONT_STYLE = 1;
    }

    public FormattedPromptTextViewer() {
        this.setBackground(this.backgroundColor);
        this.textPane = new JEditorPane();
        this.textPane.setEditable(false);
        PromptDocEditorKit promptDocKit = new PromptDocEditorKit();
        this.textPane.setEditorKitForContentType("text/x-prompt", promptDocKit);
        this.setLayout(new GridBagLayout());
        this.add(this.textPane);
        this.fontSize = this.DEFAULT_FONT_SIZE;
        this.promptFont = new Font(DEFAULT_FONT_NAME, DEFAULT_FONT_STYLE, this.fontSize);
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
        if (emphasized) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.lightGray);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return FormattedPromptTextViewer.getSupportedMIMETypes(new String[]{"text/x-prompt"});
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        ArrayList<P> mediaItemParagraphs = new ArrayList<P>();
        List mediaItemBlocks = mi.getBlocks();
        if (mediaItemBlocks != null && mediaItemBlocks.size() > 0) {
            Document cDoc;
            PromptStyledDocument doc;
            for (Block bl : mediaItemBlocks) {
                if (!(bl instanceof P)) continue;
                mediaItemParagraphs.add((P)bl);
            }
            try {
                PromptStyleContext psc = this.scaledPromptStyleContext();
                doc = new PromptStyledDocument(psc, mediaItemParagraphs);
            }
            catch (ParserException e) {
                throw new PromptPresenterException(e);
            }
            this.updatingDoc = true;
            String cCt = this.textPane.getContentType();
            if (!"text/x-prompt".equals(cCt)) {
                this.textPane.setContentType("text/x-prompt");
            }
            if ((cDoc = this.textPane.getDocument()) == null || !cDoc.equals(doc)) {
                this.textPane.setDocument(doc);
            }
            this.renderedHeight = this.getHeight();
            this.updatingDoc = false;
        } else {
            this.renderedHeight = null;
        }
    }

    @Override
    public void doLayout() {
        boolean heightChanged;
        boolean bl = heightChanged = this.renderedHeight == null || this.renderedHeight.intValue() != this.getHeight();
        if (heightChanged && !this.updatingDoc) {
            try {
                this.loadContents();
            }
            catch (PromptPresenterException e) {
                e.printStackTrace();
            }
        }
        super.doLayout();
    }

    private PromptStyleContext scaledPromptStyleContext() {
        int promptFontSize = this.promptFont.getSize();
        float scaledPromptFontSize = (float)(promptFontSize * this.getHeight()) / 600.0f;
        Font scaledPromptFont = this.promptFont.deriveFont(scaledPromptFontSize);
        return new PromptStyleContext(scaledPromptFont);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FormattedPromptTextViewer vw = new FormattedPromptTextViewer();
                vw.setPreferredSize(new Dimension(600, 400));
                JFrame w = new JFrame();
                w.setDefaultCloseOperation(3);
                w.getContentPane().add(vw);
                w.pack();
                w.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

