/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterOpenedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStartEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioSource;
import ipsk.audio.ChannelGroupLocator;
import ipsk.audio.PluginChain;
import ipsk.audio.URLAudioSource;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.VolumeControlPlugin;
import ipsk.db.speech.Mediaitem;
import ipsk.io.ChannelRouting;
import ipsk.net.URLContext;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.Mixer;
import javax.swing.Action;

public class PromptAudioJavaSound
implements PlayerListener {
    private Mixer mixer = AudioSystem.getMixer(null);
    protected Player player = new Player(this.mixer);
    private Vector<PromptPresenterListener> listeners;
    protected URL audioURL = null;
    private Logger audioLogger;
    protected Action startAction;
    private Action startPromptAction;
    protected Action stopAction;
    protected float volume = 1.0f;
    private boolean startEnabled;
    protected boolean silent = false;

    public PromptAudioJavaSound() {
        this.player.addPlayerListener((PlayerListener)this);
        this.listeners = new Vector();
        this.audioLogger = Logger.getLogger("ipsk.apps.speechrecorder");
    }

    public void setAudioMixer(Mixer mixer) throws PromptPresenterPluginException {
        if (mixer == null) {
            mixer = AudioSystem.getMixer(null);
        }
        this.mixer = mixer;
        try {
            this.player.setMixer(mixer);
        }
        catch (PlayerException e) {
            e.printStackTrace();
            throw new PromptPresenterPluginException(e);
        }
    }

    public void setAudioChannelOffset(int channelOffset) {
        this.player.setChannelRouting(null);
        this.player.setChannelOffset(channelOffset);
    }

    public void setAudioChannelGroupLocator(ChannelGroupLocator channelGroupLocator) throws PromptPresenterPluginException {
        Mixer mixer = channelGroupLocator.getDevice();
        this.setAudioMixer(mixer);
        this.setAudioChannelOffset(channelGroupLocator.getChannelOffset());
        ChannelRouting channelRouting = channelGroupLocator.getChannelRouting();
        this.player.setChannelRouting(channelRouting);
    }

    public void setRecScriptResources(Hashtable mh) {
    }

    public void open() throws PromptPresenterException {
        if (this.silent) {
            this.updateListeners(new PromptPresenterOpenedEvent(this));
        } else if (this.audioURL != null) {
            try {
                this.player.open();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                throw new PromptPresenterException(e);
            }
        }
    }

    public void start() throws PromptPresenterException {
        if (this.silent) {
            this.updateListeners(new PromptPresenterStartEvent(this));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PromptAudioJavaSound.this.stop();
                }
            });
        } else if (this.audioURL != null) {
            try {
                this.player.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                throw new PromptPresenterException(e);
            }
        }
    }

    public void loadAudioContents(Mediaitem mi, URL context) throws PromptPresenterException {
        URLAudioSource playbackSource;
        URL url;
        try {
            url = URLContext.getContextURL((URL)context, (String)mi.getSrc().toString());
        }
        catch (MalformedURLException e1) {
            throw new PromptPresenterException(e1);
        }
        String description = mi.getDescription();
        this.volume = mi.getNormalizedVolume();
        this.audioURL = url;
        URLAudioSource urlSource = new URLAudioSource(this.audioURL);
        if ((double)this.volume != 1.0) {
            PluginChain pc = new PluginChain((AudioSource)urlSource);
            VolumeControlPlugin vcp = new VolumeControlPlugin();
            vcp.setVolume(this.volume);
            try {
                pc.add((AudioPlugin)vcp);
            }
            catch (AudioFormatNotSupportedException e) {
                throw new UnsupportedContentException(e);
            }
            playbackSource = pc;
        } else {
            playbackSource = urlSource;
        }
        try {
            this.player.setAudioSource((AudioSource)playbackSource);
        }
        catch (PlayerException e) {
            throw new PromptPresenterException(e);
        }
        if (description != null) {
            this.startAction.putValue("SmallIcon", null);
            this.startAction.putValue("SwingLargeIconKey", null);
            this.startAction.putValue("Name", description);
            this.stopAction.putValue("SmallIcon", null);
            this.stopAction.putValue("SwingLargeIconKey", null);
            this.stopAction.putValue("Name", description);
        }
    }

    public void stop() {
        if (this.silent) {
            this.updateListeners(new PromptPresenterStopEvent(this));
        } else {
            this.player.stop();
        }
    }

    public void close() {
        if (this.silent) {
            this.updateListeners(new PromptPresenterClosedEvent(this));
        } else {
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
            }
        }
    }

    protected synchronized void updateListeners(PromptPresenterEvent event) {
        for (PromptPresenterListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    public void addPromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removePromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerOpenEvent) {
            this.updateListeners(new PromptPresenterOpenedEvent(this));
        } else if (playerEvent instanceof PlayerStartEvent) {
            this.updateListeners(new PromptPresenterStartEvent(this));
        } else if (playerEvent instanceof PlayerStopEvent) {
            this.updateListeners(new PromptPresenterStopEvent(this));
        } else if (playerEvent instanceof PlayerCloseEvent) {
            this.updateListeners(new PromptPresenterClosedEvent(this));
        }
    }

    public void setStartControlEnabled(boolean startEnabled) {
        this.startEnabled = startEnabled;
    }

    public void setStopControlEnabled(boolean stopEnabled) {
    }

    private void updateInAWTThread(LineEvent lineEvent) {
        LineEvent.Type let = lineEvent.getType();
        if (!LineEvent.Type.OPEN.equals(let)) {
            LineEvent.Type.CLOSE.equals(let);
        }
    }

    public void setStartControlAction(Action startControlAction) {
        this.startAction = startControlAction;
    }

    public void setStopControlAction(Action stopControlAction) {
        this.stopAction = stopControlAction;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public String[][] getSupportedMIMETypes() {
        String[][] mtypes = new String[MIMETypes.AUDIOMIMETYPES.length][1];
        int i = 0;
        while (i < MIMETypes.AUDIOMIMETYPES.length) {
            mtypes[i][0] = MIMETypes.AUDIOMIMETYPES[i];
            ++i;
        }
        return mtypes;
    }

    public class LineEventRunnable
    implements Runnable {
        private LineEvent lineEvent;

        public LineEventRunnable(LineEvent lineEvent) {
            this.lineEvent = lineEvent;
        }

        @Override
        public void run() {
            PromptAudioJavaSound.this.updateInAWTThread(this.lineEvent);
        }
    }
}

