/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

@Title(value="Formatted text prompter")
@Description(value="Presents formatted text in HTML or RTF coding.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptFormattedTextViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    private JEditorPane formattedTextPane;
    private JScrollPane editorScrollPane;
    private JPanel centerPanel;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptFormattedTextViewer.class.getName(), new LocalizableMessage("Formatted text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(nArray), new LocalizableMessage("Presents formatted text in HTML or RTF coding."), PromptFormattedTextViewer.getSupportedMIMETypes());
    }

    public PromptFormattedTextViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.create();
    }

    private void create() {
        if (this.editorScrollPane != null) {
            this.remove(this.editorScrollPane);
        }
        this.formattedTextPane = new JEditorPane();
        this.formattedTextPane.setEditable(false);
        this.centerPanel = new JPanel(new GridBagLayout());
        this.centerPanel.add(this.formattedTextPane);
        this.editorScrollPane = new JScrollPane(this.centerPanel);
        this.editorScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.editorScrollPane, "Center");
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void loadContents(URL url) {
    }

    public void setContents(String s) {
        this.formattedTextPane.setText(s);
    }

    public void setContents(String s, String d) {
        this.setContents(s);
    }

    public void setContents(String string, String description, String type) {
        this.formattedTextPane.setContentType(type);
        this.setContents(string);
    }

    public void setContents(URL url) {
        try {
            this.centerPanel.remove(this.formattedTextPane);
            this.formattedTextPane = new JEditorPane(url);
            this.centerPanel.add(this.formattedTextPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContents(URL url, String d) {
        this.setContents(url);
    }

    public void setContents(URL url, String d, String type) {
        this.setContents(url, d, type, null);
    }

    public void setContents(URL url, String d, String type, String charset) {
        this.centerPanel.remove(this.formattedTextPane);
        this.formattedTextPane = new JEditorPane();
        this.centerPanel.add(this.formattedTextPane);
        if (MIMETypes.isOfType(type, MIMETypes.FORMATTEDTEXTMIMETYPES)) {
            this.formattedTextPane.setContentType(type);
        }
        try {
            this.formattedTextPane.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL url = this.applyContextToMediaitemURL(mi);
        String htmlText = mi.getText();
        this.centerPanel.remove(this.formattedTextPane);
        this.formattedTextPane = new JEditorPane();
        this.centerPanel.add(this.formattedTextPane);
        String type = mi.getMimetype();
        if (MIMETypes.isOfType(type, MIMETypes.FORMATTEDTEXTMIMETYPES)) {
            this.formattedTextPane.setContentType(type);
        }
        if (url == null) {
            this.formattedTextPane.setText(htmlText);
        } else {
            try {
                this.formattedTextPane.setPage(url);
            }
            catch (IOException e) {
                throw new PromptPresenterException(e);
            }
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return PromptFormattedTextViewer.getSupportedMIMETypes(MIMETypes.FORMATTEDTEXTMIMETYPES);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

