/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPlainTextViewer;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptTextViewerTest;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.db.speech.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

@Title(value="Plain text prompter")
@Description(value="Presents plain text. Automatically inserts line feeds.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptTextViewer
extends BasicPromptPresenter
implements PromptPresenter,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    public static final int MINFONTSIZE = 12;
    public static final int MAXFONTSIZE = 48;
    public static final int FONTDOWNSTEP = 4;
    public static final int LEFTBORDER = 5;
    public static final int RIGHTBORDER = 5;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int MIDDLE = 5;
    public static final String DEF_CHARSET = "UTF-8";
    private Color textColor = Color.black;
    private Color backgroundColor = Color.white;
    private Font font;
    private String fontFamily = "SansSerif";
    private int fontSize = 48;
    private JTextPane textPane;
    private StyledDocument doc;
    private StyleContext context;
    private Style style;
    private String[] promptText = new String[]{""};
    private String[] promptTextStyles = new String[]{"regular"};
    private Source source = Source.TEXT;
    private Border border;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptTextViewer.class.getName(), new LocalizableMessage("Plain text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(nArray), new LocalizableMessage("Presents plain text. Automatically inserts line feeds."), PromptPlainTextViewer.getSupportedMIMETypes());
    }

    public PromptTextViewer() {
        this.setBackground(this.backgroundColor);
        this.setForeground(this.textColor);
        this.context = new StyleContext();
        this.style = this.context.getStyle("default");
        StyleConstants.setAlignment(this.style, 1);
        StyleConstants.setFontFamily(this.style, this.fontFamily);
        StyleConstants.setFontSize(this.style, this.fontSize);
        StyleConstants.setSpaceAbove(this.style, 4.0f);
        StyleConstants.setSpaceBelow(this.style, 4.0f);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        this.source = Source.TEXT;
        this.setLayout(new GridLayout(1, 1));
        this.add(this.textPane);
        this.addComponentListener(this);
    }

    protected void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
    }

    @Override
    public void setContents(Mediaitem[] mediaitems) throws PromptPresenterException {
        this.setContents(mediaitems[0].getText());
    }

    public void setPromptText(String promptText) {
        this.promptText = new String[1];
        this.promptText[0] = promptText;
        this.promptTextStyles = new String[1];
        this.promptTextStyles[0] = "regular";
    }

    public void setContents(String text) {
        this.source = Source.TEXT;
        this.setPromptText(text);
        this.fitTextToPane();
    }

    public void setContents(URL url) {
        try {
            this.source = Source.URL;
            this.border = BorderFactory.createEmptyBorder();
            this.textPane.setBorder(this.border);
            this.textPane.setPage(url);
        }
        catch (IOException e) {
            System.err.println("setContents() " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void fitTextToPane() {
        boolean fits = false;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        int counter = 0;
        while (!fits && counter < 20) {
            ++counter;
            this.font = this.doc.getFont(this.style);
            this.fontSize = this.font.getSize();
            FontMetrics fm = this.textPane.getFontMetrics(this.font);
            int stringWidth = 0;
            int i = 0;
            while (i < this.promptText.length) {
                String pt = this.promptText[i];
                if (pt != null) {
                    stringWidth += fm.stringWidth(pt);
                }
                ++i;
            }
            int stringHeight = fm.getHeight();
            int lines = stringWidth / width + 2;
            int docHeight = lines * stringHeight;
            int vSpace = height - docHeight;
            int newY = vSpace / 2;
            this.border = BorderFactory.createEmptyBorder(newY, 5, newY, 5);
            this.textPane.setBorder(this.border);
            if (lines * stringHeight > height) {
                this.fontSize -= 4;
            } else if (newY > stringHeight) {
                this.fontSize += 4;
            } else {
                fits = true;
            }
            if (this.fontSize < 12) {
                fits = true;
                this.fontSize = 12;
            } else if (this.fontSize > 48) {
                fits = true;
                this.fontSize = 48;
            }
            StyleConstants.setFontSize(this.style, this.fontSize);
            this.doc.setLogicalStyle(0, this.style);
        }
        try {
            this.doc.remove(0, this.doc.getLength());
            int i = 0;
            while (i < this.promptText.length) {
                this.doc.insertString(this.doc.getLength(), this.promptText[i], this.doc.getStyle(this.promptTextStyles[i]));
                ++i;
            }
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 400);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(500, 250);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public void loadContents() throws PromptPresenterException {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        PromptTextViewer ptv = (PromptTextViewer)e.getSource();
        if (ptv.source.equals((Object)Source.TEXT)) {
            this.fitTextToPane();
        } else {
            this.textPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String promptText = "Und ich sagte noch: \u064a\u0648\u0645 \u062c\u064a\u062f\u060c \u0643\u064a\u0641 \u062d\u0627\u0644\u0643\u061f, aber er antwortete nicht. Auch nicht auf Nachfragen. Und dann kam noch das: \u178f\u17be und danach noch: \u826f\u3044\u4e00\u65e5\u3001\u304a\u5143\u6c17\u3067\u3059\u304b und sogar: \u05d9\u05d5\u05dd \u05d8\u05d5\u05d1, \u05de\u05d4 \u05e9\u05dc\u05d5\u05de\u05da";
        PromptTextViewer ptv = new PromptTextViewer();
        ptv.setPromptText(promptText);
        frame.setContentPane(ptv);
        frame.pack();
        frame.setVisible(true);
        Rectangle r = frame.getBounds();
        frame.setLocation((screenSize.width - r.width) / 2, (screenSize.height - r.height) / 2);
        JFrame testViewer = new JFrame();
        testViewer.setDefaultCloseOperation(3);
        PromptTextViewerTest ptvt = new PromptTextViewerTest(ptv);
        testViewer.setContentPane(ptvt);
        testViewer.pack();
        testViewer.setVisible(true);
    }

    public static enum Source {
        TEXT,
        URL;

    }
}

