/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting.combined;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter2;
import ipsk.apps.speechrecorder.prompting.PromptAudioJavaSound;
import ipsk.apps.speechrecorder.prompting.PromptBufferedImageViewer;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.audio.ChannelGroupLocator;
import ipsk.db.speech.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import javax.sound.sampled.Mixer;
import javax.swing.Action;

@Title(value="Image and audio prompter")
@Description(value="Presents image and audio at the same time.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class ImageAndAudioJavaSoundViewer
extends PromptBufferedImageViewer
implements MediaPromptPresenter2 {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    private Mediaitem audioMediaitem;
    private PromptAudioJavaSound audioJavaSoundPrompter = new PromptAudioJavaSound();

    static {
        int[] nArray = new int[3];
        nArray[2] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(ImageAndAudioJavaSoundViewer.class.getName(), new LocalizableMessage("Image and audio prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(nArray), new LocalizableMessage("Presents image and audio at the same time."), ImageAndAudioJavaSoundViewer.getSupportedMIMETypes());
    }

    @Override
    public void setAudioChannelOffset(int channelOffset) {
        this.audioJavaSoundPrompter.setAudioChannelOffset(channelOffset);
    }

    @Override
    public void setAudioChannelGroupLocator(ChannelGroupLocator channelGroupLocator) throws PromptPresenterPluginException {
        this.audioJavaSoundPrompter.setAudioChannelGroupLocator(channelGroupLocator);
    }

    @Override
    public void setContents(Mediaitem[] mediaitems) throws PromptPresenterException {
        if (mediaitems.length != 2) {
            throw new UnsupportedContentException("Only audio image combinations are supported!");
        }
        Mediaitem[] mediaitemArray = mediaitems;
        int n = mediaitems.length;
        int n2 = 0;
        while (n2 < n) {
            Mediaitem mi = mediaitemArray[n2];
            if (MIMETypes.isOfType(mi.getNNMimetype(), MIMETypes.IMAGEMIMETYPES)) {
                super.setContents(new Mediaitem[]{mi});
            }
            if (MIMETypes.isOfType(mi.getNNMimetype(), MIMETypes.AUDIOMIMETYPES)) {
                this.audioMediaitem = mi;
            }
            ++n2;
        }
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        super.loadContents();
        this.audioJavaSoundPrompter.loadAudioContents(this.audioMediaitem, this.contextURL);
    }

    public static String[][] getSupportedMIMETypes() {
        int combinations = MIMETypes.AUDIOMIMETYPES.length * MIMETypes.IMAGEMIMETYPES.length;
        String[][] mtypes = new String[combinations][];
        int ci = 0;
        int i = 0;
        while (i < MIMETypes.IMAGEMIMETYPES.length) {
            int j = 0;
            while (j < MIMETypes.AUDIOMIMETYPES.length) {
                mtypes[ci++] = new String[]{MIMETypes.IMAGEMIMETYPES[i], MIMETypes.AUDIOMIMETYPES[j]};
                ++j;
            }
            ++i;
        }
        return mtypes;
    }

    @Override
    public void close() {
        this.audioJavaSoundPrompter.close();
    }

    public boolean isSilent() {
        return this.audioJavaSoundPrompter.isSilent();
    }

    @Override
    public void open() throws PromptPresenterException {
        this.audioJavaSoundPrompter.open();
    }

    @Override
    public void setAudioMixer(Mixer mixer) throws PromptPresenterPluginException {
        this.audioJavaSoundPrompter.setAudioMixer(mixer);
    }

    @Override
    public void setSilent(boolean silent) {
        this.audioJavaSoundPrompter.setSilent(silent);
    }

    @Override
    public void setStartControlAction(Action startControlAction) {
        this.audioJavaSoundPrompter.setStartControlAction(startControlAction);
    }

    public void setStartControlEnabled(boolean startEnabled) {
        this.audioJavaSoundPrompter.setStartControlEnabled(startEnabled);
    }

    @Override
    public void setStopControlAction(Action stopControlAction) {
        this.audioJavaSoundPrompter.setStopControlAction(stopControlAction);
    }

    public void setStopControlEnabled(boolean stopEnabled) {
        this.audioJavaSoundPrompter.setStopControlEnabled(stopEnabled);
    }

    @Override
    public void start() throws PromptPresenterException {
        this.audioJavaSoundPrompter.start();
    }

    @Override
    public void stop() {
        this.audioJavaSoundPrompter.stop();
    }

    @Override
    public boolean requiresDisplayableToRun() {
        return false;
    }

    @Override
    public void addPromptPresenterListener(PromptPresenterListener listener) {
        super.addPromptPresenterListener(listener);
        this.audioJavaSoundPrompter.addPromptPresenterListener(listener);
    }

    @Override
    public void removePromptPresenterListener(PromptPresenterListener listener) {
        super.removePromptPresenterListener(listener);
        this.audioJavaSoundPrompter.removePromptPresenterListener(listener);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

