/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting.sound.javasound;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter2;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterOpenedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStartEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioSource;
import ipsk.audio.ChannelGroupLocator;
import ipsk.audio.PluginChain;
import ipsk.audio.URLAudioSource;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.VolumeControlPlugin;
import ipsk.db.speech.Mediaitem;
import ipsk.io.ChannelRouting;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.Mixer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class PromptAudioJavaSoundViewer
extends BasicPromptPresenter
implements MediaPromptPresenter2,
PlayerListener {
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    private static final long serialVersionUID = -448684398142928391L;
    private static Font audioButtonFont;
    private ImageIcon audioImage;
    private Mixer mixer = AudioSystem.getMixer(null);
    private Player player = new Player(this.mixer);
    private Vector<PromptPresenterListener> listeners;
    private JButton audioButton;
    private URL audioURL = null;
    private Logger audioLogger;
    private Action startAction;
    private Action startPromptAction;
    private Action stopAction;
    private float volume = 1.0f;
    private boolean startEnabled;
    private boolean silent = false;
    private static final LocalizableMessage TITLE;
    private static final LocalizableMessage DESCRIPTION;
    private static final String VENDOR = "Institute of Phonetics and Speech processing, Munich";
    private static final Version SPECIFICATIONVERSION;
    private static final Version IMPLEMENTATIONVERSION;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptAudioJavaSoundViewer.class.getName(), new LocalizableMessage("Audio prompter"), VENDOR, new Version(nArray), new LocalizableMessage("Prompts audio using JavaSound."), PromptAudioJavaSoundViewer.getSupportedMIMETypes());
        audioButtonFont = new Font("sans-serif", 1, 36);
        TITLE = new LocalizableMessage("Audio prompter");
        DESCRIPTION = new LocalizableMessage("Presents audio using JavaSound.");
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        SPECIFICATIONVERSION = new Version(nArray2);
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        IMPLEMENTATIONVERSION = new Version(nArray3);
    }

    public PromptAudioJavaSoundViewer() {
        this.player.addPlayerListener((PlayerListener)this);
        this.listeners = new Vector();
        this.audioLogger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.audioButton = new JButton();
        this.audioButton.setFont(audioButtonFont);
        this.audioButton.setVerticalTextPosition(3);
        this.audioButton.setHorizontalTextPosition(0);
        this.add((Component)this.audioButton, "Center");
    }

    public LocalizableMessage getTitle() {
        return TITLE;
    }

    public LocalizableMessage getDescription() {
        return DESCRIPTION;
    }

    public String getVendor() {
        return VENDOR;
    }

    public Version getSpecificationVersion() {
        return SPECIFICATIONVERSION;
    }

    public Version getImplementationVersion() {
        return IMPLEMENTATIONVERSION;
    }

    @Override
    public void setAudioMixer(Mixer mixer) throws PromptPresenterPluginException {
        if (mixer == null) {
            mixer = AudioSystem.getMixer(null);
        }
        this.mixer = mixer;
        try {
            this.player.setMixer(mixer);
        }
        catch (PlayerException e) {
            e.printStackTrace();
            throw new PromptPresenterPluginException(e);
        }
    }

    @Override
    public void setAudioChannelOffset(int channelOffset) {
        this.player.setChannelRouting(null);
        this.player.setChannelOffset(channelOffset);
    }

    @Override
    public void setAudioChannelGroupLocator(ChannelGroupLocator channelGroupLocator) throws PromptPresenterPluginException {
        Mixer mixer = channelGroupLocator.getDevice();
        this.setAudioMixer(mixer);
        this.setAudioChannelOffset(channelGroupLocator.getChannelOffset());
        ChannelRouting channelRouting = channelGroupLocator.getChannelRouting();
        this.player.setChannelRouting(channelRouting);
    }

    public void setContents(String string, String description, String type) {
    }

    public void setRecScriptResources(Hashtable mh) {
    }

    @Override
    public void open() throws PromptPresenterException {
        if (this.silent) {
            this.updateListeners(new PromptPresenterOpenedEvent(this));
        } else if (this.audioURL != null) {
            try {
                this.player.open();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                throw new PromptPresenterException(e);
            }
        }
    }

    @Override
    public void start() throws PromptPresenterException {
        if (this.silent) {
            this.audioButton.setAction(this.stopAction);
            this.updateListeners(new PromptPresenterStartEvent(this));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PromptAudioJavaSoundViewer.this.stop();
                }
            });
        } else if (this.audioURL != null) {
            try {
                this.player.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                throw new PromptPresenterException(e);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize());
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        URLAudioSource playbackSource;
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL url = this.applyContextToMediaitemURL(mi);
        String description = mi.getDescription();
        this.volume = mi.getNormalizedVolume();
        this.audioURL = url;
        URLAudioSource urlSource = new URLAudioSource(this.audioURL);
        if ((double)this.volume != 1.0) {
            PluginChain pc = new PluginChain((AudioSource)urlSource);
            VolumeControlPlugin vcp = new VolumeControlPlugin();
            vcp.setVolume(this.volume);
            try {
                pc.add((AudioPlugin)vcp);
            }
            catch (AudioFormatNotSupportedException e) {
                throw new UnsupportedContentException(e);
            }
            playbackSource = pc;
        } else {
            playbackSource = urlSource;
        }
        try {
            this.player.setAudioSource((AudioSource)playbackSource);
        }
        catch (PlayerException e) {
            throw new PromptPresenterException(e);
        }
        if (description != null) {
            this.startAction.putValue("SmallIcon", null);
            this.startAction.putValue("SwingLargeIconKey", null);
            this.startAction.putValue("Name", description);
            this.stopAction.putValue("SmallIcon", null);
            this.stopAction.putValue("SwingLargeIconKey", null);
            this.stopAction.putValue("Name", description);
        }
    }

    @Override
    public void stop() {
        if (this.silent) {
            this.updateListeners(new PromptPresenterStopEvent(this));
        } else {
            this.player.stop();
        }
    }

    @Override
    public void close() {
        if (this.silent) {
            this.audioButton.setAction(this.startAction);
            this.updateListeners(new PromptPresenterClosedEvent(this));
        } else {
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected synchronized void updateListeners(PromptPresenterEvent event) {
        for (PromptPresenterListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    @Override
    public void addPromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removePromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerOpenEvent) {
            this.updateListeners(new PromptPresenterOpenedEvent(this));
        } else if (playerEvent instanceof PlayerStartEvent) {
            this.audioButton.setAction(this.stopAction);
            this.updateListeners(new PromptPresenterStartEvent(this));
        } else if (playerEvent instanceof PlayerStopEvent) {
            this.updateListeners(new PromptPresenterStopEvent(this));
        } else if (playerEvent instanceof PlayerCloseEvent) {
            this.audioButton.setAction(this.startAction);
            this.updateListeners(new PromptPresenterClosedEvent(this));
        }
    }

    public void setStartControlEnabled(boolean startEnabled) {
        this.startEnabled = startEnabled;
    }

    public void setStopControlEnabled(boolean stopEnabled) {
    }

    private void updateInAWTThread(LineEvent lineEvent) {
        LineEvent.Type let = lineEvent.getType();
        if (!LineEvent.Type.OPEN.equals(let)) {
            LineEvent.Type.CLOSE.equals(let);
        }
    }

    @Override
    public void setStartControlAction(Action startControlAction) {
        this.startAction = startControlAction;
        if (this.audioButton.getAction() == null) {
            this.audioButton.setAction(this.startAction);
        }
    }

    @Override
    public void setStopControlAction(Action stopControlAction) {
        this.stopAction = stopControlAction;
    }

    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public static String[][] getSupportedMIMETypes() {
        String[][] mtypes = new String[MIMETypes.AUDIOMIMETYPES.length][1];
        int i = 0;
        while (i < MIMETypes.AUDIOMIMETYPES.length) {
            mtypes[i][0] = MIMETypes.AUDIOMIMETYPES[i];
            ++i;
        }
        return mtypes;
    }

    @Override
    public boolean requiresDisplayableToRun() {
        return false;
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    public class LineEventRunnable
    implements Runnable {
        private LineEvent lineEvent;

        public LineEventRunnable(LineEvent lineEvent) {
            this.lineEvent = lineEvent;
        }

        @Override
        public void run() {
            PromptAudioJavaSoundViewer.this.updateInAWTThread(this.lineEvent);
        }
    }
}

