/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting.text;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;

@Title(value="Teleprompter")
@Description(value="Presents plain text like a teleprompter.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class TelePrompterViewer
extends BasicPromptPresenter
implements PromptPresenter {
    public static final PromptPresenterServiceDescriptor DESCRIPTOR;
    public static final String DEF_CHARSET = "UTF-8";
    private String promptText = "";
    private Color textColor = Color.BLACK;
    private Color backgroundColor = Color.WHITE;
    private String fontFamily = "sans-serif";
    private String fontStyleName = "bold";
    private int fontStyle;
    private int fontSize = 48;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(TelePrompterViewer.class.getName(), new LocalizableMessage("Teleprompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(nArray), new LocalizableMessage("Presents plain text like a teleprompter."), TelePrompterViewer.getSupportedMIMETypes());
    }

    public TelePrompterViewer() {
        this.setBackground(this.backgroundColor);
        this.promptFont = new Font("sans-serif", 1, 48);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.textColor);
        g.drawString(this.promptText, 0, 0);
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void setContents(String s) {
        this.promptText = s;
    }

    public void setContents(String s, String d) {
        this.promptText = s;
    }

    public void setContents(String s, String d, String type) {
        this.setContents(s, d);
    }

    public void setContents(URL u) {
        this.setContents(u, null);
    }

    public void setContents(URL u, String d) {
        this.setContents(u, null, null);
    }

    public void setContents(URL u, String d, String type) {
        this.setContents(u, null, null, null);
    }

    public void setContents(URL u, String d, String type, String cs) {
        try {
            InputStreamReader r = null;
            r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[2048];
            int read = 0;
            while ((read = r.read(cbuf)) >= 0) {
                sw.write(cbuf, 0, read);
            }
            r.close();
            sw.close();
            this.setContents(sw.getBuffer().toString(), d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
        this.fontSize = promptFont.getSize();
        this.fontStyle = promptFont.getStyle();
        this.fontFamily = promptFont.getFamily();
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
        if (emphasized) {
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(Color.LIGHT_GRAY);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return TelePrompterViewer.getSupportedMIMETypes(MIMETypes.PLAINTEXTMIMETYPES);
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        String text;
        block14: {
            if (this.mediaitems == null || this.mediaitems.length == 0) {
                throw new UnsupportedContentException("No media item to display!");
            }
            if (this.mediaitems.length > 1) {
                throw new UnsupportedContentException("Multiple media items not supported!");
            }
            text = null;
            Mediaitem mi = this.mediaitems[0];
            URL u = this.applyContextToMediaitemURL(mi);
            if (u != null) {
                Charset cs = null;
                String miCharset = mi.getCharSet();
                if (miCharset != null) {
                    cs = Charset.forName(miCharset.trim());
                }
                InputStreamReader r = null;
                try {
                    try {
                        r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
                        StringWriter sw = new StringWriter();
                        char[] cbuf = new char[2048];
                        int read = 0;
                        while ((read = r.read(cbuf)) >= 0) {
                            sw.write(cbuf, 0, read);
                        }
                        sw.close();
                        text = sw.getBuffer().toString();
                        break block14;
                    }
                    catch (IOException e) {
                        throw new PromptPresenterException(e);
                    }
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        throw new PromptPresenterException(e);
                    }
                }
            }
            text = mi.getText();
        }
        this.promptText = text;
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

