/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.io.FilenameValidator;
import java.util.HashSet;
import java.util.Set;

public class ItemCodeValidator {
    private Set<String> existingCodes;
    private Set<String> codesInUse = null;

    public Set<String> getCodesInUse() {
        return this.codesInUse;
    }

    public void setCodesInUse(Set<String> codesInUse) {
        this.codesInUse = codesInUse;
    }

    public ItemCodeValidator() {
        this(new HashSet<String>());
    }

    public ItemCodeValidator(Set<String> existingCodes) {
        this.existingCodes = existingCodes;
    }

    public boolean codeMayInUseIgnoreCase(String itemCode) {
        Boolean ciu = this.codeInUseIgnoreCase(itemCode);
        return Boolean.TRUE.equals(ciu);
    }

    public Boolean codeInUseIgnoreCase(String itemCode) {
        if (this.codesInUse != null) {
            for (String codeInUse : this.codesInUse) {
                if (!codeInUse.equalsIgnoreCase(itemCode)) continue;
                return true;
            }
            return false;
        }
        return null;
    }

    public String validateItemCode(String itemCode) {
        FilenameValidator.ValidationResult vr = FilenameValidator.validateFileNameCharacters((String)itemCode);
        if (!vr.isValid()) {
            return vr.getMessage().localize();
        }
        if (this.existingCodes != null) {
            for (String ec : this.existingCodes) {
                if (itemCode.equals(ec)) {
                    return "duplicate";
                }
                if (!itemCode.equalsIgnoreCase(ec)) continue;
                return "duplicate (ignore case)";
            }
        }
        return null;
    }

    public Set<String> getExistingCodes() {
        return this.existingCodes;
    }

    public void setExistingCodes(Set<String> existingCodes) {
        this.existingCodes = existingCodes;
    }

    public void clear() {
        if (this.existingCodes != null) {
            this.existingCodes.clear();
        }
        this.codesInUse = null;
    }
}

