/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.script.RecScriptSchemaVersionNewerException;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Script;
import ipsk.io.StreamCopy;
import ipsk.net.URLContext;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RecscriptHandler
extends DOMConverter {
    public static final String REC_SCRIPT_DTD_PREFIX = "SpeechRecPrompts";
    public static final String REC_SCRIPT_DTD_EXTENSION = "dtd";
    public static final int REC_SCRIPT_DTD_VERSION = 4;
    public static final String REC_SCRIPT_DTD_1 = "SpeechRecPrompts.dtd";
    public static final String REC_SCRIPT_DTD_2 = "SpeechRecPrompts_2.dtd";
    public static final String REC_SCRIPT_DTD_3 = "SpeechRecPrompts_3.dtd";
    public static final String REC_SCRIPT_DTD_4 = "SpeechRecPrompts_4.dtd";
    public static final String REC_SCRIPT_DTD = "SpeechRecPrompts_4.dtd";
    public static final String NAME = "script";
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private String systemIdBase = null;
    private String systemId = "SpeechRecPrompts_4.dtd";
    private IntegerSequenceGenerator seqGen = null;

    public IntegerSequenceGenerator getSeqGen() {
        return this.seqGen;
    }

    public void setSeqGen(IntegerSequenceGenerator seqGen) {
        this.seqGen = seqGen;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemIdBase() {
        return this.systemIdBase;
    }

    public void setSystemIdBase(String string) {
        this.systemIdBase = string;
    }

    public Document newRecScriptDocument() throws ParserConfigurationException {
        DocumentBuilder docBuilder = this.docFactory.newDocumentBuilder();
        DOMImplementation domImpl = docBuilder.getDOMImplementation();
        DocumentType docType = domImpl.createDocumentType(NAME, null, this.systemId);
        return domImpl.createDocument(null, NAME, docType);
    }

    @Deprecated
    public void writeXML(Document doc, OutputStream out) throws DOMConverterException {
        super.writeXML(doc, null, this.systemId, out);
    }

    public void writeXML(Script s, OutputStream out) throws DOMConverterException, ParserConfigurationException {
        this.writeXML(s, (Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public void writeXML(Document d, Writer out) throws DOMConverterException {
        super.writeXML(d, null, this.systemId, out);
    }

    public void writeXML(Script s, Writer out) throws DOMConverterException, ParserConfigurationException {
        if (s == null) {
            throw new DOMConverterException("No script object to convert (null) !");
        }
        Document d = this.newRecScriptDocument();
        s.insertIntoElement(d, d.getDocumentElement());
        super.writeXML(d, null, this.systemId, out);
    }

    public void writeXML(Script s, String systemID, Writer out) throws DOMConverterException, ParserConfigurationException {
        if (s == null) {
            throw new DOMConverterException("No script object to convert (null) !");
        }
        Document d = this.newRecScriptDocument();
        s.insertIntoElement(d, d.getDocumentElement());
        String sID = systemID;
        if (sID == null) {
            sID = this.systemId;
        }
        super.writeXML(d, null, sID, out);
    }

    public Script scriptFromDocument(Document d) throws DOMConverterException {
        return this.scriptFromDocument(d, true);
    }

    public Script scriptFromDocument(Document d, boolean propertyChangeSupport) throws DOMConverterException {
        Element rootE = d.getDocumentElement();
        Script s = new Script(rootE);
        if (propertyChangeSupport) {
            s.setPropertyChangeSupportEnabled(true);
        }
        return s;
    }

    public Script readScriptFromXML(InputSource is) throws DOMConverterException {
        Document d = this.readXML(is);
        return this.scriptFromDocument(d, true);
    }

    public Script readScriptFromXML(InputStream is, String systemId) throws DOMConverterException {
        Document d = this.readXML(is, systemId);
        return this.scriptFromDocument(d);
    }

    public Script readScriptFromXML(Reader isr, String systemId) throws DOMConverterException {
        InputSource is = new InputSource(isr);
        if (systemId != null) {
            is.setSystemId(systemId);
        }
        Document d = this.readXML(is);
        return this.scriptFromDocument(d);
    }

    public Document toDOM(Script script) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document d = docBuilder.newDocument();
        d.appendChild(script.toElement(d));
        return d;
    }

    public Script readScriptFromXMLwithoutDTD(InputSource is) throws DOMConverterException, IOException, ParserConfigurationException, SAXException {
        this.setValidating(true);
        EntityResolver er = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.matches(".*SpeechRecPrompts_[0-9]*.dtd$") || systemId.matches(".*SpeechRecPrompts.dtd$")) {
                    InputStream dtdStream = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
                    BufferedInputStream bis = new BufferedInputStream(dtdStream);
                    return new InputSource(bis);
                }
                return null;
            }
        };
        Document d = this.readXML(is, er);
        Element rootE = d.getDocumentElement();
        Script s = new Script(rootE);
        return s;
    }

    public String scriptValid(Script script) throws ParserConfigurationException, IOException {
        try {
            this.validateScript(script);
        }
        catch (DOMConverterException e) {
            return e.getMessage();
        }
        catch (SAXException e) {
            return e.getMessage();
        }
        return null;
    }

    public void validateScript(Script script) throws DOMConverterException, ParserConfigurationException, IOException, SAXException {
        StringWriter sw = new StringWriter();
        Document d = this.toDOM(script);
        this.writeXML(d, null, "SpeechRecPrompts_4.dtd", sw);
        String ss = sw.toString();
        StringReader sr = new StringReader(ss);
        InputSource sis = new InputSource(sr);
        this.readScriptFromXMLwithoutDTD(sis);
    }

    public Script insertScriptElementsFromXML(Script s, InputSource is) throws DOMConverterException {
        Document d = this.readXML(is);
        Element rootE = d.getDocumentElement();
        s.insertElement(this.seqGen, rootE);
        return s;
    }

    public Script readScriptFromXML(Reader is) throws DOMConverterException {
        Document d = this.readXML(is);
        Element rootE = d.getDocumentElement();
        Script s = new Script(this.seqGen, rootE);
        s.setPropertyChangeSupportEnabled(true);
        return s;
    }

    private File getRequiredDTDFile() throws MalformedURLException {
        URL systemIdBaseURL;
        if (this.systemIdBase != null && (systemIdBaseURL = new URL(this.systemIdBase)).getProtocol().equalsIgnoreCase("file")) {
            String systemIdBaseDirname;
            try {
                systemIdBaseDirname = systemIdBaseURL.toURI().getPath();
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
            File systemBaseDir = new File(systemIdBaseDirname);
            File dtdFile = new File(systemBaseDir, "SpeechRecPrompts_4.dtd");
            return dtdFile;
        }
        return null;
    }

    public boolean isNewVersionOfDTDFileRequired() throws MalformedURLException {
        File requiredDtdFile = this.getRequiredDTDFile();
        return requiredDtdFile != null && !requiredDtdFile.exists();
    }

    public void createDTDFileIfRequired() throws IOException {
        File dtdFile = this.getRequiredDTDFile();
        if (dtdFile != null && !dtdFile.exists()) {
            InputStream is = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
            FileOutputStream fos = new FileOutputStream(dtdFile);
            StreamCopy.copy((InputStream)is, (OutputStream)fos);
        }
    }

    private Integer parseSystemIDVersion(String systemId) {
        String originalDtdPattern = REC_SCRIPT_DTD_1;
        String versionedDtdsPattern = "SpeechRecPrompts_([0-9]{1,2}).dtd";
        if (systemId == null) {
            return null;
        }
        if (systemId.matches(originalDtdPattern)) {
            return 1;
        }
        Pattern p = Pattern.compile(versionedDtdsPattern);
        Matcher m = p.matcher(systemId);
        if (m.matches()) {
            String dtdVersString = m.group(1);
            return Integer.parseInt(dtdVersString);
        }
        return null;
    }

    public Script readRecScriptXMLFile(URL recScriptURL) throws RecscriptHandlerException {
        return this.readRecScriptXMLFile(recScriptURL, false);
    }

    public Script readRecScriptXMLFile(URL recScriptURL, boolean force) throws RecscriptHandlerException {
        URLConnection recScriptUrlConn;
        Document doc = null;
        String recScriptURLString = recScriptURL.toExternalForm();
        DOMConverter domConverter = new DOMConverter();
        domConverter.setValidating(true);
        if (this.systemIdBase == null) {
            try {
                doc = domConverter.readXML(recScriptURLString);
            }
            catch (DOMConverterException e) {
                throw new RecscriptHandlerException("Could not parse recording script " + recScriptURLString + ": " + e.getLocalizedMessage(), e);
            }
        }
        try {
            recScriptUrlConn = recScriptURL.openConnection();
        }
        catch (IOException e) {
            throw new RecscriptHandlerException("Could not open recording script URL " + recScriptURLString + ": " + e.getLocalizedMessage(), e);
        }
        recScriptUrlConn.setUseCaches(false);
        recScriptUrlConn.setRequestProperty("Accept", "application/xml");
        try {
            InputStream recScriptIs = recScriptUrlConn.getInputStream();
            doc = domConverter.readXML(recScriptIs, this.systemIdBase);
        }
        catch (IOException e) {
            throw new RecscriptHandlerException("Could not read recording script URL " + recScriptURLString + ": " + e.getLocalizedMessage(), e);
        }
        catch (DOMConverterException e) {
            throw new RecscriptHandlerException("Could not parse recording script " + recScriptURLString + ": " + e.getLocalizedMessage(), e);
        }
        DocumentType documentType = doc.getDoctype();
        String systemId = documentType.getSystemId();
        Integer dtdVers = this.parseSystemIDVersion(systemId);
        if (!force && dtdVers > 4) {
            throw new RecScriptSchemaVersionNewerException(4, dtdVers);
        }
        this.systemId = systemId;
        return new Script(this.seqGen, doc.getDocumentElement());
    }

    public Script readRecScriptXMLFileWithoutDTD(URL recScriptURL) throws DOMConverterException, IOException, ParserConfigurationException, SAXException {
        InputStream iStream = recScriptURL.openStream();
        InputSource iSrc = new InputSource(iStream);
        return this.readScriptFromXMLwithoutDTD(iSrc);
    }

    public void renameContext(File recScriptFile, URL oldCtxURL, URL newCtxURL) throws RecscriptHandlerException {
        URL recScriptURL;
        URI recScriptUri = recScriptFile.toURI();
        try {
            recScriptURL = recScriptUri.toURL();
        }
        catch (MalformedURLException e1) {
            throw new RecscriptHandlerException(e1);
        }
        Script script = this.readRecScriptXMLFile(recScriptURL);
        Script modScript = null;
        try {
            modScript = (Script)script.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return;
        }
        boolean modified = this.renameContext(modScript, oldCtxURL, newCtxURL);
        if (modified) {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(recScriptFile);
                    this.writeXML(modScript, (OutputStream)fos);
                }
                catch (FileNotFoundException e) {
                    throw new RecscriptHandlerException("Could not find file: " + e.getLocalizedMessage(), e);
                }
                catch (DOMConverterException e) {
                    throw new RecscriptHandlerException("Could not convert script to XML file: " + e.getLocalizedMessage(), e);
                }
                catch (ParserConfigurationException e) {
                    throw new RecscriptHandlerException("Could not configure XML parser for script file: " + e.getLocalizedMessage(), e);
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean renameContext(Script script, URL oldCtxURL, URL newCtxURL) throws RecscriptHandlerException {
        boolean changed = false;
        URLContext oldCtx = new URLContext(oldCtxURL);
        List pis = script.promptItemsList();
        for (PromptItem pi : pis) {
            List mis = pi.getMediaitems();
            for (Mediaitem mi : mis) {
                String newScrStr;
                String srcStr = mi.getSrcStr();
                if (srcStr == null) continue;
                try {
                    newScrStr = oldCtx.renameContextSpec(newCtxURL, srcStr);
                }
                catch (MalformedURLException e) {
                    throw new RecscriptHandlerException(e);
                }
                if (srcStr.equals(newScrStr)) continue;
                mi.setSrcStr(newScrStr);
                changed = true;
            }
        }
        return changed;
    }

    public void duplicate(URL orgCtxURL, String orgScriptSpec, URL newCtxURL) throws RecscriptHandlerException {
        URL orgScriptUrl;
        try {
            orgScriptUrl = URLContext.getContextURLStrict((URL)orgCtxURL, (String)orgScriptSpec);
        }
        catch (MalformedURLException e) {
            throw new RecscriptHandlerException(e);
        }
        Script orgScript = this.readRecScriptXMLFile(orgScriptUrl);
        Script newScript = null;
        try {
            newScript = (Script)orgScript.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RecscriptHandlerException(e);
        }
        URLContext orgCtx = new URLContext(orgCtxURL);
        List pis = newScript.promptItemsList();
        for (PromptItem pi : pis) {
            List mis = pi.getMediaitems();
            for (Mediaitem mi : mis) {
                String orgSrcStr = mi.getSrcStr();
                if (orgSrcStr == null) continue;
                try {
                    URL uRL = URLContext.getContextURLStrict((URL)orgScriptUrl, (String)orgSrcStr);
                }
                catch (MalformedURLException e) {
                    throw new RecscriptHandlerException(e);
                }
                try {
                    String newScrStr = orgCtx.renameContextSpec(newCtxURL, orgSrcStr);
                }
                catch (MalformedURLException e) {
                    throw new RecscriptHandlerException(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            RecscriptHandler h = new RecscriptHandler();
            if (args.length == 2) {
                FileInputStream fis = new FileInputStream(args[1]);
                Script script = h.readScriptFromXML(fis, args[0]);
                System.out.println(script);
                h.writeXML(script, (Writer)new OutputStreamWriter((OutputStream)System.out, Charset.forName("UTF-8")));
            } else {
                h.writeXML(h.newRecScriptDocument(), (Writer)new OutputStreamWriter((OutputStream)System.out, Charset.forName("UTF-8")));
            }
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

