/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.script.ui.ScriptUI;
import ipsk.db.speech.Section;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class SectionTransferHandler
extends TransferHandler {
    private boolean shouldRemove;

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            ScriptUI sui = (ScriptUI)c;
            try {
                Section section = (Section)t.getTransferData(Section.CLASS_DATA_FLAVOR);
                sui.insert(section);
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.err.println("importData: unsupported data flavor");
            }
            catch (IOException ioe) {
                System.err.println("importData: I/O exception");
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Section section = ((ScriptUI)c).getSelectedSection();
        this.shouldRemove = true;
        return section;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (this.shouldRemove && action == 2) {
            ((ScriptUI)c).removeSelectedSection();
        }
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (Section.CLASS_DATA_FLAVOR.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

