/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.beans.ExtBeanInfo;
import ipsk.beans.ExtendedIntrospector;
import ipsk.db.speech.Group;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.text.StringSequenceBuilder;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TableTextfileExporter
extends JPanel
implements ActionListener,
DocumentListener {
    private ColumnDescriptor[] colDescriptors = null;
    private JButton browseButton;
    private JComboBox charSetsChooser;
    private JComboBox fieldSeparatorChooser;
    private Script script;
    private JFileChooser fileChooser;
    private File textFile;
    private SortedMap<String, Charset> charSetMap;
    private Vector<String[]> lines = new Vector();
    private JTextField textFilePathField;
    private JLabel statusMessage;
    private static EnumVector<FieldSeparator> FIELD_SEPARATORS = new EnumVector(FieldSeparator.class);
    private JComboBox[] colDescriptorChoosers = null;

    public TableTextfileExporter(Script script, ColumnDescriptor[] columnDescriptors) throws IntrospectionException {
        super(new GridBagLayout());
        this.script = script;
        this.colDescriptors = columnDescriptors;
        ExtBeanInfo recBi = ExtendedIntrospector.getExtendedBeanInfo(Recording.class);
        String bName = recBi.getResourceBundleName();
        String itemCodeRK = recBi.getPropertyResourceKey("itemCode");
        LocalizableMessage lm = new LocalizableMessage(bName, itemCodeRK);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        JPanel textFileExportPanel = new JPanel(new GridBagLayout());
        TitledBorder tb = BorderFactory.createTitledBorder("Text file export");
        textFileExportPanel.setBorder(tb);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = new Insets(2, 2, 2, 2);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.anchor = 17;
        textFileExportPanel.add((Component)new JLabel("Table file:"), c2);
        ++c2.gridx;
        c2.weightx = 2.0;
        c2.fill = 2;
        this.textFilePathField = new JTextField(30);
        this.textFilePathField.setEnabled(false);
        this.textFilePathField.setEditable(false);
        textFileExportPanel.add((Component)this.textFilePathField, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.fill = 0;
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(this);
        textFileExportPanel.add((Component)this.browseButton, c2);
        c2.gridx = 0;
        ++c2.gridy;
        JLabel charSetLabel = new JLabel("Charset:");
        textFileExportPanel.add((Component)charSetLabel, c2);
        ++c2.gridx;
        c2.gridwidth = 1;
        this.charSetMap = Charset.availableCharsets();
        Set<String> charSetKeys = this.charSetMap.keySet();
        Charset defCharSet = Charset.defaultCharset();
        String defCharsetName = defCharSet.name();
        String[] charSetKeyStrs = charSetKeys.toArray(new String[0]);
        this.charSetsChooser = new JComboBox<String>(charSetKeyStrs);
        this.charSetsChooser.setSelectedItem(defCharsetName);
        this.charSetsChooser.addActionListener(this);
        textFileExportPanel.add((Component)this.charSetsChooser, c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.gridwidth = 1;
        c2.anchor = 17;
        JLabel fsLabel = new JLabel("Field Separator:");
        textFileExportPanel.add((Component)fsLabel, c2);
        ++c2.gridx;
        this.fieldSeparatorChooser = new JComboBox<FieldSeparator>((Vector<FieldSeparator>)FIELD_SEPARATORS);
        this.fieldSeparatorChooser.addActionListener(this);
        textFileExportPanel.add((Component)this.fieldSeparatorChooser, c2);
        this.add((Component)textFileExportPanel, c);
        JPanel mappingPanel = new JPanel(new GridBagLayout());
        TitledBorder tb2 = BorderFactory.createTitledBorder("Mapping");
        mappingPanel.setBorder(tb2);
        GridBagConstraints c3 = new GridBagConstraints();
        if (this.colDescriptors != null) {
            this.colDescriptorChoosers = new JComboBox[this.colDescriptors.length];
            c3.gridx = 0;
            c3.gridy = 0;
            c3.gridwidth = 1;
            int i = 0;
            while (i < this.colDescriptors.length) {
                c3.gridx = 0;
                String label = this.colDescriptors[i].toString();
                mappingPanel.add((Component)new JLabel(String.valueOf(label) + ":"), c3);
                ++c3.gridx;
                this.colDescriptorChoosers[i] = new JComboBox();
                this.colDescriptorChoosers[i].addItem(new Column(null));
                this.colDescriptorChoosers[i].addActionListener(this);
                mappingPanel.add((Component)this.colDescriptorChoosers[i], c3);
                ++c3.gridy;
                ++i;
            }
        }
        ++c.gridy;
        this.add((Component)mappingPanel, c);
        this.tableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        JComboBox[] jComboBoxArray = this.colDescriptorChoosers;
        int n = this.colDescriptorChoosers.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox rdch = jComboBoxArray[n2];
            if (src == rdch) {
                this.setDependencies();
                return;
            }
            ++n2;
        }
        if (src == this.browseButton) {
            this.fileChooser = new JFileChooser();
            int res = this.fileChooser.showOpenDialog(this);
            if (res == 0) {
                this.textFile = this.fileChooser.getSelectedFile();
            }
        }
    }

    public String[][] getTableData() {
        if (this.lines == null) {
            return null;
        }
        return (String[][])this.lines.toArray((T[])new String[0][]);
    }

    private void setDependencies() {
        if (this.textFile != null) {
            this.textFilePathField.setText("file:" + this.textFile.getPath());
            this.textFilePathField.setEnabled(true);
        } else {
            this.textFilePathField.setText("");
            this.textFilePathField.setEnabled(false);
        }
    }

    private void tableDataChanged() {
        boolean tableDataDetected = false;
        if (this.textFile != null) {
            this.textFilePathField.setText("file:" + this.textFile.getPath());
        } else {
            this.textFilePathField.setText("");
        }
        String message = "No table data";
        int maxCols = 0;
        int minCols = 0;
        if (this.lines != null && this.lines.size() > 0) {
            minCols = Integer.MAX_VALUE;
            for (String[] row : this.lines) {
                if (row.length > maxCols) {
                    maxCols = row.length;
                }
                if (row.length >= minCols) continue;
                minCols = row.length;
            }
            message = new String("Table with " + this.lines.size() + " rows and " + maxCols + " columns");
            tableDataDetected = true;
        }
        this.statusMessage.setText(message);
        if (this.colDescriptorChoosers != null) {
            int i = 0;
            while (i < this.colDescriptorChoosers.length) {
                JComboBox colDescriptorChooser = this.colDescriptorChoosers[i];
                ColumnDescriptor cd = this.colDescriptors[i];
                colDescriptorChooser.removeAllItems();
                colDescriptorChooser.addItem(new Column(null));
                int c = 0;
                while (c < maxCols) {
                    colDescriptorChooser.addItem(new Column(c));
                    ++c;
                }
                if (minCols == 1 && cd.getName().equals("PromptText")) {
                    colDescriptorChooser.setSelectedIndex(1);
                }
                if (minCols >= 2) {
                    colDescriptorChooser.setSelectedIndex(i + 1);
                }
                ++i;
            }
        }
    }

    private void writeFile() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.textFile);
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, (Charset)this.charSetMap.get(this.charSetsChooser.getSelectedItem()));
        EnumSelectionItem si = (EnumSelectionItem)this.fieldSeparatorChooser.getSelectedItem();
        FieldSeparator fs = (FieldSeparator)si.getEnumVal();
        Character fieldSep = Character.valueOf(fs.value());
        List<List<String>> lines = this.sectionsToLines(this.script.getSections());
        try {
            for (List<String> lineTks : lines) {
                String line = StringSequenceBuilder.buildString(lineTks, (char)fieldSep.charValue());
                osr.write(String.valueOf(line) + "\n");
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public List<String> promptItemToLine(PromptItem pi) {
        ArrayList<String> lineTokens = new ArrayList<String>();
        int rdi = 0;
        while (rdi < this.colDescriptors.length) {
            ColumnDescriptor rd = this.colDescriptors[rdi];
            JComboBox rdch = this.colDescriptorChoosers[rdi];
            Column col = (Column)rdch.getSelectedItem();
            Integer colI = col.getColumn();
            String name = rd.getName();
            if (colI != null) {
                if (name.equals("Code")) {
                    String itemCode = "";
                    if (pi instanceof Recording) {
                        itemCode = ((Recording)pi).getItemcode();
                    }
                    lineTokens.add(itemCode);
                }
                if (name.equals("PromptText")) {
                    List mis = pi.getMediaitems();
                    String misStr = StringSequenceBuilder.buildStringOfObjs((List)mis, (char)',');
                    lineTokens.add(misStr);
                }
            }
            ++rdi;
        }
        return lineTokens;
    }

    public List<List<String>> sectionToLines(Section s) {
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        List pus = s.getGroups();
        for (Group g : pus) {
            List pis = g.getPromptItems();
            for (PromptItem pi : pis) {
                lines.add(this.promptItemToLine(pi));
            }
        }
        return lines;
    }

    public List<List<String>> sectionsToLines(List<Section> sections) {
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        for (Section s : sections) {
            lines.addAll(this.sectionToLines(s));
        }
        return lines;
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
    }

    public static class Column {
        private Integer col;

        public Column(Integer row) {
            this.col = row;
        }

        public String toString() {
            if (this.col == null) {
                return "(no column)";
            }
            return this.col.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Column) {
                Column oRow = (Column)o;
                Integer oR = oRow.getColumn();
                if (oR == null) {
                    if (this.col == null) {
                        return true;
                    }
                } else {
                    return oR.equals(this.col);
                }
            }
            return false;
        }

        public Integer getColumn() {
            return this.col;
        }
    }

    public static class ColumnDescriptor {
        private String name;
        private LocalizableMessage description = null;

        public ColumnDescriptor(String name) {
            this(name, null);
        }

        public ColumnDescriptor(String name, LocalizableMessage description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public LocalizableMessage getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o instanceof ColumnDescriptor) {
                ColumnDescriptor oCD = (ColumnDescriptor)o;
                String oN = oCD.getName();
                return oN.equals(this.name);
            }
            return false;
        }

        public String toString() {
            if (this.description != null) {
                return this.description.toString();
            }
            return this.name;
        }
    }

    public static enum FieldSeparator {
        TAB('\t', "Tabulator"),
        COMMA(',', "',' Comma"),
        SEMICOLON(';', "';' Semicolon"),
        COLON(':', "':' Colon"),
        HYPHEN('-', "'-' Hyphen"),
        BLANK(' ', "' ' Blank");

        private final char value;
        private final String description;

        private FieldSeparator(char value, String description) {
            this.value = value;
            this.description = description;
        }

        public char value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }
}

