/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.script.ItemcodeGeneratorConfiguration;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ItemcodeGeneratorConfigurationUI
extends JPanel {
    private JTextField prefixField;
    private Document prefixDocument;
    private JSpinner fixedDecimalPlacesSpinner;
    private SpinnerNumberModel fixedDecimalPlacesModel;
    private SpinnerNumberModel incrSelModel;
    private JSpinner incrSpinner;
    private JCheckBox activeBox;
    private ItemcodeGeneratorConfiguration itemcodeGeneratorConfiguration;

    public ItemcodeGeneratorConfigurationUI(ItemcodeGeneratorConfiguration itemcodeGeneratorConfiguration) {
        super(new GridBagLayout());
        this.itemcodeGeneratorConfiguration = itemcodeGeneratorConfiguration;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.activeBox = new JCheckBox("Active");
        this.add((Component)this.activeBox, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel prefixLabel = new JLabel("Prefix:");
        this.add((Component)prefixLabel, c);
        ++c.gridx;
        c.weightx = 2.0;
        c.fill = 2;
        this.prefixField = new JTextField();
        EditorKitMenu prefixFieldEkm = new EditorKitMenu((JTextComponent)this.prefixField);
        this.add((Component)this.prefixField, c);
        this.prefixDocument = this.prefixField.getDocument();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        JLabel counterLabel = new JLabel("Counter fixed decimal places:");
        this.add((Component)counterLabel, c);
        ++c.gridx;
        c.fill = 2;
        this.fixedDecimalPlacesModel = new SpinnerNumberModel(ItemcodeGeneratorConfiguration.MIN_FIXED_DECIMAL_PLACES, 0, ItemcodeGeneratorConfiguration.MAX_FIXED_DECIMAL_PLACES, 1);
        this.fixedDecimalPlacesSpinner = new JSpinner(this.fixedDecimalPlacesModel);
        this.add((Component)this.fixedDecimalPlacesSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        JLabel counterIncrLabel = new JLabel("Counter increment:");
        this.add((Component)counterIncrLabel, c);
        ++c.gridx;
        this.incrSelModel = new SpinnerNumberModel(0, 0, 1000, 1);
        this.incrSpinner = new JSpinner(this.incrSelModel);
        this.add((Component)this.incrSpinner, c);
    }

    public ItemcodeGeneratorConfigurationUI() {
        this(new ItemcodeGeneratorConfiguration());
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] chCmps;
        super.setEnabled(enabled);
        Component[] componentArray = chCmps = this.getComponents();
        int n = chCmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component chC = componentArray[n2];
            chC.setEnabled(enabled);
            ++n2;
        }
    }

    public void setItemcodeGeneratorConfiguration(ItemcodeGeneratorConfiguration itemcodeGeneratorConfiguration) {
        this.itemcodeGeneratorConfiguration = itemcodeGeneratorConfiguration;
        this.activeBox.setSelected(itemcodeGeneratorConfiguration.isActive());
        this.prefixField.setText(itemcodeGeneratorConfiguration.getPrefix());
        this.incrSelModel.setValue(itemcodeGeneratorConfiguration.getIncrement());
        Integer decimalPlaces = itemcodeGeneratorConfiguration.getFixedDecimalPlaces();
        this.fixedDecimalPlacesModel.setValue(decimalPlaces);
    }

    public void applyValues() {
        this.applyValues(this.itemcodeGeneratorConfiguration);
    }

    public void applyValues(ItemcodeGeneratorConfiguration itemcodeGeneratorConfiguration) {
        boolean active = this.activeBox.isSelected();
        itemcodeGeneratorConfiguration.setActive(active);
        String prefix = this.prefixField.getText();
        itemcodeGeneratorConfiguration.setPrefix(prefix);
        int incr = (Integer)this.incrSelModel.getValue();
        itemcodeGeneratorConfiguration.setIncrement(incr);
        int deciPlaces = (Integer)this.fixedDecimalPlacesModel.getValue();
        itemcodeGeneratorConfiguration.setFixedDecimalPlaces(deciPlaces);
    }

    public static void main(String[] args) {
        Runnable testUI = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                ItemcodeGeneratorConfigurationUI icgui = new ItemcodeGeneratorConfigurationUI(new ItemcodeGeneratorConfiguration());
                f.getContentPane().add(icgui);
                f.setDefaultCloseOperation(3);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(testUI);
    }
}

