/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.ItemcodeGeneratorConfiguration;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ItemcodeGeneratorUI
extends JPanel
implements DocumentListener,
ChangeListener,
PropertyChangeListener {
    private ItemcodeGenerator itemcodeGenerator;
    private JTextField prefixField;
    private Document prefixDocument;
    private JSpinner fixedDecimalPlacesSpinner;
    private JSpinner currentCounterValueSpinner;
    private JTextField currValueDisplay;
    private SpinnerNumberModel fixedDecimalPlacesModel;
    private SpinnerNumberModel incrSelModel;
    private JSpinner incrSpinner;
    private JCheckBox activeBox;
    private boolean changingValue = false;

    public ItemcodeGeneratorUI(ItemcodeGenerator itemcodeGenerator) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.activeBox = new JCheckBox("Active");
        this.activeBox.addChangeListener(this);
        this.add((Component)this.activeBox, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel prefixLabel = new JLabel("Prefix:");
        this.add((Component)prefixLabel, c);
        ++c.gridx;
        c.weightx = 2.0;
        c.fill = 2;
        this.prefixField = new JTextField();
        this.add((Component)this.prefixField, c);
        this.prefixDocument = this.prefixField.getDocument();
        this.prefixDocument.addDocumentListener(this);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        JLabel counterLabel = new JLabel("Fixed decimal places:");
        this.add((Component)counterLabel, c);
        ++c.gridx;
        c.fill = 2;
        this.fixedDecimalPlacesModel = new SpinnerNumberModel(ItemcodeGeneratorConfiguration.MIN_FIXED_DECIMAL_PLACES, 0, ItemcodeGeneratorConfiguration.MAX_FIXED_DECIMAL_PLACES, 1);
        this.fixedDecimalPlacesSpinner = new JSpinner(this.fixedDecimalPlacesModel);
        this.fixedDecimalPlacesModel.addChangeListener(this);
        this.add((Component)this.fixedDecimalPlacesSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        JLabel counterIncrLabel = new JLabel("Increment:");
        this.add((Component)counterIncrLabel, c);
        ++c.gridx;
        c.fill = 2;
        this.incrSelModel = new SpinnerNumberModel(1, 1, 1000, 1);
        this.incrSpinner = new JSpinner(this.incrSelModel);
        this.incrSelModel.addChangeListener(this);
        this.add((Component)this.incrSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        JSeparator sep = new JSeparator();
        this.add((Component)sep, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        JLabel counterValueLabel = new JLabel("Counter value:");
        this.add((Component)counterValueLabel, c);
        ++c.gridx;
        c.fill = 2;
        SpinnerNumberModel counterModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.currentCounterValueSpinner = new JSpinner(counterModel);
        this.currentCounterValueSpinner.addChangeListener(this);
        this.add((Component)this.currentCounterValueSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        JLabel currValueLabel = new JLabel("Itemcode:");
        this.add((Component)currValueLabel, c);
        ++c.gridx;
        c.fill = 2;
        this.currValueDisplay = new JTextField();
        EditorKitMenu currValueEkm = new EditorKitMenu((JTextComponent)this.currValueDisplay, false);
        this.currValueDisplay.setEditable(false);
        this.add((Component)this.currValueDisplay, c);
        this.setItemcodeGenerator(itemcodeGenerator);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] chCmps;
        super.setEnabled(enabled);
        Component[] componentArray = chCmps = this.getComponents();
        int n = chCmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component chC = componentArray[n2];
            chC.setEnabled(enabled);
            ++n2;
        }
    }

    private void configChanged() {
        if (!this.changingValue) {
            ItemcodeGeneratorConfiguration cfg = this.itemcodeGenerator.getConfig();
            this.activeBox.setSelected(cfg.isActive());
            this.prefixField.setText(cfg.getPrefix());
            this.incrSelModel.setValue(cfg.getIncrement());
            Integer decimalPlaces = cfg.getFixedDecimalPlaces();
            this.fixedDecimalPlacesModel.setValue(decimalPlaces);
            DecimalFormat counterFormat = cfg.counterFormat();
            int value = this.itemcodeGenerator.getCounterValue();
            this.currentCounterValueSpinner.setValue(value);
        }
        this.currValueDisplay.setText(this.itemcodeGenerator.getItemCode());
    }

    public void setItemcodeGenerator(ItemcodeGenerator itemcodeGenerator) {
        ItemcodeGenerator oldIcg = this.itemcodeGenerator;
        if (oldIcg != null) {
            oldIcg.removePropertyChangeListener(this);
        }
        this.itemcodeGenerator = itemcodeGenerator;
        this.configChanged();
        this.itemcodeGenerator.addPropertyChangeListener(this);
    }

    public static void main(String[] args) {
        Runnable testUI = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                ItemcodeGeneratorUI icgui = new ItemcodeGeneratorUI(new ItemcodeGenerator());
                f.getContentPane().add(icgui);
                f.setDefaultCloseOperation(3);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(testUI);
    }

    private void documentUpdate(DocumentEvent de) {
        if (this.changingValue) {
            return;
        }
        Document d = de.getDocument();
        if (d == this.prefixDocument) {
            ItemcodeGeneratorConfiguration cfg = this.itemcodeGenerator.getConfig();
            this.changingValue = true;
            cfg.setPrefix(this.prefixField.getText());
            this.changingValue = false;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentUpdate(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentUpdate(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentUpdate(arg0);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        Object val;
        if (this.changingValue) {
            return;
        }
        Object src = arg0.getSource();
        ItemcodeGeneratorConfiguration cfg = this.itemcodeGenerator.getConfig();
        if (src == this.activeBox) {
            cfg.setActive(this.activeBox.isSelected());
        } else if (src == this.incrSelModel) {
            this.changingValue = true;
            Number in = this.incrSelModel.getNumber();
            cfg.setIncrement(in.intValue());
            this.changingValue = false;
        } else if (src == this.fixedDecimalPlacesSpinner || src == this.fixedDecimalPlacesModel) {
            Number fdpn = this.fixedDecimalPlacesModel.getNumber();
            this.changingValue = true;
            cfg.setFixedDecimalPlaces(fdpn.intValue());
            this.changingValue = false;
        } else if (src == this.currentCounterValueSpinner && (val = this.currentCounterValueSpinner.getValue()) instanceof Number) {
            Number valNum = (Number)val;
            this.changingValue = true;
            this.itemcodeGenerator.setCounterValue(valNum.intValue());
            this.changingValue = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        String propName = arg0.getPropertyName();
        if ("counterValue".equals(propName)) {
            Object valO = arg0.getNewValue();
            if (valO instanceof Number) {
                int val = ((Number)valO).intValue();
                this.currentCounterValueSpinner.setValue(val);
            }
        } else if (propName.startsWith("config")) {
            this.configChanged();
        }
        this.currValueDisplay.setText(this.itemcodeGenerator.getItemCode());
    }
}

