/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.script.ui.AddMediaitemAction;
import ipsk.apps.speechrecorder.script.ui.BaseMediaitemUI;
import ipsk.apps.speechrecorder.script.ui.MediaitemUI;
import ipsk.apps.speechrecorder.script.ui.RemoveMediaitemAction;
import ipsk.awt.font.AutoFontFamilyManager;
import ipsk.beans.MultiSelectPropertyState;
import ipsk.db.speech.AnnotationTemplate;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.Presenter;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Reccomment;
import ipsk.db.speech.Recinstructions;
import ipsk.db.speech.Recording;
import ipsk.lang.CollectionUtils;
import ipsk.swing.JServiceSelector;
import ipsk.swing.RedoAction;
import ipsk.swing.TitledPanel;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import ipsk.swing.text.EditorKitMenu;
import ipsk.swing.text.JLocaleSelector;
import ipsk.text.ParserException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class PromptItemUI
extends BaseMediaitemUI
implements ActionListener,
EditActionsListener,
PropertyChangeListener,
DocumentListener,
StateEditable,
CaretListener {
    private static final long serialVersionUID = 1L;
    private PromptItem promptItem;
    private JTextField recordingCodeWidget;
    private boolean forceRenameofItemcodeInUse = false;
    private EditorKitMenu recordingCodeWidgetEditorKitMenu;
    private JCheckBox blockedWidget;
    private JCheckBox preRecDelayNonDefaultWidget;
    private JTextField preRecDelayWidget;
    private JCheckBox recDurationLimitedWidget;
    private JTextField recDurationWidget;
    private JCheckBox postRecDelayNonDefaultWidget;
    private JTextField postRecDelayWidget;
    private JCheckBox finalSilenceWidget;
    private JCheckBox beepPlayWidget;
    private JComboBox<String> recTypeWidget;
    private List<MediaitemUI> mediaItemUIs;
    private String[] instructionsFontFamilies;
    private String[] descriptionFontFamilies;
    private AutoFontFamilyManager instructionsFontManager = new AutoFontFamilyManager();
    private AutoFontFamilyManager descriptionFontManager = new AutoFontFamilyManager();
    private JTextField promptInstructionsWidget;
    private EditorKitMenu promptInstructionsWidgetEditorKitMenu;
    private JTextField promptCommentWidget;
    private EditorKitMenu promptCommentWidgetEditorKitMenu;
    private JTextArea annotationTemplateWidget;
    private EditorKitMenu annotationTemplateWidgetEditorKitMenu;
    protected JLocaleSelector annotationTemplateLocaleSelector;
    private JLabel codeLabel;
    private TitledPanel instructionsPanel;
    private TitledPanel commentPanel;
    private boolean isRecording;
    private JLabel preRecLabel;
    private JLabel preRecUnitLabel;
    private JLabel recDurationLabel;
    private JLabel recDurationUnitLabel;
    private JLabel postRecLabel;
    private JLabel postRecUnitLabel;
    private int defaultPreRecording;
    private int defaultPostRecording;
    private EditActionsListener editActionsListener;
    private JServiceSelector<PromptPresenter> promptPresenterSelector;
    private JTabbedPane itemPanel;
    private List<Action> actions = new ArrayList<Action>();
    private int maxMediaitemCombinations;
    private int mediaItemCount = 1;
    private AddMediaitemAction addMediaitemAction;
    private RemoveMediaitemAction removeMediaitemAction;
    private UndoManager undoManager = new UndoManager();
    private UndoAction undoAction;
    private RedoAction redoAction;
    private EditActions editActions;
    private List<PromptItem> promptItems;
    private boolean preRecEnabled;
    private boolean durationEnabled;
    private boolean instructionsEnabled;
    private boolean commentEnabled;
    private boolean postRecEnabled;
    private boolean blockedPropEnabled;
    private boolean beepPropEnabled;
    private boolean finalSilenceEnabled;
    private boolean presenterEnabled;
    private boolean resettingFormValue = false;
    private Set<String> itemCodesInUse = null;
    private JPanel presentationPanel;
    private JPanel annotationTemplatePanel;

    public String[] getInstructionsFontFamilies() {
        return this.instructionsFontFamilies;
    }

    public String[] getDescriptionFontFamilies() {
        return this.descriptionFontFamilies;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Set<String> getItemCodesInUse() {
        return this.itemCodesInUse;
    }

    public void setItemCodesInUse(Set<String> itemCodesInUse) {
        this.itemCodesInUse = itemCodesInUse;
    }

    @Override
    public EditActionsListener getEditActionListener() {
        return this.editActionsListener;
    }

    @Override
    public void setEditActionListener(EditActionsListener editActionsListener) {
        this.editActionsListener = editActionsListener;
    }

    public PromptItemUI(URL projectContext, List<PromptPresenterServiceDescriptor> availablePromptPresenters) {
        super(projectContext, availablePromptPresenters);
        final PromptItemUI al = this;
        this.addMediaitemAction = new AddMediaitemAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.actions.add(this.addMediaitemAction);
        this.removeMediaitemAction = new RemoveMediaitemAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.actions.add(this.removeMediaitemAction);
        this.maxMediaitemCombinations = 1;
        for (PromptPresenterServiceDescriptor ppsd : availablePromptPresenters) {
            String[][] mtcs;
            String[][] stringArray = mtcs = ppsd.getSupportedMIMETypes();
            int n = mtcs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] mtc = stringArray[n2];
                int mtcLen = mtc.length;
                if (mtcLen > this.maxMediaitemCombinations) {
                    this.maxMediaitemCombinations = mtcLen;
                }
                ++n2;
            }
        }
        this.addMediaitemAction.setEnabled(this.maxMediaitemCombinations > 1);
        this.removeMediaitemAction.setEnabled(false);
        this.undoAction = new UndoAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.redoAction = new RedoAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.editActions = new EditActions("Prompt item UI", null, null, null, this.undoAction, this.redoAction);
        this.mediaItemUIs = new ArrayList<MediaitemUI>();
        this.isRecording = this.promptItem instanceof Recording;
        this.projectContext = projectContext;
        this.promptItem = this.promptItem;
        this.createWidgets();
        JTabbedPane itemPanel = this.makeItemPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)itemPanel, "Center");
    }

    @Override
    protected void createWidgets() {
        this.recordingCodeWidget = new JTextField(10);
        this.recordingCodeWidget.setToolTipText("Identification code for the recording. This code must be unique within the recording script.");
        this.recordingCodeWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.recordingCodeWidget, (EditActionsListener)this);
        this.recordingCodeWidget.addActionListener(this);
        this.blockedWidget = new JCheckBox("Blocked by prompt");
        this.blockedWidget.setToolTipText("Select if recording should start after prompt has finished.");
        this.blockedWidget.setSelected(false);
        this.preRecDelayNonDefaultWidget = new JCheckBox("Not default");
        this.preRecDelayNonDefaultWidget.setToolTipText("Select to apply a value different from project default");
        this.preRecDelayNonDefaultWidget.addActionListener(this);
        this.preRecDelayWidget = new JTextField(6);
        this.preRecDelayWidget.setToolTipText("Duration of pre-recording phase in milliseconds.");
        this.recDurationLimitedWidget = new JCheckBox("Limit");
        this.recDurationLimitedWidget.setToolTipText("Select to limit recording duration");
        this.recDurationLimitedWidget.addActionListener(this);
        this.recDurationWidget = new JTextField(6);
        this.recDurationWidget.setToolTipText("Recording duration in milliseconds.");
        this.postRecDelayNonDefaultWidget = new JCheckBox("Not default");
        this.postRecDelayNonDefaultWidget.setToolTipText("Select to apply a value different from project default");
        this.postRecDelayNonDefaultWidget.addActionListener(this);
        this.postRecDelayWidget = new JTextField(6);
        this.postRecDelayWidget.setToolTipText("Duration of post-recording phase in milliseconds.");
        this.finalSilenceWidget = new JCheckBox("Silence detection");
        this.finalSilenceWidget.setToolTipText("Select the checkbox if the recording will by terminated by silence detection");
        this.finalSilenceWidget.setSelected(false);
        this.beepPlayWidget = new JCheckBox("Beep");
        this.beepPlayWidget.setToolTipText("Select the checkbox if a beep should be played before recording.");
        this.beepPlayWidget.setSelected(false);
        this.recTypeWidget = new JComboBox<String>(REC_TYPES);
        this.recTypeWidget.setSelectedIndex(0);
        this.promptInstructionsWidget = new JTextField(10);
        this.promptInstructionsWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.promptInstructionsWidget, (EditActionsListener)this);
        this.promptCommentWidget = new JTextField(10);
        this.promptCommentWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.promptCommentWidget, (EditActionsListener)this);
        super.createWidgets();
    }

    private MediaitemUI extraMediaItemUi(int idx) {
        int s;
        int i = s = this.mediaItemUIs.size();
        while (i <= idx) {
            MediaitemUI miUI = new MediaitemUI(this.projectContext, this.availablePromptPresenters);
            miUI.setActionListener(this);
            this.mediaItemUIs.add(miUI);
            ++i;
        }
        return this.mediaItemUIs.get(idx);
    }

    private void disableAllProperties() {
        this.instructionsEnabled = false;
        this.commentEnabled = false;
        this.preRecEnabled = false;
        this.durationEnabled = false;
        this.postRecEnabled = false;
        this.beepPropEnabled = false;
        this.blockedPropEnabled = false;
        this.finalSilenceEnabled = false;
        this.presenterEnabled = false;
    }

    public void setPromptItem(PromptItem pi) {
        if (this.promptItem != null) {
            this.promptItem.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.mediaItemCount = 1;
        for (MediaitemUI mui : this.mediaItemUIs) {
            if (mui == null) continue;
            this.itemPanel.remove(mui);
        }
        Mediaitem mi = null;
        if (pi != null) {
            mi = (Mediaitem)pi.getMediaitems().get(0);
        }
        this.setMediaitem(mi);
        this.promptItem = pi;
        this.isRecording = this.promptItem instanceof Recording;
        this.setEnabled(this.promptItem != null);
        try {
            this.initializeWidgets(this.promptItem);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        this.disableAllProperties();
        if (this.promptItem != null) {
            this.instructionsEnabled = true;
            this.commentEnabled = true;
            this.preRecEnabled = this.isRecording;
            this.durationEnabled = true;
            this.postRecEnabled = this.isRecording;
            this.beepPropEnabled = this.isRecording;
            this.blockedPropEnabled = this.isRecording;
            this.finalSilenceEnabled = this.isRecording;
            this.presenterEnabled = true;
            this.promptItem.addPropertyChangeListener((PropertyChangeListener)this);
            List miList = this.promptItem.getMediaitems();
            this.mediaItemCount = miList.size();
            int i = 1;
            while (i < this.mediaItemCount) {
                mi = (Mediaitem)miList.get(i);
                MediaitemUI miUI = this.extraMediaItemUi(i - 1);
                miUI.setMediaitem(mi);
                this.itemPanel.addTab("Media " + (i + 1), miUI);
                ++i;
            }
        }
        this.setDependencies();
    }

    private void initializeWidgets(PromptItem promptItem) throws ParserException {
        this.recordingCodeWidget.removeCaretListener(this);
        this.promptInstructionsWidget.getDocument().removeDocumentListener(this);
        this.promptCommentWidget.getDocument().removeDocumentListener(this);
        String prPrClNm = null;
        Mediaitem mi = null;
        if (promptItem != null) {
            Recording recording = null;
            this.isRecording = promptItem instanceof Recording;
            if (this.isRecording) {
                boolean postRecDelayNonDefault;
                boolean recDurationLimited;
                boolean preRecDelayNonDefault;
                recording = (Recording)promptItem;
                this.recordingCodeWidget.setText(recording.getItemcode());
                this.blockedWidget.setSelected(recording.getNNBlocked());
                Integer preRecDelay = recording.getPrerecdelay();
                boolean bl = preRecDelayNonDefault = preRecDelay != null;
                if (preRecDelayNonDefault) {
                    this.preRecDelayWidget.setText(String.valueOf(preRecDelay));
                }
                this.preRecDelayNonDefaultWidget.setSelected(preRecDelayNonDefault);
                Integer recDuration = recording.getRecduration();
                boolean bl2 = recDurationLimited = recDuration != null;
                if (recDurationLimited) {
                    this.recDurationWidget.setText(String.valueOf(recDuration));
                }
                this.recDurationLimitedWidget.setSelected(recDurationLimited);
                Integer postRecDelay = recording.getPostrecdelay();
                boolean bl3 = postRecDelayNonDefault = postRecDelay != null;
                if (postRecDelayNonDefault) {
                    this.postRecDelayWidget.setText(String.valueOf(postRecDelay));
                }
                this.postRecDelayNonDefaultWidget.setSelected(postRecDelayNonDefault);
                Integer fs = recording.getFinalsilence();
                boolean fsSel = fs != null && fs != 0;
                this.finalSilenceWidget.setSelected(fsSel);
                this.beepPlayWidget.setSelected(Boolean.parseBoolean(recording.getBeep()));
                String recType = recording.getRectype();
                if (recType == null) {
                    recType = "audio/wav";
                }
                this.recTypeWidget.setSelectedItem(recType);
                Recinstructions ri = recording.getRecinstructions();
                String recInstruction = "";
                if (ri != null) {
                    recInstruction = ri.getRecinstructions();
                }
                this.promptInstructionsWidget.setText(recInstruction);
                Reccomment rc = recording.getReccomment();
                String comment = "";
                if (rc != null) {
                    comment = rc.getReccomment();
                }
                this.promptCommentWidget.setText(comment);
                AnnotationTemplate atObj = recording.getAnnotationTemplate();
                if (atObj != null && atObj.getAnnotationtemplate() != null) {
                    this.annotationTemplateWidget.setText(atObj.getAnnotationtemplate());
                    String langCode = atObj.getLanguageISO639code();
                    String countrCode = atObj.getCountryISO3166code();
                    Locale atLocale = null;
                    if (langCode != null) {
                        atLocale = countrCode == null ? new Locale(langCode) : new Locale(langCode, countrCode);
                    }
                    this.annotationTemplateLocaleSelector.setSelectedLocale(atLocale);
                } else {
                    this.annotationTemplateWidget.setText("");
                    this.annotationTemplateLocaleSelector.setSelectedLocale(null);
                }
            } else {
                boolean durationLimited;
                Integer duration = ((Nonrecording)promptItem).getDuration();
                boolean bl = durationLimited = duration != null;
                if (durationLimited) {
                    this.recDurationWidget.setText(String.valueOf(duration));
                }
                this.recDurationLimitedWidget.setSelected(durationLimited);
            }
            Presenter pr = promptItem.getPresenter();
            if (pr != null) {
                prPrClNm = pr.getClassname();
            }
            mi = (Mediaitem)promptItem.getMediaitems().get(0);
        } else {
            this.recordingCodeWidget.setText("");
            this.promptInstructionsWidget.setText("");
            this.promptCommentWidget.setText("");
        }
        this.promptPresenterSelector.setSelectedClassname(prPrClNm);
        this.recordingCodeWidgetEditorKitMenu.discardAllEdits();
        this.promptInstructionsWidgetEditorKitMenu.discardAllEdits();
        this.promptCommentWidgetEditorKitMenu.discardAllEdits();
        this.instructionsFontManager.applyFontCanDisplay((JTextComponent)this.promptInstructionsWidget);
        this.descriptionFontManager.applyFontCanDisplay((JTextComponent)this.promptCommentWidget);
        this.recordingCodeWidget.addCaretListener(this);
        this.promptInstructionsWidget.getDocument().addDocumentListener(this);
        this.promptCommentWidget.getDocument().addDocumentListener(this);
        super.initializeWidgets(mi);
    }

    @Override
    protected void setDependencies() {
        this.adjusting = true;
        boolean enabled = this.isEnabled();
        this.addMediaitemAction.setEnabled(enabled && this.mediaItemCount < this.maxMediaitemCombinations);
        this.removeMediaitemAction.setEnabled(enabled && this.mediaItemCount > 1);
        this.codeLabel.setEnabled(enabled && this.isRecording && this.mediaitem != null);
        this.recordingCodeWidget.setEnabled(enabled && this.isRecording && this.mediaitem != null);
        boolean recDurationLimited = this.recDurationLimitedWidget.isSelected();
        this.recDurationWidget.setEnabled(enabled && recDurationLimited && this.durationEnabled);
        this.recDurationLabel.setEnabled(enabled && this.durationEnabled);
        this.recDurationUnitLabel.setEnabled(enabled && this.durationEnabled);
        this.preRecLabel.setEnabled(enabled && this.preRecEnabled);
        this.preRecUnitLabel.setEnabled(enabled && this.preRecEnabled);
        this.postRecLabel.setEnabled(enabled && this.postRecEnabled);
        this.postRecUnitLabel.setEnabled(enabled && this.postRecEnabled);
        this.recDurationLimitedWidget.setEnabled(enabled && this.durationEnabled);
        boolean preRecNonDefault = this.preRecDelayNonDefaultWidget.isSelected();
        this.preRecDelayNonDefaultWidget.setEnabled(enabled && this.preRecEnabled);
        if (!preRecNonDefault) {
            this.preRecDelayWidget.setText(Integer.toString(this.defaultPreRecording));
        }
        this.preRecDelayWidget.setEnabled(enabled && this.preRecEnabled && preRecNonDefault);
        boolean postRecNonDefault = this.postRecDelayNonDefaultWidget.isSelected();
        if (!postRecNonDefault) {
            this.postRecDelayWidget.setText(Integer.toString(this.defaultPostRecording));
        }
        this.postRecDelayNonDefaultWidget.setEnabled(enabled && this.postRecEnabled);
        this.postRecDelayWidget.setEnabled(enabled && this.postRecEnabled && postRecNonDefault);
        this.instructionsPanel.setEnabled(enabled && this.instructionsEnabled);
        this.promptInstructionsWidget.setEnabled(enabled && this.instructionsEnabled);
        this.commentPanel.setEnabled(enabled && this.commentEnabled);
        this.promptCommentWidget.setEnabled(enabled && this.commentEnabled);
        this.beepPlayWidget.setEnabled(enabled && this.beepPropEnabled);
        this.blockedWidget.setEnabled(enabled && this.blockedPropEnabled);
        this.finalSilenceWidget.setEnabled(enabled && this.finalSilenceEnabled);
        this.itemPanel.setEnabled(enabled);
        ArrayList<String> mimeTypeList = new ArrayList<String>();
        List<String> selectableMimes = this.selectableMIMETypesDisplayList(this.availablePromptPresenters, mimeTypeList, this.mediaItemCount);
        this.setSelectableMIMETypes(selectableMimes);
        String mimeType = (String)this.mimeTypeWidget.getSelectedItem();
        if (mimeType == null) {
            mimeType = "text/plain";
        }
        mimeTypeList.add(mimeType);
        int i = 1;
        while (i < this.mediaItemCount) {
            MediaitemUI mui = this.mediaItemUIs.get(i - 1);
            List<String> selMimeCombis = this.selectableMIMETypesDisplayList(this.availablePromptPresenters, mimeTypeList, this.mediaItemCount);
            mui.setSelectableMIMETypes(selMimeCombis);
            String extraMime = mui.selectedMimeType();
            if (extraMime == null) {
                extraMime = "text/plain";
            }
            mimeTypeList.add(extraMime);
            ++i;
        }
        List<String> selMimesForAddMediaItem = this.selectableMIMETypesDisplayList(this.availablePromptPresenters, mimeTypeList, this.mediaItemCount + 1);
        this.addMediaitemAction.setEnabled(selMimesForAddMediaItem.size() > 0);
        if (this.presenterEnabled) {
            List<PromptPresenterServiceDescriptor> currentAvailPrPr = this.availablePromptPresenters(mimeTypeList);
            this.promptPresenterSelector.setServiceDescriptorList(currentAvailPrPr);
        } else {
            this.promptPresenterSelector.setServiceDescriptorList(null);
        }
        this.promptPresenterSelector.setEnabled(this.presenterEnabled);
        this.presentationPanel.setEnabled(this.presenterEnabled);
        this.adjusting = false;
        super.setDependencies();
        this.undoAction.update(this.undoManager);
        this.redoAction.update(this.undoManager);
    }

    private JTabbedPane makeItemPanel() {
        this.itemPanel = new JTabbedPane();
        this.itemPanel.addTab("Prompt", this.makeMediaSourcePanel());
        this.itemPanel.addTab("Control", this.makeControlPanel());
        JPanel presentationPanel = this.makePresentationPanel();
        this.itemPanel.addTab("Presentation", presentationPanel);
        JPanel annotationTemplatePanel = this.makeAnnotationTemplatePanel();
        this.itemPanel.addTab("Annot. template", annotationTemplatePanel);
        this.itemPanel.setSelectedIndex(0);
        return this.itemPanel;
    }

    private JPanel makeControlPanel() {
        JPanel controlPanel = new JPanel();
        GridBagLayout tpL = new GridBagLayout();
        controlPanel.setLayout(tpL);
        GridBagConstraints tpC = new GridBagConstraints();
        this.preRecLabel = new JLabel("Prerecording", 4);
        this.preRecUnitLabel = new JLabel("ms");
        this.recDurationLabel = new JLabel("Recording", 4);
        this.recDurationUnitLabel = new JLabel("ms");
        this.postRecLabel = new JLabel("Postrecording", 4);
        this.postRecUnitLabel = new JLabel("ms");
        tpC.fill = 2;
        tpC.insets = new Insets(0, 5, 5, 5);
        tpC.gridx = 0;
        tpC.gridy = 0;
        tpC.anchor = 12;
        tpL.setConstraints(this.preRecLabel, tpC);
        ++tpC.gridx;
        tpC.anchor = 18;
        tpL.setConstraints(this.preRecDelayNonDefaultWidget, tpC);
        ++tpC.gridx;
        tpC.anchor = 17;
        tpL.setConstraints(this.preRecDelayWidget, tpC);
        ++tpC.gridx;
        tpL.setConstraints(this.preRecUnitLabel, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.anchor = 13;
        tpL.setConstraints(this.recDurationLabel, tpC);
        ++tpC.gridx;
        tpC.anchor = 17;
        tpL.setConstraints(this.recDurationLimitedWidget, tpC);
        ++tpC.gridx;
        tpC.anchor = 17;
        tpL.setConstraints(this.recDurationWidget, tpC);
        ++tpC.gridx;
        tpL.setConstraints(this.recDurationUnitLabel, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.anchor = 13;
        tpL.setConstraints(this.postRecLabel, tpC);
        ++tpC.gridx;
        tpC.anchor = 17;
        tpL.setConstraints(this.postRecDelayNonDefaultWidget, tpC);
        ++tpC.gridx;
        tpC.anchor = 17;
        tpL.setConstraints(this.postRecDelayWidget, tpC);
        ++tpC.gridx;
        tpL.setConstraints(this.postRecUnitLabel, tpC);
        controlPanel.add(this.preRecLabel);
        controlPanel.add(this.preRecDelayNonDefaultWidget);
        controlPanel.add(this.preRecDelayWidget);
        controlPanel.add(this.preRecUnitLabel);
        controlPanel.add(this.recDurationLabel);
        controlPanel.add(this.recDurationLimitedWidget);
        controlPanel.add(this.recDurationWidget);
        controlPanel.add(this.recDurationUnitLabel);
        controlPanel.add(this.postRecLabel);
        controlPanel.add(this.postRecDelayNonDefaultWidget);
        controlPanel.add(this.postRecDelayWidget);
        controlPanel.add(this.postRecUnitLabel);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 3;
        tpC.weightx = 0.0;
        tpC.fill = 0;
        tpC.anchor = 17;
        tpL.setConstraints(this.blockedWidget, tpC);
        ++tpC.gridy;
        tpC.anchor = 17;
        tpL.setConstraints(this.beepPlayWidget, tpC);
        ++tpC.gridy;
        tpC.anchor = 17;
        tpL.setConstraints(this.finalSilenceWidget, tpC);
        controlPanel.add(this.blockedWidget);
        controlPanel.add(this.beepPlayWidget);
        this.volumeLabel = new JLabel("Volume %", 4);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 1;
        tpL.setConstraints(this.volumeLabel, tpC);
        ++tpC.gridx;
        tpC.gridwidth = 3;
        tpC.anchor = 17;
        tpL.setConstraints(this.mediaVolumeWidget, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 1;
        tpC.anchor = 17;
        tpL.setConstraints(this.autoPlayNonDefaultWidget, tpC);
        ++tpC.gridx;
        tpC.gridwidth = 1;
        tpC.anchor = 17;
        tpL.setConstraints(this.autoPlayWidget, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 3;
        tpC.anchor = 17;
        tpL.setConstraints(this.modalPlayWidget, tpC);
        controlPanel.add(this.volumeLabel);
        controlPanel.add(this.mediaVolumeWidget);
        controlPanel.add(this.autoPlayNonDefaultWidget);
        controlPanel.add(this.autoPlayWidget);
        controlPanel.add(this.modalPlayWidget);
        controlPanel.add(this.finalSilenceWidget);
        return controlPanel;
    }

    private JPanel makeMediaSourcePanel() {
        JPanel mediaSourcePanel = new JPanel();
        GridBagLayout mspL = new GridBagLayout();
        GridBagConstraints mspC = new GridBagConstraints();
        mediaSourcePanel.setLayout(mspL);
        mspC.anchor = 17;
        this.codeLabel = new JLabel("Code", 4);
        this.srcTypeLabel = new JLabel("Location", 4);
        this.mimeTypeLabel = new JLabel("MIME-Type", 4);
        this.importButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        mediaSourcePanel.add(this.codeLabel);
        mediaSourcePanel.add(this.recordingCodeWidget);
        mediaSourcePanel.add(this.srcTypeLabel);
        mediaSourcePanel.add(this.external);
        mediaSourcePanel.add(this.promptSourceWidget);
        mediaSourcePanel.add(this.importButton);
        mediaSourcePanel.add(this.selectButton);
        mspC.insets = new Insets(0, 5, 5, 5);
        mspC.gridx = 0;
        mspC.gridy = 0;
        mspC.anchor = 13;
        mspL.setConstraints(this.codeLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 2;
        mspC.anchor = 17;
        mspC.weightx = 2.0;
        mspC.fill = 2;
        mspL.setConstraints(this.recordingCodeWidget, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.fill = 0;
        mspC.anchor = 13;
        mspL.setConstraints(this.mimeTypeLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 3;
        mspC.anchor = 17;
        mspL.setConstraints(this.mimeTypeWidget, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.charsetLabel, mspC);
        ++mspC.gridx;
        mspC.anchor = 17;
        mspC.gridwidth = 3;
        mspL.setConstraints(this.charsetWidget, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.srcTypeLabel, mspC);
        ++mspC.gridx;
        mspC.anchor = 17;
        mspC.gridwidth = 2;
        mspL.setConstraints(this.external, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.sourceLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 2.0;
        mspC.anchor = 17;
        mspC.fill = 2;
        mspL.setConstraints(this.promptSourceWidget, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.anchor = 17;
        mspC.fill = 0;
        mspL.setConstraints(this.importButton, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.anchor = 17;
        mspC.fill = 0;
        mspL.setConstraints(this.selectButton, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.weightx = 0.0;
        mspC.anchor = 13;
        mspL.setConstraints(this.altTextLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 3;
        mspC.anchor = 17;
        mspC.weightx = 2.0;
        mspC.fill = 2;
        mspL.setConstraints(this.altTextWidget, mspC);
        mediaSourcePanel.add(this.mimeTypeLabel);
        mediaSourcePanel.add(this.mimeTypeWidget);
        mediaSourcePanel.add(this.charsetLabel);
        mediaSourcePanel.add(this.charsetWidget);
        mediaSourcePanel.add(this.sourceLabel);
        mediaSourcePanel.add(this.altTextLabel);
        mediaSourcePanel.add(this.altTextWidget);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 4;
        mspC.anchor = 17;
        mspC.weightx = 2.0;
        mspC.fill = 2;
        this.instructionsPanel = new TitledPanel(BorderFactory.createEtchedBorder(), "Instructions");
        this.instructionsPanel.setLayout((LayoutManager)new BorderLayout());
        this.instructionsPanel.add((Component)this.promptInstructionsWidget, (Object)"Center");
        mspL.setConstraints((Component)this.instructionsPanel, mspC);
        mediaSourcePanel.add((Component)this.instructionsPanel);
        this.promptTextContentsPanel = new TitledPanel(BorderFactory.createEtchedBorder(), "Prompt");
        this.promptTextContentsPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints ptGbc = new GridBagConstraints();
        ptGbc.gridx = 0;
        ptGbc.gridy = 0;
        JPanel stylePanel = new JPanel(new GridBagLayout());
        stylePanel.add(this.formattedCheckbox);
        stylePanel.add(this.boldButton);
        stylePanel.add(this.italicButton);
        stylePanel.add(this.lineThroughButton);
        stylePanel.add(this.underlineButton);
        stylePanel.add(this.colorButton);
        stylePanel.add(this.defaultStyleButton);
        stylePanel.add(this.defaultFontSizeCheckbox);
        stylePanel.add(this.relativeSizeSpinner);
        stylePanel.add(this.sizeUnit);
        this.promptTextContentsPanel.add((Component)stylePanel, (Object)ptGbc);
        ptGbc.gridx = 0;
        ++ptGbc.gridy;
        ptGbc.gridwidth = 2;
        ptGbc.fill = 1;
        ptGbc.weightx = 2.0;
        ptGbc.weighty = 2.0;
        JScrollPane scrollPane = new JScrollPane(this.promptTextWidget, 20, 31);
        this.promptTextContentsPanel.add((Component)scrollPane, (Object)ptGbc);
        ++ptGbc.gridy;
        ptGbc.fill = 0;
        ptGbc.anchor = 17;
        ptGbc.gridwidth = 2;
        ptGbc.weightx = 0.0;
        ptGbc.weighty = 0.0;
        this.promptTextContentsPanel.add((Component)this.promptAsAnnotationTemplateWidget, (Object)ptGbc);
        ++ptGbc.gridy;
        this.promptTextContentsPanel.add((Component)this.localeSelector, (Object)ptGbc);
        ++mspC.gridy;
        mspC.weighty = 2.0;
        mspC.fill = 1;
        mspL.setConstraints((Component)this.promptTextContentsPanel, mspC);
        mediaSourcePanel.add((Component)this.promptTextContentsPanel);
        this.commentPanel = new TitledPanel(BorderFactory.createEtchedBorder(), "Comment");
        this.commentPanel.setLayout((LayoutManager)new BorderLayout());
        this.commentPanel.add((Component)this.promptCommentWidget, (Object)"Center");
        ++mspC.gridy;
        mspC.weighty = 0.0;
        mspC.fill = 2;
        mediaSourcePanel.add((Component)this.commentPanel, mspC);
        return mediaSourcePanel;
    }

    private JPanel makePresentationPanel() {
        this.presentationPanel = new JPanel(new BorderLayout());
        this.promptPresenterSelector = new JServiceSelector();
        this.promptPresenterSelector.setServiceDescriptorList(this.availablePromptPresenters);
        GridBagConstraints mspC = new GridBagConstraints();
        mspC.anchor = 17;
        mspC.insets = new Insets(5, 5, 5, 5);
        mspC.gridx = 0;
        mspC.gridy = 0;
        mspC.weightx = 2.0;
        mspC.weighty = 2.0;
        mspC.fill = 1;
        mspC.anchor = 13;
        this.presentationPanel.add((Component)this.promptPresenterSelector, "Center");
        return this.presentationPanel;
    }

    private JPanel makeAnnotationTemplatePanel() {
        this.annotationTemplatePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        this.annotationTemplatePanel.add((Component)new JLabel("Template text:"), c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 2.0;
        c.weighty = 2.0;
        this.annotationTemplateWidget = new JTextArea();
        this.annotationTemplateWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.annotationTemplateWidget);
        this.annotationTemplatePanel.add((Component)this.annotationTemplateWidget, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.annotationTemplatePanel.add((Component)new JLabel("Language:"), c);
        this.annotationTemplateLocaleSelector = new JLocaleSelector();
        ++c.gridx;
        this.annotationTemplatePanel.add((Component)this.annotationTemplateLocaleSelector, c);
        return this.annotationTemplatePanel;
    }

    private void applyBeep(Recording recording) {
        String beepStr = null;
        boolean beepSel = this.beepPlayWidget.isSelected();
        if (beepSel) {
            beepStr = Boolean.toString(beepSel);
        }
        recording.setBeep(beepStr);
    }

    private void applyPreDelay(Recording recording) {
        if (this.preRecDelayNonDefaultWidget.isSelected()) {
            String preRecDelayStr = this.preRecDelayWidget.getText();
            int preRecDelay = this.defaultPreRecording;
            try {
                preRecDelay = Integer.parseInt(preRecDelayStr);
            }
            catch (NumberFormatException nfe) {
                this.preRecDelayWidget.setText(Integer.toString(this.defaultPreRecording));
            }
            recording.setPrerecdelay(Integer.valueOf(preRecDelay));
        } else {
            recording.setPrerecdelay(null);
        }
    }

    private void applyRecDuration(Recording recording) {
        if (this.recDurationLimitedWidget.isSelected()) {
            String recDurationStr = this.recDurationWidget.getText();
            try {
                int recDuration = Integer.parseInt(recDurationStr);
                recording.setRecduration(Integer.valueOf(recDuration));
            }
            catch (NumberFormatException nfe) {
                this.recDurationWidget.setText("");
                recording.setRecduration(null);
            }
        } else {
            recording.setRecduration(null);
        }
    }

    private void applyDuration(Nonrecording nonrecording) {
        if (this.recDurationLimitedWidget.isSelected()) {
            String durationStr = this.recDurationWidget.getText();
            try {
                int duration = Integer.parseInt(durationStr);
                nonrecording.setDuration(Integer.valueOf(duration));
            }
            catch (NumberFormatException nfe) {
                this.recDurationWidget.setText("");
                nonrecording.setDuration(null);
            }
        } else {
            nonrecording.setDuration(null);
        }
    }

    private void applyPostDelay(Recording recording) {
        if (this.postRecDelayNonDefaultWidget.isSelected()) {
            String postRecDelayStr = this.postRecDelayWidget.getText();
            int postRecDelay = this.defaultPostRecording;
            try {
                postRecDelay = Integer.parseInt(postRecDelayStr);
            }
            catch (NumberFormatException nfe) {
                this.postRecDelayWidget.setText(Integer.toString(this.defaultPostRecording));
            }
            recording.setPostrecdelay(Integer.valueOf(postRecDelay));
        } else {
            recording.setPostrecdelay(null);
        }
    }

    private void applyFinalSilence(Recording recording) {
        Integer fs = null;
        if (this.finalSilenceWidget.isSelected()) {
            fs = new Integer(4000);
        }
        recording.setFinalsilence(fs);
    }

    private void applyInstructions(Recording recording) {
        String recInstrStr = this.promptInstructionsWidget.getText();
        Recinstructions ri = null;
        if (!recInstrStr.equals("")) {
            ri = recording.getRecinstructions();
            if (ri == null) {
                ri = new Recinstructions();
            }
            ri.setRecinstructions(recInstrStr);
        }
        recording.setRecinstructions(ri);
    }

    private void applyComment(Recording recording) {
        Reccomment rc = null;
        String recCommentStr = this.promptCommentWidget.getText();
        if (!recCommentStr.equals("")) {
            rc = new Reccomment();
            rc.setReccomment(recCommentStr);
        }
        recording.setReccomment(rc);
    }

    private void applyPresenter(PromptItem promptItem) {
        String selPrPrClNm = this.promptPresenterSelector.getSelectedClassname();
        Presenter pr = null;
        if (selPrPrClNm != null) {
            pr = new Presenter();
            pr.setClassname(selPrPrClNm);
        }
        promptItem.setPresenter(pr);
    }

    @Override
    protected void applyValues() {
        if (this.promptItem != null) {
            if (this.promptItem instanceof Recording) {
                Recording recording = (Recording)this.promptItem;
                this.applyBeep(recording);
                recording.setNNBlocked(this.blockedWidget.isSelected());
                this.applyPreDelay(recording);
                this.applyPostDelay(recording);
                this.applyInstructions(recording);
                this.applyComment(recording);
                recording.setItemcode(this.recordingCodeWidget.getText());
                this.applyRecDuration(recording);
                this.applyFinalSilence(recording);
                recording.setRectype((String)this.recTypeWidget.getSelectedItem());
                String annotTemplate = this.annotationTemplateWidget.getText();
                Locale annoTemplLocale = this.annotationTemplateLocaleSelector.getSelectedLocale();
                if (!annotTemplate.isEmpty() || annoTemplLocale != null) {
                    AnnotationTemplate annoTemplObj = new AnnotationTemplate();
                    annoTemplObj.setAnnotationtemplate(annotTemplate);
                    recording.setAnnotationTemplate(annoTemplObj);
                    if (annoTemplLocale == null) {
                        annoTemplObj.setLanguageISO639code(null);
                        annoTemplObj.setCountryISO3166code(null);
                    } else {
                        annoTemplObj.setLanguageISO639code(annoTemplLocale.getLanguage());
                        String atCountry = annoTemplLocale.getCountry();
                        if (atCountry != null && !"".equals(atCountry)) {
                            annoTemplObj.setCountryISO3166code(atCountry);
                        } else {
                            annoTemplObj.setCountryISO3166code(null);
                        }
                    }
                }
            } else if (this.promptItem instanceof Nonrecording) {
                this.applyDuration((Nonrecording)this.promptItem);
            }
            this.applyPresenter(this.promptItem);
            super.applyValues();
            int miSize = this.promptItem.getMediaitems().size();
            int i = 0;
            while (i < miSize - 1) {
                MediaitemUI miUI = this.mediaItemUIs.get(i);
                if (miUI == null) {
                    JOptionPane.showConfirmDialog(this, "Undefined UI for mediaitem #" + i, "Internal error", 0);
                } else {
                    miUI.applyValues();
                }
                ++i;
            }
        } else if (this.promptItems != null) {
            for (PromptItem pi : this.promptItems) {
                if (pi instanceof Recording) {
                    Recording ri = (Recording)pi;
                    if (this.instructionsEnabled) {
                        this.applyInstructions(ri);
                    }
                    if (this.commentEnabled) {
                        this.applyComment(ri);
                    }
                    if (this.preRecEnabled) {
                        this.applyPreDelay(ri);
                    }
                    if (this.durationEnabled) {
                        this.applyRecDuration(ri);
                    }
                    if (this.postRecEnabled) {
                        this.applyPostDelay(ri);
                    }
                    if (this.beepPropEnabled) {
                        this.applyBeep(ri);
                    }
                    if (this.blockedPropEnabled) {
                        ri.setNNBlocked(this.blockedWidget.isSelected());
                    }
                    if (this.finalSilenceEnabled) {
                        this.applyFinalSilence(ri);
                    }
                } else if (pi instanceof Nonrecording && this.durationEnabled) {
                    Nonrecording nr = (Nonrecording)pi;
                    this.applyDuration(nr);
                }
                if (!this.presenterEnabled) continue;
                this.applyPresenter(pi);
            }
        }
        super.applyValues();
        this.forceRenameofItemcodeInUse = false;
    }

    private void changeMediaitemscount(int newMiCount) {
        List miList = this.promptItem.getMediaitems();
        int miSize = miList.size();
        if (miSize < newMiCount) {
            int diffMiCnt = newMiCount - miSize;
            int i = 0;
            while (i < diffMiCnt) {
                Mediaitem newMi = new Mediaitem();
                miList.add(newMi);
                int uiIdx = miSize + i - 1;
                MediaitemUI miUi = this.extraMediaItemUi(uiIdx);
                this.itemPanel.insertTab("Media " + uiIdx + 2, null, miUi, null, miSize + i + 1);
                miUi.setMediaitem(newMi);
                ++i;
            }
        } else if (miSize > newMiCount) {
            int diffMiCnt = miSize - newMiCount;
            int i = 0;
            while (i < diffMiCnt) {
                int uiIdx = miSize - i - 2;
                MediaitemUI miUiToRem = this.mediaItemUIs.get(uiIdx);
                this.itemPanel.remove(miUiToRem);
                miList.remove(miSize - i - 1);
                ++i;
            }
        }
        this.mediaItemCount = newMiCount;
    }

    private List<String> selectedMIMECombination() {
        ArrayList<String> mimesCombi = new ArrayList<String>();
        mimesCombi.add((String)this.mimeTypeWidget.getSelectedItem());
        int i = 1;
        while (i < this.mediaItemCount) {
            MediaitemUI mui = this.mediaItemUIs.get(i - 1);
            mimesCombi.add(mui.selectedMimeType());
            ++i;
        }
        return mimesCombi;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.adjusting) {
            return;
        }
        Object src = e.getSource();
        String cmd = e.getActionCommand();
        if (AddMediaitemAction.ACTION_COMMAND.equals(cmd)) {
            List<String> currMimeCombi = this.selectedMIMECombination();
            int newMiCount = this.mediaItemCount + 1;
            List<String> availMimes = this.selectableMIMETypesDisplayList(this.availablePromptPresenters, currMimeCombi, this.mediaItemCount + 1);
            if (newMiCount <= this.maxMediaitemCombinations && newMiCount >= 1 && availMimes.size() > 0) {
                this.applyValues();
                StateEdit addMiStateEdit = new StateEdit(this, "Add media item");
                List miList = this.promptItem.getMediaitems();
                Mediaitem newMi = new Mediaitem();
                newMi.setMimetype(availMimes.get(0));
                miList.add(newMi);
                this.setPromptItem(this.promptItem);
                addMiStateEdit.end();
                this.undoManager.addEdit(addMiStateEdit);
                this.setDependencies();
                this.editActionsListener.providesEditActions((Object)this, this.editActions);
            }
        } else if (RemoveMediaitemAction.ACTION_COMMAND.equals(cmd)) {
            int newMiCount = this.mediaItemCount - 1;
            if (newMiCount <= this.maxMediaitemCombinations && newMiCount >= 1) {
                StateEdit removeMiStateEdit = new StateEdit(this, "Remove media item");
                this.changeMediaitemscount(newMiCount);
                removeMiStateEdit.end();
                this.undoManager.addEdit(removeMiStateEdit);
                this.setDependencies();
                this.editActionsListener.providesEditActions((Object)this, this.editActions);
            }
        } else if (src == this.recDurationLimitedWidget || src == this.preRecDelayNonDefaultWidget || src == this.postRecDelayNonDefaultWidget) {
            this.setDependencies();
        } else if (src instanceof BaseMediaitemUI) {
            this.setDependencies();
        } else if (this.undoAction.getActionCommand().equals(cmd)) {
            this.undoManager.undo();
        } else if (this.redoAction.getActionCommand().equals(cmd)) {
            this.undoManager.redo();
        } else if (src == this.recordingCodeWidget && this.promptItem instanceof Recording) {
            Recording r = (Recording)this.promptItem;
            r.setItemcode(this.recordingCodeWidget.getText());
        }
        super.actionPerformed(e);
    }

    private void createTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Recording Script");
        this.createNodes(top);
        final JTree tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setDragEnabled(true);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
            }
        });
        JScrollPane treeView = new JScrollPane(tree);
        JFrame frame = new JFrame("Recording script tree");
        frame.getContentPane().add(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode section = null;
        DefaultMutableTreeNode item = null;
        section = new DefaultMutableTreeNode("Introduction");
        top.add(section);
        item = new DefaultMutableTreeNode("promptItem 1");
        section.add(item);
        section = new DefaultMutableTreeNode("Recording");
        top.add(section);
        item = new DefaultMutableTreeNode("IMAGE\ta small but quite nice photo\tx");
        section.add(item);
        item = new DefaultMutableTreeNode("TEXT\tW O L V E R H A M P T O N");
        section.add(item);
        item = new DefaultMutableTreeNode("TEXT\tBillericay");
        section.add(item);
        item = new DefaultMutableTreeNode("AUDIO\taudio file\t_");
        section.add(item);
    }

    public static void main(String[] args) {
        Recording pi = new Recording();
        Mediaitem mi = (Mediaitem)pi.getMediaitems().get(0);
        mi.setAlt("Alternative");
        mi.setAutoplay(Boolean.valueOf(false));
        mi.setHeight(Integer.valueOf(100));
        mi.setWidth(Integer.valueOf(100));
        mi.setVolume(Integer.valueOf(50));
        mi.setMimetype("text/plain");
        mi.setModal(Boolean.valueOf(false));
        pi.setPostrecdelay(Integer.valueOf(500));
        pi.setPrerecdelay(Integer.valueOf(1000));
        Reccomment rc = new Reccomment();
        rc.setReccomment("Comment");
        pi.setReccomment(rc);
        Recinstructions ri = new Recinstructions();
        ri.setRecinstructions("Instructions");
        pi.setRecinstructions(ri);
        pi.setItemcode("Code");
        try {
            mi.setSrc(new URI("http://www.source.url/a_very_long_filename.html"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        mi.setText("Prompt text");
        pi.setRecduration(Integer.valueOf(10000));
        pi.setRectype("audio");
        PromptItemUI pie = new PromptItemUI(null, null);
        pie.setPromptItem((PromptItem)pi);
        pie.createTree();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setDependencies();
    }

    @Override
    public void providesEditActions(Object src, EditActions editActions) {
        if (this.editActionsListener != null) {
            this.editActionsListener.providesEditActions(src, editActions);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (src instanceof Recording) {
            if ("itemcode".equals(propertyName)) {
                this.recordingCodeWidget.setText((String)evt.getNewValue());
            }
        } else if (src instanceof Mediaitem && "text".equals(propertyName)) {
            this.promptTextWidget.getDocument().removeDocumentListener(this);
            this.promptTextWidget.setText((String)evt.getNewValue());
            this.promptTextWidget.getDocument().addDocumentListener(this);
        }
    }

    public int getDefaultPreRecording() {
        return this.defaultPreRecording;
    }

    public void setDefaultPreRecording(int defaultPreRecording) {
        this.defaultPreRecording = defaultPreRecording;
    }

    public int getDefaultPostRecording() {
        return this.defaultPostRecording;
    }

    public void setDefaultPostRecording(int defaultPostRecording) {
        this.defaultPostRecording = defaultPostRecording;
    }

    @Override
    public boolean isDefaultPromptAutoPlay() {
        return this.defaultPromptAutoPlay;
    }

    @Override
    public void setDefaultPromptAutoPlay(boolean defaultPromptAutoPlay) {
        this.defaultPromptAutoPlay = defaultPromptAutoPlay;
    }

    private String[] getSelectableMIMETypeCombinationsDisplayList(List<PromptPresenterServiceDescriptor> availablePromptPresenters2) {
        String[] singleMIMETypeCombinations;
        HashSet<List<String>> availMimes = new HashSet<List<String>>();
        for (PromptPresenterServiceDescriptor ppsd : availablePromptPresenters2) {
            String[][] ppMimesArrs;
            String[][] stringArray = ppMimesArrs = ppsd.getSupportedMIMETypes();
            int n = ppMimesArrs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ppMimesArr = stringArray[n2];
                List<String> ppMimesL = Arrays.asList(ppMimesArr);
                availMimes.add(ppMimesL);
                ++n2;
            }
        }
        if (availMimes.size() > 0) {
            ArrayList selectableMIMETypeCombinationssorted = new ArrayList(availMimes);
            Collections.sort(selectableMIMETypeCombinationssorted, new BaseMediaitemUI.MIMETypeCombinationsSorter());
            ArrayList<String> singleMIMETypeCombinationList = new ArrayList<String>();
            for (List mimeTypeCombi : selectableMIMETypeCombinationssorted) {
                if (mimeTypeCombi.size() != 1) continue;
                singleMIMETypeCombinationList.add((String)mimeTypeCombi.get(0));
            }
            singleMIMETypeCombinations = singleMIMETypeCombinationList.toArray(new String[0]);
        } else {
            singleMIMETypeCombinations = MIMETypes.getAllMimeTypes();
        }
        return singleMIMETypeCombinations;
    }

    private List<String> selectableMIMETypesDisplayList(List<PromptPresenterServiceDescriptor> availablePromptPresenters2, List<String> mimeTypeList, int misLength) {
        if (misLength < mimeTypeList.size()) {
            throw new IllegalArgumentException("Length of currently selected media item MIME type list longer than media items count");
        }
        HashSet<List<String>> availMimes = new HashSet<List<String>>();
        for (PromptPresenterServiceDescriptor ppsd : availablePromptPresenters2) {
            String[][] ppMimesArrs;
            String[][] stringArray = ppMimesArrs = ppsd.getSupportedMIMETypes();
            int n = ppMimesArrs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ppMimesArr = stringArray[n2];
                List<String> ppMimesL = Arrays.asList(ppMimesArr);
                availMimes.add(ppMimesL);
                ++n2;
            }
        }
        CollectionUtils collectionUtils = new CollectionUtils();
        Set selectableMimesSet = collectionUtils.residualNextMatchingElements(availMimes, mimeTypeList);
        List<String> selectableMIMETypesList = Arrays.asList(selectableMimesSet.toArray(new String[selectableMimesSet.size()]));
        Collections.sort(selectableMIMETypesList, new BaseMediaitemUI.MIMETypeSorter());
        return selectableMIMETypesList;
    }

    private List<PromptPresenterServiceDescriptor> availablePromptPresenters(List<String> mimeTypeCombination) {
        ArrayList<PromptPresenterServiceDescriptor> filteredPPList = new ArrayList<PromptPresenterServiceDescriptor>();
        if (mimeTypeCombination != null) {
            int mimeTypeMemberCount = mimeTypeCombination.size();
            block0: for (PromptPresenterServiceDescriptor ppsd : this.availablePromptPresenters) {
                String[][] suppMIMEspp;
                String[][] stringArray = suppMIMEspp = ppsd.getSupportedMIMETypes();
                int n = suppMIMEspp.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] mtcmbs = stringArray[n2];
                    if (mtcmbs != null && mtcmbs.length == mimeTypeMemberCount) {
                        boolean add = true;
                        int i = 0;
                        while (i < mimeTypeMemberCount) {
                            String smime = mtcmbs[i];
                            String rmime = mimeTypeCombination.get(i);
                            if (rmime == null || !rmime.equals(smime)) {
                                add = false;
                                break;
                            }
                            ++i;
                        }
                        if (add) {
                            filteredPPList.add(ppsd);
                            continue block0;
                        }
                    }
                    ++n2;
                }
            }
        }
        return filteredPPList;
    }

    @Override
    protected void documentUpdate(DocumentEvent e) {
        if (this.promptItem != null) {
            Document d = e.getDocument();
            if (d.equals(this.promptInstructionsWidget.getDocument())) {
                this.instructionsFontManager.applyFontCanDisplay((JTextComponent)this.promptInstructionsWidget);
            } else if (d.equals(this.promptCommentWidget.getDocument())) {
                this.descriptionFontManager.applyFontCanDisplay((JTextComponent)this.promptCommentWidget);
            }
        }
        super.documentUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        this.applyValues();
        try {
            PromptItem piClone = (PromptItem)this.promptItem.clone();
            state.put("promptitem", piClone);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        Object piObj = state.get("promptitem");
        PromptItem pi = null;
        if (piObj != null && piObj instanceof PromptItem) {
            pi = (PromptItem)piObj;
        }
        this.setPromptItem(pi);
    }

    public void setDescriptionFontFamilies(String[] descriptionFontFamilies) {
        this.descriptionFontFamilies = descriptionFontFamilies;
        this.descriptionFontManager.setPreferredFontFamilies(descriptionFontFamilies);
    }

    public void setInstructionsFontFamilies(String[] instructionsFontFamilies) {
        this.instructionsFontFamilies = instructionsFontFamilies;
        this.instructionsFontManager.setPreferredFontFamilies(instructionsFontFamilies);
    }

    public void setPromptItems(List<PromptItem> promptItemsList) {
        PromptPresenterProperty ppProp;
        this.setPromptItem(null);
        this.promptItems = promptItemsList;
        this.setEnabled(this.promptItems != null && this.promptItems.size() > 0);
        this.disableAllProperties();
        MultiSelectPropertyState instrState = new MultiSelectPropertyState();
        MultiSelectPropertyState commentState = new MultiSelectPropertyState();
        MultiSelectPropertyState preRecPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState durPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState postRecPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState blockedPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState beepPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState finalSilencePropState = new MultiSelectPropertyState();
        MultiSelectPropertyState promptPresenterState = new MultiSelectPropertyState();
        ArrayList<Mediaitem> mis = new ArrayList<Mediaitem>(promptItemsList.size());
        Integer minMiCount = null;
        boolean allAreRecordings = promptItemsList.size() > 0;
        for (PromptItem pi : promptItemsList) {
            List piMis = pi.getMediaitems();
            int piMiCnt = piMis.size();
            if (minMiCount == null) {
                minMiCount = piMiCnt;
            } else if (piMiCnt < minMiCount) {
                minMiCount = piMiCnt;
            }
            mis.add((Mediaitem)piMis.get(0));
            List mimes = pi.getMIMETypes();
            String prClNm = null;
            Presenter pr = pi.getPresenter();
            if (pr != null) {
                prClNm = pr.getClassname();
            }
            PromptPresenterProperty ppProp2 = new PromptPresenterProperty(mimes, prClNm);
            promptPresenterState.next((Object)ppProp2);
            if (pi instanceof Recording) {
                Recording r = (Recording)pi;
                Recinstructions piInstructions = r.getRecinstructions();
                instrState.next((Object)piInstructions);
                Reccomment piComment = r.getReccomment();
                commentState.next((Object)piComment);
                Integer piPreRec = r.getPrerecdelay();
                preRecPropState.next((Object)piPreRec);
                Integer piDur = r.getRecduration();
                durPropState.next((Object)piDur);
                Integer piPostRec = r.getPostrecdelay();
                postRecPropState.next((Object)piPostRec);
                Boolean piBlocked = r.getBlocked();
                blockedPropState.next((Object)piBlocked);
                String piBeep = r.getBeep();
                beepPropState.next((Object)piBeep);
                Integer piFs = r.getFinalsilence();
                finalSilencePropState.next((Object)piFs);
                continue;
            }
            if (pi instanceof Nonrecording) {
                allAreRecordings = false;
                Nonrecording nr = (Nonrecording)pi;
                instrState.nextNotAvail();
                commentState.nextNotAvail();
                preRecPropState.nextNotAvail();
                Integer nrDur = nr.getDuration();
                durPropState.next((Object)nrDur);
                postRecPropState.nextNotAvail();
                continue;
            }
            allAreRecordings = false;
        }
        this.isRecording = allAreRecordings;
        this.setMediaitems(mis);
        if (minMiCount > 1) {
            int i = 1;
            while (i < minMiCount) {
                ArrayList<Mediaitem> msMis = new ArrayList<Mediaitem>();
                for (PromptItem pi : promptItemsList) {
                    Mediaitem mi = (Mediaitem)pi.getMediaitems().get(i);
                    msMis.add(mi);
                }
                MediaitemUI miUI = this.extraMediaItemUi(i - 1);
                miUI.setMediaitems(msMis);
                this.itemPanel.addTab("Media " + (i + 1), miUI);
                ++i;
            }
        }
        this.preRecEnabled = preRecPropState.allEqual();
        Integer preRec = (Integer)preRecPropState.getObjectSet();
        if (this.preRecEnabled) {
            if (preRec == null) {
                this.preRecDelayNonDefaultWidget.setSelected(false);
                this.preRecDelayWidget.setText(Integer.toString(this.defaultPreRecording));
            } else {
                this.preRecDelayNonDefaultWidget.setSelected(true);
                this.preRecDelayWidget.setText(preRec.toString());
            }
        }
        this.durationEnabled = durPropState.allEqual();
        Integer dur = (Integer)durPropState.getObjectSet();
        if (this.durationEnabled) {
            if (dur == null) {
                this.recDurationLimitedWidget.setSelected(false);
                this.recDurationWidget.setText("");
            } else {
                this.recDurationLimitedWidget.setSelected(true);
                this.recDurationWidget.setText(dur.toString());
            }
        }
        this.postRecEnabled = postRecPropState.allEqual();
        Integer postRec = (Integer)postRecPropState.getObjectSet();
        if (this.postRecEnabled) {
            if (postRec == null) {
                this.postRecDelayNonDefaultWidget.setSelected(false);
                this.postRecDelayWidget.setText(Integer.toString(this.defaultPostRecording));
            } else {
                this.postRecDelayNonDefaultWidget.setSelected(true);
                this.postRecDelayWidget.setText(postRec.toString());
            }
        }
        this.finalSilenceEnabled = finalSilencePropState.allEqual();
        Integer finalSilence = (Integer)finalSilencePropState.getObjectSet();
        boolean fsSel = finalSilence != null && finalSilence != 0;
        this.finalSilenceWidget.setSelected(fsSel);
        this.blockedPropEnabled = blockedPropState.allEqual();
        if (this.blockedPropEnabled) {
            Boolean blocked = (Boolean)blockedPropState.getObjectSet();
            this.blockedWidget.setSelected(blocked != null && blocked != false);
        }
        this.beepPropEnabled = beepPropState.allEqual();
        if (this.beepPropEnabled) {
            String beep = (String)beepPropState.getObjectSet();
            boolean bBeep = Boolean.parseBoolean(beep);
            this.beepPlayWidget.setSelected(bBeep);
        }
        this.instructionsEnabled = instrState.allEqual();
        String instrText = "";
        Recinstructions instructions = (Recinstructions)instrState.getObjectSet();
        if (this.instructionsEnabled && instructions != null) {
            instrText = instructions.getRecinstructions();
        }
        this.promptInstructionsWidget.setText(instrText);
        this.commentEnabled = commentState.allEqual();
        String commText = "";
        Reccomment reccomment = (Reccomment)commentState.getObjectSet();
        if (this.commentEnabled && reccomment != null) {
            commText = reccomment.getReccomment();
        }
        this.promptCommentWidget.setText(commText);
        this.presenterEnabled = promptPresenterState.allEqual();
        if (this.presenterEnabled && (ppProp = (PromptPresenterProperty)promptPresenterState.getObjectSet()) != null) {
            String prClassname = ppProp.getPresenterClassname();
            this.promptPresenterSelector.setSelectedClassname(prClassname);
        }
        this.setDependencies();
    }

    @Override
    public void caretUpdate(CaretEvent ce) {
        super.caretUpdate(ce);
        if (!this.resettingFormValue && !this.forceRenameofItemcodeInUse && this.promptItem instanceof Recording) {
            Recording orgRec = (Recording)this.promptItem;
            final String orgIc = orgRec.getItemcode();
            String dIc = this.recordingCodeWidget.getText();
            if (orgIc != null && !orgIc.equals(dIc) && this.itemCodesInUse != null && this.itemCodesInUse.contains(orgIc)) {
                int answ = JOptionPane.showConfirmDialog(this, "Itemcode " + orgIc + " is already in use. There exists at least one recording file for this prompt.\nIf you rename this itemcode the recordings will not be visible anymore.\nDo you want, nevertheless, change the itemcode ?", "Change item code", 0);
                if (answ == 0) {
                    this.forceRenameofItemcodeInUse = true;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PromptItemUI.this.resettingFormValue = true;
                            PromptItemUI.this.recordingCodeWidget.setText(orgIc);
                            PromptItemUI.this.resettingFormValue = false;
                        }
                    });
                    this.forceRenameofItemcodeInUse = false;
                }
            }
        }
    }

    @Override
    protected void releaseListeners() {
        super.releaseListeners();
        if (this.promptItem != null) {
            this.promptItem.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public class PromptPresenterProperty {
        private List<String> mimeList;
        private String presenterClassname;

        public List<String> getMimeList() {
            return this.mimeList;
        }

        public String getPresenterClassname() {
            return this.presenterClassname;
        }

        public PromptPresenterProperty(List<String> mimeList, String presenterClassname) {
            this.mimeList = mimeList;
            this.presenterClassname = presenterClassname;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PromptPresenterProperty)) {
                return false;
            }
            PromptPresenterProperty op = (PromptPresenterProperty)o;
            String opcnm = op.getPresenterClassname();
            if (this.presenterClassname == null ? opcnm != null : !this.presenterClassname.equals(opcnm)) {
                return false;
            }
            List<String> oMimes = op.getMimeList();
            int mSize = this.mimeList.size();
            if (oMimes.size() != mSize) {
                return false;
            }
            int i = 0;
            while (i < mSize) {
                String oMime = oMimes.get(i);
                String mime = this.mimeList.get(i);
                if (oMime == null ? mime != null : !oMime.equals(mime)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

