/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.PromptItemsTableModel;
import ipsk.apps.speechrecorder.script.ui.AddNonRecordingAction;
import ipsk.apps.speechrecorder.script.ui.AddRecordingAction;
import ipsk.apps.speechrecorder.script.ui.GroupItemsAction;
import ipsk.apps.speechrecorder.script.ui.PromptItemUI;
import ipsk.apps.speechrecorder.script.ui.ToggleGroupRandomAction;
import ipsk.apps.speechrecorder.script.ui.UngroupItemsAction;
import ipsk.db.speech.Group;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptGroupsList;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.PromptItemsList;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Section;
import ipsk.lang.DisplayBoolean;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.CopyAction;
import ipsk.swing.CutAction;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.swing.PasteAction;
import ipsk.swing.RedoAction;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import ipsk.swing.table.AutoFontCellRenderer;
import ipsk.swing.text.EditorKitMenu;
import ipsk.util.collections.ObservableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class SectionUI
extends JPanel
implements ListSelectionListener,
FlavorListener,
ClipboardOwner,
PropertyChangeListener,
ActionListener,
FocusListener,
EditActionsListener,
StateEditable {
    private EnumVector<Section.Mode> modes = new EnumVector(Section.Mode.class, "(Default)");
    private static EnumVector<Section.Order> ORDERS;
    private static EnumVector<Section.PromptPhase> PROMPTPHASES;
    private Section section;
    private JTextField nameField;
    private JComboBox<EnumSelectionItem<Section.Mode>> modeBox;
    private JComboBox<EnumSelectionItem<Section.Order>> orderBox;
    private JComboBox<EnumSelectionItem<Section.PromptPhase>> promptphasesBox;
    private JComboBox<DisplayBoolean> speakerdisplayBox;
    private JPanel promptItemsPanel;
    private PromptItemsTableModel promptItemTableModel;
    private AutoFontCellRenderer promptTextCellRenderer;
    private JTable promptItemsTable;
    private String[] promptFontFamilies;
    private String[] instructionsFontFamilies;
    private String[] descriptionFontFamilies;
    private AddRecordingAction addRecordingAction;
    private AddNonRecordingAction addNonRecordingAction;
    private GroupItemsAction groupItemsAction;
    private UngroupItemsAction ungroupItemsAction;
    private ToggleGroupRandomAction toggleGroupRandomAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private Clipboard clipboard = null;
    private JSplitPane splitPane;
    private Section.Mode defaultMode = Section.Mode.MANUAL;
    private int defaultPreRecording;
    private int defaultPostRecording;
    private boolean defaultPromptAutoPlay = true;
    private URL projectContext = null;
    private PromptItemUI promptItemEditor;
    private EditActions editActions;
    private EditActionsListener editActionsListener;
    private boolean userSelection = true;
    private List<Action> newActionsList;
    IntegerSequenceGenerator sequenceGenerator;
    private ItemcodeGenerator itemcodeGenerator;
    private ObservableList<String> itemCodesList;
    private Set<String> itemCodesInUse = null;
    private UndoManager undoManager = new UndoManager();
    private UndoAction undoAction;
    private RedoAction redoAction;
    private Font defaultPromptFont;

    static {
        PROMPTPHASES = new EnumVector(Section.PromptPhase.class, "Idle (Default)");
        HashSet<Section.Order> excludes = new HashSet<Section.Order>();
        excludes.add(Section.Order.RANDOMIZED);
        ORDERS = new EnumVector(Section.Order.class, "Sequential (Default)", excludes);
    }

    public String[] getInstructionsFontFamilies() {
        return this.instructionsFontFamilies;
    }

    public void setInstructionsFontFamilies(String[] instructionsFontFamilies) {
        this.instructionsFontFamilies = instructionsFontFamilies;
        this.promptItemEditor.setInstructionsFontFamilies(instructionsFontFamilies);
    }

    public String[] getDescriptionFontFamilies() {
        return this.descriptionFontFamilies;
    }

    public void setDescriptionFontFamilies(String[] descriptionFontFamilies) {
        this.descriptionFontFamilies = descriptionFontFamilies;
        this.promptItemEditor.setDescriptionFontFamilies(descriptionFontFamilies);
    }

    public String[] getPromptFontFamilies() {
        return this.promptFontFamilies;
    }

    public void setPromptFontFamilies(String[] promptFontFamilies) {
        this.promptFontFamilies = promptFontFamilies;
        this.promptTextCellRenderer.setPreferredFontFamilies(promptFontFamilies);
        this.promptItemEditor.setPromptFontFamilies(promptFontFamilies);
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
        this.promptItemEditor.setProjectContext(projectContext);
    }

    public PromptItemUI getPromptItemEditor() {
        return this.promptItemEditor;
    }

    public Set<String> getItemCodesInUse() {
        return this.itemCodesInUse;
    }

    public void setItemCodesInUse(Set<String> itemCodesInUse) {
        this.itemCodesInUse = itemCodesInUse;
        this.promptItemEditor.setItemCodesInUse(itemCodesInUse);
    }

    public SectionUI(URL projectContext, IntegerSequenceGenerator sequenceGenerator, ObservableList<String> itemCodesSetProvider, ItemcodeGenerator itemcodeGenerator, List<PromptPresenterServiceDescriptor> availablePromptPresenters2) {
        super(new BorderLayout());
        FontMetrics fontMetrics;
        this.projectContext = projectContext;
        this.sequenceGenerator = sequenceGenerator;
        this.itemCodesList = itemCodesSetProvider;
        this.itemcodeGenerator = itemcodeGenerator;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(new AllPermission());
            }
            catch (SecurityException se) {
                System.err.println("WARNING: System clipboard not accessible.");
                this.clipboard = new Clipboard("Script Clipboard");
            }
        }
        if (this.clipboard == null) {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        this.clipboard.addFlavorListener(this);
        JPanel sectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 19;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel nameLabel = new JLabel("Name (Id):");
        sectionPanel.add((Component)nameLabel, c);
        this.nameField = new JTextField();
        EditorKitMenu nameFieldEkm = new EditorKitMenu((JTextComponent)this.nameField);
        nameFieldEkm.setPopupMenuActiv(true);
        this.nameField.addActionListener(this);
        ++c.gridx;
        sectionPanel.add((Component)this.nameField, c);
        c.gridx = 0;
        ++c.gridy;
        sectionPanel.add((Component)new JLabel("Mode:"), c);
        this.modeBox = new JComboBox<Section.Mode>((Vector<Section.Mode>)this.modes);
        ++c.gridx;
        sectionPanel.add(this.modeBox, c);
        c.gridx = 0;
        ++c.gridy;
        sectionPanel.add((Component)new JLabel("Order:"), c);
        this.orderBox = new JComboBox<Section.Order>((Vector<Section.Order>)ORDERS);
        ++c.gridx;
        sectionPanel.add(this.orderBox, c);
        c.gridx = 0;
        ++c.gridy;
        sectionPanel.add((Component)new JLabel("Promptphase:"), c);
        this.promptphasesBox = new JComboBox<Section.PromptPhase>((Vector<Section.PromptPhase>)PROMPTPHASES);
        ++c.gridx;
        sectionPanel.add(this.promptphasesBox, c);
        c.gridx = 0;
        ++c.gridy;
        sectionPanel.add((Component)new JLabel("Speakerdisplay:"), c);
        this.speakerdisplayBox = new JComboBox<DisplayBoolean>(DisplayBoolean.getDefinedvalues());
        ++c.gridx;
        sectionPanel.add(this.speakerdisplayBox, c);
        this.promptItemTableModel = new PromptItemsTableModel();
        this.promptItemsTable = new JTable(this.promptItemTableModel);
        TableColumn txtTableCol = this.promptItemsTable.getColumnModel().getColumn(3);
        TableCellRenderer txtTcr = txtTableCol.getCellRenderer();
        if (txtTcr == null) {
            txtTcr = this.promptItemsTable.getDefaultRenderer(this.promptItemsTable.getColumnClass(3));
        }
        this.promptTextCellRenderer = new AutoFontCellRenderer(txtTcr);
        txtTableCol.setCellRenderer((TableCellRenderer)this.promptTextCellRenderer);
        TableColumn itemCodeTableCol = this.promptItemsTable.getColumnModel().getColumn(2);
        ItemCodeCellEditor icEditor = new ItemCodeCellEditor();
        itemCodeTableCol.setCellEditor(icEditor);
        Font currFont = this.getFont();
        if (currFont != null && (fontMetrics = this.getFontMetrics(currFont)) != null) {
            TableColumn groupCol = this.promptItemsTable.getColumnModel().getColumn(1);
            String maxGroupVal = "99";
            int maxGroupWidth = fontMetrics.stringWidth(maxGroupVal);
            groupCol.setPreferredWidth(maxGroupWidth);
        }
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SectionUI.this.isEnabled()) {
                    SectionUI.this.editSelectedPromptItem();
                }
            }
        };
        this.promptItemsTable.addMouseListener(listMouseListener);
        ListSelectionModel promptItemsSelModel = this.promptItemsTable.getSelectionModel();
        promptItemsSelModel.setSelectionMode(2);
        promptItemsSelModel.addListSelectionListener(this);
        this.promptItemsTable.setDragEnabled(true);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.promptItemsTable);
        this.promptItemsTable.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.promptItemsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints sc = new GridBagConstraints();
        sc.gridx = 0;
        sc.gridy = 0;
        sc.weightx = 2.0;
        sc.weighty = 2.0;
        sc.fill = 1;
        this.promptItemsPanel.setBorder(BorderFactory.createTitledBorder("Prompt items"));
        this.promptItemsPanel.add((Component)scrollPane, sc);
        sectionPanel.add((Component)scrollPane, c);
        this.promptItemEditor = new PromptItemUI(projectContext, availablePromptPresenters2);
        sectionPanel.setMinimumSize(new Dimension(0, 0));
        this.promptItemEditor.setMinimumSize(new Dimension(0, 0));
        this.splitPane = new JSplitPane(1, true, sectionPanel, this.promptItemEditor);
        this.add((Component)this.splitPane, "Center");
        final SectionUI al = this;
        this.addRecordingAction = new AddRecordingAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.addRecordingAction.setEnabled(false);
        this.addNonRecordingAction = new AddNonRecordingAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.addNonRecordingAction.setEnabled(false);
        this.groupItemsAction = new GroupItemsAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.groupItemsAction.setEnabled(false);
        this.ungroupItemsAction = new UngroupItemsAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.ungroupItemsAction.setEnabled(false);
        this.toggleGroupRandomAction = new ToggleGroupRandomAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.toggleGroupRandomAction.setEnabled(false);
        this.cutAction = new CutAction(){

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.cutAction.setEnabled(false);
        this.copyAction = new CopyAction(){

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.copyAction.setEnabled(false);
        this.pasteAction = new PasteAction(){

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.pasteAction.setEnabled(false);
        this.undoAction = new UndoAction(){

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.redoAction = new RedoAction(){

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.editActions = new EditActions("Sections UI", (Action)this.cutAction, (Action)this.copyAction, (Action)this.pasteAction, this.undoAction, this.redoAction);
        this.updateEditActions();
        InputMap imap = this.promptItemsTable.getInputMap();
        imap.put(KeyStroke.getKeyStroke("ctrl X"), this.cutAction.getValue("ActionCommandKey"));
        imap.put(KeyStroke.getKeyStroke("ctrl C"), this.copyAction.getValue("Name"));
        imap.put(KeyStroke.getKeyStroke("ctrl V"), this.pasteAction.getValue("Name"));
        ActionMap map = this.promptItemsTable.getActionMap();
        map.put(this.cutAction.getValue("ActionCommandKey"), (Action)this.cutAction);
        map.put(this.copyAction.getValue("Name"), (Action)this.copyAction);
        map.put(this.pasteAction.getValue("Name"), (Action)this.pasteAction);
        this.promptItemsTable.addFocusListener(this);
        this.newActionsList = new ArrayList<Action>();
        this.newActionsList.add(this.addRecordingAction);
        this.newActionsList.add(this.addNonRecordingAction);
        this.promptItemEditor.setEditActionListener(this);
    }

    public UngroupItemsAction getUngroupItemsAction() {
        return this.ungroupItemsAction;
    }

    public GroupItemsAction getGroupItemsAction() {
        return this.groupItemsAction;
    }

    private void setTablePromptUnits(List<Group> tablePromptUnits) {
        this.promptItemTableModel.setPromptUnits(tablePromptUnits);
        if (tablePromptUnits.size() > 0) {
            this.promptItemsTable.setRowSelectionInterval(0, 0);
        } else {
            this.promptItemsTable.clearSelection();
            this.promptItemEditor.applyValues();
            this.promptItemEditor.setPromptItem(null);
        }
    }

    private List<Group> promptUnitsCopy(List<Group> promptUnits) {
        ArrayList<Group> copyPus = new ArrayList<Group>();
        Iterator<Group> iterator = promptUnits.iterator();
        while (iterator.hasNext()) {
            Group pu;
            Group g = pu = iterator.next();
            try {
                Group gc = (Group)g.clone();
                copyPus.add(gc);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return copyPus;
    }

    private void setPromptItemsCopy() {
        List<Object> copyPus = new ArrayList();
        copyPus = this.section != null ? this.promptUnitsCopy(this.section.getGroups()) : new ArrayList();
        this.setTablePromptUnits(copyPus);
    }

    public void setSection(Section section) {
        boolean enabled;
        if (this.section != null) {
            this.section.removePropertyChangeListener((PropertyChangeListener)this);
            this.applyValues();
        }
        this.section = section;
        this.userSelection = false;
        boolean bl = enabled = this.section != null;
        if (enabled) {
            this.nameField.setText(section.getName());
            this.modeBox.setSelectedItem(this.modes.getItem((Enum)this.section.getMode()));
            this.orderBox.setSelectedItem(ORDERS.getItem((Enum)this.section.getOrder()));
            this.promptphasesBox.setSelectedItem(PROMPTPHASES.getItem((Enum)this.section.getPromptphase()));
            this.speakerdisplayBox.setSelectedItem(new DisplayBoolean(this.section.getSpeakerDisplay()));
            this.section.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.undoManager.discardAllEdits();
        this.setEnabled(enabled);
        this.setPromptItemsCopy();
        this.updateEditActions();
        this.userSelection = true;
    }

    public static void main(String[] args) {
        new SectionUI(null, null, null, new ItemcodeGenerator(), null);
    }

    private void editSelectedPromptItem() {
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        int sel = selModel.getMinSelectionIndex();
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.promptItemsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected void applyValues() {
        if (this.section != null) {
            this.promptItemEditor.applyValues();
            String nameFieldText = this.nameField.getText();
            if (this.section.getName() != null || !nameFieldText.equals("")) {
                this.section.setName(nameFieldText);
            }
            this.section.setMode((Section.Mode)((EnumSelectionItem)this.modeBox.getSelectedItem()).getEnumVal());
            this.section.setOrder((Section.Order)((EnumSelectionItem)this.orderBox.getSelectedItem()).getEnumVal());
            this.section.setPromptphase((Section.PromptPhase)((EnumSelectionItem)this.promptphasesBox.getSelectedItem()).getEnumVal());
            this.section.setSpeakerDisplay(((DisplayBoolean)this.speakerdisplayBox.getSelectedItem()).getValue());
            this.stopCellEditing();
            List<Group> tablePis = this.promptItemTableModel.getPromptUnits();
            this.section.setGroups(tablePis);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        String cmd = e.getActionCommand();
        if (this.copyAction.getActionCommand().equals(cmd)) {
            this.selectedPromptUnitsToClipboard();
        } else if (this.pasteAction.getActionCommand().equals(cmd)) {
            DataFlavor[] adf = this.clipboard.getAvailableDataFlavors();
            try {
                DataFlavor[] dataFlavorArray = adf;
                int n = adf.length;
                int n2 = 0;
                while (n2 < n) {
                    PromptGroupsList pusDf;
                    DataFlavor df = dataFlavorArray[n2];
                    if (PromptItem.CLASS_DATA_FLAVOR.equals(df)) {
                        this.insert((PromptItem)this.clipboard.getContents(this).getTransferData(PromptItem.CLASS_DATA_FLAVOR));
                        break;
                    }
                    if (PromptItemsList.CLASS_DATA_FLAVOR.equals(df)) {
                        PromptItemsList pisDf = (PromptItemsList)this.clipboard.getContents(this).getTransferData(PromptItemsList.CLASS_DATA_FLAVOR);
                        if (pisDf != null) {
                            this.insert((List<PromptItem>)pisDf);
                            break;
                        }
                    } else if (PromptGroupsList.CLASS_DATA_FLAVOR.equals(df) && (pusDf = (PromptGroupsList)this.clipboard.getContents(this).getTransferData(PromptGroupsList.CLASS_DATA_FLAVOR)) != null) {
                        this.insertPromptGroups((List<Group>)pusDf);
                        break;
                    }
                    ++n2;
                }
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (this.cutAction.getActionCommand().equals(cmd)) {
            this.selectedPromptUnitsToClipboard();
            this.removeSelectedPromptItems();
        } else if (this.undoAction.getActionCommand().equals(cmd)) {
            this.undoManager.undo();
        } else if (this.redoAction.getActionCommand().equals(cmd)) {
            this.undoManager.redo();
        } else if (this.addRecordingAction.getActionCommand().equals(cmd)) {
            Recording r = new Recording();
            Mediaitem mi = new Mediaitem();
            mi.setText("");
            if (this.sequenceGenerator != null) {
                r.setRecpromptId(this.sequenceGenerator.getAndIncrement());
                mi.setMediaitemId(this.sequenceGenerator.getAndIncrement());
            }
            ArrayList<Mediaitem> mis = new ArrayList<Mediaitem>();
            mis.add(mi);
            r.setMediaitems(mis);
            this.insert((PromptItem)r);
        } else if (this.addNonRecordingAction.getActionCommand().equals(cmd)) {
            Nonrecording nr = new Nonrecording();
            Mediaitem mi = new Mediaitem();
            mi.setText("");
            if (this.sequenceGenerator != null) {
                nr.setRecpromptId(this.sequenceGenerator.getAndIncrement());
                mi.setMediaitemId(this.sequenceGenerator.getAndIncrement());
            }
            ArrayList<Mediaitem> mis = new ArrayList<Mediaitem>();
            mis.add(mi);
            nr.setMediaitems(mis);
            this.insert((PromptItem)nr);
        } else if (this.groupItemsAction.getActionCommand().equals(cmd)) {
            this.groupSelectedItems();
        } else if (this.ungroupItemsAction.getActionCommand().equals(cmd)) {
            this.ungroupSelectedItems();
        } else if (this.toggleGroupRandomAction.getActionCommand().equals(cmd)) {
            this.toggleGroupRandom();
        } else if (src == this.nameField) {
            this.section.setName(this.nameField.getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.validateSelectionModel();
            this.updateEditActions();
            ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
            int selIndex = selModel.getMinSelectionIndex();
            if (selIndex >= 0) {
                ArrayList<PromptItem> selPis = new ArrayList<PromptItem>();
                int maxSelIdx = selModel.getMaxSelectionIndex();
                List<PromptItem> promptItems = this.promptItemTableModel.promptItems();
                int pisSize = promptItems.size();
                if (maxSelIdx != -1) {
                    int si = selIndex;
                    while (si <= maxSelIdx) {
                        if (selModel.isSelectedIndex(si) && si < pisSize) {
                            PromptItem pi = promptItems.get(si);
                            selPis.add(pi);
                        }
                        ++si;
                    }
                    this.promptItemEditor.applyValues();
                    int selPisSize = selPis.size();
                    if (selPisSize == 0) {
                        this.promptItemEditor.setPromptItem(null);
                    } else if (selPisSize == 1) {
                        this.promptItemEditor.setPromptItem((PromptItem)selPis.get(0));
                    } else {
                        this.promptItemEditor.setPromptItems(selPis);
                    }
                }
            } else {
                this.promptItemEditor.applyValues();
                this.promptItemEditor.setPromptItem(null);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (src instanceof Section && "name".equals(propertyName)) {
            this.nameField.setText((String)evt.getNewValue());
        }
    }

    private boolean removePromptItem(List<Group> units, int selIdx) {
        int cgIdx = 0;
        boolean removed = false;
        for (Group g : units) {
            int grIdx = selIdx - cgIdx;
            List gpis = g.getPromptItems();
            int grSize = gpis.size();
            if (grIdx >= 0 && grIdx < grSize) {
                gpis.remove(grIdx);
                removed = true;
                break;
            }
            cgIdx += grSize;
        }
        return removed;
    }

    private List<Group> removeEmptyGroups(List<Group> units) {
        ArrayList<Group> res = new ArrayList<Group>();
        for (Group g : units) {
            List gpis = g.getPromptItems();
            if (gpis == null) continue;
            if (gpis.size() > 0) {
                res.add(g);
                continue;
            }
            g.setSection(null);
        }
        return res;
    }

    public void removeSelectedPromptItems() {
        StateEdit removeStateEdit = new StateEdit(this, "Remove prompt items");
        this.stopCellEditing();
        List<Group> newPromptUnits = this.promptUnitsCopy(this.promptItemTableModel.getPromptUnits());
        List<PromptItem> pis = this.promptItemTableModel.promptItems();
        int[] selRowsOrg = this.promptItemsTable.getSelectedRows();
        if (selRowsOrg.length > 0) {
            int[] selRowsAsc = Arrays.copyOf(selRowsOrg, selRowsOrg.length);
            Arrays.sort(selRowsAsc);
            int lowestSelRow = Integer.MAX_VALUE;
            int i = selRowsAsc.length - 1;
            while (i >= 0) {
                int selRow = selRowsAsc[i];
                if (selRow < pis.size()) {
                    if (selRow < lowestSelRow) {
                        lowestSelRow = selRow;
                    }
                    PromptItem itemToRemove = pis.get(selRow);
                    boolean removed = this.removePromptItem(newPromptUnits, selRow);
                    itemToRemove.setGroup(null);
                    if (removed && itemToRemove instanceof Recording) {
                        Recording removedRec = (Recording)itemToRemove;
                        String removedItemcode = removedRec.getItemcode();
                        this.itemCodesList.remove((Object)removedItemcode);
                        this.promptItemTableModel.setPromptUnits(newPromptUnits, selRow, selRow);
                    }
                }
                --i;
            }
            newPromptUnits = this.removeEmptyGroups(newPromptUnits);
            this.promptItemTableModel.setPromptUnits(newPromptUnits);
            if (newPromptUnits.size() == 0) {
                this.promptItemsTable.clearSelection();
            } else {
                int newSelRow = lowestSelRow - 1;
                if (newSelRow < 0) {
                    newSelRow = 0;
                }
                this.promptItemsTable.setRowSelectionInterval(newSelRow, newSelRow);
            }
            this.promptItemsTable.doLayout();
        }
        removeStateEdit.end();
        this.undoManager.addEdit(removeStateEdit);
        this.updateEditActions();
    }

    public PromptItemsList getSelectedPromptItems() {
        int[] selRowIdcs = this.promptItemsTable.getSelectedRows();
        PromptItemsList selPis = new PromptItemsList();
        int[] nArray = selRowIdcs;
        int n = selRowIdcs.length;
        int n2 = 0;
        while (n2 < n) {
            int selRowIdx = nArray[n2];
            PromptItem selPi = this.promptItemTableModel.promptItems().get(selRowIdx);
            selPis.add((Object)selPi);
            ++n2;
        }
        return selPis;
    }

    private boolean isIn(int[] arr, int i) {
        int[] nArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            int arrI = nArray[n2];
            if (arrI == i) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PromptGroupsList selectedPromptUnits() {
        int[] selRowIdcs = this.promptItemsTable.getSelectedRows();
        PromptGroupsList selPus = new PromptGroupsList();
        List<Group> pus = this.promptItemTableModel.getPromptUnits();
        int i = 0;
        for (Group g : pus) {
            List gPis = g.getPromptItems();
            ArrayList<PromptItem> selGrPis = new ArrayList<PromptItem>();
            boolean completeGroupSelected = true;
            for (PromptItem gPi : gPis) {
                if (this.isIn(selRowIdcs, i)) {
                    selGrPis.add(gPi);
                } else {
                    completeGroupSelected = false;
                }
                ++i;
            }
            if (completeGroupSelected) {
                selPus.add((Object)g);
                continue;
            }
            for (PromptItem selGrPi : selGrPis) {
                Group sg = new Group();
                sg.setSection(this.section);
                sg.getPromptItems().add(selGrPi);
                selPus.add((Object)sg);
            }
        }
        return selPus;
    }

    private void selectedPromptUnitsToClipboard() {
        PromptGroupsList pul = this.selectedPromptUnits();
        this.clipboard.setContents((Transferable)pul, this);
    }

    private void insert(List<Group> promptGroups, int insertIndex, PromptItem promptItem) {
        int prUSize = promptGroups.size();
        boolean insertedInGroup = false;
        if (prUSize == 0) {
            Group g = new Group();
            g.setSection(this.section);
            g.getPromptItems().add(promptItem);
            promptGroups.add(g);
        } else {
            int currIndex = 0;
            Integer promptUnitInsertPosition = null;
            int pInd = 0;
            while (pInd < promptGroups.size()) {
                Group g = promptGroups.get(pInd);
                List pis = g.getPromptItems();
                int pisSize = pis.size();
                if (insertIndex >= currIndex && insertIndex <= currIndex + pisSize) {
                    int groupInsertPos = insertIndex - currIndex;
                    if (pisSize == 1) {
                        promptUnitInsertPosition = pInd + 1;
                        break;
                    }
                    promptItem.setGroup(g);
                    pis.add(groupInsertPos, promptItem);
                    insertedInGroup = true;
                    break;
                }
                currIndex += pisSize;
                ++pInd;
            }
            if (!insertedInGroup && promptUnitInsertPosition == null && currIndex == insertIndex) {
                promptUnitInsertPosition = promptGroups.size();
            }
            if (promptUnitInsertPosition != null) {
                Group g = new Group();
                g.setSection(this.section);
                promptItem.setGroup(g);
                g.getPromptItems().add(promptItem);
                promptGroups.add(promptUnitInsertPosition, g);
            }
        }
    }

    public void insert(PromptItem promptItem) {
        this.applyValues();
        StateEdit insertStateEdit = new StateEdit(this, "Insert prompt item");
        this.stopCellEditing();
        if (promptItem instanceof Recording) {
            Recording recording = (Recording)promptItem;
            String itemcode = recording.getItemcode();
            if (this.itemcodeGenerator.getConfig().isActive() && (itemcode == null || "".equals(itemcode) || this.itemCodesList.contains((Object)itemcode))) {
                HashSet<String> ics = new HashSet<String>((Collection<String>)this.itemCodesList);
                this.itemcodeGenerator.toNext(ics);
                String icGen = this.itemcodeGenerator.getItemCode();
                recording.setItemcode(icGen);
            }
            this.itemCodesList.add((Object)recording.getItemcode());
        }
        List<Group> newPus = this.promptUnitsCopy(this.promptItemTableModel.getPromptUnits());
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        int insertIndex = 0;
        if (!selModel.isSelectionEmpty()) {
            insertIndex = this.promptItemsTable.getSelectedRow() + 1;
        }
        this.insert(newPus, insertIndex, promptItem);
        this.promptItemTableModel.setPromptUnits(newPus);
        insertStateEdit.end();
        this.undoManager.addEdit(insertStateEdit);
        this.promptItemsTable.setRowSelectionInterval(insertIndex, insertIndex);
        this.updateEditActions();
    }

    public void insert(List<PromptItem> promptItemsList) {
        StateEdit insertStateEdit = new StateEdit(this, "Insert prompt items");
        this.stopCellEditing();
        for (PromptItem promptItem : promptItemsList) {
            if (!(promptItem instanceof Recording)) continue;
            Recording recording = (Recording)promptItem;
            String itemcode = recording.getItemcode();
            if (this.itemcodeGenerator.getConfig().isActive() && (itemcode == null || "".equals(itemcode) || this.itemCodesList.contains((Object)itemcode))) {
                HashSet<String> ics = new HashSet<String>((Collection<String>)this.itemCodesList);
                this.itemcodeGenerator.toNext(ics);
                String icGen = this.itemcodeGenerator.getItemCode();
                recording.setItemcode(icGen);
            }
            this.itemCodesList.add((Object)recording.getItemcode());
        }
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        int startInsertIndex = 0;
        if (!selModel.isSelectionEmpty()) {
            startInsertIndex = selModel.getMaxSelectionIndex() + 1;
        }
        List<Group> newPus = this.promptUnitsCopy(this.promptItemTableModel.getPromptUnits());
        int insertIndex = startInsertIndex;
        for (PromptItem promptItem : promptItemsList) {
            this.insert(newPus, insertIndex, promptItem);
            ++insertIndex;
        }
        int endInsertIndex = insertIndex - 1;
        this.promptItemTableModel.setPromptUnits(newPus);
        insertStateEdit.end();
        this.undoManager.addEdit(insertStateEdit);
        this.promptItemsTable.setRowSelectionInterval(startInsertIndex, endInsertIndex);
        this.updateEditActions();
    }

    private void applyItemCode(Recording recording) {
        String itemcode = recording.getItemcode();
        if (this.itemcodeGenerator.getConfig().isActive() && (itemcode == null || "".equals(itemcode) || this.itemCodesList.contains((Object)itemcode))) {
            HashSet<String> ics = new HashSet<String>((Collection<String>)this.itemCodesList);
            this.itemcodeGenerator.toNext(ics);
            String icGen = this.itemcodeGenerator.getItemCode();
            recording.setItemcode(icGen);
        }
        this.itemCodesList.add((Object)recording.getItemcode());
    }

    public void insertPromptGroups(List<Group> promptGroupsList) {
        StateEdit insertStateEdit = new StateEdit(this, "Insert prompt units");
        this.stopCellEditing();
        int insertPisSize = 0;
        for (Group g : promptGroupsList) {
            g.setSection(this.section);
            for (PromptItem gPi : g.getPromptItems()) {
                if (gPi instanceof Recording) {
                    Recording recording = (Recording)gPi;
                    this.applyItemCode(recording);
                }
                ++insertPisSize;
            }
        }
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        int startInsertIndex = 0;
        if (!selModel.isSelectionEmpty()) {
            startInsertIndex = selModel.getMaxSelectionIndex() + 1;
        }
        List<Group> newPgs = this.promptUnitsCopy(this.promptItemTableModel.getPromptUnits());
        int insertIndex = startInsertIndex;
        int currIndex = 0;
        List<Group> currPgs = this.promptItemTableModel.getPromptUnits();
        int pgsSize = currPgs.size();
        boolean inserted = false;
        int pgi = 0;
        while (pgi < pgsSize) {
            Group g = currPgs.get(pgi);
            List pis = g.getPromptItems();
            int pisSize = pis.size();
            if (insertIndex >= currIndex && insertIndex <= currIndex + pisSize) {
                insertIndex = currIndex + pisSize;
                newPgs.addAll(pgi + 1, promptGroupsList);
                inserted = true;
                break;
            }
            currIndex += pisSize;
            ++pgi;
        }
        if (!inserted) {
            newPgs.addAll(promptGroupsList);
            insertIndex = currIndex;
        }
        int endInsertIndex = insertIndex + insertPisSize - 1;
        this.promptItemTableModel.setPromptUnits(newPgs);
        insertStateEdit.end();
        this.undoManager.addEdit(insertStateEdit);
        this.setRowSelectionIntervalSave(insertIndex, endInsertIndex);
        this.updateEditActions();
    }

    private void setRowSelectionIntervalSave(int startInsertIndex, int endInsertIndex) {
        int rc = this.promptItemsTable.getRowCount();
        if (startInsertIndex < 0 || endInsertIndex < 0) {
            return;
        }
        if (startInsertIndex >= rc) {
            startInsertIndex = rc - 1;
        }
        if (endInsertIndex >= rc) {
            endInsertIndex = rc - 1;
        }
        this.promptItemsTable.setRowSelectionInterval(startInsertIndex, endInsertIndex);
    }

    private void validateSelectionModel() {
        int rc = this.promptItemsTable.getRowCount();
        ListSelectionModel listSelectionModel = this.promptItemsTable.getSelectionModel();
        if (listSelectionModel != null && !listSelectionModel.isSelectionEmpty()) {
            int minSelIdx = listSelectionModel.getMinSelectionIndex();
            int maxSelIdx = listSelectionModel.getMaxSelectionIndex();
            if (minSelIdx >= rc || maxSelIdx >= rc) {
                System.err.println("Selection out of range: row count: " + rc + ",min sel Idx: " + minSelIdx + ",max sel Idx: " + maxSelIdx + ",adjusting:" + listSelectionModel.getValueIsAdjusting());
                System.err.println("Clearing invalid list selection");
                listSelectionModel.clearSelection();
            }
        }
    }

    private boolean isContinousSelection() {
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return false;
        }
        int i = selModel.getMinSelectionIndex();
        while (i <= selModel.getMaxSelectionIndex()) {
            if (!selModel.isSelectedIndex(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSelectionGroupable() {
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return false;
        }
        int tidx = 0;
        int continousInSelCnt = 0;
        boolean selComplete = false;
        List<Group> pus = this.promptItemTableModel.getPromptUnits();
        for (Group g : pus) {
            List pis = g.getPromptItems();
            boolean realGroup = pis.size() > 1;
            for (PromptItem pi : pis) {
                if (realGroup) {
                    if (selModel.isSelectedIndex(tidx)) {
                        return false;
                    }
                    ++tidx;
                    continue;
                }
                if (selModel.isSelectedIndex(tidx)) {
                    if (selComplete) {
                        return false;
                    }
                    ++continousInSelCnt;
                } else if (continousInSelCnt > 0) {
                    selComplete = true;
                }
                ++tidx;
            }
        }
        return continousInSelCnt > 1;
    }

    private boolean isSelectionGroupsOnly() {
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        boolean atLeastOneGroupSelected = false;
        if (!selModel.isSelectionEmpty()) {
            int tidx = 0;
            List<Group> pus = this.promptItemTableModel.getPromptUnits();
            for (Group g : pus) {
                List pis = g.getPromptItems();
                boolean realGroup = pis.size() > 1;
                boolean groupSelected = selModel.isSelectedIndex(tidx);
                if (!realGroup && groupSelected) {
                    return false;
                }
                for (PromptItem pi : pis) {
                    boolean piSel = selModel.isSelectedIndex(tidx);
                    if (piSel != groupSelected) {
                        return false;
                    }
                    ++tidx;
                }
                if (!groupSelected) continue;
                atLeastOneGroupSelected = true;
            }
        }
        return atLeastOneGroupSelected;
    }

    private void groupSelectedItems() {
        if (this.isSelectionGroupable()) {
            StateEdit groupItsStateEdit = new StateEdit(this, "Group prompt items");
            this.stopCellEditing();
            ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
            ArrayList<Integer> selPis = new ArrayList<Integer>();
            ArrayList<Group> newGs = new ArrayList<Group>();
            List<Group> gs = this.promptItemTableModel.getPromptUnits();
            int piIdx = 0;
            Group newGroup = null;
            for (Group g : gs) {
                boolean realGroup;
                List pis = g.getPromptItems();
                int pisSize = pis.size();
                boolean bl = realGroup = pisSize > 1;
                if (realGroup) {
                    if (newGroup != null) {
                        newGs.add(newGroup);
                        newGroup = null;
                    }
                    newGs.add(g);
                } else {
                    PromptItem pi = (PromptItem)pis.get(0);
                    if (selModel.isSelectedIndex(piIdx)) {
                        selPis.add(piIdx);
                        if (newGroup == null) {
                            newGroup = new Group();
                            if (this.sequenceGenerator != null) {
                                newGroup.setGroupId(this.sequenceGenerator.getAndIncrement());
                            }
                        }
                        newGroup.getPromptItems().add(pi);
                    } else {
                        if (newGroup != null) {
                            newGs.add(newGroup);
                            newGroup = null;
                        }
                        newGs.add(g);
                    }
                }
                piIdx += pisSize;
            }
            if (newGroup != null) {
                newGs.add(newGroup);
                newGroup = null;
            }
            this.promptItemTableModel.setPromptUnits(newGs);
            groupItsStateEdit.end();
            this.undoManager.addEdit(groupItsStateEdit);
            this.updateEditActions();
            selModel.clearSelection();
            for (Integer selIdx : selPis) {
                selModel.addSelectionInterval(selIdx, selIdx);
            }
        }
    }

    private List<Group> selectedGroups() {
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        List<Group> pus = this.promptItemTableModel.getPromptUnits();
        ArrayList<Group> selGroups = new ArrayList<Group>();
        int tidx = 0;
        for (Group g : pus) {
            List pis = g.getPromptItems();
            boolean realGroup = pis.size() > 1;
            boolean groupSelected = selModel.isSelectedIndex(tidx);
            if (realGroup) {
                for (PromptItem pi : pis) {
                    boolean piSel = selModel.isSelectedIndex(tidx);
                    if (piSel != groupSelected) {
                        return null;
                    }
                    ++tidx;
                }
                if (!groupSelected) continue;
                selGroups.add(g);
                continue;
            }
            if (groupSelected) {
                return null;
            }
            ++tidx;
        }
        return selGroups;
    }

    private void ungroupSelectedItems() {
        this.stopCellEditing();
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        ArrayList<Group> newPus = new ArrayList<Group>();
        List<Group> pus = this.promptItemTableModel.getPromptUnits();
        int tidx = 0;
        for (Group g : pus) {
            boolean groupSelected = selModel.isSelectedIndex(tidx);
            List pis = g.getPromptItems();
            for (PromptItem pi : pis) {
                boolean piSel = selModel.isSelectedIndex(tidx);
                if (piSel != groupSelected) {
                    return;
                }
                ++tidx;
            }
            if (groupSelected) {
                for (PromptItem pi : pis) {
                    Group sg = new Group();
                    sg.setSection(this.section);
                    sg.getPromptItems().add(pi);
                    newPus.add(sg);
                }
                continue;
            }
            newPus.add(g);
        }
        StateEdit ungroupItsStateEdit = new StateEdit(this, "Ungroup prompt items");
        this.promptItemTableModel.setPromptUnits(newPus);
        ungroupItsStateEdit.end();
        this.undoManager.addEdit(ungroupItsStateEdit);
        this.updateEditActions();
    }

    private void toggleGroupRandom() {
        Object selrandomObj;
        List<Group> selGrps = this.selectedGroups();
        if (selGrps != null && (selrandomObj = this.toggleGroupRandomAction.getValue("SwingSelectedKey")) instanceof Boolean) {
            boolean random = (Boolean)selrandomObj;
            for (Group selGr : selGrps) {
                if (random) {
                    selGr.setOrder(Group.Order.RANDOM);
                    continue;
                }
                selGr.setOrder(Group.Order.SEQUENTIAL);
            }
        }
    }

    public ToggleGroupRandomAction getToggleGroupRandomAction() {
        return this.toggleGroupRandomAction;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.userSelection = false;
        this.updateEditActions();
        this.userSelection = true;
    }

    private void updateEditActions() {
        boolean editorEnabled = super.isEnabled();
        boolean clipBoardAvail = false;
        try {
            clipBoardAvail = this.clipboard.isDataFlavorAvailable(PromptItem.CLASS_DATA_FLAVOR) || this.clipboard.isDataFlavorAvailable(PromptItemsList.CLASS_DATA_FLAVOR) || this.clipboard.isDataFlavorAvailable(PromptGroupsList.CLASS_DATA_FLAVOR);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pasteAction.setEnabled(editorEnabled && clipBoardAvail);
        ListSelectionModel selModel = this.promptItemsTable.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            this.copyAction.setEnabled(false);
            this.cutAction.setEnabled(false);
        } else {
            this.copyAction.setEnabled(editorEnabled);
            this.cutAction.setEnabled(editorEnabled);
            if (this.editActionsListener != null && this.userSelection) {
                this.editActionsListener.providesEditActions((Object)this, this.editActions);
            }
        }
        boolean groupable = this.isSelectionGroupable();
        this.groupItemsAction.setEnabled(groupable);
        List<Group> selGrps = this.selectedGroups();
        boolean selectionGroupsOnly = this.isSelectionGroupsOnly();
        this.ungroupItemsAction.setEnabled(selectionGroupsOnly);
        boolean toggleRandomGroupEnabled = selGrps != null && selGrps.size() == 1;
        this.toggleGroupRandomAction.setEnabled(toggleRandomGroupEnabled);
        if (toggleRandomGroupEnabled) {
            Group selGrp = selGrps.get(0);
            Group.Order grOrder = selGrp.getNNOrder();
            boolean grIsRandom = Group.Order.RANDOM.equals((Object)grOrder);
            this.toggleGroupRandomAction.putValue("SwingSelectedKey", grIsRandom);
        }
        this.addRecordingAction.setEnabled(editorEnabled);
        this.addNonRecordingAction.setEnabled(editorEnabled);
        this.undoAction.update(this.undoManager);
        this.redoAction.update(this.undoManager);
    }

    private void setDeepEnabled(Container c, boolean b) {
        Component[] componentArray = c.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc = componentArray[n2];
            if (cc instanceof Container) {
                this.setDeepEnabled((Container)cc, b);
            }
            cc.setEnabled(b);
            ++n2;
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setDeepEnabled(this, b);
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public EditActionsListener getEditActionListener() {
        return this.editActionsListener;
    }

    public void setEditActionListener(EditActionsListener editActionsListener) {
        this.editActionsListener = editActionsListener;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.updateEditActions();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public List<Action> getNewActionsList() {
        return this.newActionsList;
    }

    public void providesEditActions(Object src, EditActions editActions) {
        if (this.editActionsListener != null) {
            this.editActionsListener.providesEditActions(src, editActions);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        List<Group> pus = this.promptItemTableModel.getPromptUnits();
        for (Group g : pus) {
            for (PromptItem pi : g.getPromptItems()) {
                if (!(pi instanceof Recording)) continue;
                Recording r = (Recording)pi;
                String ic = r.getItemcode();
                this.itemCodesList.remove((Object)ic);
            }
        }
        List tablepromptItems = (List)state.get("promptUnits");
        for (Group g : tablepromptItems) {
            for (PromptItem pi : g.getPromptItems()) {
                if (!(pi instanceof Recording)) continue;
                Recording r = (Recording)pi;
                String ic = r.getItemcode();
                this.itemCodesList.add((Object)ic);
            }
        }
        this.setTablePromptUnits(tablepromptItems);
        Integer selRow = (Integer)state.get("_promptItems.selected_row");
        if (selRow == null || selRow == -1) {
            this.promptItemsTable.clearSelection();
        } else {
            this.promptItemsTable.setRowSelectionInterval(selRow, selRow);
        }
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        state.put("promptUnits", this.promptItemTableModel.getPromptUnits());
        state.put("_promptItems.selected_row", this.promptItemsTable.getSelectedRow());
    }

    public void setSelectedPromptItem(PromptItem pi) {
        if (pi != null) {
            List<PromptItem> pis = this.promptItemTableModel.promptItems();
            int i = 0;
            while (i < pis.size()) {
                PromptItem tPi = pis.get(i);
                if (tPi.getRecpromptId() == pi.getRecpromptId()) {
                    this.promptItemsTable.setRowSelectionInterval(i, i);
                    break;
                }
                ++i;
            }
        }
    }

    public void setDefaultPromptFont(Font promptFont) {
        this.defaultPromptFont = promptFont;
        if (this.promptItemEditor != null) {
            this.promptItemEditor.setDefaultPromptFont(this.defaultPromptFont);
        }
    }

    public Section.Mode getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Section.Mode defaultMode) {
        this.defaultMode = defaultMode;
        if (defaultMode != null) {
            this.modes.getItem(null).setDisplayName(String.valueOf(defaultMode.toString()) + " (Default)");
        }
    }

    public int getDefaultPreRecording() {
        return this.defaultPreRecording;
    }

    public void setDefaultPreRecording(int defaultPreRecording) {
        this.defaultPreRecording = defaultPreRecording;
        if (this.promptItemEditor != null) {
            this.promptItemEditor.setDefaultPreRecording(defaultPreRecording);
        }
    }

    public int getDefaultPostRecording() {
        return this.defaultPostRecording;
    }

    public void setDefaultPostRecording(int defaultPostRecording) {
        this.defaultPostRecording = defaultPostRecording;
        if (this.promptItemEditor != null) {
            this.promptItemEditor.setDefaultPostRecording(defaultPostRecording);
        }
    }

    public boolean isDefaultPromptAutoPlay() {
        return this.defaultPromptAutoPlay;
    }

    public void setDefaultPromptAutoPlay(boolean defaultPromptAutoPlay) {
        this.defaultPromptAutoPlay = defaultPromptAutoPlay;
        if (this.promptItemEditor != null) {
            this.promptItemEditor.setDefaultPromptAutoPlay(defaultPromptAutoPlay);
        }
    }

    protected void releaseListeners() {
        this.promptItemEditor.releaseListeners();
        this.promptItemTableModel.releaseListeners();
        if (this.section != null) {
            this.section.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    static class EnumSel {
        private String displayName;
        private Enum<?> string;

        public EnumSel(Enum<?> e, String displayName) {
            this.string = e;
            this.displayName = displayName;
        }

        public EnumSel(Enum<?> e) {
            this(e, e == null ? null : e.toString());
        }

        public Enum<?> getEnum() {
            return this.string;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof EnumSel) {
                EnumSel mo = (EnumSel)o;
                if (this.string == null ? mo.getEnum() == null : this.string.equals(mo.getEnum())) {
                    return true;
                }
            }
            return false;
        }
    }

    public class ItemCodeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public ItemCodeCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof String) {
                int answ;
                String ic = (String)value;
                if (SectionUI.this.itemCodesInUse != null && SectionUI.this.itemCodesInUse.contains(ic) && (answ = JOptionPane.showConfirmDialog(table, "Itemcode " + ic + " is already in use. There exists at least one recording file for this prompt.\nIf you rename this itemcode the recordings will not be visible anymore.\nDo you want, nevertheless, change the itemcode ?", "Change item code", 0)) != 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ItemCodeCellEditor.this.stopCellEditing();
                        }
                    });
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

