/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.Font;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class PromptDocEditorKit
extends StyledEditorKit {
    @Override
    public String getContentType() {
        return "text/x-prompt";
    }

    @Override
    public Document createDefaultDocument() {
        return new PromptStyledDocument();
    }

    public static class SetFontSizeAction
    extends StyledEditorKit.StyledTextAction {
        public SetFontSizeAction() {
            super("set-font-size");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null && e instanceof SetFontSizeActionEvent) {
                SetFontSizeActionEvent sfae = (SetFontSizeActionEvent)e;
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                Font.FontSize fs = sfae.getFontSize();
                SimpleAttributeSet sas = new SimpleAttributeSet();
                if (fs == null) {
                    PromptStyledDocument psd;
                    Style defStyle;
                    Object defFontSize;
                    sas.removeAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
                    Document d = editor.getDocument();
                    if (d instanceof PromptStyledDocument && (defFontSize = (defStyle = (psd = (PromptStyledDocument)d).getStyle("default")).getAttribute(StyleConstants.FontSize)) instanceof Number) {
                        Number defFontSizeNumber = (Number)defFontSize;
                        StyleConstants.setFontSize(sas, defFontSizeNumber.intValue());
                    }
                } else {
                    sas.addAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                    StyleConstants.setFontSize(sas, sfae.getSize());
                }
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    public static class SetFontSizeActionEvent
    extends ActionEvent {
        private static final long serialVersionUID = 1L;
        private int size;
        private Font.FontSize fontSize;

        public SetFontSizeActionEvent(Object source, String command, Font.FontSize fontSize, int size) {
            super(source, 1001, command);
            this.fontSize = fontSize;
            this.size = size;
        }

        public Font.FontSize getFontSize() {
            return this.fontSize;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class StrikethroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikethroughAction() {
            super("strike-through");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikethrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikethrough);
                if (strikethrough) {
                    StyleConstants.setUnderline(sas, false);
                }
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    public static class UnderlineAction
    extends StyledEditorKit.StyledTextAction {
        public UnderlineAction() {
            super("underline");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean underline = !StyleConstants.isUnderline(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setUnderline(sas, underline);
                if (underline) {
                    StyleConstants.setStrikeThrough(sas, false);
                }
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }
}

