/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.session;

import ips.annot.BundleAnnotationPersistor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.io.BundleAnnotationFilePersistor;
import ips.annot.model.AnnotatedAudioClip;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Session;
import ipsk.apps.speechrecorder.RecStatus;
import ipsk.apps.speechrecorder.RecWindow;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.SpeechRecorderUI;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.actions.AdvanceToNextAction;
import ipsk.apps.speechrecorder.actions.BackwardAction;
import ipsk.apps.speechrecorder.annotation.AnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationWorker;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotator;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import ipsk.apps.speechrecorder.prompting.PromptViewer;
import ipsk.apps.speechrecorder.prompting.PromptViewerListener;
import ipsk.apps.speechrecorder.prompting.PrompterException;
import ipsk.apps.speechrecorder.prompting.StartPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.StopPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerOpenedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStartedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStoppedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.script.RecScriptChangedEvent;
import ipsk.apps.speechrecorder.script.RecscriptManagerEvent;
import ipsk.apps.speechrecorder.session.SessionActions;
import ipsk.apps.speechrecorder.session.SessionManagerListener;
import ipsk.apps.speechrecorder.session.action.CloseSpeakerDisplayAction;
import ipsk.apps.speechrecorder.session.action.ContinueAutoRecordingAction;
import ipsk.apps.speechrecorder.session.action.ContinuePlaybackAction;
import ipsk.apps.speechrecorder.session.action.ForwardAction;
import ipsk.apps.speechrecorder.session.action.PauseAutoRecordingAction;
import ipsk.apps.speechrecorder.session.action.PausePlaybackAction;
import ipsk.apps.speechrecorder.session.action.RecTransporterActions;
import ipsk.apps.speechrecorder.session.action.SetIndexAction;
import ipsk.apps.speechrecorder.session.action.StartAutoRecordingAction;
import ipsk.apps.speechrecorder.session.action.StartPlaybackAction;
import ipsk.apps.speechrecorder.session.action.StartRecordAction;
import ipsk.apps.speechrecorder.session.action.StopNonrecordingAction;
import ipsk.apps.speechrecorder.session.action.StopPlaybackAction;
import ipsk.apps.speechrecorder.session.action.StopRecordAction;
import ipsk.apps.speechrecorder.session.progress.ProgressManager;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerEvent;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerException;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerListener;
import ipsk.apps.speechrecorder.session.progress.SessionPositionChangedEvent;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioController4;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.audio.FileAudioSource;
import ipsk.audio.PluginChain;
import ipsk.audio.URLAudioSource;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.capture.BufferOverrunException;
import ipsk.audio.capture.event.CaptureCloseEvent;
import ipsk.audio.capture.event.CaptureErrorEvent;
import ipsk.audio.capture.event.CaptureEvent;
import ipsk.audio.capture.event.CaptureRecordedEvent;
import ipsk.audio.capture.event.CaptureRecordingFileTransitEvent;
import ipsk.audio.capture.event.CaptureStartCaptureEvent;
import ipsk.audio.capture.event.CaptureStartRecordEvent;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.speech.SpeechFinalSilenceDetector;
import ipsk.audio.dsp.speech.SpeechFinalSilenceDetectorEvent;
import ipsk.audio.dsp.speech.SpeechFinalSilenceDetectorListener;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetector;
import ipsk.audio.dsp.speech.vad.impl.VoicedSpeechDetector;
import ipsk.audio.io.push.FloatAudioOutputStream;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.VolumeControlPlugin;
import ipsk.awt.ProgressListener;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import ipsk.text.EncodeException;
import ipsk.text.ParserException;
import ipsk.util.SystemHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class SessionManager
implements ActionListener,
AudioController2.AudioController2Listener,
ProgressManagerListener,
PromptViewerListener,
ProgressListener,
PlayerListener,
SpeechFinalSilenceDetectorListener,
AnnotationManager {
    public static final boolean DEBUG = false;
    public final boolean USE_MAX_REC_TIMER = true;
    private final double MIN_EXPECTED_REC_LEN_TOLERANCE = 0.9;
    private final int MIN_EXPECTED_REC_LEN_LNE_ACTIVATION_MS_DEFAULT = 250;
    private long RECORD_RETRY_DELAY = 3000L;
    private static final boolean DEBUG_AUDIO_QUALITY_FAKE_CHECK_FAIL = false;
    private UIResources uiString;
    private boolean debugSinusTest = false;
    private StartRecordAction startRecordAction;
    private StopRecordAction stopRecordAction;
    private StopNonrecordingAction stopNonrecordingAction;
    private StartAutoRecordingAction startAutoRecordingAction;
    private PauseAutoRecordingAction pauseAutoRecordingAction;
    private ContinueAutoRecordingAction continueAutoRecordingAction;
    private AdvanceToNextAction advanceToNextAction;
    private ForwardAction forwardAction;
    private BackwardAction backwardAction;
    private StartPlaybackAction startPlaybackAction;
    private PausePlaybackAction pausePlaybackAction;
    private StopPlaybackAction stopPlaybackAction;
    private ContinuePlaybackAction continuePlaybackAction;
    private SetIndexAction setIndexAction;
    private CloseSpeakerDisplayAction closeSpeakerDisplayAction;
    public Action[] actions = null;
    private Logger logger;
    private Logger timeLogger;
    private SessionManagerListener listener;
    private SpeechRecorderUI speechRecorderUI;
    private RecStatus recStat;
    private boolean useUploadCache;
    private SessionActions sessionActions;
    private RecTransporterActions recTransporterActions;
    private AudioController4 audioController;
    private boolean audioEnabled = false;
    private URL beepURL;
    private Player beepPlayer;
    private ActiveSessionStorageManager storageManager;
    private AutoAnnotationManager autoAnnotationManager = new AutoAnnotationManager();
    private boolean overwrite;
    private boolean overwriteWarning;
    private boolean defaultShowSpeakerWindow;
    private ProgressManager progressManager;
    private AnnotatedAudioClip audioClip = new AnnotatedAudioClip();
    private RecordingConfiguration.CaptureScope captureScope = RecordingConfiguration.CaptureScope.ITEM;
    private RepeatRequest repeatRequest = null;
    private AutoAnnotationWorker autoAnnotationWorker;
    private boolean seamlessAutoRecording = false;
    private Section.Mode defaultSectionMode;
    private boolean resetPeakOnRecording;
    private boolean progressToNextUnrecorded;
    private AudioSource beepAudioSource;
    private VoiceActivityDetector voiceDetector;
    private SpeechFinalSilenceDetector silenceDetector;
    private List<AutoAnnotator> enabledAutoAnnotators = new ArrayList<AutoAnnotator>();
    private List<BundleAnnotationPersistor> bundleAnnotationPersistorList = new ArrayList<BundleAnnotationPersistor>();
    private PromptAutoAnnotator promptAutoAnnotator;
    private TemplateAutoAnnotator templateAutoAnnotator;
    private Section.Mode sectionMode = null;
    private PromptItem promptItem;
    private String promptItemCode = null;
    private boolean progressPaused = true;
    private boolean advanceToNextRequest = false;
    private boolean incrementIndexRequest = false;
    private boolean decrementIndexRequest = false;
    private Integer skipToRequest = null;
    private boolean recDisplayValid = false;
    private boolean speakerWindow;
    private Script script = null;
    private Session annotationSession = null;
    private boolean sessionOverwriteWarning = true;
    private boolean recManualPlay = false;
    private boolean allRecordingsDoneNotified;
    private boolean lastSpeakerWindowRequest;
    private Timer preRecTimer;
    private Timer postRecTimer;
    private Timer maxRecTimer;
    private Timer nonRecordingTimer;
    public boolean useMaxRecTimer = true;
    private Double beepVolume;
    private boolean forcePostRecPhase;
    private boolean itemPlayable;
    private boolean annotatingEnabled = false;

    public StartPlaybackAction getStartPlaybackAction() {
        return this.startPlaybackAction;
    }

    public SetIndexAction getSetIndexAction() {
        return this.setIndexAction;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public SessionManagerListener getListener() {
        return this.listener;
    }

    public void setListener(SessionManagerListener listener) {
        this.listener = listener;
    }

    public SpeechRecorderUI getSpeechRecorderUI() {
        return this.speechRecorderUI;
    }

    public void setSpeechRecorderUI(SpeechRecorderUI ui) {
        this.speechRecorderUI = ui;
        StartPromptPlaybackAction startPromptAction = this.speechRecorderUI.getPrompter().getStartPromptPlaybackAction();
        StopPromptPlaybackAction stopPromptAction = this.speechRecorderUI.getPrompter().getStopPromptPlaybackAction();
        this.actions = new Action[]{this.startRecordAction, this.stopRecordAction, this.startAutoRecordingAction, this.pauseAutoRecordingAction, this.continueAutoRecordingAction, startPromptAction, stopPromptAction, this.advanceToNextAction, this.forwardAction, this.backwardAction, this.startPlaybackAction, this.pausePlaybackAction, this.stopPlaybackAction, this.continuePlaybackAction, this.closeSpeakerDisplayAction};
    }

    public boolean isUseUploadCache() {
        return this.useUploadCache;
    }

    public void setUseUploadCache(boolean useUploadCache) {
        this.useUploadCache = useUploadCache;
    }

    public RecTransporterActions getRecTransporterActions() {
        return this.recTransporterActions;
    }

    public AudioController4 getAudioController() {
        return this.audioController;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public void setAudioEnabled(boolean audioEnabled) {
        this.audioEnabled = audioEnabled;
    }

    public URL getBeepURL() {
        return this.beepURL;
    }

    public void setBeepURL(URL beepURL) {
        this.beepURL = beepURL;
    }

    public Player getBeepPlayer() {
        return this.beepPlayer;
    }

    public void setBeepPlayer(Player beepPlayer) {
        this.beepPlayer = beepPlayer;
    }

    public void setAudioController(AudioController4 audioController) {
        this.audioController = audioController;
    }

    public ActiveSessionStorageManager getStorageManager() {
        return this.storageManager;
    }

    public void setStorageManager(ActiveSessionStorageManager storageManager) {
        this.storageManager = storageManager;
        this.progressManager.setStorageManager(storageManager);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwriteWarning() {
        return this.overwriteWarning;
    }

    public void setOverwriteWarning(boolean overwriteWarning) {
        this.overwriteWarning = overwriteWarning;
    }

    public boolean isDefaultShowSpeakerWindow() {
        return this.defaultShowSpeakerWindow;
    }

    public void setDefaultShowSpeakerWindow(boolean defaultShowSpeakerWindow) {
        this.defaultShowSpeakerWindow = defaultShowSpeakerWindow;
    }

    public ProgressManager getProgressManager() {
        return this.progressManager;
    }

    public AnnotatedAudioClip getAudioClip() {
        return this.audioClip;
    }

    public void setAudioClip(AnnotatedAudioClip audioClip) {
        this.audioClip = audioClip;
    }

    public RecordingConfiguration.CaptureScope getCaptureScope() {
        return this.captureScope;
    }

    public void setCaptureScope(RecordingConfiguration.CaptureScope captureScope) {
        this.captureScope = captureScope;
    }

    public boolean isSeamlessAutoRecording() {
        return this.seamlessAutoRecording;
    }

    public void setSeamlessAutoRecording(boolean seamlessAutoRecording) {
        this.seamlessAutoRecording = seamlessAutoRecording;
    }

    public Section.Mode getDefaultSectionMode() {
        return this.defaultSectionMode;
    }

    public void setDefaultSectionMode(Section.Mode defaultSectionMode) {
        this.defaultSectionMode = defaultSectionMode;
    }

    public boolean isResetPeakOnRecording() {
        return this.resetPeakOnRecording;
    }

    public void setResetPeakOnRecording(boolean resetPeakOnRecording) {
        this.resetPeakOnRecording = resetPeakOnRecording;
    }

    public boolean isProgressToNextUnrecorded() {
        return this.progressToNextUnrecorded;
    }

    public void setProgressToNextUnrecorded(boolean progressToNextUnrecorded) {
        this.progressToNextUnrecorded = progressToNextUnrecorded;
    }

    public List<AutoAnnotator> getEnabledAutoAnnotators() {
        return this.enabledAutoAnnotators;
    }

    public void setEnabledAutoAnnotators(List<AutoAnnotator> enabledAutoAnnotators) {
        this.enabledAutoAnnotators = enabledAutoAnnotators;
    }

    public List<BundleAnnotationPersistor> getBundleAnnotationPersistorList() {
        return this.bundleAnnotationPersistorList;
    }

    public void setBundleAnnotationPersistorList(List<BundleAnnotationPersistor> bundleAnnotationPersistorList) {
        this.bundleAnnotationPersistorList = bundleAnnotationPersistorList;
    }

    public boolean isSpeakerWindowShowing() {
        return this.speakerWindow;
    }

    public SessionManager() {
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.timeLogger = Logger.getLogger("time");
        this.recStat = RecStatus.getInstance();
        this.progressManager = new ProgressManager();
        this.uiString = UIResources.getInstance();
        this.startRecordAction = new StartRecordAction(this, this.uiString.getString("RecordingButtonText"));
        this.startRecordAction.setEnabled(false);
        this.stopRecordAction = new StopRecordAction(this, this.uiString.getString("StopButtonText"));
        this.stopRecordAction.setEnabled(false);
        this.stopNonrecordingAction = new StopNonrecordingAction(this, this.uiString.getString("NextButtonText"));
        this.stopNonrecordingAction.setEnabled(false);
        this.startAutoRecordingAction = new StartAutoRecordingAction(this, this.uiString.getString("StartButtonText"));
        this.pauseAutoRecordingAction = new PauseAutoRecordingAction(this, this.uiString.getString("PauseButtonText"));
        this.continueAutoRecordingAction = new ContinueAutoRecordingAction(this, this.uiString.getString("ContinueButtonText"));
        this.advanceToNextAction = new AdvanceToNextAction(this, this.uiString.getString("AdvanceToNextButtonText"));
        this.forwardAction = new ForwardAction(this, this.uiString.getString("ForwardButtonText"));
        this.backwardAction = new BackwardAction(this, this.uiString.getString("BackwardButtonText"));
        this.startPlaybackAction = new StartPlaybackAction(this, this.uiString.getString("PlayButtonText"));
        this.pausePlaybackAction = new PausePlaybackAction(this, String.valueOf(this.uiString.getString("PlayButtonText")) + "-" + this.uiString.getString("PauseButtonText"));
        this.stopPlaybackAction = new StopPlaybackAction(this, this.uiString.getString("StopButtonText"));
        this.continuePlaybackAction = new ContinuePlaybackAction(this, this.uiString.getString("PlayButtonText"));
        this.closeSpeakerDisplayAction = new CloseSpeakerDisplayAction(this, "Close speaker display");
        this.setIndexAction = new SetIndexAction(this, "Set index");
        this.progressManager.setSetIndexAction(this.setIndexAction);
        this.recTransporterActions = new RecTransporterActions();
        this.recTransporterActions.startRecordAction = this.startRecordAction;
        this.recTransporterActions.stopRecordAction = this.stopRecordAction;
        this.recTransporterActions.stopNonrecordingAction = this.stopNonrecordingAction;
        this.recTransporterActions.startAutoRecordingAction = this.startAutoRecordingAction;
        this.recTransporterActions.pauseAutoRecordingAction = this.pauseAutoRecordingAction;
        this.recTransporterActions.continueAutoRecordingAction = this.continueAutoRecordingAction;
        this.recTransporterActions.advanceToNextAction = this.advanceToNextAction;
        this.recTransporterActions.forwardAction = this.forwardAction;
        this.recTransporterActions.backwardAction = this.backwardAction;
        this.recTransporterActions.startPlaybackAction = this.startPlaybackAction;
        this.recTransporterActions.pausePlaybackAction = this.pausePlaybackAction;
        this.recTransporterActions.stopPlaybackAction = this.stopPlaybackAction;
        this.recTransporterActions.continuePlaybackAction = this.continuePlaybackAction;
        this.sessionActions = new SessionActions();
        this.sessionActions.recTransporterActions = this.recTransporterActions;
        this.sessionActions.closeSpeakerDisplayAction = this.closeSpeakerDisplayAction;
        this.sessionActions.setIndexAction = this.setIndexAction;
        this.debugSinusTest = System.getProperty("debug.sinustest") != null;
    }

    public Script getScript() {
        return this.script;
    }

    public List<AutoAnnotator> getAutoAnnotators() {
        if (this.autoAnnotationWorker != null) {
            return this.autoAnnotationWorker.getAutoAnnotators();
        }
        return null;
    }

    public boolean isRecManualPlay() {
        return this.recManualPlay;
    }

    public void setRecManualPlay(boolean recManualPlay) {
        this.recManualPlay = recManualPlay;
    }

    public boolean isItemPlayable() {
        return this.itemPlayable;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.maxRecTimer) {
            this.preRecTimer.stop();
            if (this.forcePostRecPhase) {
                this.startPostRecordingPhase();
            } else {
                try {
                    this.stopRecording();
                }
                catch (AudioControllerException ex) {
                    this.speechRecorderUI.displayError("Audiocontroller error", "Error on stop of audio recording\n" + ex.getLocalizedMessage());
                    ex.printStackTrace();
                    this.logger.severe(ex.getMessage());
                }
            }
        } else if (src == this.preRecTimer) {
            if (this.recStat.getStatus() == 7) {
                this.startRecordingPhase();
            } else if (this.recStat.getStatus() == 9) {
                if (this.annotatingEnabled) {
                    this.startAnnotation();
                } else {
                    this.setIdle();
                    this.startPrompt();
                }
            }
        } else if (src == this.postRecTimer) {
            try {
                this.stopRecording();
            }
            catch (AudioControllerException ex) {
                this.speechRecorderUI.displayError("Audio controller error ", "Error on stop of audio recording\n" + ex.getLocalizedMessage());
                this.logger.severe(ex.getMessage());
            }
        } else if (src == this.nonRecordingTimer) {
            this.setIdle();
            if (this.isAutoRecording()) {
                this.continueSession();
            }
        }
    }

    public boolean isAutoRecording() {
        return Section.Mode.AUTORECORDING.equals((Object)this.sectionMode);
    }

    public boolean isAutoProgress() {
        return this.isAutoRecording() || Section.Mode.AUTOPROGRESS.equals((Object)this.sectionMode);
    }

    public void setProgressPaused(boolean progressPaused) {
        this.progressPaused = progressPaused;
        this.speechRecorderUI.setProgressPaused(progressPaused);
    }

    public boolean getProgressPaused() {
        return this.progressPaused;
    }

    public boolean isForcePostRecPhase() {
        return this.forcePostRecPhase;
    }

    public void setForcePostRecPhase(boolean forcePostRecPhase) {
        this.forcePostRecPhase = forcePostRecPhase;
    }

    private void setEditingEnabled(boolean b) {
        if (this.listener != null) {
            this.listener.setEditingEnabled(b);
        }
    }

    private int preRecDelay(Recording r) {
        return r.getNNPrerecdelay();
    }

    private int postRecDelay(Recording r) {
        return r.getNNPostrecdelay();
    }

    private int minRecLengthMs(Recording r) {
        int preRecDelay = this.preRecDelay(r);
        int postRecDelay = this.postRecDelay(r);
        return preRecDelay + postRecDelay;
    }

    private Bundle loadBundle(BundleAnnotationFilePersistor bafp, File annoFile, Bundle bundle) {
        if (annoFile.exists()) {
            bafp.setFile(annoFile);
            try {
                Bundle annotBundle = bafp.load(bundle);
                return annotBundle;
            }
            catch (IOException ioe) {
                this.speechRecorderUI.displayError("Could not read annotation file \"" + annoFile + "\"", ioe);
            }
            catch (ParserException pe) {
                this.speechRecorderUI.displayError("Annotation parsing error", "Could not read/parse annotation file \"" + annoFile + "\":\n" + pe.getMessage());
            }
        }
        return null;
    }

    private synchronized void setRecDisplay() {
        block20: {
            Integer recIndex = this.progressManager.getRecIndex();
            if (recIndex != null && this.progressManager.getRecCounter(recIndex) > 0) {
                if (this.useUploadCache) {
                    try {
                        File[] recFiles = this.storageManager.getCachedInputFiles();
                        if (recFiles != null) {
                            this.audioClip.setBundle(null);
                            this.audioClip.setAudioSource((AudioSource)new FileAudioSource(recFiles[0]));
                            break block20;
                        }
                        this.audioClip.setBundle(null);
                        this.audioClip.setAudioSource(null);
                    }
                    catch (Exception e) {
                        this.speechRecorderUI.displayError("Audio system error", "Cannot get audio stream.");
                    }
                } else {
                    String msg;
                    URL[] audioFileURLs = null;
                    try {
                        audioFileURLs = this.storageManager.generateAudioFileURLs();
                    }
                    catch (StorageManagerException e) {
                        e.printStackTrace();
                        msg = "Storage Exception: " + e.getLocalizedMessage();
                        this.logger.severe(msg);
                        this.speechRecorderUI.displayError("Storage manager error", msg);
                    }
                    try {
                        if (audioFileURLs.length > 1) {
                            throw new AudioSourceException("Mutiple lines are currently not supported.");
                        }
                        File[] audioFiles = null;
                        if (audioFileURLs != null) {
                            audioFiles = new File[audioFileURLs.length];
                            int i = 0;
                            while (i < audioFileURLs.length) {
                                audioFiles[i] = ActiveSessionStorageManager.fileURLToFile(audioFileURLs[i]);
                                ++i;
                            }
                        }
                        Bundle bundle = this.buildBaseBundle(audioFiles);
                        String bundleRootFn = this.storageManager.getRootFileName();
                        URL sessURL = this.storageManager.getSessionURL();
                        File sessDir = ActiveSessionStorageManager.fileURLToFile(sessURL);
                        if (sessDir != null) {
                            File annoFile;
                            BundleAnnotationFilePersistor bafp;
                            Bundle annotBundle = null;
                            for (BundleAnnotationPersistor bap : this.bundleAnnotationPersistorList) {
                                if (bap instanceof BundleAnnotationFilePersistor && bap.isLossless()) {
                                    bafp = (BundleAnnotationFilePersistor)bap;
                                    annoFile = new File(sessDir, String.valueOf(bundleRootFn) + bafp.getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension());
                                    annotBundle = this.loadBundle(bafp, annoFile, bundle);
                                }
                                if (annotBundle != null) break;
                            }
                            if (annotBundle == null) {
                                for (BundleAnnotationPersistor bap : this.bundleAnnotationPersistorList) {
                                    if (!(bap instanceof BundleAnnotationFilePersistor)) continue;
                                    bafp = (BundleAnnotationFilePersistor)bap;
                                    annoFile = new File(sessDir, String.valueOf(bundleRootFn) + bafp.getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension());
                                    annotBundle = this.loadBundle(bafp, annoFile, bundle);
                                }
                            }
                            if (annotBundle != null) {
                                bundle = annotBundle;
                            }
                        }
                        this.audioClip.setAudioSource((AudioSource)new URLAudioSource(audioFileURLs[0]));
                        this.audioClip.setBundle(bundle);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        msg = "Exception: " + ex.getLocalizedMessage();
                        this.logger.severe(msg);
                        this.speechRecorderUI.displayError("Display error", msg);
                    }
                }
            } else {
                this.audioClip.setBundle(null);
                this.audioClip.setAudioSource(null);
            }
        }
    }

    public void open() {
        this.lastSpeakerWindowRequest = false;
        if (this.audioController != null) {
            this.audioController.addAudioController2Listener((AudioController2.AudioController2Listener)this);
        }
        if (this.beepPlayer != null) {
            this.beepPlayer.addPlayerListener((PlayerListener)this);
        }
        this.autoAnnotationWorker = new AutoAnnotationWorker();
        List<AutoAnnotator> wAas = this.autoAnnotationWorker.getAutoAnnotators();
        wAas.clear();
        for (AutoAnnotator aa : this.enabledAutoAnnotators) {
            if (aa instanceof PromptAutoAnnotator) {
                this.promptAutoAnnotator = (PromptAutoAnnotator)aa;
            }
            if (aa instanceof TemplateAutoAnnotator) {
                this.templateAutoAnnotator = (TemplateAutoAnnotator)aa;
            }
            wAas.add(aa);
        }
        this.autoAnnotationWorker.addProgressListener(this);
    }

    public void start(int sessionId, String speakerCode) throws AudioControllerException {
        this.sessionOverwriteWarning = true;
        this.progressManager.addSessionManagerListener(this);
        if (this.storageManager != null) {
            this.storageManager.setSessionID(sessionId);
            this.annotationSession = new Session();
            NumberFormat sessFmt = this.storageManager.getSessionIDFormat();
            String sessNm = sessFmt.format(sessionId);
            this.annotationSession.setName(sessNm);
            this.storageManager.setSpeakerCode(speakerCode);
        }
        try {
            this.storageManager.createSessionDirectory();
            if (this.progressManager != null) {
                this.progressManager.resetItemMarkers();
                this.progressManager.updateItemMarkers();
            }
        }
        catch (ProgressManagerException e1) {
            e1.printStackTrace();
            return;
        }
        catch (StorageManagerException e) {
            e.printStackTrace();
            return;
        }
        if (this.autoAnnotationWorker != null) {
            try {
                this.autoAnnotationWorker.open();
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
            this.autoAnnotationWorker.start();
        }
        if (this.audioEnabled) {
            boolean silenceDetection;
            int itemCount;
            if (this.seamlessAutoRecording) {
                try {
                    URL recSessInfUrl = this.storageManager.getRecordingSessionInfoFile();
                    File recSessInfFile = new File(recSessInfUrl.toURI().getPath());
                    this.audioController.setRecordingSessionInfoFile(recSessInfFile);
                }
                catch (StorageManagerException recSessInfFile) {
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if ((itemCount = this.progressManager.numberOfPromptItems()) > 0) {
                this.progressManager.setRecIndex(0);
            } else {
                this.progressManager.setRecIndex(null);
            }
            this.beepAudioSource = null;
            if (this.progressManager.needsBeep()) {
                URLAudioSource orgBeepAs = new URLAudioSource(this.beepURL);
                if (this.beepVolume != null) {
                    PluginChain beepPc = new PluginChain((AudioSource)orgBeepAs);
                    VolumeControlPlugin vcp = new VolumeControlPlugin();
                    try {
                        beepPc.add((AudioPlugin)vcp);
                    }
                    catch (AudioFormatNotSupportedException e) {
                        e.printStackTrace();
                        String eMsg = "Could not set beep volume: " + e.getMessage();
                        this.logger.severe(eMsg);
                        throw new AudioControllerException(eMsg);
                    }
                    vcp.setGainRatio(this.beepVolume.doubleValue());
                    this.beepAudioSource = beepPc;
                } else {
                    this.beepAudioSource = orgBeepAs;
                }
            }
            if ((silenceDetection = this.progressManager.needsSilenceDetector()) && this.silenceDetector == null) {
                this.voiceDetector = new VoicedSpeechDetector();
                this.silenceDetector = new SpeechFinalSilenceDetector(this.voiceDetector, (SpeechFinalSilenceDetectorListener)this);
            }
            if (RecordingConfiguration.CaptureScope.SESSION.equals((Object)this.captureScope)) {
                if (silenceDetection) {
                    this.audioController.addCaptureFloatAudioOutputStream((FloatAudioOutputStream)this.voiceDetector);
                }
                try {
                    this.audioController.openCapture();
                    this.audioController.startCapture();
                }
                catch (AudioControllerException ace) {
                    this.speechRecorderUI.displayError("Audio controller error", ace);
                    this.closeAudioController();
                }
            }
        }
    }

    public Double getBeepVolume() {
        return this.beepVolume;
    }

    public void setBeepVolume(Double beepVolume) {
        this.beepVolume = beepVolume;
    }

    /*
     * WARNING - void declaration
     */
    public void startItem() {
        this.repeatRequest = null;
        PromptItem promptItem = this.progressManager.getCurrentPromptItem();
        boolean isRecording = promptItem instanceof Recording;
        if (isRecording) {
            File recFile;
            List<Object> annotationFiles = new ArrayList(0);
            try {
                recFile = this.storageManager.getNewRecordingFiles()[0];
                if (!this.useUploadCache && this.bundleAnnotationPersistorList != null && this.bundleAnnotationPersistorList.size() > 0) {
                    annotationFiles = this.currentAnnotationFiles();
                }
            }
            catch (StorageManagerException e) {
                JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), e.getMessage(), "Storage error!", 0);
                e.printStackTrace();
                return;
            }
            boolean overWriteConfirmed = this.overwrite;
            boolean projectOverwriteWarning = this.overwriteWarning;
            if (projectOverwriteWarning && this.sessionOverwriteWarning && !this.useUploadCache) {
                overWriteConfirmed = false;
                boolean bl = recFile.exists();
                int existingAnnoFileCnt = 0;
                for (File file : annotationFiles) {
                    if (!file.exists()) continue;
                    ++existingAnnoFileCnt;
                }
                if (bl) {
                    Object[] objectArray = new Object[]{"No", "Yes", "Yes to all in this session", "Yes to all in this project"};
                    String msg = "Recording file ";
                    if (existingAnnoFileCnt > 0) {
                        msg = msg.concat("and " + existingAnnoFileCnt + " annotation ");
                        msg = existingAnnoFileCnt == 1 ? msg.concat("file ") : msg.concat("files ");
                        msg = msg.concat("already exist!");
                    } else {
                        msg = msg.concat("already exists!");
                    }
                    msg = msg.concat("\nDo you want to overwrite?");
                    int selOpt = JOptionPane.showOptionDialog(this.speechRecorderUI.getDialogTarget(), msg, "Overwrite warning", -1, 2, null, objectArray, objectArray[0]);
                    if (selOpt == -1 || selOpt == 0) {
                        overWriteConfirmed = false;
                        this.setProgressPaused(true);
                        this.setIdle();
                        return;
                    }
                    if (selOpt == 2) {
                        overWriteConfirmed = true;
                        this.sessionOverwriteWarning = false;
                    } else if (selOpt == 3) {
                        overWriteConfirmed = true;
                        if (this.listener != null) {
                            this.listener.requestProjectConfigDisableOverwriteWarning();
                        }
                    }
                }
            }
            if (overWriteConfirmed) {
                for (File file : annotationFiles) {
                    boolean bl;
                    if (!file.exists() || (bl = file.delete())) continue;
                    JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), "Could not delete annotation file " + file.getName(), "Delete error", 0);
                }
            }
        }
        this.setEditingEnabled(false);
        this.sessionActions.setIndexAction.setEnabled(false);
        this.recTransporterActions.startAutoRecordingAction.setEnabled(false);
        this.recTransporterActions.continueAutoRecordingAction.setEnabled(false);
        this.recTransporterActions.startRecordAction.setEnabled(false);
        this.recTransporterActions.stopRecordAction.setEnabled(false);
        this.recTransporterActions.advanceToNextAction.setEnabled(false);
        this.recTransporterActions.forwardAction.setEnabled(false);
        this.recTransporterActions.backwardAction.setEnabled(false);
        this.recTransporterActions.startPlaybackAction.setEnabled(false);
        this.recTransporterActions.stopPlaybackAction.setEnabled(false);
        this.recTransporterActions.pausePlaybackAction.setEnabled(false);
        if (this.isAutoRecording()) {
            this.recTransporterActions.pauseAutoRecordingAction.setEnabled(false);
            this.recTransporterActions.continueAutoRecordingAction.setEnabled(false);
            this.recTransporterActions.startAutoRecordingAction.setEnabled(false);
        }
        if (Section.PromptPhase.IDLE.equals((Object)this.progressManager.currentPromptPhase()) || !isRecording) {
            boolean blocked = true;
            if (this.promptItemCode != null) {
                this.timeLogger.info("PLAY_PROMPT: " + this.promptItemCode);
            } else {
                this.timeLogger.info("PLAY_PROMPT:");
            }
            if (isRecording) {
                Recording recording = (Recording)promptItem;
                blocked = recording.getNNBlocked();
                this.recStat.setStatus(4);
                if (!blocked) {
                    List mis = recording.getMediaitems();
                    boolean containsAudio = false;
                    for (Mediaitem mediaitem : mis) {
                        void var9_27;
                        String string = mediaitem.getNNMimetype();
                        int mimeSep = string.indexOf("/");
                        if (mimeSep > 0) {
                            String string2 = string.substring(0, mimeSep);
                        }
                        if (!var9_27.equalsIgnoreCase("audio")) continue;
                        containsAudio = true;
                        break;
                    }
                    if (containsAudio) {
                        this.startPreRecWaiting();
                    } else {
                        try {
                            this.startBeep();
                        }
                        catch (SpeechRecorderException speechRecorderException) {
                            speechRecorderException.printStackTrace();
                            this.speechRecorderUI.displayError("Beep playback error", speechRecorderException);
                            this.setIdle();
                            this.startPrompt();
                        }
                    }
                }
            } else {
                this.recStat.setStatus(4);
            }
            this.speechRecorderUI.setPromptStartControlEnabled(this.recManualPlay);
            try {
                this.speechRecorderUI.openPlayPrompt();
            }
            catch (PrompterException e) {
                e.printStackTrace();
                this.setIdle();
            }
        } else {
            try {
                this.startBeep();
            }
            catch (SpeechRecorderException e) {
                e.printStackTrace();
                this.speechRecorderUI.displayError("Beep playback error", e);
                this.setIdle();
            }
        }
    }

    private void startNonRecording() {
        PromptItem promptItem = this.progressManager.getCurrentPromptItem();
        Integer duration = null;
        if (promptItem instanceof Nonrecording) {
            Nonrecording nr = (Nonrecording)promptItem;
            duration = nr.getDuration();
        }
        if (duration != null) {
            this.timeLogger.info("NON_RECORDING:");
            this.recStat.setStatus(6);
            this.nonRecordingTimer = new Timer(duration, this);
            this.nonRecordingTimer.setRepeats(false);
            this.nonRecordingTimer.start();
        } else {
            this.setIdle();
            if (this.isAutoRecording()) {
                this.continueSession();
            }
        }
    }

    public void startBeep() throws SpeechRecorderException {
        PromptItem promptItem = this.progressManager.getCurrentPromptItem();
        boolean playBeep = false;
        if (promptItem instanceof Recording) {
            Recording recording = (Recording)promptItem;
            playBeep = new Boolean(recording.getBeep());
        }
        if (playBeep) {
            if (this.promptItemCode != null) {
                this.timeLogger.info("PLAY_BEEP: " + this.promptItemCode);
            } else {
                this.timeLogger.info("PLAY_BEEP:");
            }
            this.recStat.setStatus(5);
            try {
                this.beepPlayer.setAudioSource(this.beepAudioSource);
                if (this.beepPlayer.isOpen()) {
                    System.err.println("Beep player still open!");
                }
                this.beepPlayer.open();
                this.beepPlayer.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                try {
                    this.stopRecording();
                }
                catch (AudioControllerException e1) {
                    throw new SpeechRecorderException(e1);
                }
                this.speechRecorderUI.displayError("Beep playback error", e);
                this.startPreRecWaiting();
            }
        } else {
            this.startPreRecWaiting();
        }
    }

    public void startPreRecWaiting() {
        PromptViewer pv1;
        PromptViewer pv0;
        this.setEditingEnabled(false);
        this.sessionActions.setIndexAction.setEnabled(false);
        this.speechRecorderUI.setLevelMeterMode(3);
        if (this.resetPeakOnRecording) {
            LevelInfo[] lis = this.audioController.getCaptureLevelInfos();
            if (lis != null) {
                LevelInfo[] levelInfoArray = lis;
                int n = lis.length;
                int n2 = 0;
                while (n2 < n) {
                    LevelInfo li = levelInfoArray[n2];
                    li.setPeakLevelHold(0.0f);
                    ++n2;
                }
            }
            this.speechRecorderUI.getLevelMeter().resetPeakHold();
        }
        if (this.promptItemCode != null) {
            this.timeLogger.info("PRERECORDING: " + this.promptItemCode);
        }
        this.recDisplayValid = false;
        this.recStat.setStatus(7);
        this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.PRERECORDING);
        try {
            this.startRecording();
        }
        catch (AudioControllerException e) {
            this.speechRecorderUI.displayError("Audiocontroller error", "Error on start of audio recording\n" + e.getLocalizedMessage());
            this.repeatRequest = new RepeatRequest();
            e.printStackTrace();
            this.setProgressPaused(true);
            this.continueSession();
            return;
        }
        catch (StorageManagerException e) {
            this.speechRecorderUI.displayError("Storage error", "Error on start of audio recording\n" + e.getLocalizedMessage());
            this.repeatRequest = new RepeatRequest();
            e.printStackTrace();
            this.setProgressPaused(true);
            this.continueSession();
            return;
        }
        RecWindow rw = this.speechRecorderUI.getRecWindow();
        if (rw != null && (pv0 = rw.getPromptViewer()) != null) {
            pv0.setInstructionsEmphased(true);
        }
        if ((pv1 = this.speechRecorderUI.getPromptViewer()) != null) {
            pv1.setInstructionsEmphased(true);
        }
        if (Section.PromptPhase.PRERECORDING.equals((Object)this.progressManager.currentPromptPhase())) {
            this.speechRecorderUI.setShowPromptViewers(true);
            this.speechRecorderUI.setPromptStartControlEnabled(this.recManualPlay);
            try {
                this.speechRecorderUI.openPlayPrompt();
            }
            catch (PrompterException e) {
                e.printStackTrace();
                this.setIdle();
            }
        }
    }

    public void startRecordingPhase() {
        this.sessionActions.setIndexAction.setEnabled(false);
        if (this.promptItemCode != null) {
            this.timeLogger.info("RECORDING: " + this.promptItemCode);
        }
        this.speechRecorderUI.getPromptViewer().setInstructionsEmphased(false);
        this.speechRecorderUI.getRecWindow().getPromptViewer().setInstructionsEmphased(false);
        this.speechRecorderUI.getPromptViewer().setPromptEmphased(true);
        this.speechRecorderUI.getRecWindow().getPromptViewer().setPromptEmphased(true);
        if (Section.PromptPhase.RECORDING.equals((Object)this.progressManager.currentPromptPhase())) {
            this.speechRecorderUI.setShowPromptViewers(true);
            this.speechRecorderUI.setPromptStartControlEnabled(false);
            try {
                this.speechRecorderUI.openPlayPrompt();
            }
            catch (PrompterException e) {
                e.printStackTrace();
                this.setIdle();
            }
            if (!this.progressManager.currentPromptBlocking()) {
                this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.RECORDING);
            }
        } else {
            this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.RECORDING);
        }
        this.recStat.setStatus(8);
    }

    public void startPostRecordingPhase() {
        this.sessionActions.setIndexAction.setEnabled(false);
        this.preRecTimer.stop();
        if (this.maxRecTimer != null) {
            this.maxRecTimer.stop();
        }
        if (this.promptItemCode != null) {
            this.timeLogger.info("POSTRECORDING: " + this.promptItemCode);
        }
        this.speechRecorderUI.getPromptViewer().stop();
        this.speechRecorderUI.getRecWindow().getPromptViewer().stop();
        int postRecDelay = this.postRecDelay((Recording)this.promptItem);
        this.postRecTimer = new Timer(postRecDelay, this);
        this.postRecTimer.setRepeats(false);
        this.postRecTimer.start();
        this.recStat.setStatus(9);
        this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.POSTRECORDING);
    }

    public void startRecording() throws AudioControllerException, StorageManagerException {
        PromptItem promptItem = this.progressManager.getCurrentPromptItem();
        if (promptItem instanceof Recording) {
            Recording pi = (Recording)promptItem;
            int preRecDelay = this.preRecDelay(pi);
            this.preRecTimer = new Timer(preRecDelay, this);
            this.maxRecTimer = null;
            Integer recDuration = pi.getRecduration();
            if (recDuration != null) {
                long totalRecTime;
                int postRecDelay = pi.getNNPostrecdelay();
                long recTime = totalRecTime = (long)(preRecDelay + recDuration + postRecDelay);
                if (this.forcePostRecPhase) {
                    recTime = preRecDelay + recDuration;
                }
                if (this.useMaxRecTimer || this.seamlessAutoRecording) {
                    this.maxRecTimer = new Timer((int)recTime, this);
                    this.maxRecTimer.setDelay((int)recTime);
                    this.maxRecTimer.setRepeats(false);
                } else {
                    float frameRate = this.audioController.getAudioFileFormat().getFormat().getFrameRate();
                    long maxFrameLength = (long)((float)totalRecTime * frameRate) / 1000L;
                    this.audioController.setMaxRecordingFrameLength(Long.valueOf(maxFrameLength));
                }
            }
            this.preRecTimer.setDelay(preRecDelay);
            this.preRecTimer.setRepeats(false);
            this.audioClip.setAudioSource(null);
            File recFile = this.storageManager.getCurrentItemRecordingFiles()[0];
            this.audioController.setRecordingFile(recFile);
            boolean silenceDetection = pi.needsSilenceDetector();
            Integer finalSilence = pi.getFinalsilence();
            if (silenceDetection) {
                this.silenceDetector.setSilencelength((double)finalSilence.intValue() / 1000.0);
            }
            if (this.debugSinusTest) {
                // empty if block
            }
            if (!this.audioController.isCaptureOpen()) {
                if (silenceDetection) {
                    this.audioController.addCaptureFloatAudioOutputStream((FloatAudioOutputStream)this.voiceDetector);
                }
                this.audioController.openCapture();
                this.audioController.startRecording();
            } else {
                this.audioController.startRecording();
            }
            if (silenceDetection) {
                this.silenceDetector.start();
            }
        }
    }

    public synchronized void stopRecording() throws AudioControllerException {
        if (this.preRecTimer != null) {
            this.preRecTimer.stop();
        }
        if (this.maxRecTimer != null) {
            this.maxRecTimer.stop();
        }
        if (this.isAutoRecording() && this.seamlessAutoRecording && !this.progressPaused) {
            this.progressManager.incrementRecCounter(this.progressManager.getRecIndex());
            this.continueSession();
        } else {
            try {
                boolean continueCapture = RecordingConfiguration.CaptureScope.SESSION.equals((Object)this.captureScope);
                this.audioController.stopRecording(continueCapture);
            }
            catch (AudioControllerException e) {
                this.speechRecorderUI.displayError("Audiocontroller error", "Technical error: \n" + e.getLocalizedMessage() + "\nPlease press OK.\nthe recording will be repeated.");
                this.logger.severe(e.getMessage());
            }
            this.logger.fine("Recording stopped");
        }
    }

    public synchronized void stopNonrecording() {
        if (this.nonRecordingTimer != null) {
            this.nonRecordingTimer.stop();
        }
        if (this.speechRecorderUI.isPromptClosed()) {
            this.continueSession();
        } else {
            this.speechRecorderUI.closePrompt();
        }
    }

    public void startAnnotation() {
        if (this.promptItem != null) {
            if (this.promptItem instanceof Recording) {
                this.timeLogger.info("ANNOTATE: " + this.promptItemCode);
            } else if (this.promptItem instanceof Nonrecording) {
                this.timeLogger.info("ANNOTATE: Nonrecording");
            }
        }
        this.setEditingEnabled(true);
        this.speechRecorderUI.idle();
        this.speechRecorderUI.setLevelMeterMode(0);
        int recVersions = 0;
        if (this.promptItem instanceof Recording) {
            try {
                recVersions = this.storageManager.getRecordedVersions();
            }
            catch (StorageManagerException e) {
                e.printStackTrace();
            }
        }
        this.itemPlayable = recVersions > 0;
        this.setRecDisplay();
    }

    public void continueSession() {
        if (this.progressManager.allRecordingsDone() && this.repeatRequest == null) {
            this.setIdle();
            if (!this.allRecordingsDoneNotified) {
                JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), this.uiString.getString("DialogRecordingsCompleteText"), this.uiString.getString("DialogRecordingsCompleteTitle"), 1);
                this.allRecordingsDoneNotified = true;
            }
        } else {
            boolean autoProgress = this.isAutoProgress();
            boolean autoRecording = this.isAutoRecording();
            if (this.repeatRequest != null) {
                String title = this.repeatRequest.getMessageTitle();
                String msg = this.repeatRequest.getMessage();
                this.setIdle();
                if (msg != null) {
                    JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), msg, title, 2);
                }
                if (autoRecording && !this.progressPaused) {
                    MessageFormat form = new MessageFormat(this.uiString.getString("prompt_repeat_info"));
                    JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), form.format(new Object[]{new Float(this.RECORD_RETRY_DELAY / 1000L)}), this.uiString.getString("prompt_repeat"), 1);
                    try {
                        Thread.sleep(this.RECORD_RETRY_DELAY);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.startItem();
                } else {
                    JOptionPane.showMessageDialog(this.speechRecorderUI.getDialogTarget(), this.uiString.getString("prompt_repeat"), this.uiString.getString("prompt_repeat"), 1);
                }
            } else {
                if (autoProgress) {
                    if (this.progressToNextUnrecorded) {
                        this.progressManager.advanceToNextRecording();
                    } else {
                        this.progressManager.incrementIndex();
                    }
                    autoRecording = this.isAutoRecording();
                } else {
                    this.setIdle();
                }
                if (autoRecording && !this.progressPaused) {
                    this.startItem();
                }
            }
        }
    }

    public void init() {
        this.allRecordingsDoneNotified = false;
        this.progressManager.setRecIndex(null);
        this.annotationSession = null;
        this.recStat.setStatus(0);
        this.setEditingEnabled(true);
        this.speechRecorderUI.init();
    }

    public void applyItem() throws PromptPresenterException {
        this.promptItem = this.progressManager.getCurrentPromptItem();
        if (this.promptItem != null) {
            this.promptItemCode = this.promptItem != null && this.promptItem instanceof Recording ? ((Recording)this.promptItem).getItemcode() : null;
            this.storageManager.setPromptCode(this.promptItemCode);
            this.speechRecorderUI.setRecIndex(this.progressManager.getRecIndex());
            this.speechRecorderUI.setPromptItem(this.promptItem);
            Section currentRecSection = this.progressManager.getCurrentRecSection();
            if (currentRecSection != null) {
                Section.Mode scriptMode = currentRecSection.getMode();
                this.sectionMode = scriptMode != null ? scriptMode : this.defaultSectionMode;
                boolean currentSpeakerWindowRequest = currentRecSection.getNNSpeakerDisplay();
                if (this.lastSpeakerWindowRequest != currentSpeakerWindowRequest) {
                    this.setSpeakerWindowShowing(currentSpeakerWindowRequest);
                }
                this.lastSpeakerWindowRequest = currentSpeakerWindowRequest;
            } else {
                this.sectionMode = null;
            }
            this.speechRecorderUI.setAutoRecording(this.isAutoRecording());
        }
        this.recDisplayValid = false;
    }

    public void setPromptErrorState() {
        if (this.promptItem != null) {
            if (this.promptItem instanceof Recording) {
                this.timeLogger.info("ERROR: " + this.promptItemCode);
            } else if (this.promptItem instanceof Nonrecording) {
                this.timeLogger.info("ERROR: Nonrecording");
            }
        }
        this.setEditingEnabled(true);
        this.speechRecorderUI.idle();
        this.speechRecorderUI.setLevelMeterMode(0);
        this.storageManager.setScriptID(this.script.getName());
        if (!this.recDisplayValid) {
            int recVersions = 0;
            if (this.promptItem instanceof Recording) {
                try {
                    recVersions = this.storageManager.getRecordedVersions();
                    this.storageManager.setRecVersion(recVersions - 1);
                }
                catch (StorageManagerException e) {
                    e.printStackTrace();
                }
            }
            this.itemPlayable = recVersions > 0;
            this.speechRecorderUI.setPlaybackEnabled(this.itemPlayable);
            this.setRecDisplay();
            this.recDisplayValid = true;
        }
        this.speechRecorderUI.setShowPromptViewers(false);
        this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.OFF);
        this.recStat.setStatus(-2);
        if (this.isAutoRecording()) {
            this.setProgressPaused(true);
        }
    }

    public void setIdle() {
        this.repeatRequest = null;
        if (this.promptItem != null) {
            if (this.promptItem instanceof Recording) {
                this.timeLogger.info("IDLE: " + this.promptItemCode);
            } else if (this.promptItem instanceof Nonrecording) {
                this.timeLogger.info("IDLE: Nonrecording");
            }
        }
        this.setEditingEnabled(true);
        this.speechRecorderUI.idle();
        if (RecordingConfiguration.CaptureScope.SESSION.equals((Object)this.captureScope)) {
            this.speechRecorderUI.setLevelMeterMode(2);
        } else {
            this.speechRecorderUI.setLevelMeterMode(0);
        }
        this.storageManager.setScriptID(this.script.getName());
        if (!this.useUploadCache) {
            try {
                this.storageManager.createSessionDirectory();
            }
            catch (StorageManagerException e) {
                e.printStackTrace();
                return;
            }
        }
        if (!this.recDisplayValid) {
            int recVersions = 0;
            if (this.promptItem instanceof Recording) {
                try {
                    recVersions = this.storageManager.getRecordedVersions();
                }
                catch (StorageManagerException e) {
                    e.printStackTrace();
                }
                this.storageManager.setRecVersion(recVersions - 1);
            }
            this.itemPlayable = recVersions > 0;
            this.speechRecorderUI.setPlaybackEnabled(this.itemPlayable);
            this.setRecDisplay();
            this.recDisplayValid = true;
        }
        if (this.promptItem instanceof Recording) {
            if (!Section.PromptPhase.IDLE.equals((Object)this.progressManager.currentPromptPhase())) {
                this.speechRecorderUI.setShowPromptViewers(false);
            }
            this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.IDLE);
            this.recStat.setStatus(1);
        } else if (this.promptItem instanceof Nonrecording) {
            this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.OFF);
            this.recStat.setStatus(2);
        }
    }

    private void startPrompt() {
        boolean promptStartEnabled;
        boolean bl = promptStartEnabled = !this.isAutoRecording() || this.getProgressPaused();
        if (this.promptItem instanceof Recording) {
            if (Section.PromptPhase.IDLE.equals((Object)this.progressManager.currentPromptPhase())) {
                this.speechRecorderUI.setShowPromptViewers(true);
                try {
                    this.speechRecorderUI.startPromptAutoplay();
                }
                catch (PrompterException e) {
                    e.printStackTrace();
                    this.setIdle();
                }
                this.speechRecorderUI.setPromptStartControlEnabled(promptStartEnabled);
            }
        } else if (this.promptItem instanceof Nonrecording) {
            this.speechRecorderUI.setShowPromptViewers(true);
            try {
                this.speechRecorderUI.startPromptAutoplay();
            }
            catch (PrompterException e) {
                e.printStackTrace();
                this.setIdle();
            }
            this.speechRecorderUI.setPromptStartControlEnabled(promptStartEnabled);
        }
    }

    private Bundle buildBaseBundle(File[] recFiles) throws IOException, UnsupportedAudioFileException {
        Bundle bundle = new Bundle();
        bundle.setSession(this.annotationSession);
        String targetRootFn = this.storageManager.getNewRootFileName();
        bundle.setName(targetRootFn);
        if (recFiles != null && recFiles.length > 0) {
            File masterFile = recFiles[0];
            bundle.setAnnotates(masterFile.getName());
            ArrayList<String> sigPathes = new ArrayList<String>();
            File[] fileArray = recFiles;
            int n = recFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File rf = fileArray[n2];
                sigPathes.add(rf.getAbsolutePath());
                ++n2;
            }
            bundle.setSignalpaths(sigPathes);
            try {
                ConvenienceFileAudioSource cfas = new ConvenienceFileAudioSource(masterFile);
                AudioFormat af = cfas.getFormat();
                long fl = cfas.getFrameLength();
                bundle.setSampleRate(Float.valueOf(af.getSampleRate()));
                bundle.setFrameLength(Long.valueOf(fl));
            }
            catch (AudioSourceException e) {
                e.printStackTrace();
            }
        }
        return bundle;
    }

    private Bundle prepareAutoAnnotation() throws IOException, UnsupportedAudioFileException {
        if (this.promptAutoAnnotator != null) {
            this.promptAutoAnnotator.setPromptText(null);
        }
        if (this.templateAutoAnnotator != null) {
            this.templateAutoAnnotator.setTemplateText(null);
        }
        Bundle bundle = null;
        File[] recFiles = this.storageManager.getCurrentItemRecordingFiles();
        bundle = this.buildBaseBundle(recFiles);
        String prDescr = this.promptItem.getDescription();
        if (this.promptAutoAnnotator != null) {
            this.promptAutoAnnotator.setPromptText(prDescr);
        }
        LocalizedText annoTempl = this.promptItem.annotationTemplateLocalizedText();
        if (this.templateAutoAnnotator != null && annoTempl != null) {
            String annoTempltext = annoTempl.getText();
            this.templateAutoAnnotator.setTemplateText(annoTempltext);
        }
        return bundle;
    }

    private void itemFinished() {
        RecStatus st = RecStatus.getInstance();
        int status = st.getStatus();
        if (status == 7 || status == 8 || status == 9) {
            st.setStatus(10);
            if (this.useUploadCache) {
                try {
                    this.storageManager.upload();
                }
                catch (StorageManagerException e) {
                    this.speechRecorderUI.displayError("Storage error", "Storage error: " + e.getLocalizedMessage());
                    this.logger.severe(e.getMessage());
                }
            }
            if (RecordingConfiguration.CaptureScope.SESSION.equals((Object)this.captureScope) || !this.audioController.isCaptureOpen()) {
                if (this.speechRecorderUI.isPromptClosed()) {
                    if (this.repeatRequest == null && this.bundleAnnotationPersistorList != null && this.bundleAnnotationPersistorList.size() > 0) {
                        Bundle bundle = null;
                        try {
                            bundle = this.prepareAutoAnnotation();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (UnsupportedAudioFileException e1) {
                            e1.printStackTrace();
                        }
                        if (this.annotatingEnabled) {
                            this.startAnnotation();
                        }
                        try {
                            this.persistBundle(bundle);
                            this.startAutoAnnotation(bundle);
                        }
                        catch (StorageManagerException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (EncodeException e) {
                            e.printStackTrace();
                        }
                    }
                    this.continueSession();
                } else {
                    this.speechRecorderUI.closePrompt();
                }
            } else {
                System.err.println("Capture still open !");
            }
        }
    }

    public void update(AudioController2.AudioControllerEvent ace) {
        if (ace instanceof PlayerEvent) {
            if (ace instanceof PlayerStopEvent) {
                if (ace instanceof PlayerPauseEvent) {
                    this.sessionActions.setIndexAction.setEnabled(true);
                    this.recStat.setStatus(14);
                } else {
                    try {
                        this.audioController.closePlayback();
                    }
                    catch (AudioControllerException e) {
                        this.speechRecorderUI.displayError("Audio controller close playback error", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else if (ace instanceof PlayerStartEvent) {
                this.sessionActions.setIndexAction.setEnabled(true);
                this.speechRecorderUI.setLevelMeterMode(1);
                this.recStat.setStatus(13);
            } else if (ace instanceof PlayerCloseEvent) {
                this.speechRecorderUI.updateView();
                if (this.incrementIndexRequest) {
                    this.incrementIndexRequest = false;
                    this.progressManager.incrementIndex();
                } else if (this.decrementIndexRequest) {
                    this.decrementIndexRequest = false;
                    this.progressManager.decrementIndex();
                } else if (this.advanceToNextRequest) {
                    this.advanceToNextRequest = false;
                    this.progressManager.advanceToNextRecording();
                } else if (this.skipToRequest != null) {
                    int skipTo = this.skipToRequest;
                    this.skipToRequest = null;
                    this.progressManager.setRecIndex(skipTo);
                }
                this.setIdle();
                this.startPrompt();
            }
        } else if (ace instanceof CaptureEvent && !(ace instanceof CaptureStartCaptureEvent)) {
            if (ace instanceof CaptureStartRecordEvent) {
                this.preRecTimer.start();
                if (this.maxRecTimer != null) {
                    this.maxRecTimer.start();
                }
            } else if (ace instanceof CaptureRecordingFileTransitEvent) {
                this.preRecTimer.start();
                if (this.maxRecTimer != null) {
                    this.maxRecTimer.start();
                }
            } else if (ace instanceof CaptureRecordedEvent) {
                this.progressManager.incrementRecCounter(this.progressManager.getRecIndex());
                if (this.promptItem instanceof Recording) {
                    long recordedFrameLength = this.audioController.getCaptureFramePosition();
                    float sampleRate = this.audioController.getAudioFileFormat().getFormat().getSampleRate();
                    double recordedMs = (double)recordedFrameLength * 1000.0 / (double)sampleRate;
                    Recording r = (Recording)this.promptItem;
                    int minRecordLenMs = this.minRecLengthMs(r);
                    int lineActivateTolerance = 250;
                    if (SystemHelper.getInstance().isMacOSX()) {
                        lineActivateTolerance += 1000;
                    }
                    if (recordedMs + (double)lineActivateTolerance < (double)minRecordLenMs * 0.9) {
                        String msg = "Recording length " + recordedMs + " ms is shorter than " + 0.9 + " of minimum expected length of " + minRecordLenMs + " ms";
                        System.err.println(msg);
                        this.repeatRequest = new RepeatRequest("Audio quality check failed", msg);
                    }
                }
                if (this.silenceDetector != null) {
                    this.silenceDetector.stop();
                }
                if (RecordingConfiguration.CaptureScope.SESSION.equals((Object)this.captureScope)) {
                    this.itemFinished();
                } else {
                    try {
                        this.audioController.closeCapture();
                    }
                    catch (AudioControllerException e1) {
                        this.speechRecorderUI.displayError("Audio controller close capture error", e1.getLocalizedMessage());
                        e1.printStackTrace();
                    }
                }
            } else if (ace instanceof CaptureCloseEvent) {
                if (this.voiceDetector != null) {
                    this.audioController.removeCaptureFloatAudioOutputStream((FloatAudioOutputStream)this.voiceDetector);
                }
                if (this.silenceDetector != null) {
                    this.silenceDetector.stop();
                }
                this.itemFinished();
            } else if (ace instanceof CaptureErrorEvent) {
                CaptureErrorEvent cErrEv = (CaptureErrorEvent)ace;
                Exception cause = cErrEv.getCause();
                String errMsg = "Unknown capture error";
                String locErrMsg = "Unknown capture error";
                if (cause != null) {
                    errMsg = cause.getMessage();
                    locErrMsg = cause.getLocalizedMessage();
                }
                if (this.preRecTimer != null) {
                    this.preRecTimer.stop();
                }
                if (this.maxRecTimer != null) {
                    this.maxRecTimer.stop();
                }
                if (this.voiceDetector != null) {
                    this.audioController.removeCaptureFloatAudioOutputStream((FloatAudioOutputStream)this.voiceDetector);
                }
                if (this.silenceDetector != null) {
                    this.silenceDetector.stop();
                }
                this.logger.severe(errMsg);
                if (cause instanceof BufferOverrunException && 1 != this.recStat.getStatus()) {
                    this.repeatRequest = new RepeatRequest();
                }
                this.speechRecorderUI.displayError("Audio controller error", locErrMsg);
                try {
                    this.audioController.closeCapture();
                }
                catch (AudioControllerException e) {
                    this.speechRecorderUI.displayError("Audio controller close capture error", e.getLocalizedMessage());
                }
            }
        }
    }

    private void persistBundle(Bundle bundle) throws StorageManagerException, IOException, EncodeException {
        Session sessOfBundle = bundle.getSession();
        if (sessOfBundle != null) {
            File sessDir;
            String rootFn = bundle.getName();
            File storageDir = ActiveSessionStorageManager.fileURLToFile(this.storageManager.getStorageURL());
            String sessNm = sessOfBundle.getName();
            if (sessNm != null && !"".equals(sessNm) && (sessDir = new File(storageDir, sessNm)) != null && sessDir.isDirectory()) {
                for (BundleAnnotationPersistor bap : this.bundleAnnotationPersistorList) {
                    if (!(bap instanceof BundleAnnotationFilePersistor)) continue;
                    BundleAnnotationFilePersistor bafp = (BundleAnnotationFilePersistor)bap;
                    File annoFile = new File(sessDir, String.valueOf(rootFn) + bafp.getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension());
                    bafp.setFile(annoFile);
                    if (!bap.isWritable(bundle)) continue;
                    try {
                        bap.write(bundle);
                    }
                    catch (EncodeException ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
    }

    private void startAutoAnnotation(Bundle bundle) {
        if (this.autoAnnotationWorker != null) {
            File[] recFiles = null;
            try {
                recFiles = this.storageManager.getRecordingFiles();
                PromptItem pi = this.progressManager.getCurrentPromptItem();
                LocalizedText annoTempl = pi.annotationTemplateLocalizedText();
                if (annoTempl != null) {
                    Locale templLocale = annoTempl.getLocale();
                    if (templLocale == null) {
                        templLocale = Locale.getDefault();
                    }
                    bundle.setLocale(templLocale);
                }
                AutoAnnotator.AnnotationRequest ar = new AutoAnnotator.AnnotationRequest(bundle);
                this.autoAnnotationWorker.request(ar);
            }
            catch (StorageManagerException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void annotate(Object annotatedObject, String annotationName, String propertyName, Object annotation) {
        FileWriter annoWriter = null;
        try {
            File annotationFile = this.storageManager.getAnnoationFile();
            annoWriter = new FileWriter(annotationFile);
            annoWriter.write("Annotation: " + propertyName + " " + annotation);
            annoWriter.close();
            if (this.useUploadCache) {
                this.storageManager.uploadAnnotation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (annoWriter != null) {
                try {
                    annoWriter.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.speechRecorderUI.displayError("Annotation storage error", ioe);
                }
            }
            this.speechRecorderUI.displayError("Annotation storage error", e);
        }
        this.continueSession();
    }

    public void setScript(Script script) {
        this.script = script;
        this.progressManager.setScript(script);
    }

    private boolean playbackActive() {
        int st = this.recStat.getStatus();
        return st == 13 || st == 14;
    }

    public void setRecIndex(int skipTo) {
        if (this.playbackActive()) {
            this.skipToRequest = skipTo;
            try {
                this.stopPlayback();
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
            }
        } else {
            this.progressManager.setRecIndex(skipTo);
        }
    }

    public void advanceToNextRecording() {
        if (this.playbackActive()) {
            this.advanceToNextRequest = true;
            try {
                this.stopPlayback();
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
            }
        } else {
            this.getProgressManager().advanceToNextRecording();
        }
    }

    public void decrementIndex() {
        if (this.playbackActive()) {
            this.decrementIndexRequest = true;
            try {
                this.stopPlayback();
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
            }
        } else {
            this.getProgressManager().decrementIndex();
        }
    }

    public void incrementIndex() {
        if (this.playbackActive()) {
            this.incrementIndexRequest = true;
            try {
                this.stopPlayback();
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
            }
        } else {
            this.getProgressManager().incrementIndex();
        }
    }

    public void startPlayback() throws AudioControllerException, StorageManagerException {
        this.setEditingEnabled(false);
        this.audioController.setPlaybackFile(this.storageManager.getRecordingFiles()[0]);
        this.audioController.openPlayback();
        this.audioController.setPlaybackStartFramePosition(0L);
        this.audioController.setPlaybackStopFramePosition((long)AJSAudioSystem.NOT_SPECIFIED);
        this.audioController.startPlayback();
    }

    public void startPlayback(long start, long stop) throws AudioControllerException, StorageManagerException {
        this.setEditingEnabled(false);
        this.audioController.setPlaybackFile(this.storageManager.getRecordingFiles()[0]);
        this.audioController.openPlayback();
        this.audioController.setPlaybackStartFramePosition(start);
        this.audioController.setPlaybackStopFramePosition(stop);
        this.audioController.startPlayback();
    }

    public void stopPlayback() throws AudioControllerException {
        this.audioController.stopPlayback();
    }

    public void pausePlayback() throws AudioControllerException {
        this.audioController.pausePlayback();
    }

    public void continuePlayback() {
        try {
            this.audioController.startPlayback();
        }
        catch (AudioControllerException e) {
            this.speechRecorderUI.displayError("AudioController Error", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private List<File> currentAnnotationFiles() throws StorageManagerException {
        ArrayList<File> annoFileList = new ArrayList<File>();
        File sessDir = ActiveSessionStorageManager.fileURLToFile(this.storageManager.getSessionURL());
        String rootFn = this.storageManager.getRootFileName();
        if (sessDir != null) {
            for (BundleAnnotationPersistor bap : this.bundleAnnotationPersistorList) {
                if (!(bap instanceof BundleAnnotationFilePersistor)) continue;
                BundleAnnotationFilePersistor bafp = (BundleAnnotationFilePersistor)bap;
                File annoFile = new File(sessDir, String.valueOf(rootFn) + bafp.getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension());
                annoFileList.add(annoFile);
            }
        }
        return annoFileList;
    }

    public void setSpeakerWindowShowing(boolean v) {
        this.speakerWindow = v;
        this.speechRecorderUI.setSpeakerWindowShowing(this.speakerWindow);
    }

    public void stop() throws SpeechRecorderException {
        if (this.autoAnnotationWorker != null) {
            try {
                this.autoAnnotationWorker.cancel();
                this.autoAnnotationWorker.close();
            }
            catch (WorkerException e1) {
                throw new SpeechRecorderException(e1);
            }
        }
        this.closeAudioController();
    }

    private void closeAudioController() {
        if (this.audioController != null) {
            this.audioController.removeAudioController2Listener((AudioController2.AudioController2Listener)this);
            try {
                this.audioController.closePlayback();
                this.audioController.closeCapture();
            }
            catch (AudioControllerException e) {
                this.speechRecorderUI.displayError("Audiocontroller error", e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.beepPlayer != null) {
            this.beepPlayer.removePlayerListener((PlayerListener)this);
            try {
                this.beepPlayer.close();
            }
            catch (PlayerException e) {
                this.speechRecorderUI.displayError("Beep player close error", e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    public void close() throws SpeechRecorderException {
        if (this.recStat.getStatus() == 18) {
            return;
        }
        this.stop();
        this.recStat.setStatus(17);
        if (this.autoAnnotationWorker != null) {
            this.autoAnnotationWorker.cancel();
            try {
                this.autoAnnotationWorker.close();
                this.autoAnnotationWorker = null;
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
        }
        this.annotationSession = null;
        this.closeAudioController();
        this.setEditingEnabled(false);
        this.speechRecorderUI.closeSession();
        this.audioEnabled = false;
        this.audioClip.setBundle(null);
        this.audioClip.setAudioSource(null);
        this.setIndexAction.setEnabled(false);
        this.speechRecorderUI.setLevelMeterMode(0);
        this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.OFF);
        this.progressManager.doClose();
        this.recStat.setStatus(18);
    }

    public void update(RecscriptManagerEvent e) {
        if (e instanceof RecScriptChangedEvent && this.getScript() != null && this.recStat.getStatus() != 0 && this.recStat.getStatus() != 18) {
            try {
                this.applyItem();
            }
            catch (PromptPresenterException e1) {
                this.setPromptErrorState();
                return;
            }
            this.setRecDisplay();
            this.setIdle();
            this.startPrompt();
        }
    }

    @Override
    public void update(PromptViewerEvent promptViewerEvent) {
        if (promptViewerEvent instanceof PromptViewerOpenedEvent) {
            this.speechRecorderUI.startPlayPrompt();
        } else if (promptViewerEvent instanceof PromptViewerStartedEvent) {
            int currStat = this.recStat.getStatus();
            if (currStat == 2 || currStat == 1) {
                this.sessionActions.setIndexAction.setEnabled(false);
                this.setEditingEnabled(false);
                this.recStat.setStatus(3);
            }
        } else if (!(promptViewerEvent instanceof PromptViewerStoppedEvent) && promptViewerEvent instanceof PromptViewerPresenterClosedEvent) {
            int status = this.recStat.getStatus();
            if (status == 4) {
                PromptItem promptItem = this.progressManager.getCurrentPromptItem();
                if (promptItem instanceof Recording) {
                    try {
                        this.startBeep();
                    }
                    catch (SpeechRecorderException e) {
                        this.speechRecorderUI.displayError("Beep playback error", e);
                        this.setIdle();
                    }
                } else if (promptItem instanceof Nonrecording) {
                    this.startNonRecording();
                } else {
                    this.setIdle();
                    if (this.isAutoRecording()) {
                        this.continueSession();
                    }
                }
            } else if (status == 3) {
                this.setIdle();
            } else if (status == 7 || status == 8 || status == 9) {
                if (Section.PromptPhase.RECORDING.equals((Object)this.progressManager.currentPromptPhase()) && this.progressManager.currentPromptBlocking()) {
                    this.speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.RECORDING);
                }
            } else if (status == 10) {
                if (this.speechRecorderUI.isPromptClosed()) {
                    this.continueSession();
                } else {
                    System.err.println("Prompter not closed. (Internal error)");
                }
            }
        }
    }

    public void update(PlayerEvent playerEvent) {
        Player p = (Player)playerEvent.getSource();
        if (playerEvent instanceof PlayerStopEvent) {
            try {
                p.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                try {
                    this.stopRecording();
                }
                catch (AudioControllerException e1) {
                    e1.printStackTrace();
                }
                this.speechRecorderUI.displayError("Beep playback error", e);
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            this.startPreRecWaiting();
        }
    }

    @Override
    public void update(ProgressManagerEvent e) {
        if (e instanceof SessionPositionChangedEvent) {
            SessionPositionChangedEvent rspce = (SessionPositionChangedEvent)e;
            Integer newPos = rspce.getPosition();
            if (newPos == null) {
                this.init();
            } else {
                try {
                    this.applyItem();
                }
                catch (PromptPresenterException e1) {
                    this.setPromptErrorState();
                    return;
                }
                this.setIdle();
                this.startPrompt();
            }
        }
    }

    public void update(ProgressEvent progressEvent) {
        Object src = progressEvent.getSource();
        if (src == this.autoAnnotationWorker && progressEvent instanceof AutoAnnotationWorker.BundleAnnotatedEvent) {
            AutoAnnotationWorker.BundleAnnotatedEvent bae = (AutoAnnotationWorker.BundleAnnotatedEvent)progressEvent;
            Bundle bundle = bae.getAnnotatedBundle();
            try {
                this.persistBundle(bundle);
            }
            catch (StorageManagerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (EncodeException e) {
                e.printStackTrace();
            }
            String currViewedBundle = this.storageManager.getRootFileName();
            if (currViewedBundle.equals(bundle.getName())) {
                this.audioClip.setBundle(bundle);
            }
        }
    }

    public void update(SpeechFinalSilenceDetectorEvent event) {
        if (event.isFinalSilenceDetected()) {
            this.startPostRecordingPhase();
        }
    }

    public class RepeatRequest {
        private String messageTitle;
        private String message;

        public RepeatRequest() {
        }

        public RepeatRequest(String messageTitle, String message) {
            this.messageTitle = messageTitle;
            this.message = message;
        }

        public String getMessageTitle() {
            return this.messageTitle;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

