/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class TextToJavaHelpGraphicsHelper {
    public static String TEX_INCLUDEGRAPHICS = "\\includegraphics";
    public static double PIXELS_CM = 60.0;

    public void convertTexForJavaHelp(File inputFile, Writer outputwriter, File imageDir) throws IOException {
        File baseDir = inputFile.getParentFile();
        FileReader inputReader = new FileReader(inputFile);
        String line = null;
        try (LineNumberReader lnr = new LineNumberReader(inputReader);){
            while ((line = lnr.readLine()) != null) {
                StringBuffer convertedLine = new StringBuffer();
                int startPos = 0;
                do {
                    File jhFile;
                    String jhFilename;
                    BufferedImage scaled;
                    int filenameEndPos;
                    int pos;
                    if ((pos = line.indexOf(TEX_INCLUDEGRAPHICS, startPos)) != -1) {
                        convertedLine.append(line.substring(startPos, pos));
                        convertedLine.append(TEX_INCLUDEGRAPHICS);
                        Integer pixelWidth = null;
                        if (line.substring(pos += TEX_INCLUDEGRAPHICS.length(), pos + 1).equals("[")) {
                            convertedLine.append("[");
                            int endParams = line.indexOf("]", ++pos);
                            String params = line.substring(pos, endParams);
                            StringTokenizer optionTokenizer = new StringTokenizer(params, ",");
                            while (optionTokenizer.hasMoreTokens()) {
                                String option = optionTokenizer.nextToken();
                                String trimmedOption = option.trim();
                                if (trimmedOption.startsWith("width=")) {
                                    String widthValue = trimmedOption.substring("width=".length());
                                    int unitPos = (widthValue = widthValue.trim()).indexOf("cm");
                                    if (unitPos != -1) {
                                        String value = widthValue.substring(0, unitPos).trim();
                                        double cmVal = Double.parseDouble(value);
                                        pixelWidth = (int)(cmVal * PIXELS_CM);
                                    }
                                    convertedLine.append(option);
                                    continue;
                                }
                                convertedLine.append(option);
                            }
                            convertedLine.append("]");
                            pos = endParams + 1;
                        }
                        int filenamePos = line.indexOf("{", pos);
                        filenameEndPos = line.indexOf("}", filenamePos);
                        String filename = line.substring(filenamePos + 1, filenameEndPos).trim();
                        int extIndex = filename.lastIndexOf(46);
                        String fileNameBody = filename.substring(0, extIndex);
                        String ext = filename.substring(extIndex);
                        File imgFile = new File(filename);
                        if (!imgFile.isAbsolute()) {
                            imgFile = new File(baseDir, filename);
                        }
                        if (!imgFile.exists()) {
                            System.err.println("Image file: " + imgFile + " does not exist!");
                        }
                        BufferedImage img = ImageIO.read(imgFile);
                        int imgWidth = img.getWidth();
                        if (pixelWidth == null) {
                            pixelWidth = imgWidth;
                        }
                        double factor = (double)pixelWidth.intValue() / (double)imgWidth;
                        int h = (int)((double)img.getHeight() * factor);
                        scaled = new BufferedImage(pixelWidth, h, 1);
                        Graphics2D g = scaled.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.drawImage(img, 0, 0, pixelWidth, h, null);
                        g.dispose();
                        jhFilename = String.valueOf(fileNameBody) + "_" + pixelWidth + "x" + h + ".png";
                        jhFile = null;
                        if (imageDir != null) {
                            jhFile = new File(imageDir, jhFilename);
                            jhFile.mkdirs();
                        } else {
                            jhFile = new File(jhFilename);
                        }
                    } else {
                        convertedLine.append(line.substring(startPos));
                        break;
                    }
                    ImageIO.write((RenderedImage)scaled, "PNG", jhFile);
                    convertedLine.append("{" + jhFilename + "}");
                    startPos = pos = filenameEndPos + 1;
                } while (startPos < line.length());
                outputwriter.append(convertedLine);
                outputwriter.append('\n');
            }
        }
    }

    public static void main(String[] args) {
        TextToJavaHelpGraphicsHelper h = new TextToJavaHelpGraphicsHelper();
        Writer w = null;
        File imageDir = null;
        File inFile = new File(args[0]);
        if (args.length >= 2) {
            File outFile = new File(args[1]);
            try {
                w = new FileWriter(outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            w = new PrintWriter(System.out);
        }
        if (args.length == 3) {
            imageDir = new File(args[2]);
        }
        try {
            h.convertTexForJavaHelp(inFile, w, imageDir);
            w.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

