/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.net.URLContext;
import ipsk.net.Utils;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import ipsk.util.zip.ZipPacker;
import ipsk.util.zip.ZipPackerWorker;
import java.awt.Component;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXB;

public class ProjectExporter {
    public void exportProject(URL projectContext, ProjectConfiguration project, File zipFile, boolean exportSessionData, Component speechRecorderUI) throws IOException, URISyntaxException, SpeechRecorderException {
        File projDir = new File(projectContext.toURI().getPath());
        FileOutputStream zipStream = new FileOutputStream(zipFile);
        ProgressStatus finalStatus = null;
        if (exportSessionData) {
            ZipPackerWorker zipPackerWorker = new ZipPackerWorker();
            zipPackerWorker.setSrcDir(projDir);
            zipPackerWorker.setPackRecusive(true);
            zipPackerWorker.setOutputStream((OutputStream)zipStream);
            JProgressDialogPanel progressDialog = new JProgressDialogPanel((Worker)zipPackerWorker, "Export project", "Exporting...");
            try {
                zipPackerWorker.open();
            }
            catch (WorkerException e) {
                e.printStackTrace();
                throw new SpeechRecorderException("Could not open ZIP file packer!", e);
            }
            zipPackerWorker.start();
            Object val = progressDialog.showDialog(speechRecorderUI);
            try {
                zipPackerWorker.close();
            }
            catch (WorkerException e) {
                e.printStackTrace();
                throw new SpeechRecorderException("Could not close ZIP file packer!", e);
            }
            finalStatus = zipPackerWorker.getProgressStatus();
            if (!finalStatus.isDone()) {
                zipFile.delete();
            }
        } else {
            finalStatus = new ProgressStatus();
            try {
                String spkUrlStr;
                File resourcesDir;
                ZipPacker zp = new ZipPacker((OutputStream)zipStream);
                String dirZipEntryName = zp.packDir(projDir.getName());
                File projectConfFile = new File(projDir, String.valueOf(project.getName()) + "_project.prj");
                String scriptUrlStr = project.getPromptConfiguration().getPromptsUrl();
                if (scriptUrlStr != null && !"".equals(scriptUrlStr)) {
                    URI promptURI = new URI(scriptUrlStr);
                    if (promptURI.isAbsolute()) {
                        JOptionPane.showMessageDialog(speechRecorderUI, "Cannot export project with absolute recording script URL!");
                        return;
                    }
                    URL scriptURL = URLContext.getContextURL((URL)projectContext, (String)scriptUrlStr);
                    File scriptFile = Utils.fileFromDecodedURL((URL)scriptURL);
                    zp.packFile(scriptFile, String.valueOf(dirZipEntryName) + scriptUrlStr);
                    RecScriptManager scriptExportManager = new RecScriptManager();
                    scriptExportManager.setContext(projectContext);
                    scriptExportManager.setSystemIdBase(projectContext.toExternalForm());
                    try {
                        scriptExportManager.load(scriptURL);
                        String sysId = scriptExportManager.getSystemId();
                        String sysIDBase = scriptExportManager.getSystemIdBase();
                        URL dtdURL = URLContext.getContextURL((URL)projectContext, (String)(String.valueOf(sysIDBase) + sysId));
                        File dtdFile = Utils.fileFromDecodedURL((URL)dtdURL);
                        zp.packFile(dtdFile, String.valueOf(dirZipEntryName) + sysId);
                    }
                    catch (RecscriptManagerException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(speechRecorderUI, "Cannot load recording script for export!");
                        return;
                    }
                }
                if ((resourcesDir = new File(projDir, "resources")).isDirectory()) {
                    zp.packDirRecursive(projDir.getName(), resourcesDir);
                }
                if ((spkUrlStr = project.getSpeakers().getSpeakersUrl()) != null && !"".equals(spkUrlStr)) {
                    URI spkURI = new URI(spkUrlStr);
                    if (spkURI.isAbsolute()) {
                        JOptionPane.showMessageDialog(speechRecorderUI, "Cannot export project with absolute speaker database URL!");
                        return;
                    }
                    ByteArrayOutputStream emptySpkFileOs = new ByteArrayOutputStream();
                    JAXB.marshal(new ArrayList(), (OutputStream)emptySpkFileOs);
                    byte[] spkData = emptySpkFileOs.toByteArray();
                    zp.packData(spkData, String.valueOf(dirZipEntryName) + spkUrlStr);
                }
                zp.packFile(projectConfFile, String.valueOf(dirZipEntryName) + projectConfFile.getName());
                zp.close();
                finalStatus.done();
            }
            catch (IOException ioe) {
                finalStatus.error(new LocalizableMessage(ioe.getLocalizedMessage()));
            }
        }
        if (finalStatus.isDone()) {
            Object[] options = new Object[]{"OK", "Open containing folder"};
            int selOpt = JOptionPane.showOptionDialog(speechRecorderUI, "Successful export to ZIP file:\n" + zipFile, "Project export", -1, 1, null, options, options[0]);
            if (selOpt == 1 && Desktop.isDesktopSupported()) {
                Desktop dt = Desktop.getDesktop();
                File containingFolder = zipFile.getParentFile();
                dt.open(containingFolder);
            }
        } else if (finalStatus.isError()) {
            JOptionPane.showMessageDialog(speechRecorderUI, "Project export failed:" + finalStatus.getMessage().localize());
        } else if (finalStatus.isCanceled()) {
            JOptionPane.showMessageDialog(speechRecorderUI, "Project export canceled.");
        }
    }
}

