/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.actions.EditScriptAction;
import ipsk.apps.speechrecorder.actions.EditScriptEvent;
import ipsk.apps.speechrecorder.session.action.SetIndexAction;
import ipsk.apps.speechrecorder.session.progress.ProgressManager;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerEvent;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerListener;
import ipsk.apps.speechrecorder.session.progress.SessionPositionChangedEvent;
import ipsk.db.speech.PromptItem;
import ipsk.swing.table.AutoFontCellRenderer;
import ipsk.swing.table.DisableNullValueCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ProgressViewer
extends JPanel
implements TableModelListener,
ProgressManagerListener {
    private static final long serialVersionUID = -7930881752326662930L;
    private JLabel label;
    private static final int PREFERRED_WIDTH = 200;
    private static final int PREFERRED_HEIGHT = 600;
    private static int COLUMN_WIDTH = 50;
    private Logger logger;
    private JTable progressViewTable;
    private ListSelectionModel lsm;
    private ProgressManager sessionManager;
    private EditScriptAction editScriptAction;
    private JLabel recSectionDisplay;
    private UIResources uiString;
    private boolean editEnabled;
    private URL projectContext;
    private AutoFontCellRenderer promptTextCellRenderer;

    public ProgressViewer(ProgressManager rSM, SetIndexAction setIndexAction, EditScriptAction editScriptAction) {
        this.sessionManager = rSM;
        this.editScriptAction = editScriptAction;
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.uiString = UIResources.getInstance();
        this.progressViewTable = new JTable(this.sessionManager);
        this.progressViewTable.setShowGrid(true);
        this.sessionManager.addTableModelListener(this.progressViewTable);
        this.progressViewTable.setSelectionModel(rSM);
        this.lsm = rSM;
        rSM.addSessionManagerListener(this);
        this.progressViewTable.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selRow = ProgressViewer.this.progressViewTable.getSelectedRow();
                    if (ProgressViewer.this.editEnabled) {
                        ProgressViewer.this.editSelectedItem(selRow);
                    }
                }
            }
        };
        this.progressViewTable.addMouseListener(listMouseListener);
        this.lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int i = ProgressViewer.this.progressViewTable.getSelectedRow();
                    Rectangle rowFirstColRect = ProgressViewer.this.progressViewTable.getCellRect(i, 0, true);
                    ProgressViewer.this.progressViewTable.scrollRectToVisible(rowFirstColRect);
                }
            }
        });
        TableColumn column = null;
        for (int i = 0; i < this.sessionManager.getColumnCount(); ++i) {
            column = this.progressViewTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(COLUMN_WIDTH / 2);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(2 * COLUMN_WIDTH);
                continue;
            }
            if (i == 2) {
                column.setPreferredWidth(5 * COLUMN_WIDTH);
                continue;
            }
            column.setPreferredWidth(COLUMN_WIDTH);
        }
        JScrollPane jsp = new JScrollPane(this.progressViewTable);
        this.label = new JLabel(this.uiString.getString("RecProgressStatus"), 0);
        this.recSectionDisplay = new JLabel("", 0);
        this.recSectionDisplay.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "North");
        this.add((Component)jsp, "Center");
        this.add((Component)this.recSectionDisplay, "South");
        this.editEnabled = false;
        TableColumn txtTableCol = this.progressViewTable.getColumnModel().getColumn(2);
        TableCellRenderer txtTcr = txtTableCol.getCellRenderer();
        if (txtTcr == null) {
            txtTcr = this.progressViewTable.getDefaultRenderer(this.progressViewTable.getColumnClass(2));
        }
        this.promptTextCellRenderer = new AutoFontCellRenderer(txtTcr);
        txtTableCol.setCellRenderer((TableCellRenderer)this.promptTextCellRenderer);
        TableColumn recTableCol = this.progressViewTable.getColumnModel().getColumn(3);
        TableCellRenderer tcr = recTableCol.getCellRenderer();
        if (tcr == null) {
            tcr = this.progressViewTable.getDefaultRenderer(this.progressViewTable.getColumnClass(3));
        }
        recTableCol.setCellRenderer((TableCellRenderer)new DisableNullValueCellRenderer(tcr));
    }

    public void setUseablePromptFontFamilies(String[] useableFontFamilies) {
        this.promptTextCellRenderer.setPreferredFontFamilies(useableFontFamilies);
    }

    public void editSelectedItem(int i) {
        this.sessionManager.setRecIndex(i);
        PromptItem pi = this.sessionManager.getCurrentPromptItem();
        EditScriptEvent ese = new EditScriptEvent((Object)this, pi);
        this.editScriptAction.actionPerformed(ese);
    }

    @Override
    public void tableChanged(TableModelEvent te) {
        this.logger.info("tableChanged: " + te.toString());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.progressViewTable.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 600);
    }

    public void setEditEnabled(boolean editEnabled) {
        this.editEnabled = editEnabled;
    }

    @Override
    public void update(ProgressManagerEvent e) {
        String sectionInfo = null;
        if (e instanceof SessionPositionChangedEvent) {
            sectionInfo = this.sessionManager.getRecSectionInfo();
        }
        String sectionInfoLabel = "";
        if (sectionInfo != null) {
            sectionInfoLabel = sectionInfo;
        }
        this.recSectionDisplay.setText(sectionInfoLabel);
        this.recSectionDisplay.setMinimumSize(new Dimension(0, 0));
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }
}

