/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.RecTransporter;
import ipsk.apps.speechrecorder.RecWindowPanel;
import ipsk.apps.speechrecorder.monitor.RecMonitor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptViewer;
import ipsk.apps.speechrecorder.prompting.Prompter;
import ipsk.apps.speechrecorder.session.action.RecTransporterActions;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class RecFrame
extends JFrame {
    private static final long serialVersionUID = -785487645992767852L;
    private boolean activeState;
    private RecWindowPanel recWindowPanel;

    public PromptViewer getPromptViewer() {
        return this.recWindowPanel.getPromptViewer();
    }

    public RecFrame(RecTransporterActions transporterActions, List<PromptPresenterServiceDescriptor> promptPresenters, GraphicsConfiguration spkc, Prompter prompter) throws PluginLoadingException {
        super(spkc);
        this.recWindowPanel = new RecWindowPanel(transporterActions, promptPresenters, spkc, prompter);
        this.setContentPane(this.recWindowPanel);
        this.pack();
    }

    public void setWindowActive(boolean wa) {
        this.activeState = wa;
        this.recWindowPanel.setSilent(!this.activeState);
        if (this.activeState) {
            Runnable doShow = new Runnable(){

                @Override
                public void run() {
                    RecFrame.this.setExtendedState(6);
                    RecFrame.this.setVisible(true);
                }
            };
            if (EventQueue.isDispatchThread()) {
                doShow.run();
            } else {
                SwingUtilities.invokeLater(doShow);
            }
        } else {
            Runnable doHide = new Runnable(){

                @Override
                public void run() {
                    RecFrame.this.setExtendedState(6);
                    RecFrame.this.setVisible(false);
                }
            };
            SwingUtilities.invokeLater(doHide);
        }
    }

    public boolean isWindowActive() {
        return this.activeState;
    }

    public void setTransporterShowing(boolean show) {
        this.recWindowPanel.setTransporterShowing(show);
    }

    public boolean isTransporterShowing() {
        return this.recWindowPanel.isTransporterShowing();
    }

    public void setAutoRecording(boolean b) {
        this.recWindowPanel.setAutoRecording(b);
    }

    public RecTransporter getRecTransporter() {
        return this.recWindowPanel.getRecTransporter();
    }

    public boolean isInstructionNumbering() {
        return this.recWindowPanel.isInstructionNumbering();
    }

    public void setInstructionNumbering(boolean instructionNumbering) {
        this.recWindowPanel.setInstructionNumbering(instructionNumbering);
    }

    public RecMonitor getRecMonitor() {
        return this.recWindowPanel.getRecMonitor();
    }
}

