/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RecLogger {
    private static RecLogger _instance = null;
    private Hashtable tagList = new Hashtable();
    private File logDirectory;

    private RecLogger() {
    }

    public static RecLogger getInstance() {
        if (_instance == null) {
            _instance = new RecLogger();
        }
        return _instance;
    }

    public void setDirectory(File directory) {
        this.logDirectory = directory;
    }

    public File getDirectory() {
        return this.logDirectory;
    }

    public void setLogEntry(String label, String entry) {
        this.tagList.put(label, entry);
    }

    private String generateNewName(String inName) {
        File newName = new File(inName);
        File tmpName = new File(inName);
        if (tmpName.exists()) {
            int versionCount = 0;
            while (tmpName.exists()) {
                tmpName = new File(inName + "_" + ++versionCount);
            }
            newName.renameTo(tmpName);
        }
        return inName;
    }

    public void createLabelFile(String fileName) {
        File lblFile = new File(this.generateNewName(this.logDirectory.getAbsolutePath() + File.separator + fileName));
        try {
            FileWriter fw = new FileWriter(lblFile);
            Enumeration e = this.tagList.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                fw.write(key + this.tagList.get(key) + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("createLabelFile(" + fileName + "): " + e);
        }
    }
}

