/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.Speaker;
import ipsk.apps.speechrecorder.SpeakerReader;
import ipsk.apps.speechrecorder.Speakers;
import ipsk.apps.speechrecorder.UIResources;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXB;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpeakerDatabaseLoader {
    private UIResources uiString;
    private Logger logger;
    private Speakers db = null;
    private Vector dbDescription = null;
    private int maxID = 0;
    private int dbIndex = 0;
    private String dbFileName;
    private String dbDirectory;
    private DatabaseType databaseType = DatabaseType.SPEECH_DB;

    public SpeakerDatabaseLoader() {
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.uiString = UIResources.getInstance();
        this.db = new Speakers();
    }

    public SpeakerDatabaseLoader(File file, Vector description) throws IOException {
        this();
        this.dbDescription = description;
        if (file == null || !file.isFile()) {
            FileDialog fd = new FileDialog((Frame)null, this.uiString.getString("LoadSpeakerFile"), 0);
            fd.setVisible(true);
            this.dbDirectory = fd.getDirectory();
            this.dbFileName = fd.getDirectory() + fd.getFile();
            file = new File(this.dbFileName);
        }
        if (file.getName().endsWith(".txt") || file.getName().endsWith(".TXT")) {
            this.databaseType = DatabaseType.TXT;
            this.readDatabaseFile(file);
        } else {
            this.databaseType = DatabaseType.SPEECH_DB;
            this.readDatabaseXMLFile(file);
        }
        this.dbIndex = this.db.getSpeakers().size() - 1;
    }

    private void setMaxID(int id) {
        if (id > this.maxID) {
            this.maxID = id;
        }
    }

    public int getMaxID() {
        return this.maxID;
    }

    public SpeakerDatabaseLoader(URL url, Vector description) {
        this();
        this.dbDescription = description;
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setUseCaches(false);
            InputStream is = urlConn.getInputStream();
            URI uri = url.toURI();
            String path = uri.getPath();
            if (path.endsWith(".txt") || path.endsWith(".TXT")) {
                this.databaseType = DatabaseType.TXT;
                this.readDatabaseStream(is);
            } else if ("https".equalsIgnoreCase(url.getProtocol())) {
                this.databaseType = DatabaseType.WIKISPEECH_XML;
                this.readDatabaseXMLStream(is);
            } else {
                this.databaseType = DatabaseType.SPEECH_DB;
                this.readSpeakersXMLStream(is);
            }
        }
        catch (Exception e) {
            this.logger.severe("SpeakerDatabaseLoader(" + url.toString() + "): " + e.toString());
        }
        this.dbIndex = this.db.getSpeakers().size() - 1;
    }

    public List<ipsk.apps.speechrecorder.db.Speaker> getDatabase() {
        return this.db.getSpeakers();
    }

    public Speakers getSpeakersDb() {
        return this.db;
    }

    private void readDatabaseStream(InputStream is) throws IOException {
        String fileLine;
        InputStreamReader fr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(fr);
        int lineCount = 0;
        while ((fileLine = br.readLine()) != null) {
            ++lineCount;
            if (fileLine.trim().startsWith("#")) break;
            String[] fields = fileLine.split("\t");
            int fieldCount = fields.length;
            if (fieldCount >= 1) {
                int ID2 = Integer.parseInt(fields[0]);
                this.setMaxID(ID2);
                ipsk.apps.speechrecorder.db.Speaker spk = new ipsk.apps.speechrecorder.db.Speaker(ID2);
                for (int i = 0; i < fieldCount - 1; ++i) {
                    int col = i + 1;
                    if (col == Speaker.COL_CODE) {
                        spk.setCode(fields[col]);
                        continue;
                    }
                    if (col == Speaker.COL_NAME) {
                        spk.setName(fields[col]);
                        continue;
                    }
                    if (col == Speaker.COL_FORENAME) {
                        spk.setForename(fields[col]);
                        continue;
                    }
                    if (col == Speaker.COL_GENDER) {
                        spk.setGender(fields[col]);
                        continue;
                    }
                    if (col == Speaker.COL_ACCENT) {
                        spk.setAccent(fields[col]);
                        continue;
                    }
                    if (col != Speaker.COL_BIRTHDATE) continue;
                    spk.setDateOfBirthString(fields[col]);
                }
                this.db.getSpeakers().add(spk);
                continue;
            }
            this.logger.warning("Incomplete entry in line " + lineCount + ". A valid entry must have an ID and a code field. " + fileLine);
        }
        fr.close();
        br.close();
    }

    private void readDatabaseFile(File fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.readDatabaseStream(fis);
        }
        catch (FileNotFoundException e) {
            this.logger.severe("readDatabaseFile(" + fileName.getAbsolutePath() + "): " + e.toString());
        }
        catch (IOException e) {
            this.logger.severe("readDatabaseFile(" + fileName.getAbsolutePath() + "): " + e.toString());
        }
    }

    private void readSpeakersXMLStream(InputStream is) throws IOException {
        this.db = (Speakers)JAXB.unmarshal((InputStream)is, Speakers.class);
        is.close();
        this.db.getSpeakers();
        this.setMaxID(this.db.maxID());
    }

    private void readDatabaseXMLStream(InputStream is) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            this.extractData(doc.getDocumentElement());
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void readDatabaseXMLFile(File file) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        this.readDatabaseXMLStream(fis);
    }

    private void extractData(Node node) {
        if (node.getNodeType() == 1) {
            if (node.getNodeName().equals("speakerlist")) {
                SpeakerReader speakerReader = new SpeakerReader(node);
                Vector<Speaker> dbV = speakerReader.getVector();
                ArrayList<ipsk.apps.speechrecorder.db.Speaker> dbSpks = new ArrayList<ipsk.apps.speechrecorder.db.Speaker>();
                for (Speaker sp : dbV) {
                    ipsk.apps.speechrecorder.db.Speaker nSpk = new ipsk.apps.speechrecorder.db.Speaker(sp.getID());
                    dbSpks.add(nSpk);
                }
                this.db.setSpeakers(dbSpks);
                this.setMaxID(speakerReader.getMaxID());
            } else {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    this.extractData(currentNode);
                }
            }
        }
    }

    public void writeDatabaseFile(File dbFile) throws IOException {
        if (DatabaseType.SPEECH_DB.equals((Object)this.databaseType)) {
            JAXB.marshal((Object)this.db, (File)dbFile);
        } else {
            BufferedWriter dbOutput = new BufferedWriter(new FileWriter(dbFile));
            for (ipsk.apps.speechrecorder.db.Speaker spk : this.db.getSpeakers()) {
                StringBuffer s = new StringBuffer(Integer.toString(spk.getPersonId()));
                Vector<String> v = new Vector<String>();
                v.add(spk.getCode());
                v.add(spk.getName());
                v.add(spk.getForename());
                v.add(spk.getGender());
                v.add(spk.getAccent());
                v.add(spk.getDateOfBirthString());
                for (int i = 0; i < v.size(); ++i) {
                    String element = (String)v.elementAt(i);
                    String dbValue = "";
                    if (element != null) {
                        dbValue = element.toString();
                    }
                    s.append("\t" + dbValue);
                }
                dbOutput.write(s + "\n");
            }
            dbOutput.close();
        }
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public static enum DatabaseType {
        SPEECH_DB,
        WIKISPEECH_XML,
        TXT;

    }
}

