/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.Speaker;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SpeakerViewer
extends JPanel {
    private static final long serialVersionUID = 938664794388265379L;
    private JLabel[] desc;
    private JLabel[] val;
    static final Font labelFont = new Font("sans-serif", 0, 12);
    static final Font valueFont = new Font("sans-serif", 1, 12);
    private Vector<String> labels;
    private ipsk.db.speech.Speaker data;
    private int rows = 0;
    private int hspace = 2;
    private int vspace = 2;
    private DecimalFormat idFormat = new DecimalFormat("0000");

    SpeakerViewer() {
        this.labels = Speaker.getDescription();
        int l = this.labels.size();
        int cols = (l + 1 + 1) / 2 * 2;
        this.setLayout(new GridLayout(this.rows, cols, this.hspace, this.vspace));
        this.setForeground(Color.black);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.desc = new JLabel[l];
        this.val = new JLabel[l];
        for (int i = 0; i < l; ++i) {
            this.desc[i] = new JLabel(this.labels.elementAt(i) + ":", 4);
            this.desc[i].setFont(labelFont);
            this.val[i] = new JLabel("");
            this.val[i].setHorizontalAlignment(2);
            this.val[i].setFont(valueFont);
            this.add(this.desc[i]);
            this.add(this.val[i]);
        }
    }

    SpeakerViewer(ipsk.apps.speechrecorder.db.Speaker spk) {
        this();
        this.setData(spk);
    }

    public void setData(ipsk.apps.speechrecorder.db.Speaker spk) {
        if (spk == null) {
            for (int i = 0; i < this.labels.size(); ++i) {
                this.val[i].setText("");
            }
        } else {
            for (int i = 0; i < this.labels.size(); ++i) {
                String dataStr = null;
                int col = i;
                if (col == Speaker.COL_ID) {
                    int id = spk.getPersonId();
                    dataStr = this.idFormat.format(id);
                } else if (col == Speaker.COL_CODE) {
                    dataStr = spk.getCode();
                } else if (col == Speaker.COL_NAME) {
                    dataStr = spk.getName();
                } else if (col == Speaker.COL_FORENAME) {
                    dataStr = spk.getForename();
                } else if (col == Speaker.COL_GENDER) {
                    dataStr = spk.getGender();
                } else if (col == Speaker.COL_ACCENT) {
                    dataStr = spk.getAccent();
                } else if (col == Speaker.COL_BIRTHDATE) {
                    dataStr = spk.getDateOfBirthString();
                }
                if (dataStr != null) {
                    this.val[i].setText(dataStr);
                    continue;
                }
                this.val[i].setText("");
            }
        }
        this.revalidate();
        this.repaint();
    }
}

