/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config;

import ipsk.apps.speechrecorder.config.Font;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontView
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_MAX_FONT_SIZE = 1000000.0f;
    private JSpinner sizeSpinner;
    private JComboBox familyBox;
    private JList altFamilyList;
    private JButton addAltFamilyButt;
    private JButton removeAltFamilyButt;
    private JCheckBox boldBox;
    private JCheckBox italicBox;
    private JTextArea tc;
    private boolean adjusting = false;
    private JComboBox altFamilyBox;

    public FontView() {
        this((Font)null);
    }

    public FontView(Font f) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.5;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] familys = ge.getAvailableFontFamilyNames();
        this.add((Component)new JLabel("Family"), c);
        this.familyBox = new JComboBox<String>(familys);
        ++c.gridx;
        this.add((Component)this.familyBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Alt. families"), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.altFamilyList = new JList();
        this.altFamilyList.setVisibleRowCount(3);
        this.altFamilyList.addListSelectionListener(this);
        JScrollPane famlistSp = new JScrollPane(this.altFamilyList);
        this.add((Component)famlistSp, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.altFamilyBox = new JComboBox<String>(familys);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)this.altFamilyBox, c);
        this.addAltFamilyButt = new JButton("+");
        this.addAltFamilyButt.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.addAltFamilyButt, c);
        this.removeAltFamilyButt = new JButton("-");
        ++c.gridx;
        this.add((Component)this.removeAltFamilyButt, c);
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Bold"), c);
        this.boldBox = new JCheckBox();
        ++c.gridx;
        this.add((Component)this.boldBox, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Italic"), c);
        this.italicBox = new JCheckBox();
        ++c.gridx;
        this.add((Component)this.italicBox, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Size"), c);
        Float min = new Float(0.0f);
        Float max = new Float(1000000.0f);
        Float step = new Float(1.0f);
        SpinnerNumberModel model = new SpinnerNumberModel(min, min, max, step);
        this.sizeSpinner = new JSpinner(model);
        ++c.gridx;
        this.add((Component)this.sizeSpinner, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        this.tc = new JTextArea();
        this.tc.setPreferredSize(new Dimension(100, 60));
        this.tc.setText("Example !");
        this.add((Component)this.tc, c);
        if (f != null) {
            this.setSelectedFont(f);
        }
        this.familyBox.addActionListener(this);
        this.altFamilyBox.addActionListener(this);
        this.removeAltFamilyButt.addActionListener(this);
        this.boldBox.addActionListener(this);
        this.italicBox.addActionListener(this);
        this.sizeSpinner.addChangeListener(this);
    }

    public void setSelectedFont(Font f) {
        this.adjusting = true;
        String[] families = f.getFamily();
        int famSize = families.length;
        if (famSize <= 0) {
            throw new IllegalArgumentException("At least one font family expected!");
        }
        String family = families[0];
        String[] altFamilies = new String[families.length - 1];
        for (int i = 1; i < famSize; ++i) {
            altFamilies[i - 1] = families[i];
        }
        this.altFamilyList.setListData(altFamilies);
        this.familyBox.setSelectedItem(family);
        int style = f.getStyle();
        this.boldBox.setSelected((style & 1) > 0);
        this.italicBox.setSelected((style & 2) > 0);
        this.sizeSpinner.setValue(new Float(f.getSize()));
        this.tc.setFont(f.toFont());
        this.setDependencies();
        this.adjusting = false;
    }

    public Font getSelectedFont() {
        Font f = new Font();
        this.applySelectedFont(f);
        return f;
    }

    private String[] familiesInList() {
        int fontsCount = this.altFamilyList.getModel().getSize();
        String[] fontFams = new String[fontsCount];
        for (int i = 0; i < fontsCount; ++i) {
            fontFams[i] = (String)this.altFamilyList.getModel().getElementAt(i);
        }
        return fontFams;
    }

    private List<String> familiesInListAsList() {
        int fontsCount = this.altFamilyList.getModel().getSize();
        ArrayList<String> fontFams = new ArrayList<String>();
        for (int i = 0; i < fontsCount; ++i) {
            fontFams.add((String)this.altFamilyList.getModel().getElementAt(i));
        }
        return fontFams;
    }

    public void applySelectedFont(Font f) {
        ArrayList<String> fontFams = new ArrayList<String>();
        fontFams.add((String)this.familyBox.getSelectedItem());
        List<String> altFontFams = this.familiesInListAsList();
        fontFams.addAll(altFontFams);
        f.setFamily(fontFams.toArray(new String[0]));
        if (this.boldBox.isSelected()) {
            f.setStyle(f.getStyle() | 1);
        } else {
            f.setStyle(f.getStyle() & 0xFFFFFFFE);
        }
        if (this.italicBox.isSelected()) {
            f.setStyle(f.getStyle() | 2);
        } else {
            f.setStyle(f.getStyle() & 0xFFFFFFFD);
        }
        f.setSize(((Float)this.sizeSpinner.getValue()).floatValue());
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Object src = ce.getSource();
        if (src == this.sizeSpinner) {
            this.updatePreview();
        }
    }

    private void setDependencies() {
        if (!this.adjusting) {
            this.updatePreview();
        }
        Object altFamsel = this.altFamilyList.getSelectedValue();
        this.removeAltFamilyButt.setEnabled(altFamsel instanceof String);
        String selFont = (String)this.familyBox.getSelectedItem();
        List<String> selFonts = this.familiesInListAsList();
        selFonts.add(selFont);
        String selAltFont = (String)this.altFamilyBox.getSelectedItem();
        this.addAltFamilyButt.setEnabled(!selFonts.contains(selAltFont));
    }

    private void updatePreview() {
        Font f = this.getSelectedFont();
        this.tc.setFont(f.toFont());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object sel;
        Object src = ae.getSource();
        if (src == this.addAltFamilyButt) {
            List<String> fams = this.familiesInListAsList();
            fams.add((String)this.altFamilyBox.getSelectedItem());
            this.altFamilyList.setListData(fams.toArray(new String[0]));
        } else if (src == this.removeAltFamilyButt && (sel = this.altFamilyList.getSelectedValue()) instanceof String) {
            List<String> fams = this.familiesInListAsList();
            fams.remove(sel);
            this.altFamilyList.setListData(fams.toArray(new String[0]));
        }
        this.setDependencies();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        Object src = lse.getSource();
        if (src == this.altFamilyList) {
            this.setDependencies();
        }
    }
}

