/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.MixerName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AudioDevicesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COL_INTERFACE = 0;
    private static final int COL_PROVIDERID = 1;
    private static final int COL_DEVICE = 2;
    private static final int COL_REGEX = 3;
    private static final int LAST_COL_INDEX = 3;
    private List<MixerName> deviceNames = new ArrayList<MixerName>();

    @Override
    public String getColumnName(int colIndex) {
        if (colIndex == 0) {
            return "Interface";
        }
        if (colIndex == 1) {
            return "Provider ID";
        }
        if (colIndex == 2) {
            return "Device";
        }
        if (colIndex == 3) {
            return "Regular expression";
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int colIndex) {
        if (colIndex == 0) {
            return String.class;
        }
        if (colIndex == 1) {
            return String.class;
        }
        if (colIndex == 2) {
            return String.class;
        }
        if (colIndex == 3) {
            return Boolean.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.deviceNames.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        if (colIndex == 0) {
            return false;
        }
        if (colIndex == 1) {
            return false;
        }
        if (colIndex == 2) {
            return true;
        }
        return colIndex == 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.deviceNames.size() || col > 3) {
            return null;
        }
        MixerName rowMn = this.deviceNames.get(row);
        if (col == 0) {
            return rowMn.getInterfaceName();
        }
        if (col == 1) {
            String providerId = rowMn.getProviderId();
            if (providerId == null) {
                return "";
            }
            return providerId;
        }
        if (col == 2) {
            return rowMn.getName();
        }
        if (col == 3) {
            return rowMn.isRegex();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int col) {
        if (rowIndex <= this.deviceNames.size()) {
            MixerName mn = this.deviceNames.get(rowIndex);
            if (col == 0) {
                if (aValue instanceof String) {
                    String strVal = (String)aValue;
                    mn.setInterfaceName(strVal);
                }
            } else if (col == 1) {
                if (aValue instanceof String) {
                    String strVal = (String)aValue;
                    if (strVal == null || "".equals(strVal)) {
                        mn.setProviderId(null);
                    } else {
                        mn.setProviderId(strVal);
                    }
                }
            } else if (col == 2) {
                if (aValue instanceof String) {
                    String strVal = (String)aValue;
                    mn.setName(strVal);
                }
            } else if (col == 3 && aValue instanceof Boolean) {
                Boolean bVal = (Boolean)aValue;
                mn.setRegex(bVal);
            }
            this.fireTableDataChanged();
        }
    }

    public boolean add(MixerName arg0) {
        boolean ret = this.deviceNames.add(arg0);
        if (ret) {
            this.fireTableDataChanged();
        }
        return ret;
    }

    public void clear() {
        this.deviceNames.clear();
        this.fireTableDataChanged();
    }

    public MixerName get(int arg0) {
        MixerName ret = this.deviceNames.get(arg0);
        this.fireTableDataChanged();
        return ret;
    }

    public MixerName remove(int arg0) {
        MixerName ret = this.deviceNames.remove(arg0);
        this.fireTableDataChanged();
        return ret;
    }

    public boolean remove(MixerName arg0) {
        boolean ret = this.deviceNames.remove(arg0);
        this.fireTableDataChanged();
        return ret;
    }

    public int size() {
        return this.deviceNames.size();
    }

    public boolean contains(MixerName o) {
        return this.deviceNames.contains(o);
    }

    public boolean containsAll(Collection<MixerName> c) {
        return this.deviceNames.containsAll(c);
    }

    public List<MixerName> getDeviceNames() {
        return this.deviceNames;
    }
}

