/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.config.Handler;
import ipsk.apps.speechrecorder.config.HandlerView;
import ipsk.apps.speechrecorder.config.Logger;
import ipsk.apps.speechrecorder.config.LoggingConfiguration;
import ipsk.apps.speechrecorder.config.ui.LoggerView;
import ipsk.swing.TitledPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LoggingConfigurationView
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GridBagConstraints c = new GridBagConstraints();
    protected TitledPanel handlerPanel;
    protected TitledPanel loggerPanel;
    private JCheckBox[] enableCheckBoxes = new JCheckBox[0];
    private Logger[] displayedLogger;
    private Handler[] displayedHandlers;
    private LoggerView[] loggerViews;
    private HandlerView[] handlerViews;

    public LoggingConfigurationView() {
        super(new GridBagLayout());
        int i;
        this.c.insets = new Insets(2, 5, 2, 5);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.anchor = 11;
        this.c.weighty = 1.0;
        this.handlerPanel = new TitledPanel("Log-Handler");
        this.handlerPanel.setLayout((LayoutManager)new GridBagLayout());
        this.add((Component)this.handlerPanel, this.c);
        this.loggerPanel = new TitledPanel("Logger");
        this.loggerPanel.setLayout((LayoutManager)new GridBagLayout());
        ++this.c.gridy;
        this.add((Component)this.loggerPanel, this.c);
        this.displayedHandlers = SpeechRecorder.DEF_LOG_HANDLERS;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.handlerViews = new HandlerView[this.displayedHandlers.length];
        for (i = 0; i < this.displayedHandlers.length; ++i) {
            HandlerView hv;
            this.handlerViews[i] = hv = new HandlerView(SpeechRecorder.DEF_LOG_HANDLERS[i]);
            this.handlerPanel.add((Component)hv, (Object)c);
            ++c.gridy;
        }
        this.displayedLogger = SpeechRecorder.AVAIL_LOGGERS;
        this.enableCheckBoxes = new JCheckBox[this.displayedLogger.length];
        this.loggerViews = new LoggerView[this.displayedLogger.length];
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        for (i = 0; i < this.displayedLogger.length; ++i) {
            LoggerView lv;
            c.gridx = 0;
            JCheckBox enableBox = new JCheckBox();
            enableBox.addActionListener(this);
            this.enableCheckBoxes[i] = enableBox;
            this.loggerPanel.add((Component)this.enableCheckBoxes[i], (Object)c);
            this.loggerViews[i] = lv = new LoggerView();
            lv.setEnabled(false);
            lv.setLogger(this.displayedLogger[i]);
            ++c.gridx;
            this.loggerPanel.add((Component)lv, (Object)c);
            ++c.gridy;
        }
    }

    public void setLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
        Logger[] logs = loggingConfiguration.getLogger();
        block0: for (int i = 0; i < this.displayedLogger.length; ++i) {
            this.loggerViews[i].setEnabled(false);
            for (int j = 0; j < logs.length; ++j) {
                if (!this.displayedLogger[i].getName().equals(logs[j].getName())) continue;
                this.loggerViews[i].setLogger(logs[i]);
                this.loggerViews[i].setEnabled(true);
                this.enableCheckBoxes[i].setSelected(true);
                continue block0;
            }
        }
        this.setDependencies();
    }

    public void applyValues(LoggingConfiguration l) {
        Vector<Logger> newLgs = new Vector<Logger>();
        ArrayList<Handler> newHandlers = new ArrayList<Handler>();
        for (int i = 0; i < this.displayedLogger.length; ++i) {
            if (!this.enableCheckBoxes[i].isSelected()) continue;
            this.loggerViews[i].applyValues(this.displayedLogger[i]);
            newLgs.add(this.displayedLogger[i]);
            String handlerName = this.displayedLogger[i].getHandlerName();
            for (int j = 0; j < this.displayedHandlers.length; ++j) {
                if (!handlerName.equals(this.displayedHandlers[j].getName())) continue;
                this.handlerViews[j].applyValues(this.displayedHandlers[j]);
                newHandlers.add(this.displayedHandlers[j]);
            }
        }
        l.setHandler(newHandlers.toArray(new Handler[0]));
        l.setLogger(newLgs.toArray(new Logger[0]));
    }

    private void setDependencies() {
        for (int i = 0; i < this.enableCheckBoxes.length; ++i) {
            this.loggerViews[i].setEnabled(this.enableCheckBoxes[i].isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setDependencies();
    }
}

