/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.ui.audio.ControllerSelector;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceChooserTabs;
import ipsk.audio.AudioController2;
import javax.swing.JTabbedPane;

public class ProjectAudioConfigPanel
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private AudioController2 audioController;
    private DeviceChooserTabs captureListChooser;
    private DeviceChooserTabs playbackListChooser;
    private DeviceChooserTabs promptPlaybackListChooser;
    private ControllerSelector controllerSelector;

    public ProjectAudioConfigPanel(AudioController2 audioController) {
        this.audioController = audioController;
        this.captureListChooser = new DeviceChooserTabs(audioController, AudioController2.DeviceType.CAPTURE);
        this.addTab("Recording", this.captureListChooser);
        this.playbackListChooser = new DeviceChooserTabs(audioController, AudioController2.DeviceType.PLAYBACK);
        this.addTab("Playback", this.playbackListChooser);
        this.promptPlaybackListChooser = new DeviceChooserTabs(audioController, AudioController2.DeviceType.PLAYBACK);
        this.addTab("Prompt Playback", this.promptPlaybackListChooser);
        this.controllerSelector = new ControllerSelector();
        this.addTab("Controller", this.controllerSelector);
    }

    public void setProjectConfiguration(ProjectConfiguration project) {
        this.controllerSelector.setProjectConfiguration(project);
        MixerName[] orgRecMixerNames = project.getRecordingMixerName();
        MixerName[] recMixerNames = ConfigHelper.getAJSConvertedMixerNames(this.audioController, orgRecMixerNames);
        this.captureListChooser.setSelectedMixerNames(recMixerNames);
        MixerName[] orgPlayMixerNames = project.getPlaybackMixerName();
        MixerName[] playMixerNames = ConfigHelper.getAJSConvertedMixerNames(this.audioController, orgPlayMixerNames);
        this.playbackListChooser.setSelectedMixerNames(playMixerNames);
        MixerName[] promptPlayMixerNames = project.getPromptPlaybackMixerName();
        this.promptPlaybackListChooser.setSelectedMixerNames(promptPlayMixerNames);
    }

    public void applyValues(ProjectConfiguration p) {
        this.captureListChooser.stopEditing();
        MixerName[] recMixerNames = this.captureListChooser.getSelectedMixerNames();
        p.setRecordingMixerName(recMixerNames);
        this.playbackListChooser.stopEditing();
        MixerName[] playMixerNames = this.playbackListChooser.getSelectedMixerNames();
        p.setPlaybackMixerName(playMixerNames);
        this.promptPlaybackListChooser.stopEditing();
        MixerName[] promptPlayMixerNames = this.promptPlaybackListChooser.getSelectedMixerNames();
        p.setPromptPlaybackMixerName(promptPlayMixerNames);
    }
}

