/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceChooserTabs;
import ipsk.apps.speechrecorder.config.ui.recording.ChannelAssignmentUI;
import ipsk.apps.speechrecorder.config.ui.recording.RecordingFormatView;
import ipsk.apps.speechrecorder.config.ui.recording.RecordingMainView;
import ipsk.audio.AudioController2;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class RecordingView
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private DeviceChooserTabs dvc;
    private RecordingFormatView rfv;
    private RecordingMainView rmv;
    private ChannelAssignmentUI rui;
    private AudioController2 audioController;

    public RecordingView(AudioController2 ac) {
        this.audioController = ac;
        this.dvc = new DeviceChooserTabs(ac, AudioController2.DeviceType.CAPTURE);
        this.rui = new ChannelAssignmentUI();
        this.rfv = new RecordingFormatView(this.rui);
        this.rmv = new RecordingMainView();
        this.addTab("Device", this.dvc);
        this.addTab("Channel routing", (Component)((Object)this.rui));
        this.addTab("Format", (Component)((Object)this.rfv));
        this.addTab("Options", (Component)((Object)this.rmv));
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        MixerName[] orgRecMixerNames = projectConfiguration.getRecordingMixerName();
        MixerName[] recMixerNames = ConfigHelper.getAJSConvertedMixerNames(this.audioController, orgRecMixerNames);
        this.dvc.setSelectedMixerNames(recMixerNames);
        RecordingConfiguration recordingConfiguration = projectConfiguration.getRecordingConfiguration();
        this.rfv.setRecordingConfiguration(recordingConfiguration);
        this.rmv.setRecordingConfiguration(recordingConfiguration);
        this.rui.setConfig(recordingConfiguration.getChannelAssignment());
    }

    public void applyValues(ProjectConfiguration p) {
        RecordingConfiguration r = p.getRecordingConfiguration();
        this.dvc.stopEditing();
        MixerName[] recMixerNames = this.dvc.getSelectedMixerNames();
        p.setRecordingMixerName(recMixerNames);
        this.rfv.applyValues(r);
        this.rmv.applyValues(r);
    }
}

