/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.audio;

import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceChooser;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceListChooser;
import ipsk.audio.AudioController2;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProviderInfo;
import ipsk.text.ParserException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.sound.sampled.Mixer;
import javax.swing.JTabbedPane;

public class DeviceChooserTabs
extends JTabbedPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DeviceChooser chooser;
    private DeviceListChooser listChooser;

    public DeviceChooserTabs(AudioController2 controller, AudioController2.DeviceType deviceType) {
        this.setTabPlacement(4);
        this.chooser = new DeviceChooser(controller, deviceType);
        this.chooser.addActionListener(this);
        this.addTab("Simple", this.chooser);
        this.listChooser = new DeviceListChooser(controller, deviceType);
        this.listChooser.addActionListener(this);
        this.addTab("Expert", this.listChooser);
    }

    public void setSelectedMixerNames(MixerName[] mixerNames) {
        this.listChooser.setSelectedMixerNames(mixerNames);
        DeviceInfo selDeviceInfo = null;
        boolean chooserEnabled = false;
        if (mixerNames != null) {
            if (mixerNames.length == 0) {
                chooserEnabled = true;
            } else if (mixerNames.length == 1) {
                MixerName mn = mixerNames[0];
                String cn = null;
                try {
                    MixerName.ProviderId providerIdObj = mn.providerIdObj();
                    if (MixerName.ProviderId.ProviderIdType.JAVA_CLASS.equals((Object)providerIdObj.getIdType())) {
                        cn = providerIdObj.getId();
                    }
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
                DeviceProviderInfo defaultDeviceProviderInfo = this.chooser.getDefaultDeviceProviderInfo();
                if (!mn.isRegex() && cn != null && cn.equals(defaultDeviceProviderInfo.getImplementationClassname())) {
                    String devName = mn.getName();
                    List<DeviceInfo> diList = this.chooser.selectableDeviceInfos();
                    for (DeviceInfo di : diList) {
                        String mName;
                        Mixer.Info mInfo;
                        if (di == null || (mInfo = di.getMixerInfo()) == null || (mName = mInfo.getName()) == null || !mName.equals(devName)) continue;
                        selDeviceInfo = di;
                        chooserEnabled = true;
                        break;
                    }
                }
            }
        } else {
            chooserEnabled = true;
        }
        this.chooser.setSelectedDeviceInfo(selDeviceInfo);
        this.chooser.setEnabled(chooserEnabled);
        if (!chooserEnabled) {
            this.setSelectedComponent(this.listChooser);
        }
        this.setEnabledAt(0, chooserEnabled);
    }

    public void stopEditing() {
        this.listChooser.stopEditing();
    }

    public MixerName[] getSelectedMixerNames() {
        return this.listChooser.getSelectedMixerNames();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.chooser) {
            DeviceInfo di = this.chooser.getSelectedDeviceInfo();
            if (di == null) {
                this.setSelectedMixerNames(new MixerName[0]);
            } else {
                String cn = di.getDeviceProviderInfo().getImplementationClassname();
                MixerName.ProviderId pIdObj = new MixerName.ProviderId(MixerName.ProviderId.ProviderIdType.JAVA_CLASS, cn);
                MixerName mn = new MixerName(pIdObj.toString(), di.getMixerInfo().getName());
                this.setSelectedMixerNames(new MixerName[]{mn});
            }
        } else if (src == this.listChooser) {
            MixerName[] mns = this.listChooser.getSelectedMixerNames();
            this.setSelectedMixerNames(mns);
        }
    }
}

