/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.prompt;

import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.Prompter;
import ipsk.apps.speechrecorder.config.TransportPanel;
import ipsk.apps.speechrecorder.config.ui.KeyInputMapView;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PromptSpeakerPrompterConfigurationView
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox promptWindowCheckBox;
    private JComboBox speakerDisplayTypeBox;
    private JCheckBox speakerDisplayFullScreenModeBox;
    private JCheckBox buttonsInPromptWindowCheckBox;
    private JLabel buttonsInPromptWindowLabel;
    private JLabel showStartRecordActionLabel;
    private JCheckBox showStartRecordActionChkBox;
    private JLabel showStopRecordActionLabel;
    private JCheckBox showStopRecordActionChkBox;
    private KeyInputMapView keyInputMapView;

    public PromptSpeakerPrompterConfigurationView(KeyInputMapView keyInputMapView) {
        super(new GridBagLayout());
        this.keyInputMapView = keyInputMapView;
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Show separate prompt window:"), c);
        this.promptWindowCheckBox = new JCheckBox();
        this.promptWindowCheckBox.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.promptWindowCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel speakerDisplayFullScreenModeLabel = new JLabel("Speaker display fullscreen mode:");
        this.add((Component)speakerDisplayFullScreenModeLabel, c);
        this.speakerDisplayFullScreenModeBox = new JCheckBox();
        this.speakerDisplayFullScreenModeBox.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.speakerDisplayFullScreenModeBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel speakerDisplayTypeLabel = new JLabel("Choose speaker display type:");
        this.add((Component)speakerDisplayTypeLabel, c);
        EnumVector wTypeVector = new EnumVector(Prompter.SpeakerWindowType.class);
        this.speakerDisplayTypeBox = new JComboBox(wTypeVector);
        this.speakerDisplayTypeBox.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.speakerDisplayTypeBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.buttonsInPromptWindowLabel = new JLabel("Show transport buttons in prompt window:");
        this.add((Component)this.buttonsInPromptWindowLabel, c);
        this.buttonsInPromptWindowCheckBox = new JCheckBox();
        this.buttonsInPromptWindowCheckBox.addActionListener(this);
        ++c.gridx;
        this.add((Component)this.buttonsInPromptWindowCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.showStartRecordActionLabel = new JLabel("Show start record button");
        this.showStartRecordActionChkBox = new JCheckBox();
        this.showStartRecordActionChkBox.addActionListener(this);
        this.add((Component)this.showStartRecordActionLabel, c);
        ++c.gridx;
        this.add((Component)this.showStartRecordActionChkBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.showStopRecordActionLabel = new JLabel("Show stop record button");
        this.showStopRecordActionChkBox = new JCheckBox();
        this.showStopRecordActionChkBox.addActionListener(this);
        this.add((Component)this.showStopRecordActionLabel, c);
        ++c.gridx;
        this.add((Component)this.showStopRecordActionChkBox, c);
        this.setDependencies();
    }

    public void setPromptConfiguration(PromptConfiguration promptConfiguration) {
        Prompter spkDisplayPrompter = null;
        Prompter[] prompters = promptConfiguration.getPrompter();
        if (prompters != null && prompters.length > 0) {
            spkDisplayPrompter = prompters[0];
        }
        this.promptWindowCheckBox.setSelected(promptConfiguration.getShowPromptWindow());
        this.buttonsInPromptWindowCheckBox.setSelected(promptConfiguration.getShowButtonsInPromptWindow());
        if (spkDisplayPrompter != null) {
            TransportPanel tr = spkDisplayPrompter.getTransportPanel();
            if (tr != null) {
                this.showStartRecordActionChkBox.setSelected(tr.isShowStartRecordAction());
                this.showStopRecordActionChkBox.setSelected(tr.isShowStopRecordAction());
            }
            Prompter.SpeakerWindowType speakerWindowType = spkDisplayPrompter.getSpeakerWindowType();
            EnumSelectionItem spkWTEsi = new EnumSelectionItem((Enum)speakerWindowType);
            this.speakerDisplayTypeBox.setSelectedItem(spkWTEsi);
            Boolean fsm = spkDisplayPrompter.getFullScreenMode();
            boolean fsmb = false;
            if (fsm != null) {
                fsmb = fsm;
            }
            this.speakerDisplayFullScreenModeBox.setSelected(fsmb);
        } else {
            this.showStartRecordActionChkBox.setSelected(promptConfiguration.getShowButtonsInPromptWindow());
            this.showStopRecordActionChkBox.setSelected(promptConfiguration.getShowButtonsInPromptWindow());
        }
        this.setDependencies();
    }

    public void applyValues(PromptConfiguration p) {
        p.setShowPromptWindow(this.promptWindowCheckBox.isSelected());
        boolean showTransport = this.buttonsInPromptWindowCheckBox.isSelected();
        p.setShowButtonsInPromptWindow(showTransport);
        boolean showStartButt = this.showStartRecordActionChkBox.isSelected();
        boolean showStopButt = this.showStopRecordActionChkBox.isSelected();
        Prompter[] prompters = p.getPrompter();
        Prompter prompter = null;
        if (prompters == null || prompters.length == 0) {
            prompter = new Prompter();
            prompters = new Prompter[]{prompter};
            p.setPrompter(prompters);
        } else {
            prompter = prompters[0];
        }
        EnumSelectionItem swtsi = (EnumSelectionItem)this.speakerDisplayTypeBox.getSelectedItem();
        prompter.setSpeakerWindowType((Prompter.SpeakerWindowType)swtsi.getEnumVal());
        Boolean fullscreenMode = null;
        if (this.speakerDisplayFullScreenModeBox.isSelected()) {
            fullscreenMode = new Boolean(true);
        }
        prompter.setFullScreenMode(fullscreenMode);
        TransportPanel tr = prompter.getTransportPanel();
        if (tr == null) {
            tr = new TransportPanel();
            prompter.setTransportPanel(tr);
        }
        tr.setShowStartRecordAction(showStartButt);
        tr.setShowStopRecordAction(showStopButt);
    }

    private void setDependencies() {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.speakerDisplayTypeBox) {
            int res;
            EnumSelectionItem swtsi = (EnumSelectionItem)this.speakerDisplayTypeBox.getSelectedItem();
            Prompter.SpeakerWindowType spkwType = (Prompter.SpeakerWindowType)swtsi.getEnumVal();
            boolean closeWindowActionBound = this.keyInputMapView.isCloseSpeakerDisplayActionBound();
            if (spkwType != null && spkwType.equals((Object)Prompter.SpeakerWindowType.WINDOW) && !closeWindowActionBound && (res = JOptionPane.showOptionDialog(this, "You selected a plain window as display type for the speaker window.\nYou may not be able to use the mouse to get back to the operating system view.\nIt is recommended to associate a key to close the window.\nAssociate the Escape key with speaker window close action?", "Speaker window configuration warning", 0, 0, null, null, 0)) == 0) {
                this.keyInputMapView.bindCloseSpeakerDisplayActiontoEscape();
            }
        } else if (src == this.speakerDisplayFullScreenModeBox) {
            int res;
            boolean closeWindowActionBound = this.keyInputMapView.isCloseSpeakerDisplayActionBound();
            if (this.speakerDisplayFullScreenModeBox.isSelected() && !closeWindowActionBound && (res = JOptionPane.showOptionDialog(this, "You selected fullscreen display for the speaker window.\nYou may not be able to use the mouse to get back to the operating system view.\nIt is recommended to associate a key to close the window.\nAssociate the Escape key with speaker window close action?", "Speaker window configuration warning", 0, 0, null, null, 0)) == 0) {
                this.keyInputMapView.bindCloseSpeakerDisplayActiontoEscape();
            }
        }
        this.setDependencies();
    }

    public void documentChanged(DocumentEvent de) {
        Document src = de.getDocument();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }
}

