/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.recording;

import ipsk.apps.speechrecorder.config.ChannelRouting;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.swing.TitledPanel;
import ipsk.swing.panel.JConfigPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChannelAssignmentUI
extends JConfigPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private ChannelRouting config;
    private ChannelRouting initialChannelRouting;
    private int targetChannelCount;
    private TitledPanel channelOffsetPanel;
    private JLabel channelOffsetLabel;
    private JSpinner channelOffsetBox;
    private TitledPanel channelRoutingPanel;
    private JLabel enableLabel;
    private JCheckBox enableBox;
    private JSpinner inputChannelCountBox;
    private TrgChannelListUI channelAssignmentUI;
    private JLabel inputChannelCountLbl;
    private SpinnerNumberModel channelOffsetModel;
    private SpinnerNumberModel inputChannelCountModel;

    public ChannelRouting getConfig() {
        return this.config;
    }

    public int getTargetChannelCount() {
        return this.targetChannelCount;
    }

    public void setTargetChannelCount(int targetChannelCount) {
        int oldTargetChannelCount = this.targetChannelCount;
        this.targetChannelCount = targetChannelCount;
        if (oldTargetChannelCount != targetChannelCount) {
            this.channelAssignmentUI.setRecordingChannelCount(targetChannelCount);
        }
    }

    public void setConfig(ChannelRouting config) {
        this.initialChannelRouting = config;
        this.applyConfig(config);
    }

    public void applyConfig(ChannelRouting config) {
        this.config = config;
        boolean channelOffsetMode = false;
        boolean routingEnabled = false;
        int[] routing = null;
        Integer srcChannelCount = null;
        int channelOffset = 0;
        if (config != null) {
            routing = config.getAssign();
            channelOffset = config.getChannelOffset();
            channelOffsetMode = channelOffset != 0;
            routingEnabled = !channelOffsetMode && routing != null;
            srcChannelCount = config.getSrcChannelCount();
            if (srcChannelCount == null) {
                srcChannelCount = this.srcChannelCountByAssignment(routing);
            }
        }
        this.channelOffsetModel.setValue(channelOffset);
        this.channelAssignmentUI.setRouting(routing);
        this.enableBox.setSelected(routingEnabled);
        if (srcChannelCount == null) {
            this.setDefaultSrcChannels();
        } else {
            this.channelAssignmentUI.setSrcChannelCount(srcChannelCount);
            this.inputChannelCountBox.setValue(srcChannelCount);
        }
        this.setDependencies();
    }

    public ChannelAssignmentUI() {
        JPanel cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints pc = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.anchor = 17;
        pc.insets = new Insets(1, 1, 1, 1);
        c.weightx = 2.0;
        c.gridx = 0;
        c.gridy = 0;
        this.channelOffsetPanel = new TitledPanel("Channel offset");
        this.channelOffsetPanel.setLayout((LayoutManager)new GridBagLayout());
        pc.gridx = 0;
        pc.gridy = 0;
        pc.weightx = 0.0;
        pc.anchor = 17;
        this.channelOffsetLabel = new JLabel("Channel offset:");
        this.channelOffsetPanel.add((Component)this.channelOffsetLabel, (Object)pc);
        this.channelOffsetModel = new SpinnerNumberModel(0, 0, 256, 1);
        this.channelOffsetBox = new JSpinner(this.channelOffsetModel);
        this.channelOffsetModel.addChangeListener(this);
        ++pc.gridx;
        pc.weightx = 2.0;
        this.channelOffsetPanel.add((Component)this.channelOffsetBox, (Object)pc);
        c.fill = 2;
        cp.add((Component)this.channelOffsetPanel, c);
        this.channelRoutingPanel = new TitledPanel("Channel routing");
        this.channelRoutingPanel.setLayout((LayoutManager)new GridBagLayout());
        pc.gridx = 0;
        pc.gridy = 0;
        pc.weightx = 0.0;
        this.enableLabel = new JLabel("Enable: ");
        this.channelRoutingPanel.add((Component)this.enableLabel, (Object)pc);
        this.enableBox = new JCheckBox();
        ++pc.gridx;
        pc.weightx = 2.0;
        this.channelRoutingPanel.add((Component)this.enableBox, (Object)pc);
        this.enableBox.addActionListener(this);
        pc.gridx = 0;
        ++pc.gridy;
        pc.weightx = 0.0;
        this.inputChannelCountLbl = new JLabel("Input channel count:");
        this.channelRoutingPanel.add((Component)this.inputChannelCountLbl, (Object)pc);
        this.inputChannelCountModel = new SpinnerNumberModel(1, 1, 256, 1);
        this.inputChannelCountBox = new JSpinner(this.inputChannelCountModel);
        ++pc.gridx;
        pc.weightx = 2.0;
        this.channelRoutingPanel.add((Component)this.inputChannelCountBox, (Object)pc);
        this.inputChannelCountBox.addChangeListener(this);
        pc.gridx = 0;
        ++pc.gridy;
        pc.weightx = 2.0;
        pc.weighty = 2.0;
        pc.fill = 1;
        pc.gridwidth = 2;
        this.channelAssignmentUI = new TrgChannelListUI();
        JScrollPane sp = new JScrollPane(this.channelAssignmentUI);
        this.channelRoutingPanel.add((Component)sp, (Object)pc);
        c.weighty = 2.0;
        ++c.gridy;
        c.fill = 1;
        cp.add((Component)this.channelRoutingPanel, c);
    }

    private Integer srcChannelCountByAssignment(int[] assign) {
        Integer iccba = null;
        if (assign != null && assign.length > 0) {
            int maxAssChIdx = -1;
            for (int ac : assign) {
                if (ac <= maxAssChIdx) continue;
                maxAssChIdx = ac;
            }
            iccba = maxAssChIdx + 1;
        }
        return iccba;
    }

    public boolean anyChannelRoutingSelected() {
        int chOffset = this.channelOffsetModel.getNumber().intValue();
        boolean crSel = chOffset != 0 || this.enableBox.isSelected();
        return crSel;
    }

    public void applyStereoCaptureForMonoRecording() {
        this.enableBox.setSelected(true);
        this.inputChannelCountModel.setValue(new Integer(2));
        this.setDependencies();
    }

    public void applyValues(RecordingConfiguration recCfg) {
        ChannelRouting chRouting = null;
        int chOffset = this.channelOffsetModel.getNumber().intValue();
        if (this.enableBox.isSelected()) {
            chRouting = new ChannelRouting();
            Number minChsNum = this.inputChannelCountModel.getNumber();
            int minChs = minChsNum.intValue();
            int[] routing = this.channelAssignmentUI.getRouting();
            int srcChsByassign = this.srcChannelCountByAssignment(routing);
            Integer srcChannelsEff = null;
            if (srcChsByassign < minChs) {
                srcChannelsEff = minChs;
            }
            chRouting.setSrcChannelCount(srcChannelsEff);
            chRouting.setAssign(this.channelAssignmentUI.getRouting());
        } else if (chOffset != 0) {
            chRouting = new ChannelRouting();
            chRouting.setChannelOffset(chOffset);
        }
        recCfg.setChannelAssignment(chRouting);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelAssignmentUI ui = new ChannelAssignmentUI();
                JFrame f = new JFrame();
                f.getContentPane().add((Component)((Object)ui));
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private void setDefaultSrcChannels() {
        Number chOffsetNumber = this.channelOffsetModel.getNumber();
        int chOffset = chOffsetNumber.intValue();
        int minVal = chOffset + this.targetChannelCount;
        this.inputChannelCountModel.setValue(minVal);
        this.channelAssignmentUI.setSrcChannelCount(minVal);
    }

    private void setDependencies() {
        Number chOffsetNumber = this.channelOffsetModel.getNumber();
        int chOffset = chOffsetNumber.intValue();
        boolean channelOffsetMode = chOffset != 0;
        this.enableLabel.setEnabled(!channelOffsetMode);
        this.enableBox.setEnabled(!channelOffsetMode);
        boolean routingEnabled = !channelOffsetMode && this.enableBox.isSelected();
        this.channelOffsetLabel.setEnabled(!routingEnabled);
        this.channelOffsetBox.setEnabled(!routingEnabled);
        this.channelAssignmentUI.setEnabled(routingEnabled);
        this.inputChannelCountBox.setEnabled(routingEnabled);
        this.inputChannelCountLbl.setEnabled(routingEnabled);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean channelOffsetMode;
        Object src = e.getSource();
        Number chOffsetNumber = this.channelOffsetModel.getNumber();
        int chOffset = chOffsetNumber.intValue();
        boolean bl = channelOffsetMode = chOffset != 0;
        if (src == this.channelOffsetModel) {
            this.setDefaultSrcChannels();
        } else if (src == this.inputChannelCountBox && !channelOffsetMode) {
            Number valNum = this.inputChannelCountModel.getNumber();
            int minCh = valNum.intValue();
            this.channelAssignmentUI.setSrcChannelCount(minCh);
        }
        this.setDependencies();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.enableBox) {
            this.setDefaultSrcChannels();
        } else {
            super.actionPerformed(e);
        }
        this.setDependencies();
    }

    public void resetToDefaults() {
        this.applyConfig(new ChannelRouting());
    }

    public void resetToInitial() {
        this.applyConfig(this.initialChannelRouting);
    }

    public class TrgChannelListUI
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private List<JLabel> trgChLabels;
        private List<JComboBox> trgChSelectors;
        private boolean enabled;
        private int srcChannelCount;
        private int recordingChannelCount;
        private int[] routing;

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.apply();
        }

        public int getSrcChannelCount() {
            return this.srcChannelCount;
        }

        public void setSrcChannelCount(int srcChannelCount) {
            this.srcChannelCount = srcChannelCount;
            if (this.routing != null) {
                for (int i = 0; i < this.routing.length; ++i) {
                    int r = this.routing[i];
                    if (r < srcChannelCount) continue;
                    int newIdx = srcChannelCount - 1;
                    if (newIdx < 0) {
                        newIdx = 0;
                    }
                    this.routing[i] = newIdx;
                }
            }
            this.createUI();
        }

        public TrgChannelListUI() {
            super(new GridBagLayout());
            this.trgChLabels = new ArrayList<JLabel>();
            this.trgChSelectors = new ArrayList<JComboBox>();
            this.enabled = true;
            this.srcChannelCount = 0;
            this.recordingChannelCount = 0;
        }

        public void setRouting(int[] routing) {
            this.routing = routing;
            this.apply();
        }

        public int[] getRouting() {
            int trgChCount = this.trgChSelectors.size();
            int[] routing = new int[trgChCount];
            for (int i = 0; i < trgChCount; ++i) {
                routing[i] = this.trgChSelectors.get(i).getSelectedIndex();
            }
            return routing;
        }

        public void setRecordingChannelCount(int recChannels) {
            this.recordingChannelCount = recChannels;
            int[] newRouting = new int[this.recordingChannelCount];
            for (int i = 0; i < this.recordingChannelCount; ++i) {
                if (this.routing != null && i < this.routing.length) {
                    newRouting[i] = this.routing[i];
                    continue;
                }
                int defCh = i;
                if (defCh >= this.srcChannelCount && (defCh = this.srcChannelCount - 1) < 0) {
                    defCh = 0;
                }
                newRouting[i] = defCh;
            }
            this.routing = newRouting;
            this.createUI();
        }

        private void createUI() {
            this.removeAll();
            this.trgChLabels.clear();
            this.trgChSelectors.clear();
            for (int i = 0; i < this.recordingChannelCount; ++i) {
                JLabel trgChLabel = new JLabel(": recording file channel idx: " + Integer.toString(i));
                this.trgChLabels.add(trgChLabel);
                String[] elems = new String[this.srcChannelCount];
                for (int inCh = 0; inCh < elems.length; ++inCh) {
                    elems[inCh] = "Source channel idx: " + Integer.toString(inCh);
                }
                JComboBox<String> trgChBox = new JComboBox<String>(elems);
                this.trgChSelectors.add(trgChBox);
            }
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(1, 1, 1, 1);
            for (int r = 0; r < this.recordingChannelCount; ++r) {
                c.gridx = 0;
                c.gridy = r;
                this.add((Component)this.trgChSelectors.get(r), c);
                ++c.gridx;
                this.add((Component)this.trgChLabels.get(r), c);
            }
            this.apply();
            this.revalidate();
            this.repaint();
        }

        private void apply() {
            for (int trgIdx = 0; trgIdx < this.trgChSelectors.size(); ++trgIdx) {
                int srcCh;
                JLabel trgChLbl = this.trgChLabels.get(trgIdx);
                JComboBox trgChSel = this.trgChSelectors.get(trgIdx);
                if (this.srcChannelCount == 0) {
                    trgChSel.setEnabled(false);
                    trgChLbl.setEnabled(false);
                    continue;
                }
                if (this.routing != null) {
                    srcCh = this.routing[trgIdx];
                } else {
                    srcCh = trgIdx;
                    if (srcCh >= this.srcChannelCount) {
                        srcCh = this.srcChannelCount - 1;
                    }
                }
                trgChSel.setSelectedIndex(srcCh);
                trgChLbl.setEnabled(this.enabled);
                trgChSel.setEnabled(this.enabled);
            }
        }
    }
}

