/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.recording;

import ipsk.apps.speechrecorder.config.Format;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.config.ui.recording.ChannelAssignmentUI;
import ipsk.audio.Profile;
import ipsk.audio.ui.AudioFormatChooser;
import ipsk.swing.panel.JConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.sound.sampled.AudioFormat;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RecordingFormatView
extends JConfigPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private AudioFormatChooser afc;
    private RecordingConfiguration currentConfig;
    private ChannelAssignmentUI channelRoutingUI;
    private boolean changeByUser = true;

    public RecordingFormatView(ChannelAssignmentUI channelRoutingUI) {
        this.channelRoutingUI = channelRoutingUI;
        this.changeByUser = false;
        JPanel contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.afc = new AudioFormatChooser();
        this.afc.setProfile(Profile.SPEECH_RECORDING);
        this.afc.addChangeListener((ChangeListener)this);
        contentPane.add((Component)this.afc, "North");
        this.changeByUser = true;
    }

    public void resetToInitial() {
        this.setRecordingConfiguration(this.currentConfig);
    }

    public void resetToDefaults() {
        RecordingConfiguration defaultConfig = new RecordingConfiguration();
        RecordingConfiguration oldCurrentConfig = this.currentConfig;
        this.setRecordingConfiguration(defaultConfig);
        this.currentConfig = oldCurrentConfig;
    }

    public void setRecordingConfiguration(RecordingConfiguration recordingConfiguration) {
        this.changeByUser = false;
        AudioFormat af = this.getAudioFormat(recordingConfiguration.getFormat());
        this.afc.setAudioFormat(af);
        this.channelRoutingUI.setTargetChannelCount(af.getChannels());
        this.setDependencies();
        this.currentConfig = recordingConfiguration;
        this.changeByUser = true;
    }

    private AudioFormat getAudioFormat(Format f) {
        return f.toAudioFormat();
    }

    public void applyValues(RecordingConfiguration r) {
        AudioFormat af = this.afc.getAudioFormat();
        Format f = r.getFormat();
        f.setEncoding(af.getEncoding().toString());
        f.setSampleRate(af.getSampleRate());
        f.setSampleSizeInBits(af.getSampleSizeInBits());
        f.setFrameSize(af.getFrameSize());
        f.setChannels(af.getChannels());
        f.setBigEndian(af.isBigEndian());
        this.channelRoutingUI.applyValues(r);
    }

    private void setDependencies() {
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Object src = ce.getSource();
        if (src == this.afc) {
            AudioFormat af = this.afc.getAudioFormat();
            int chs = af.getChannels();
            this.channelRoutingUI.setTargetChannelCount(chs);
        }
    }
}

