/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.db;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMElements;
import ipsk.db.speech.Person;
import java.text.DateFormat;
import java.util.Date;
import javax.xml.bind.annotation.XmlType;

@DOMAttributes(value={"personId"})
@DOMElements(value={"name", "forename", "address", "sex", "dateOfBirth", "birthPlace", "profession", "dialectRegion", "additionalLanguage", "comments"})
@PreferredDisplayOrder(value="name,forename,address,sex,dateOfBirth,height,weight,smoker,brace,mouthPiercing,birthPlace,zipcode,profession,dialectRegion,motherTongue,motherTongueMother,motherTongueFather,additionalLanguage,comments")
@XmlType(name="speaker", namespace="speechrecorder")
public class Speaker
extends ipsk.db.speech.Speaker {
    public static final String ELEMENT_NAME = "speaker";
    private String gender;
    private String dateOfBirthString;
    private DateFormat dateOfBirthFormat = DateFormat.getDateInstance();

    public Speaker() {
    }

    public Speaker(int personId) {
        super(personId);
    }

    public String getGender() {
        Person.Sex s = this.getSex();
        if (s != null) {
            return s.toString();
        }
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getDateOfBirthString() {
        Date dob = this.getDateOfBirth();
        if (dob != null) {
            return this.dateOfBirthFormat.format(dob);
        }
        return this.dateOfBirthString;
    }

    public void setDateOfBirthString(String dateOfBirthString) {
        this.dateOfBirthString = dateOfBirthString;
    }
}

