/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.db.export.emu;

import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.db.export.emu.EmuExporter;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;

public class EmuExportWorker
extends ProgressWorker {
    private EmuExporter emuExporter = new EmuExporter();
    private Path exportBasepath;

    public Path getExportBasepath() {
        return this.exportBasepath;
    }

    public void setExportBasepath(Path exportBasepath) {
        this.exportBasepath = exportBasepath;
    }

    public void setProjectContext(URL context) {
        this.emuExporter.setProjectContext(context);
    }

    public void config(ProjectConfiguration cfgProject) throws ProjectManagerException {
        this.emuExporter.config(cfgProject);
    }

    protected void doWork() throws WorkerException {
        try {
            this.emuExporter.exportProjectAsEmuDB(this.exportBasepath);
        }
        catch (SpeechRecorderException | ProjectManagerException | IOException | URISyntaxException e) {
            e.printStackTrace();
            throw new WorkerException("Error processing EMU export: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

