/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.project;

import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.db.Speaker;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Project;
import ipsk.db.speech.Script;
import ipsk.db.speech.Session;
import ipsk.net.URLContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXB;

public class ProjectManager {
    public static final String PROJECT_VERSION = "4.0.0";
    public static final String PROJECT_FILE_EXTENSION = "_project.prj";
    public static final String SPEAKER_FILE_SUFFIX = "_speakers.xml";
    public static final String REC_SCRIPT_FILE_EXTENSION = "_script.xml";
    public static final String DEFAULT_RESOURCE_PATH = "resources";
    protected Project projectDb;
    protected ProjectConfiguration project;
    protected URL projectContext = null;
    protected DOMCodec domCodec;
    protected SpeakerManager speakerManager;
    protected String speakerFileName;
    protected URL speakerURL;
    protected SessionStorageManager projectStorageManager;
    protected RecScriptManager recScriptManager;
    protected URL promptFile;
    protected URL recBaseURL;
    protected int numLines;

    public SessionStorageManager getProjectStorageManager() {
        return this.projectStorageManager;
    }

    public ProjectManager() throws ProjectManagerException {
        try {
            Package configBasePack = Class.forName("ipsk.apps.speechrecorder.config.ProjectConfiguration").getPackage();
            this.domCodec = new DOMCodec(configBasePack);
        }
        catch (DOMCodecException | ClassNotFoundException e) {
            throw new ProjectManagerException(e);
        }
        this.speakerManager = new SpeakerManager();
        this.recScriptManager = new RecScriptManager();
        this.projectStorageManager = new SessionStorageManager();
    }

    public void init() {
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL context) {
        this.projectContext = context;
    }

    protected void setConfiguration(ProjectConfiguration newProject) {
        this.project = newProject;
    }

    public ProjectConfiguration getConfiguration() {
        return this.project;
    }

    public void config(ProjectConfiguration cfgProject) throws ProjectManagerException {
        try {
            this.commonConfig(cfgProject);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            throw new ProjectManagerException(e1);
        }
        PromptConfiguration pc = cfgProject.getPromptConfiguration();
        String promptFileName = pc.getPromptsUrl();
        if (promptFileName != null && !promptFileName.equals("")) {
            try {
                this.promptFile = URLContext.getContextURL((URL)this.projectContext, (String)promptFileName);
                this.recScriptManager.load(this.promptFile);
            }
            catch (RecscriptManagerException | MalformedURLException e) {
                e.printStackTrace();
                throw new ProjectManagerException(e);
            }
        } else {
            throw new ProjectManagerException("Prompt file not configured");
        }
        String newSpeakerFilename = this.project.getSpeakers().getSpeakersUrl();
        if (this.speakerFileName == null || !this.speakerFileName.equals(newSpeakerFilename)) {
            this.speakerFileName = this.project.getSpeakers().getSpeakersUrl();
            if (this.speakerFileName != null && !this.speakerFileName.equals("")) {
                try {
                    this.speakerURL = URLContext.getContextURL((URL)this.projectContext, (String)this.speakerFileName);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    throw new ProjectManagerException(e);
                }
            } else {
                throw new ProjectManagerException("Speaker database not configured");
            }
        }
        this.speakerManager.loadURL(this.speakerURL);
    }

    protected void commonConfig(ProjectConfiguration cfgProject) throws MalformedURLException {
        this.projectDb = new Project();
        this.projectDb.setName(cfgProject.getName());
        this.project = cfgProject;
        this.recScriptManager.setContext(this.projectContext);
        RecordingConfiguration recCfg = this.project.getRecordingConfiguration();
        String recDirName = recCfg.getUrl();
        this.recBaseURL = URLContext.getContextURL((URL)this.projectContext, (String)recDirName);
        this.projectStorageManager.setStorageURL(this.recBaseURL);
        this.numLines = 1;
        this.projectStorageManager.setNumLines(this.numLines);
        boolean overwrite = recCfg.getOverwrite();
        this.projectStorageManager.setOverwrite(overwrite);
    }

    public Project getProjectDb() {
        return this.projectDb;
    }

    public void createEmptySpeakerDatabase(File speakerDbFile, boolean overwrite) {
        if (overwrite || !speakerDbFile.exists()) {
            JAXB.marshal(new ArrayList(), (File)speakerDbFile);
        }
    }

    public void rebuildDb() throws StorageManagerException {
        Script script = this.recScriptManager.getScript();
        this.projectDb.getScripts().clear();
        this.projectDb.getScripts().add(script);
        script.getSessions().clear();
        Set<Session> sesss = this.projectStorageManager.sessionsLazy(this.projectDb, script);
        this.projectDb.setSessions(sesss);
        List<Speaker> speakersList = this.speakerManager.getSpeakersList();
        for (Speaker spk : speakersList) {
            spk.getSessions().clear();
        }
        for (Session s : sesss) {
            s.setScript(script);
            script.getSessions().add(s);
            s.getSpeakers().clear();
            for (Speaker spk : speakersList) {
                if (!spk.getPersonId().equals(s.getSessionId())) continue;
                s.setCode(spk.getCode());
                s.getSpeakers().add(spk);
                spk.getSessions().add(s);
            }
            boolean hasRecs = this.projectStorageManager.sessionHasRecordingFiles(s);
            s.setRecordingFiles(null);
            s.markHasRecordings(Boolean.valueOf(hasRecs));
        }
        this.speakerManager.setSessions(sesss);
    }
}

